/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import java.util.Arrays;
import java.util.stream.IntStream;
import vcf.Marker;
import vcf.RefGTRec;
import vcf.VcfRecGTParser;

public final class LowMafRefGT
implements RefGTRec {
    private final Marker marker;
    private final Samples samples;
    private final int nHaps;
    private final int majorAllele;
    private final int[][] hapIndices;

    public LowMafRefGT(RefGTRec refGTRec) {
        this.hapIndices = RefGTRec.hapIndices(refGTRec);
        int n = 0;
        while (this.hapIndices[n] != null) {
            ++n;
        }
        this.marker = refGTRec.marker();
        this.samples = refGTRec.samples();
        this.nHaps = refGTRec.nHaps();
        this.majorAllele = n;
    }

    public LowMafRefGT(VcfRecGTParser vcfRecGTParser) {
        this.marker = vcfRecGTParser.marker();
        this.samples = vcfRecGTParser.samples();
        this.nHaps = 2 * vcfRecGTParser.nSamples();
        this.hapIndices = vcfRecGTParser.nonMajRefIndices();
        int n = -1;
        for (int i = 0; i < this.hapIndices.length; ++i) {
            if (this.hapIndices[i] != null) continue;
            n = i;
            break;
        }
        this.majorAllele = n;
    }

    public LowMafRefGT(Marker marker, Samples samples, int[][] nArray) {
        this.marker = marker;
        this.samples = samples;
        this.nHaps = 2 * samples.nSamples();
        this.majorAllele = LowMafRefGT.checkIndicesAndReturnMajorAllele(nArray, this.nHaps);
        this.hapIndices = LowMafRefGT.deepCopy(nArray);
    }

    static int checkIndicesAndReturnMajorAllele(int[][] nArray, int n) {
        int n2 = -1;
        int n3 = n;
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null) {
                if (n2 == -1) {
                    n2 = i;
                    continue;
                }
                throw new IllegalArgumentException("invalid index array");
            }
            LowMafRefGT.checkSorted(nArray[i], n);
            n3 -= nArray[i].length;
            if (nArray[i].length <= n4) continue;
            n4 = nArray[i].length;
        }
        if (n3 < n4) {
            throw new IllegalArgumentException("invalid index array");
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("invalid index array");
        }
        return n2;
    }

    private static void checkSorted(int[] nArray, int n) {
        if (nArray.length > 0 && (nArray[0] < 0 || nArray[nArray.length - 1] >= n)) {
            throw new IllegalArgumentException("invalid index array");
        }
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i - 1] < nArray[i]) continue;
            throw new IllegalArgumentException("invalid index array");
        }
    }

    static int[][] deepCopy(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null) continue;
            nArrayArray[i] = (int[])nArray[i].clone();
        }
        return nArray;
    }

    @Override
    public RefGTRec changeMarker(Marker marker) {
        if (marker.nAlleles() < this.nAlleles()) {
            throw new IllegalArgumentException(marker.toString());
        }
        return new LowMafRefGT(marker, this.samples, this.hapIndices);
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public int nHaps() {
        return this.nHaps;
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isPhased() {
        return true;
    }

    @Override
    public boolean isGTData() {
        return true;
    }

    @Override
    public float gl(int n, int n2, int n3) {
        if (n2 < 0 || n2 >= this.hapIndices.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        if (n3 < 0 || n3 >= this.hapIndices.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n3));
        }
        boolean bl = n2 == this.allele1(n) && n3 == this.allele2(n);
        return bl ? 1.0f : 0.0f;
    }

    @Override
    public boolean isPhased(int n) {
        if (n >= this.samples.nSamples()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return true;
    }

    @Override
    public int allele1(int n) {
        return this.allele(2 * n);
    }

    @Override
    public int allele2(int n) {
        return this.allele(2 * n + 1);
    }

    @Override
    public int allele(int n) {
        if (n < 0 || n >= this.nHaps) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        for (int i = 0; i < this.hapIndices.length; ++i) {
            if (i == this.majorAllele || Arrays.binarySearch(this.hapIndices[i], n) < 0) continue;
            return i;
        }
        return this.majorAllele;
    }

    @Override
    public int[] alleles() {
        int[] nArray = IntStream.range(0, this.nHaps).map(n -> this.majorAllele).toArray();
        for (int i = 0; i < this.hapIndices.length; ++i) {
            if (i == this.majorAllele) continue;
            for (int n2 : this.hapIndices[i]) {
                nArray[n2] = i;
            }
        }
        return nArray;
    }

    @Override
    public int nAlleles() {
        return this.marker().nAlleles();
    }

    @Override
    public boolean isAlleleCoded() {
        return true;
    }

    @Override
    public int majorAllele() {
        return this.majorAllele;
    }

    @Override
    public int alleleCount(int n) {
        if (this.hapIndices[n] == null) {
            throw new IllegalArgumentException("major allele");
        }
        return this.hapIndices[n].length;
    }

    @Override
    public int hapIndex(int n, int n2) {
        if (this.hapIndices[n] == null) {
            throw new IllegalArgumentException("major allele");
        }
        return this.hapIndices[n][n2];
    }

    @Override
    public boolean isCarrier(int n, int n2) {
        if (n == this.majorAllele) {
            for (int i = 0; i < this.hapIndices.length; ++i) {
                if (i == this.majorAllele || Arrays.binarySearch(this.hapIndices[i], n2) < 0) continue;
                return false;
            }
            return true;
        }
        return Arrays.binarySearch(this.hapIndices[n], n2) >= 0;
    }

    public String toString() {
        return this.toVcfRec();
    }
}

