/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromInterval;
import java.io.File;
import vcf.Marker;
import vcf.Markers;
import vcf.PlinkGenMap;
import vcf.PositionMap;

public interface GeneticMap {
    public int basePos(int var1, double var2);

    public double genPos(Marker var1);

    public double genPos(int var1, int var2);

    public String toString();

    public static GeneticMap geneticMap(File file, ChromInterval chromInterval) {
        if (file == null) {
            double d = 1.0E-6;
            return new PositionMap(d);
        }
        if (chromInterval == null) {
            return PlinkGenMap.fromPlinkMapFile(file);
        }
        return PlinkGenMap.fromPlinkMapFile(file, chromInterval.chrom());
    }

    default public double[] genPos(Markers markers) {
        double[] dArray = new double[markers.nMarkers()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.genPos(markers.marker(i));
        }
        return dArray;
    }

    default public float[] pRecomb(Markers markers, double d) {
        if (d <= 0.0 || !Double.isFinite(d)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
        double d2 = 1.0E-7;
        int n = markers.marker(0).chromIndex();
        float[] fArray = new float[markers.nMarkers()];
        double d3 = -d;
        double d4 = this.genPos(n, markers.marker(0).pos());
        fArray[0] = 0.0f;
        for (int i = 1; i < fArray.length; ++i) {
            Marker marker = markers.marker(i);
            double d5 = this.genPos(markers.marker(i));
            if (marker.chromIndex() != n) {
                fArray[i] = 0.0f;
            } else {
                double d6 = Math.max(Math.abs(d5 - d4), d2);
                fArray[i] = (float)(-Math.expm1(d3 * d6));
            }
            d4 = d5;
        }
        return fArray;
    }
}

