/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import vcf.Marker;
import vcf.Markers;

public interface GT {
    public int nMarkers();

    public Markers markers();

    public Marker marker(int var1);

    default public int nHaps() {
        return 2 * this.nSamples();
    }

    public int nSamples();

    public Samples samples();

    public int allele1(int var1, int var2);

    public int allele2(int var1, int var2);

    default public int allele(int n, int n2) {
        int n3 = n2 / 2;
        if ((n2 & 1) == 0) {
            return this.allele1(n, n3);
        }
        return this.allele2(n, n3);
    }

    public boolean isPhased(int var1, int var2);

    public boolean isPhased(int var1);

    public boolean isPhased();

    default public boolean isGTData() {
        return true;
    }

    default public float gl(int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = this.marker(n).nAlleles();
        if (n3 < 0 || n3 >= n5) {
            String string = "invalid alleles: (" + n3 + "): " + n;
            throw new IllegalArgumentException(string);
        }
        if (n4 < 0 || n4 >= n5) {
            String string = "invalid alleles: (" + n4 + "): " + n;
            throw new IllegalArgumentException(string);
        }
        int n6 = this.allele1(n, n2);
        int n7 = this.allele2(n, n2);
        boolean bl2 = bl = !(n6 != -1 && n6 != n3 || n7 != -1 && n7 != n4);
        if (!bl && !this.isPhased(n2)) {
            bl = !(n6 != -1 && n6 != n4 || n7 != -1 && n7 != n3);
        }
        return bl ? 1.0f : 0.0f;
    }
}

