/*
 * Decompiled with CFR 0.152.
 */
package sample;

import haplotype.BitHapPair;
import haplotype.HapPair;
import haplotype.HapPairs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import vcf.GT;

public final class InitTargHapPairs {
    private InitTargHapPairs() {
    }

    public static List<HapPair> run(GT gT, HapPairs hapPairs, double d, int n, long l) {
        if (d <= 0.0 || d >= 0.5 || Double.isNaN(d)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        double[][] dArray = InitTargHapPairs.alleleFreq(gT, hapPairs, d);
        IntFunction<List<HapPair>> intFunction = InitTargHapPairs.mapper(gT, dArray, n, l);
        return IntStream.range(0, gT.nSamples()).parallel().mapToObj(intFunction).flatMap(list -> list.stream()).collect(Collectors.toCollection(ArrayList::new));
    }

    private static double[][] alleleFreq(GT gT, HapPairs hapPairs, double d) {
        IntFunction<double[]> intFunction = InitTargHapPairs.freqMapper(gT, hapPairs, d);
        return (double[][])IntStream.range(0, gT.nMarkers()).parallel().mapToObj(intFunction).toArray(n -> new double[n][]);
    }

    private static IntFunction<double[]> freqMapper(GT gT, HapPairs hapPairs, double d) {
        return n -> {
            if (gT.isGTData()) {
                return InitTargHapPairs.alleleFreqGT(gT, hapPairs, n, d);
            }
            return InitTargHapPairs.alleleFreqGL(gT, hapPairs, n, d);
        };
    }

    private static double[] alleleFreqGL(GT gT, HapPairs hapPairs, int n, double d) {
        int n2;
        int n3 = gT.marker(n).nAlleles();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        int n4 = gT.nSamples();
        for (n2 = 0; n2 < n4; ++n2) {
            int n5;
            for (n5 = 0; n5 < n3; ++n5) {
                int n6 = 0;
                while (n6 <= n5) {
                    double d2 = gT.gl(n, n2, n6, n5);
                    if (n6 != n5) {
                        d2 = Math.max(d2, (double)gT.gl(n, n2, n5, n6));
                    }
                    int n7 = n5;
                    dArray2[n7] = dArray2[n7] + d2;
                    int n8 = n6++;
                    dArray2[n8] = dArray2[n8] + d2;
                }
            }
            InitTargHapPairs.divideElementsBySum(dArray2);
            for (n5 = 0; n5 < dArray2.length; ++n5) {
                int n9 = n5;
                dArray[n9] = dArray[n9] + dArray2[n5];
                dArray2[n5] = 0.0;
            }
        }
        if (hapPairs != null) {
            n4 = hapPairs.nHaps();
            for (n2 = 0; n2 < n4; ++n2) {
                int n10 = hapPairs.allele(n, n2);
                dArray[n10] = dArray[n10] + 1.0;
            }
        }
        InitTargHapPairs.divideElementsBySum(dArray);
        InitTargHapPairs.enforceMinFreq(dArray, d);
        return dArray;
    }

    private static double[] alleleFreqGT(GT gT, HapPairs hapPairs, int n, double d) {
        int n2;
        int n3;
        int n4 = gT.marker(n).nAlleles();
        int[] nArray = new int[n4];
        double[] dArray = new double[n4];
        int n5 = gT.nHaps();
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = gT.allele(n, n3);
            if (n2 < 0) continue;
            int n6 = n2;
            nArray[n6] = nArray[n6] + 1;
        }
        if (hapPairs != null) {
            n5 = hapPairs.nHaps();
            for (n3 = 0; n3 < n5; ++n3) {
                int n7 = n2 = hapPairs.allele(n, n3);
                nArray[n7] = nArray[n7] + 1;
            }
        }
        n3 = Arrays.stream(nArray).sum();
        for (n5 = 0; n5 < nArray.length; ++n5) {
            dArray[n5] = (double)nArray[n5] / (double)n3;
        }
        InitTargHapPairs.enforceMinFreq(dArray, d);
        return dArray;
    }

    private static void divideElementsBySum(double[] dArray) {
        double d = Arrays.stream(dArray).sum();
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d;
        }
    }

    private static void enforceMinFreq(double[] dArray, double d) {
        boolean bl = false;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            dArray[i] = d;
            bl = true;
        }
        if (bl) {
            InitTargHapPairs.divideElementsBySum(dArray);
        }
    }

    private static IntFunction<List<HapPair>> mapper(GT gT, double[][] dArray, int n, long l) {
        return n2 -> {
            int n3;
            int n4;
            int n5 = gT.isPhased(n2) ? 1 : n;
            int n6 = gT.nMarkers();
            Random random = new Random(l + (long)n2);
            ArrayList<BitHapPair> arrayList = new ArrayList<BitHapPair>(n5);
            int[][] nArray = new int[n5][gT.nMarkers()];
            int[][] nArray2 = new int[n5][gT.nMarkers()];
            boolean bl = gT.isGTData();
            for (n4 = 0; n4 < n6; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    if (bl) {
                        InitTargHapPairs.sampleGT(gT, n4, n2, dArray, nArray[n3], nArray2[n3], random);
                        continue;
                    }
                    InitTargHapPairs.sampleGL(gT, n4, n2, dArray, nArray[n3], nArray2[n3], random);
                }
            }
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = gT.samples().idIndex(n2);
                arrayList.add(new BitHapPair(gT.markers(), n3, nArray[n4], nArray2[n4]));
            }
            return arrayList;
        };
    }

    private static void sampleGT(GT gT, int n, int n2, double[][] dArray, int[] nArray, int[] nArray2, Random random) {
        boolean bl = gT.isPhased(n, n2);
        boolean bl2 = bl ? false : random.nextBoolean();
        int n3 = bl2 ? gT.allele2(n, n2) : gT.allele1(n, n2);
        int n4 = bl2 ? gT.allele1(n, n2) : gT.allele2(n, n2);
        nArray[n] = n3 < 0 ? InitTargHapPairs.randAllele(dArray[n], random) : n3;
        nArray2[n] = n4 < 0 ? InitTargHapPairs.randAllele(dArray[n], random) : n4;
    }

    private static void sampleGL(GT gT, int n, int n2, double[][] dArray, int[] nArray, int[] nArray2, Random random) {
        int n3 = InitTargHapPairs.randAllele(dArray[n], random);
        int n4 = InitTargHapPairs.randAllele(dArray[n], random);
        while ((double)gT.gl(n, n2, n3, n4) == 0.0) {
            n3 = InitTargHapPairs.randAllele(dArray[n], random);
            n4 = InitTargHapPairs.randAllele(dArray[n], random);
        }
        nArray[n] = n3;
        nArray2[n] = n4;
    }

    private static int randAllele(double[] dArray, Random random) {
        double d = random.nextDouble();
        double d2 = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (!((d2 += dArray[i]) >= d)) continue;
            return i;
        }
        return dArray.length - 1;
    }
}

