/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.IntArray;
import blbutil.IntList;
import blbutil.IntSet;
import blbutil.Utilities;
import imp.HapToSeq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import main.Par;
import phase.PhaseData;

public final class PhaseIbs {
    private final PhaseData phaseData;
    private final int nTargHaps;
    private final long seed;
    private final int nStates;
    private final int nStepsToMerge;
    private final int nHapsPerStep;
    private final int ibsThreshold;
    private final int[] stepStarts;
    private final int[][][] ibsHaps;

    public PhaseIbs(PhaseData phaseData) {
        Par par = phaseData.par();
        this.phaseData = phaseData;
        this.nTargHaps = phaseData.nTargHaps();
        this.seed = phaseData.seed();
        this.nStates = phaseData.par().phase_states();
        float f = par.step();
        this.nStepsToMerge = par.nsteps();
        float f2 = par.phase_segment();
        int n2 = Math.round(f2 / f);
        this.nHapsPerStep = this.nStates / n2 / 2;
        this.ibsThreshold = phaseData.burnin() ? 20 * this.nHapsPerStep : this.nHapsPerStep + 2;
        this.stepStarts = PhaseIbs.stepStarts(phaseData);
        HapToSeq[] hapToSeqArray = (HapToSeq[])IntStream.range(0, this.stepStarts.length).parallel().mapToObj(n -> PhaseIbs.codeStep(phaseData, this.stepStarts, n)).toArray(HapToSeq[]::new);
        this.ibsHaps = (int[][][])IntStream.range(0, hapToSeqArray.length).parallel().mapToObj(n -> this.getIbsHaps(hapToSeqArray, n)).toArray(n -> new int[n][][]);
    }

    private static int[] stepStarts(PhaseData phaseData) {
        double[] dArray = phaseData.genPos();
        double d = phaseData.par().step();
        IntList intList = new IntList(dArray.length / 10);
        intList.add(0);
        Random random = new Random(phaseData.seed());
        double d2 = dArray[0] + random.nextDouble() * d;
        int n = PhaseIbs.nextIndex(dArray, 0, d2);
        while (n < dArray.length) {
            intList.add(n);
            d2 = dArray[n] + d;
            n = PhaseIbs.nextIndex(dArray, n, d2);
        }
        return intList.toArray();
    }

    private static int nextIndex(double[] dArray, int n, double d) {
        int n2 = Arrays.binarySearch(dArray, n, dArray.length, d);
        return n2 < 0 ? -n2 - 1 : n2;
    }

    private static HapToSeq codeStep(PhaseData phaseData, int[] nArray, int n2) {
        int n3 = phaseData.nTargHaps();
        int n4 = phaseData.nHaps();
        int[] nArray2 = IntStream.range(0, n4).map(n -> 1).toArray();
        int n5 = nArray[n2];
        int n6 = n2 + 1 < nArray.length ? nArray[n2 + 1] : phaseData.nMarkers();
        int n7 = 2;
        for (int i = n5; i < n6; ++i) {
            int n8;
            int n9;
            int n10;
            int n11 = phaseData.marker(i).nAlleles();
            int[] nArray3 = new int[n7 * n11];
            n7 = 1;
            for (n10 = 0; n10 < n3; ++n10) {
                n9 = phaseData.allele(i, n10);
                n8 = n11 * nArray2[n10] + n9;
                if (nArray3[n8] == 0) {
                    nArray3[n8] = n7++;
                }
                nArray2[n10] = nArray3[n8];
            }
            for (n10 = n3; n10 < n4; ++n10) {
                if (nArray2[n10] == 0) continue;
                n9 = phaseData.allele(i, n10);
                n8 = n11 * nArray2[n10] + n9;
                nArray2[n10] = nArray3[n8];
            }
        }
        return new HapToSeq(nArray2, n7);
    }

    public IntSet ibsHaps(int n, int n2, int n3) {
        IntSet intSet = new IntSet(this.nHapsPerStep);
        Random random = new Random(this.seed * (long)(n3 + 1) + (long)n);
        int[] nArray = this.ibsHaps[n3][n];
        int n4 = random.nextInt(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            int n5;
            if (n4 == nArray.length) {
                n4 -= nArray.length;
            }
            if ((n5 = nArray[n4]) != n && n5 != n2 && intSet.add(n5) && intSet.size() == this.nHapsPerStep) {
                return intSet;
            }
            ++n4;
        }
        return intSet;
    }

    public PhaseData phaseData() {
        return this.phaseData;
    }

    public int nStates() {
        return this.nStates;
    }

    public int nSteps() {
        return this.ibsHaps.length;
    }

    public int stepStart(int n) {
        return this.stepStarts[n];
    }

    private int[][] getIbsHaps(HapToSeq[] hapToSeqArray, int n) {
        Random random = new Random(this.seed * (long)(n + 1));
        int[][] nArrayArray = new int[this.nTargHaps][];
        int n2 = Math.min(this.nStepsToMerge, hapToSeqArray.length - n);
        List<IntList> list = this.initPartition(hapToSeqArray[n]);
        ArrayList<IntList> arrayList = new ArrayList<IntList>(list.size());
        this.initUpdateResults(list, arrayList, nArrayArray);
        for (int i = 1; i < n2; ++i) {
            int n3 = Math.min(this.nTargHaps, 2 * arrayList.size());
            ArrayList<IntList> arrayList2 = arrayList;
            arrayList = new ArrayList(n3);
            HapToSeq hapToSeq = hapToSeqArray[n + i];
            int n4 = arrayList2.size();
            for (int j = 0; j < n4; ++j) {
                IntList intList = (IntList)arrayList2.get(j);
                list = this.partition(intList, hapToSeq);
                this.updateResults(intList, list, arrayList, nArrayArray, random);
            }
        }
        this.finalUpdateResults(arrayList, nArrayArray, random);
        return nArrayArray;
    }

    private List<IntList> initPartition(HapToSeq hapToSeq) {
        int n;
        int n2;
        IntList[] intListArray = new IntList[hapToSeq.nSeqs()];
        IntArray intArray = hapToSeq.hap2Seq();
        int n3 = intArray.size();
        ArrayList<IntList> arrayList = new ArrayList<IntList>();
        for (n2 = 0; n2 < this.nTargHaps; ++n2) {
            n = intArray.get(n2);
            if (intListArray[n] == null) {
                intListArray[n] = new IntList();
                arrayList.add(intListArray[n]);
            }
            intListArray[n].add(n2);
        }
        for (n2 = this.nTargHaps; n2 < n3; ++n2) {
            n = intArray.get(n2);
            if (intListArray[n] == null) continue;
            intListArray[n].add(n2);
        }
        return arrayList;
    }

    private List<IntList> partition(IntList intList, HapToSeq hapToSeq) {
        int n;
        int n2;
        int n3;
        IntList[] intListArray = new IntList[hapToSeq.nSeqs()];
        IntArray intArray = hapToSeq.hap2Seq();
        int n4 = intList.size();
        ArrayList<IntList> arrayList = new ArrayList<IntList>();
        int n5 = PhaseIbs.insertionPoint(intList, this.nTargHaps);
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = intList.get(n3);
            n = intArray.get(n2);
            if (intListArray[n] == null) {
                intListArray[n] = new IntList();
                arrayList.add(intListArray[n]);
            }
            intListArray[n].add(n2);
        }
        for (n3 = n5; n3 < n4; ++n3) {
            n2 = intList.get(n3);
            n = intArray.get(n2);
            if (intListArray[n] == null) continue;
            intListArray[n].add(n2);
        }
        return arrayList;
    }

    private void initUpdateResults(List<IntList> list, List<IntList> list2, int[][] nArray) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IntList intList = list.get(i);
            if (intList.size() < this.ibsThreshold) {
                this.setResult(intList.toArray(), intList, nArray);
                continue;
            }
            list2.add(intList);
        }
    }

    private void updateResults(IntList intList, List<IntList> list, List<IntList> list2, int[][] nArray, Random random) {
        int[] nArray2 = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IntList intList2 = list.get(i);
            if (intList2.size() < this.ibsThreshold) {
                if (nArray2 == null) {
                    nArray2 = PhaseIbs.randomizedArray(intList, random);
                }
                this.setResult(nArray2, intList2, nArray);
                continue;
            }
            list2.add(intList2);
        }
    }

    private void finalUpdateResults(List<IntList> list, int[][] nArray, Random random) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IntList intList = list.get(i);
            int[] nArray2 = PhaseIbs.randomizedArray(intList, random);
            this.setResult(nArray2, intList, nArray);
        }
    }

    private static int[] randomizedArray(IntList intList, Random random) {
        int[] nArray = intList.toArray();
        Utilities.shuffle(nArray, random);
        return nArray;
    }

    private void setResult(int[] nArray, IntList intList, int[][] nArray2) {
        int n = PhaseIbs.insertionPoint(intList, this.nTargHaps);
        for (int i = 0; i < n; ++i) {
            nArray2[intList.get((int)i)] = nArray;
        }
    }

    private static int insertionPoint(IntList intList, int n) {
        int n2 = intList.binarySearch(n);
        return n2 >= 0 ? n2 : -n2 - 1;
    }
}

