/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.FloatArray;
import blbutil.FloatList;
import blbutil.IntArray;
import blbutil.IntList;
import java.util.Arrays;
import math.Regress;
import phase.EstPhase;
import phase.PhaseData;
import phase.PhaseIbs;
import phase.PhaseStates;

public class PhaseBaum1 {
    private final PhaseData phaseData;
    private final FloatArray genDist;
    private final FloatArray pRecomb;
    private final int[][] stateAlleles;
    private final PhaseStates states;
    private final FloatList lrList;
    private final int nMarkers;
    private final float pErr;
    private final float pNoErr;
    private final int[] hap1;
    private final int[] hap2;
    private final float[] fwd;
    private final float[] fwd1;
    private final float[] fwd2;
    private final float[] bwd;
    private final float[] bwd1;
    private final float[] bwd2;
    private final float[][] savedBwd1;
    private final float[][] savedBwd2;
    private int nStates;
    private float shift;
    private float scale;
    private float scale1;
    private float scale2;
    private float sum;
    private float sum1;
    private float sum2;
    private final boolean[] switchHaps;

    public PhaseBaum1(PhaseData phaseData, PhaseIbs phaseIbs) {
        this.phaseData = phaseData;
        this.genDist = phaseData.genDist();
        this.pRecomb = phaseData.pRecomb();
        this.lrList = new FloatList(200);
        this.nMarkers = phaseData.nMarkers();
        this.states = new PhaseStates(phaseIbs);
        this.pErr = phaseData.par().err();
        this.pNoErr = 1.0f - this.pErr;
        int n = this.states.nStates();
        this.stateAlleles = new int[phaseData.nMarkers()][n];
        this.hap1 = new int[this.nMarkers];
        this.hap2 = new int[this.nMarkers];
        this.bwd = new float[n];
        this.bwd1 = new float[n];
        this.bwd2 = new float[n];
        this.savedBwd1 = new float[this.nMarkers][n];
        this.savedBwd2 = new float[this.nMarkers][n];
        this.fwd = new float[n];
        this.fwd1 = new float[n];
        this.fwd2 = new float[n];
        this.switchHaps = new boolean[this.nMarkers];
    }

    public void phase(EstPhase estPhase, int n, Regress regress) {
        long l = System.nanoTime();
        boolean bl = estPhase.hasMissingGT(n);
        boolean bl2 = estPhase.hasUnphasedHets(n);
        if (bl || bl2) {
            this.nStates = this.states.ibsStates(n, this.stateAlleles);
            estPhase.setHapsWithMaskedMissingAlleles(n, this.hap1, this.hap2);
            this.phaseHets(estPhase, n);
            if (bl || regress != null) {
                if (regress == null) {
                    this.imputeMissingAlleles(this.hap1);
                    this.imputeMissingAlleles(this.hap2);
                } else {
                    this.imputeMissingAlleles(this.hap1, regress);
                    this.imputeMissingAlleles(this.hap2, regress);
                }
            }
            estPhase.setHapPair(n, this.hap1, this.hap2);
        }
    }

    private void phaseHets(EstPhase estPhase, int n) {
        this.lrList.clear();
        Arrays.fill(this.switchHaps, false);
        IntArray intArray = estPhase.getUnphasedHets(n);
        if (intArray.size() > 0) {
            this.setBwd(intArray);
            Arrays.fill(this.fwd, 0, this.nStates, 1.0f / (float)this.nStates);
            this.sum = 1.0f;
            int n2 = intArray.size();
            for (int i = 0; i < n2; ++i) {
                int n3 = i == 0 ? 0 : intArray.get(i - 1);
                int n4 = intArray.get(i);
                this.setFwd(n3, n4);
                this.phaseHet(n4);
            }
            this.updatePhase();
            if (!this.phaseData.burnin()) {
                this.updateUnphased(estPhase, n);
            }
        }
    }

    private void updatePhase() {
        boolean bl = false;
        for (int i = 0; i < this.nMarkers; ++i) {
            if (this.switchHaps[i]) {
                boolean bl2 = bl = !bl;
            }
            if (!bl) continue;
            int n = this.hap1[i];
            this.hap1[i] = this.hap2[i];
            this.hap2[i] = n;
        }
    }

    private void setBwd(IntArray intArray) {
        Arrays.fill(this.bwd, 0, this.nStates, 1.0f / (float)this.nStates);
        for (int i = intArray.size() - 1; i >= 0; --i) {
            int n = intArray.get(i);
            int n2 = i + 1 == intArray.size() ? this.nMarkers : intArray.get(i + 1);
            System.arraycopy(this.bwd, 0, this.bwd1, 0, this.nStates);
            System.arraycopy(this.bwd, 0, this.bwd2, 0, this.nStates);
            for (int j = n2 - 2; j > n - 2; --j) {
                this.bwdUpdate(j);
            }
            System.arraycopy(this.bwd1, 0, this.savedBwd1[n - 1], 0, this.nStates);
            System.arraycopy(this.bwd2, 0, this.savedBwd2[n - 1], 0, this.nStates);
        }
    }

    private void bwdUpdate(int n) {
        int n2;
        int n3 = n + 1;
        this.sum = 0.0f;
        this.sum2 = 0.0f;
        this.sum1 = 0.0f;
        for (n2 = 0; n2 < this.nStates; ++n2) {
            float f;
            float f2 = this.hap1[n3] == -1 ? 1.0f : (f = this.stateAlleles[n3][n2] == this.hap1[n3] ? this.pNoErr : this.pErr);
            float f3 = this.hap2[n3] == -1 ? 1.0f : (this.stateAlleles[n3][n2] == this.hap2[n3] ? this.pNoErr : this.pErr);
            float f4 = f == f3 ? f : 1.0f;
            int n4 = n2;
            this.bwd[n4] = this.bwd[n4] * f4;
            int n5 = n2;
            this.bwd1[n5] = this.bwd1[n5] * f;
            int n6 = n2;
            this.bwd2[n6] = this.bwd2[n6] * f3;
            this.sum += this.bwd[n2];
            this.sum1 += this.bwd1[n2];
            this.sum2 += this.bwd2[n2];
        }
        this.setScaleAndShift1(n3);
        for (n2 = 0; n2 < this.nStates; ++n2) {
            this.bwd[n2] = this.scale * this.bwd[n2] + this.shift;
            this.bwd1[n2] = this.scale1 * this.bwd1[n2] + this.shift;
            this.bwd2[n2] = this.scale2 * this.bwd2[n2] + this.shift;
        }
    }

    private void setFwd(int n, int n2) {
        System.arraycopy(this.fwd, 0, this.fwd1, 0, this.nStates);
        System.arraycopy(this.fwd, 0, this.fwd2, 0, this.nStates);
        this.sum1 = this.sum2 = this.sum;
        for (int i = n; i < n2; ++i) {
            this.fwdUpdate(i);
        }
    }

    private void fwdUpdate(int n) {
        this.setScaleAndShift1(n);
        this.sum2 = 0.0f;
        this.sum1 = 0.0f;
        this.sum = 0.0f;
        for (int i = 0; i < this.nStates; ++i) {
            float f;
            float f2 = this.hap1[n] == -1 ? 1.0f : (f = this.stateAlleles[n][i] == this.hap1[n] ? this.pNoErr : this.pErr);
            float f3 = this.hap2[n] == -1 ? 1.0f : (this.stateAlleles[n][i] == this.hap2[n] ? this.pNoErr : this.pErr);
            float f4 = f == f3 ? f : 1.0f;
            this.fwd[i] = f4 * (this.scale * this.fwd[i] + this.shift);
            this.fwd1[i] = f * (this.scale1 * this.fwd1[i] + this.shift);
            this.fwd2[i] = f3 * (this.scale2 * this.fwd2[i] + this.shift);
            this.sum += this.fwd[i];
            this.sum1 += this.fwd1[i];
            this.sum2 += this.fwd2[i];
        }
    }

    private void imputeMissingAlleles(int[] nArray, Regress regress) {
        int n;
        Arrays.fill(this.bwd, 1.0f);
        System.arraycopy(this.bwd, 0, this.savedBwd1[this.nMarkers - 1], 0, this.nStates);
        for (n = this.nMarkers - 2; n >= 0; --n) {
            int n2;
            int n3 = n + 1;
            this.sum = 0.0f;
            for (n2 = 0; n2 < this.nStates; ++n2) {
                if (nArray[n3] >= 0) {
                    int n4 = n2;
                    this.bwd[n4] = this.bwd[n4] * (this.stateAlleles[n3][n2] == nArray[n3] ? this.pNoErr : this.pErr);
                }
                this.sum += this.bwd[n2];
            }
            this.setScaleAndShift(n3);
            for (n2 = 0; n2 < this.nStates; ++n2) {
                this.bwd[n2] = this.scale * this.bwd[n2] + this.shift;
            }
            System.arraycopy(this.bwd, 0, this.savedBwd1[n], 0, this.nStates);
        }
        Arrays.fill(this.fwd, 0, this.nStates, 1.0f / (float)this.nStates);
        this.sum = 1.0f;
        this.updateFwd(nArray, 0);
        if (nArray[0] < 0) {
            nArray[0] = PhaseBaum1.maxIndex(this.alProbs(0));
        }
        for (n = 1; n < this.nMarkers; ++n) {
            this.updateFwdAndRecomb(nArray, n, regress);
            if (nArray[n] >= 0) continue;
            nArray[n] = PhaseBaum1.maxIndex(this.alProbs(n));
        }
    }

    private void imputeMissingAlleles(int[] nArray) {
        int n;
        Arrays.fill(this.bwd, 0, this.nStates, 1.0f);
        if (nArray[this.nMarkers - 1] < 0) {
            Arrays.fill(this.savedBwd1[this.nMarkers - 1], 0, this.nStates, 1.0f);
        }
        for (n = this.nMarkers - 2; n >= 0; --n) {
            int n2;
            int n3 = n + 1;
            this.sum = 0.0f;
            for (n2 = 0; n2 < this.nStates; ++n2) {
                if (nArray[n3] >= 0) {
                    int n4 = n2;
                    this.bwd[n4] = this.bwd[n4] * (this.stateAlleles[n3][n2] == nArray[n3] ? this.pNoErr : this.pErr);
                }
                this.sum += this.bwd[n2];
            }
            this.setScaleAndShift(n3);
            for (n2 = 0; n2 < this.nStates; ++n2) {
                this.bwd[n2] = this.scale * this.bwd[n2] + this.shift;
            }
            if (nArray[n] >= 0) continue;
            System.arraycopy(this.bwd, 0, this.savedBwd1[n], 0, this.nStates);
        }
        Arrays.fill(this.fwd, 0, this.nStates, 1.0f / (float)this.nStates);
        this.sum = 1.0f;
        for (n = 0; n < this.nMarkers; ++n) {
            this.updateFwd(nArray, n);
            if (nArray[n] >= 0) continue;
            nArray[n] = PhaseBaum1.maxIndex(this.alProbs(n));
        }
    }

    private void updateFwdAndRecomb(int[] nArray, int n, Regress regress) {
        this.setScaleAndShift(n);
        float f = (float)this.nStates / ((float)this.nStates - 1.0f);
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = this.sum;
        float f5 = f4 / this.shift;
        this.sum = 0.0f;
        for (int i = 0; i < this.nStates; ++i) {
            float f6 = (f4 - this.fwd[i]) / f5;
            this.fwd[i] = this.scale * this.fwd[i] + this.shift;
            if (nArray[n] >= 0) {
                float f7 = this.stateAlleles[n][i] == nArray[n] ? this.pNoErr : this.pErr;
                f6 *= f7;
                int n2 = i;
                this.fwd[n2] = this.fwd[n2] * f7;
            }
            f2 += f6 * this.savedBwd1[n][i];
            f3 += this.fwd[i] * this.savedBwd1[n][i];
            this.sum += this.fwd[i];
        }
        regress.add(this.genDist.get(n), f * (f2 / f3));
    }

    private void updateFwd(int[] nArray, int n) {
        this.setScaleAndShift(n);
        this.sum = 0.0f;
        for (int i = 0; i < this.nStates; ++i) {
            this.fwd[i] = this.scale * this.fwd[i] + this.shift;
            if (nArray[n] >= 0) {
                int n2 = i;
                this.fwd[n2] = this.fwd[n2] * (this.stateAlleles[n][i] == nArray[n] ? this.pNoErr : this.pErr);
            }
            this.sum += this.fwd[i];
        }
    }

    private float[] alProbs(int n) {
        float[] fArray = new float[this.phaseData.marker(n).nAlleles()];
        for (int i = 0; i < this.nStates; ++i) {
            int n2 = this.stateAlleles[n][i];
            fArray[n2] = fArray[n2] + this.fwd[i] * this.savedBwd1[n][i];
        }
        return fArray;
    }

    private void updateUnphased(EstPhase estPhase, int n) {
        IntArray intArray = estPhase.getUnphasedHets(n);
        IntList intList = new IntList();
        float f = PhaseBaum1.threshold(this.lrList, this.phaseData.nItsRemaining());
        int n2 = intArray.size();
        for (int i = 0; i < n2; ++i) {
            if (!(this.lrList.get(i) < f)) continue;
            intList.add(intArray.get(i));
        }
        estPhase.setUnphasedHets(n, IntArray.create(intList, 0, this.nMarkers));
    }

    private static float threshold(FloatList floatList, int n) {
        float[] fArray = floatList.toArray();
        Arrays.sort(fArray);
        if (n == 1) {
            return fArray[0];
        }
        int n2 = fArray.length + 1;
        double d = Math.pow(1.0 / (double)n2, 1.0 / (double)n);
        int n3 = (int)Math.floor(d * (double)fArray.length + 0.5);
        return fArray[n3 < fArray.length ? n3 : fArray.length - 1];
    }

    private void phaseHet(int n) {
        int n2 = n - 1;
        float[] fArray = this.savedBwd1[n2];
        float[] fArray2 = this.savedBwd2[n2];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < this.nStates; ++i) {
            f += this.fwd1[i] * fArray[i];
            f2 += this.fwd1[i] * fArray2[i];
            f3 += this.fwd2[i] * fArray[i];
            f4 += this.fwd2[i] * fArray2[i];
        }
        float f5 = f * f4 / (f2 * f3);
        if (f5 >= 1.0f) {
            this.lrList.add(f5);
        } else {
            this.lrList.add(1.0f / f5);
            this.switchHaps[n] = true;
        }
    }

    private void setScaleAndShift(int n) {
        float f = this.pRecomb.get(n);
        this.shift = f / (float)this.nStates;
        this.scale = (1.0f - f) / this.sum;
    }

    private void setScaleAndShift1(int n) {
        float f = this.pRecomb.get(n);
        this.shift = f / (float)this.nStates;
        this.scale = (1.0f - f) / this.sum;
        this.scale1 = (1.0f - f) / this.sum1;
        this.scale2 = (1.0f - f) / this.sum2;
    }

    private static int maxIndex(float[] fArray) {
        int n = 0;
        for (int i = 1; i < fArray.length; ++i) {
            if (!(fArray[i] > fArray[n])) continue;
            n = i;
        }
        return n;
    }

    private void switchHaps(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            int n3 = this.hap1[i];
            this.hap1[i] = this.hap2[i];
            this.hap2[i] = n3;
        }
    }
}

