/*
 * Decompiled with CFR 0.152.
 */
package main;

import haplotype.HapPair;
import haplotype.HapPairPhasedGT;
import haplotype.WrappedHapPairs;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReferenceArray;
import main.CurrentData;
import main.Par;
import main.RunStats;
import math.Regress;
import phase.EstPhase;
import phase.PhaseData;
import phase.PhaseLS;
import sample.InitTargHapPairs;
import vcf.GeneticMap;
import vcf.PhasedGT;
import vcf.PhasedGTWrapper;
import vcf.RefGT;

public class MainHelper {
    private final Par par;
    private final RunStats runStats;

    MainHelper(Par par, GeneticMap geneticMap, RunStats runStats) {
        this.par = par;
        this.runStats = runStats;
    }

    PhasedGT phase(CurrentData currentData) {
        if (currentData.targGT().isPhased()) {
            return new PhasedGTWrapper(currentData.targGT());
        }
        float f = 1.0E-4f;
        RefGT refGT = currentData.restrictRefGT();
        WrappedHapPairs wrappedHapPairs = refGT == null ? null : new WrappedHapPairs(refGT);
        List<HapPair> list = InitTargHapPairs.run(currentData.targGT(), wrappedHapPairs, f, 1, this.par.seed());
        list = this.lsPhaseSingles(currentData, list);
        return new HapPairPhasedGT(currentData.targSamples(), list);
    }

    private List<HapPair> lsPhaseSingles(CurrentData currentData, List<HapPair> list) {
        float f = currentData.par().ne();
        double d = 0.04f * f / (float)(2 * currentData.nAllSamples());
        EstPhase estPhase = new EstPhase(currentData.targGT(), list);
        Random random = new Random(this.par.seed());
        int n = this.par.burnin();
        int n2 = n + this.par.iterations();
        for (int i = 0; i < n2; ++i) {
            long l = System.nanoTime();
            boolean bl = i < n;
            boolean bl2 = i > n - 3 && i < n;
            Regress regress = bl2 ? new Regress() : null;
            PhaseData phaseData = new PhaseData(currentData, estPhase, d, i, random.nextLong());
            long l2 = System.nanoTime();
            PhaseLS.run(phaseData, estPhase, regress);
            if (regress != null) {
                d = this.recombFactor(currentData, regress);
            }
            long l3 = System.nanoTime() - l;
            this.runStats.printPhasingIterationUpdate(i + 1, bl, l3);
        }
        return estPhase.getHapPairs();
    }

    private double recombFactor(CurrentData currentData, Regress regress) {
        double d = regress.beta();
        float f = currentData.par().ne();
        float f2 = Math.max(f, 5.0E7f);
        double d2 = 0.04f * f2 / (float)(2 * currentData.nAllSamples());
        if (d <= 0.0 || d > d2) {
            this.runStats.println("");
            this.runStats.println("WARNING: recombination factor estimate is out-of-bounds: " + d);
            this.runStats.println("");
            d = 0.04f * f / (float)(2 * currentData.nAllSamples());
        }
        return d;
    }

    public static <E> List<E> toList(AtomicReferenceArray<E> atomicReferenceArray) {
        ArrayList<E> arrayList = new ArrayList<E>(atomicReferenceArray.length());
        int n = atomicReferenceArray.length();
        for (int i = 0; i < n; ++i) {
            arrayList.add(atomicReferenceArray.get(i));
        }
        return arrayList;
    }
}

