/*
 * Decompiled with CFR 0.152.
 */
package imp;

import imp.ImpData;
import imp.ImpIbs;
import imp.ImpStates;
import imp.StateProbs;
import imp.StateProbsFactory;
import java.util.Arrays;

public class ImpLSBaum {
    private final ImpData impData;
    private final ImpStates states;
    private final int nMarkers;
    private final int[][] hapIndices;
    private final boolean[][] allelesMatch;
    private final float[][] fwdVal;
    private final float[] bwdVal;
    private final StateProbsFactory alProbsFactory;
    private final int[] targAllele;

    public ImpLSBaum(ImpData impData, ImpIbs impIbs) {
        this.impData = impData;
        this.states = new ImpStates(impIbs);
        this.nMarkers = impData.nClusters();
        int n = this.states.nStates();
        this.hapIndices = new int[this.nMarkers][n];
        this.allelesMatch = new boolean[this.nMarkers][n];
        this.fwdVal = new float[this.nMarkers][n];
        this.bwdVal = new float[n];
        this.alProbsFactory = new StateProbsFactory(this.nMarkers);
        this.targAllele = new int[impData.nClusters()];
    }

    public StateProbs impute(int n) {
        int n2 = this.impData.nClusters() - 1;
        int n3 = this.states.ibsStates(n, this.hapIndices, this.allelesMatch);
        this.setFwdValues(n, n3);
        Arrays.fill(this.bwdVal, 0, n3, 1.0f / (float)n3);
        float f = 1.0f;
        for (int i = n2; i >= 0; --i) {
            f = this.setBwdValue(i, n3, f);
        }
        return this.alProbsFactory.stateProbs(n, n3, this.hapIndices, this.fwdVal);
    }

    public ImpData impData() {
        return this.impData;
    }

    private void setFwdValues(int n, int n2) {
        int n3 = this.impData.nRefHaps();
        float f = 1.0f;
        for (int i = 0; i < this.fwdVal.length; ++i) {
            float f2 = this.impData.pRecomb(i);
            float f3 = this.impData.errProb(i);
            float f4 = 1.0f - f3;
            float f5 = f2 / (float)n2;
            float f6 = (1.0f - f2) / f;
            float f7 = 0.0f;
            this.targAllele[i] = this.impData.allele(i, n3 + n);
            for (int j = 0; j < n2; ++j) {
                float f8 = this.allelesMatch[i][j] ? f4 : f3;
                this.fwdVal[i][j] = i == 0 ? f8 : f8 * (f6 * this.fwdVal[i - 1][j] + f5);
                f7 += this.fwdVal[i][j];
            }
            f = f7;
        }
    }

    private float setBwdValue(int n, int n2, float f) {
        int n3;
        int n4 = n + 1;
        float f2 = n4 < this.nMarkers ? this.impData.pRecomb(n4) : 0.0f;
        float f3 = this.impData.errProb(n);
        float f4 = 1.0f - f3;
        float f5 = (1.0f - f2) / f;
        float f6 = f2 / (float)n2;
        float f7 = 0.0f;
        float f8 = 0.0f;
        for (n3 = 0; n3 < n2; ++n3) {
            this.bwdVal[n3] = f5 * this.bwdVal[n3] + f6;
            float[] fArray = this.fwdVal[n];
            int n5 = n3;
            fArray[n5] = fArray[n5] * this.bwdVal[n3];
            f8 += this.fwdVal[n][n3];
            float f9 = this.allelesMatch[n][n3] ? f4 : f3;
            int n6 = n3;
            this.bwdVal[n6] = this.bwdVal[n6] * f9;
            f7 += this.bwdVal[n3];
        }
        n3 = 0;
        while (n3 < n2) {
            float[] fArray = this.fwdVal[n];
            int n7 = n3++;
            fArray[n7] = fArray[n7] / f8;
        }
        return f7;
    }
}

