/*
 * Decompiled with CFR 0.152.
 */
package imp;

import blbutil.IntArray;
import blbutil.IntList;
import blbutil.Utilities;
import imp.HapToSeq;
import imp.ImpData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import main.Par;

public final class ImpIbs {
    private final ImpData impData;
    private final int nRefHaps;
    private final long seed;
    private final int nStates;
    private final int nSteps;
    private final int nHapsPerStep;
    private final int[] stepStarts;
    private final int[][][] ibsHaps;

    public ImpIbs(ImpData impData) {
        Par par = impData.par();
        this.impData = impData;
        this.seed = par.seed();
        this.nRefHaps = impData.nRefHaps();
        this.nStates = par.imp_states();
        float f = par.step();
        this.nSteps = par.nsteps();
        int n2 = Math.round(par.imp_segment() / f);
        this.nHapsPerStep = par.imp_states() / n2;
        this.stepStarts = ImpIbs.stepStarts(impData);
        HapToSeq[] hapToSeqArray = (HapToSeq[])IntStream.range(0, this.stepStarts.length).parallel().mapToObj(n -> ImpIbs.codeStep(impData, this.stepStarts, n)).toArray(HapToSeq[]::new);
        this.ibsHaps = (int[][][])IntStream.range(0, hapToSeqArray.length).parallel().mapToObj(n -> this.getIbsHaps(hapToSeqArray, n)).toArray(n -> new int[n][][]);
    }

    private static int[] stepStarts(ImpData impData) {
        double[] dArray = impData.pos();
        double d = impData.par().step();
        IntList intList = new IntList(dArray.length / 10);
        intList.add(0);
        double d2 = dArray[0] + d / 2.0;
        int n = ImpIbs.nextIndex(dArray, 0, d2);
        while (n < dArray.length) {
            intList.add(n);
            d2 = dArray[n] + d;
            n = ImpIbs.nextIndex(dArray, n, d2);
        }
        return intList.toArray();
    }

    private static int nextIndex(double[] dArray, int n, double d) {
        int n2 = Arrays.binarySearch(dArray, n, dArray.length, d);
        return n2 < 0 ? -n2 - 1 : n2;
    }

    private static HapToSeq codeStep(ImpData impData, int[] nArray, int n2) {
        int n3 = impData.nRefHaps();
        int n4 = impData.nHaps();
        int[] nArray2 = IntStream.range(0, n4).map(n -> 1).toArray();
        int n5 = nArray[n2];
        int n6 = n2 + 1 < nArray.length ? nArray[n2 + 1] : impData.nClusters();
        int n7 = 2;
        for (int i = n5; i < n6; ++i) {
            int n8;
            int n9;
            HapToSeq hapToSeq = impData.hapToSeq(i);
            IntArray intArray = hapToSeq.hap2Seq();
            int n10 = hapToSeq.nSeqs();
            int[] nArray3 = new int[n7 * n10];
            n7 = 1;
            for (n9 = n3; n9 < n4; ++n9) {
                n8 = n10 * nArray2[n9] + intArray.get(n9);
                if (nArray3[n8] == 0) {
                    nArray3[n8] = n7++;
                }
                nArray2[n9] = nArray3[n8];
            }
            for (n9 = 0; n9 < n3; ++n9) {
                if (nArray2[n9] == 0) continue;
                n8 = nArray2[n9] * n10 + intArray.get(n9);
                nArray2[n9] = nArray3[n8];
            }
        }
        return new HapToSeq(nArray2, n7);
    }

    private int[][] getIbsHaps(HapToSeq[] hapToSeqArray, int n) {
        int n2 = this.impData.nTargHaps();
        int[][] nArrayArray = new int[n2][];
        int n3 = Math.min(this.nSteps, hapToSeqArray.length - n);
        List<IntList> list = this.initPartition(hapToSeqArray[n]);
        ArrayList<IntList> arrayList = new ArrayList<IntList>(list.size());
        this.initUpdateResults(list, nArrayArray, arrayList);
        for (int i = 1; i < n3; ++i) {
            int n4 = Math.min(n2, 2 * arrayList.size());
            ArrayList<IntList> arrayList2 = new ArrayList<IntList>(n4);
            HapToSeq hapToSeq = hapToSeqArray[n + i];
            int n5 = arrayList.size();
            for (int j = 0; j < n5; ++j) {
                IntList intList = (IntList)arrayList.get(j);
                list = this.partition(intList, hapToSeq);
                this.updateResults(intList, list, nArrayArray, arrayList2);
            }
            arrayList = arrayList2;
        }
        this.finalUpdateResults(arrayList, nArrayArray);
        return nArrayArray;
    }

    private List<IntList> initPartition(HapToSeq hapToSeq) {
        int n;
        int n2;
        IntList[] intListArray = new IntList[hapToSeq.nSeqs()];
        IntArray intArray = hapToSeq.hap2Seq();
        int n3 = intArray.size();
        ArrayList<IntList> arrayList = new ArrayList<IntList>();
        for (n2 = this.nRefHaps; n2 < n3; ++n2) {
            n = intArray.get(n2);
            if (intListArray[n] != null) continue;
            intListArray[n] = new IntList();
            arrayList.add(intListArray[n]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = intArray.get(n2);
            if (intListArray[n] == null) continue;
            intListArray[n].add(n2);
        }
        return arrayList;
    }

    private List<IntList> partition(IntList intList, HapToSeq hapToSeq) {
        int n;
        int n2;
        int n3;
        int n4;
        IntList[] intListArray = new IntList[hapToSeq.nSeqs()];
        IntArray intArray = hapToSeq.hap2Seq();
        int n5 = intList.size();
        ArrayList<IntList> arrayList = new ArrayList<IntList>();
        for (n4 = n3 = ImpIbs.insertionPoint(intList, this.nRefHaps); n4 < n5; ++n4) {
            n2 = intList.get(n4);
            n = intArray.get(n2);
            if (intListArray[n] != null) continue;
            intListArray[n] = new IntList();
            arrayList.add(intListArray[n]);
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n2 = intList.get(n4);
            n = intArray.get(n2);
            if (intListArray[n] == null) continue;
            intListArray[n].add(n2);
        }
        return arrayList;
    }

    private void initUpdateResults(List<IntList> list, int[][] nArray, List<IntList> list2) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IntList intList = list.get(i);
            int n2 = ImpIbs.insertionPoint(intList, this.nRefHaps);
            if (n2 <= this.nHapsPerStep) {
                this.setResult(intList, n2, nArray, intList.copyOf(n2));
                continue;
            }
            list2.add(intList);
        }
    }

    private void updateResults(IntList intList, List<IntList> list, int[][] nArray, List<IntList> list2) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IntList intList2 = list.get(i);
            int n2 = ImpIbs.insertionPoint(intList2, this.nRefHaps);
            if (n2 <= this.nHapsPerStep) {
                int[] nArray2 = this.combineLists(intList, intList2, n2);
                this.setResult(intList2, n2, nArray, nArray2);
                intList2.clear();
                continue;
            }
            list2.add(intList2);
        }
    }

    private void finalUpdateResults(List<IntList> list, int[][] nArray) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            IntList intList = list.get(i);
            int[] nArray2 = intList.copyOf(n2 = ImpIbs.insertionPoint(intList, this.nRefHaps));
            if (this.nHapsPerStep < nArray2.length) {
                Random random = new Random(this.seed + (long)intList.get(0));
                Utilities.shuffle(nArray2, random);
                nArray2 = Arrays.copyOf(nArray2, this.nHapsPerStep);
                Arrays.sort(nArray2);
            }
            this.setResult(intList, n2, nArray, nArray2);
        }
    }

    private int[] combineLists(IntList intList, IntList intList2, int n) {
        int[] nArray = intList2.copyOf(this.nHapsPerStep);
        if (n < this.nHapsPerStep) {
            Random random = new Random(this.seed + (long)intList.get(0) + (long)intList2.get(0));
            int n2 = ImpIbs.insertionPoint(intList, this.nRefHaps);
            int[] nArray2 = intList.copyOf(n2);
            Utilities.shuffle(nArray2, random);
            int n3 = 0;
            int n4 = n;
            while (n4 < this.nHapsPerStep) {
                if (Arrays.binarySearch(nArray, 0, n, nArray2[n3]) < 0) {
                    nArray[n4++] = nArray2[n3];
                }
                ++n3;
            }
        }
        Arrays.sort(nArray);
        return nArray;
    }

    private void setResult(IntList intList, int n, int[][] nArray, int[] nArray2) {
        int n2 = intList.size();
        for (int i = n; i < n2; ++i) {
            nArray[intList.get((int)i) - this.nRefHaps] = nArray2;
        }
    }

    private static int insertionPoint(IntList intList, int n) {
        int n2 = intList.binarySearch(n);
        return n2 >= 0 ? n2 : -n2 - 1;
    }

    public int[] ibsHaps(int n, int n2) {
        return (int[])this.ibsHaps[n2][n].clone();
    }

    public ImpData impData() {
        return this.impData;
    }

    public int nStates() {
        return this.nStates;
    }

    public int nSteps() {
        return this.ibsHaps.length;
    }

    public int stepStart(int n) {
        return this.stepStarts[n];
    }
}

