/*
 * Decompiled with CFR 0.152.
 */
package imp;

import beagleutil.Samples;
import blbutil.IntArray;
import blbutil.IntList;
import imp.HapToSeq;
import imp.HaplotypeCoder;
import java.util.Arrays;
import java.util.stream.IntStream;
import main.CurrentData;
import main.Par;
import vcf.GeneticMap;
import vcf.Markers;
import vcf.PhasedGT;
import vcf.RefGT;
import vcf.RefGTRec;

public class ImpData {
    private static final double MIN_CM_DIST = 1.0E-7;
    private final Par par;
    private final CurrentData cd;
    private final RefGT refGT;
    private final PhasedGT phasedTarg;
    private final int[] targClustStartEnd;
    private final int[] refClusterStart;
    private final int[] refClusterEnd;
    private final HapToSeq[] hapToSeq;
    private final float[] errProb;
    private final double[] pos;
    private final float[] pRecomb;
    private final float[] weight;
    private final int nClusters;
    private final int nRefHaps;
    private final int nTargHaps;
    private final int nHaps;

    public ImpData(Par par, CurrentData currentData, PhasedGT phasedGT, GeneticMap geneticMap) {
        if (!currentData.targMarkers().equals(phasedGT.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (!currentData.targSamples().equals(phasedGT.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        int[] nArray = currentData.markerIndices();
        this.par = par;
        this.cd = currentData;
        this.refGT = currentData.refGT();
        this.phasedTarg = phasedGT;
        double[] dArray = ImpData.cumPos(phasedGT.markers(), geneticMap);
        int[] nArray2 = ImpData.targBlockEnd(this.refGT, nArray);
        this.targClustStartEnd = ImpData.targClustStartEnd(dArray, nArray2, par.cluster());
        this.pos = ImpData.midPos(dArray, this.targClustStartEnd);
        this.nClusters = this.targClustStartEnd.length - 1;
        this.nRefHaps = this.refGT.nHaps();
        this.nTargHaps = phasedGT.nHaps();
        this.nHaps = this.refGT.nHaps() + phasedGT.nHaps();
        this.hapToSeq = ImpData.hapToSeq(currentData.restrictRefGT(), phasedGT, this.targClustStartEnd);
        this.refClusterStart = ImpData.refClustStart(this.targClustStartEnd, nArray);
        this.refClusterEnd = ImpData.refClustEnd(this.targClustStartEnd, nArray);
        this.errProb = ImpData.err(par.err(), this.targClustStartEnd);
        this.pRecomb = ImpData.pRecomb(par.ne(), this.refGT.nHaps(), this.pos);
        this.weight = ImpData.wts(this.refGT.markers(), this.refClusterStart, this.refClusterEnd, geneticMap);
    }

    private static double[] cumPos(Markers markers, GeneticMap geneticMap) {
        double[] dArray = new double[markers.nMarkers()];
        double d = geneticMap.genPos(markers.marker(0));
        dArray[0] = 0.0;
        for (int i = 1; i < dArray.length; ++i) {
            double d2 = geneticMap.genPos(markers.marker(i));
            double d3 = Math.max(Math.abs(d2 - d), 1.0E-7);
            dArray[i] = dArray[i - 1] + d3;
            d = d2;
        }
        return dArray;
    }

    private static int[] targBlockEnd(RefGT refGT, int[] nArray) {
        IntList intList = new IntList(nArray.length / 4);
        IntArray intArray = null;
        for (int i = 0; i < nArray.length; ++i) {
            IntArray intArray2;
            int n = nArray[i];
            RefGTRec refGTRec = refGT.get(n);
            if (refGTRec.isAlleleCoded() || (intArray2 = refGTRec.hapToSeq()) == intArray) continue;
            if (intArray != null) {
                intList.add(i);
            }
            intArray = intArray2;
        }
        intList.add(nArray.length);
        return intList.toArray();
    }

    private static int[] targClustStartEnd(double[] dArray, int[] nArray, float f) {
        int[] nArray2 = new int[dArray.length + 1];
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray2[n - 1];
            int n3 = nArray[i];
            double d = dArray[n2];
            for (int j = n2 + 1; j < n3; ++j) {
                double d2 = dArray[j];
                if (!(d2 - d > (double)f)) continue;
                nArray2[n++] = j;
                d = d2;
            }
            nArray2[n++] = n3;
            nArray[i] = n - 2;
        }
        return Arrays.copyOf(nArray2, n);
    }

    private static double[] midPos(double[] dArray, int[] nArray) {
        return IntStream.range(1, nArray.length).mapToDouble(n -> (dArray[nArray[n - 1]] + dArray[nArray[n] - 1]) / 2.0).toArray();
    }

    private static HapToSeq[] hapToSeq(RefGT refGT, PhasedGT phasedGT, int[] nArray) {
        HaplotypeCoder haplotypeCoder = new HaplotypeCoder(refGT, phasedGT);
        return (HapToSeq[])IntStream.range(1, nArray.length).mapToObj(n -> haplotypeCoder.run(nArray[n - 1], nArray[n])).toArray(HapToSeq[]::new);
    }

    private static float[] err(float f, int[] nArray) {
        float f2 = 0.5f;
        float[] fArray = new float[nArray.length - 1];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f * (float)(nArray[i + 1] - nArray[i]);
            if (!(fArray[i] > f2)) continue;
            fArray[i] = f2;
        }
        return fArray;
    }

    private static int[] refClustStart(int[] nArray, int[] nArray2) {
        return IntStream.range(0, nArray.length - 1).map(n -> nArray2[nArray[n]]).toArray();
    }

    private static int[] refClustEnd(int[] nArray, int[] nArray2) {
        return IntStream.range(1, nArray.length).map(n -> nArray2[nArray[n] - 1] + 1).toArray();
    }

    private static float[] pRecomb(float f, int n, double[] dArray) {
        float[] fArray = new float[dArray.length];
        double d = -(0.04 * (double)f / (double)n);
        for (int i = 1; i < fArray.length; ++i) {
            fArray[i] = (float)(-Math.expm1(d * (dArray[i] - dArray[i - 1])));
        }
        return fArray;
    }

    private static float[] wts(Markers markers, int[] nArray, int[] nArray2, GeneticMap geneticMap) {
        double[] dArray = ImpData.cumPos(markers, geneticMap);
        int n = nArray.length - 1;
        float[] fArray = new float[dArray.length];
        Arrays.fill(fArray, 0, nArray[0], Float.NaN);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = nArray2[i];
            int n4 = nArray[i + 1];
            double d = dArray[n4];
            double d2 = d - dArray[n3 - 1];
            Arrays.fill(fArray, n2, n3, Float.NaN);
            for (int j = n3; j < n4; ++j) {
                fArray[j] = (float)((dArray[n4] - dArray[j]) / d2);
            }
        }
        Arrays.fill(fArray, nArray[n], markers.nMarkers(), Float.NaN);
        return fArray;
    }

    public Par par() {
        return this.par;
    }

    public CurrentData cd() {
        return this.cd;
    }

    public RefGT refGT() {
        return this.refGT;
    }

    public PhasedGT targGT() {
        return this.phasedTarg;
    }

    public int targClusterStart(int n) {
        if (n >= this.nClusters) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.targClustStartEnd[n];
    }

    public int targClusterEnd(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.targClustStartEnd[n + 1];
    }

    public int refClusterStart(int n) {
        return this.refClusterStart[n];
    }

    public int refClusterEnd(int n) {
        return this.refClusterEnd[n];
    }

    public int nClusters() {
        return this.nClusters;
    }

    public Samples targSamples() {
        return this.phasedTarg.samples();
    }

    public int nTargSamples() {
        return this.phasedTarg.nSamples();
    }

    public int nHaps() {
        return this.nHaps;
    }

    public int nRefHaps() {
        return this.nRefHaps;
    }

    public int nTargHaps() {
        return this.nTargHaps;
    }

    public int allele(int n, int n2) {
        return this.hapToSeq[n].hap2Seq().get(n2);
    }

    public HapToSeq hapToSeq(int n) {
        return this.hapToSeq[n];
    }

    public float errProb(int n) {
        return this.errProb[n];
    }

    public double pos(int n) {
        return this.pos[n];
    }

    public double[] pos() {
        return (double[])this.pos.clone();
    }

    public float pRecomb(int n) {
        return this.pRecomb[n];
    }

    public double weight(int n) {
        return this.weight[n];
    }
}

