/*
 * Decompiled with CFR 0.152.
 */
package imp;

import blbutil.IntArray;
import imp.HapToSeq;
import java.util.Arrays;
import vcf.PhasedGT;
import vcf.RefGT;
import vcf.RefGTRec;

public class HaplotypeCoder {
    private final int nRefHaps;
    private final int nHaps;
    private final RefGT ref;
    private final PhasedGT targ;

    public HaplotypeCoder(RefGT refGT, PhasedGT phasedGT) {
        if (!refGT.markers().equals(phasedGT.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        this.nRefHaps = refGT.nHaps();
        this.nHaps = this.nRefHaps + phasedGT.nHaps();
        this.ref = refGT;
        this.targ = phasedGT;
    }

    public PhasedGT refHapPairs() {
        return this.ref;
    }

    public PhasedGT targHapPairs() {
        return this.targ;
    }

    public HapToSeq run(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException("start >= end");
        }
        if (HaplotypeCoder.isHapCoded(this.ref, n, n2)) {
            return this.codeSeqCodedRef(n, n2);
        }
        return this.codeSeq(n, n2);
    }

    private static boolean isHapCoded(RefGT refGT, int n, int n2) {
        RefGTRec refGTRec = refGT.get(n);
        if (refGTRec.isAlleleCoded()) {
            return false;
        }
        IntArray intArray = refGT.get(n).hapToSeq();
        for (int i = n + 1; i < n2; ++i) {
            RefGTRec refGTRec2 = refGT.get(i);
            if (!refGTRec2.isAlleleCoded() && refGTRec2.hapToSeq() == intArray) continue;
            return false;
        }
        return true;
    }

    private HapToSeq codeTarg(int n, int[][] nArray) {
        int n2 = this.targ.nHaps();
        int[] nArray2 = new int[n2];
        Arrays.fill(nArray2, 1);
        int n3 = 2;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = n + i;
            int n5 = this.ref.marker(n4).nAlleles();
            nArray[i] = new int[n3 * n5];
            n3 = 1;
            for (int j = 0; j < n2; ++j) {
                int n6 = n5 * nArray2[j] + this.targ.allele(n4, j);
                if (nArray[i][n6] == 0) {
                    nArray[i][n6] = n3++;
                }
                nArray2[j] = nArray[i][n6];
            }
        }
        return new HapToSeq(nArray2, n3);
    }

    private HapToSeq codeSeqCodedRef(int n, int n2) {
        int[][] nArrayArray = new int[n2 - n][];
        HapToSeq hapToSeq = this.codeTarg(n, nArrayArray);
        int[] nArray = new int[this.ref.get(n).seqToAllele().size()];
        Arrays.fill(nArray, 1);
        for (int i = 0; i < nArrayArray.length; ++i) {
            int n3 = n + i;
            int n4 = this.ref.marker(n3).nAlleles();
            IntArray intArray = this.ref.get(n3).seqToAllele();
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] <= 0) continue;
                int n5 = nArray[j] * n4 + intArray.get(j);
                nArray[j] = nArrayArray[i][n5];
            }
        }
        return this.combine(this.ref.get(n).hapToSeq(), nArray, hapToSeq);
    }

    private HapToSeq combine(final IntArray intArray, final int[] nArray, HapToSeq hapToSeq) {
        final IntArray intArray2 = hapToSeq.hap2Seq();
        IntArray intArray3 = new IntArray(){

            @Override
            public int size() {
                return HaplotypeCoder.this.nHaps;
            }

            @Override
            public int get(int n) {
                if (n < HaplotypeCoder.this.nRefHaps) {
                    return nArray[intArray.get(n)];
                }
                return intArray2.get(n - HaplotypeCoder.this.nRefHaps);
            }
        };
        return new HapToSeq(intArray3, hapToSeq.nSeqs());
    }

    private HapToSeq codeSeq(int n, int n2) {
        int[][] nArrayArray = new int[n2 - n][];
        HapToSeq hapToSeq = this.codeTarg(n, nArrayArray);
        int[] nArray = new int[this.nRefHaps];
        Arrays.fill(nArray, 1);
        for (int i = 0; i < nArrayArray.length; ++i) {
            int n3 = n + i;
            int n4 = this.ref.marker(n3).nAlleles();
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] <= 0) continue;
                int n5 = nArray[j] * n4 + this.ref.allele(n3, j);
                nArray[j] = nArrayArray[i][n5];
            }
        }
        return this.combine(nArray, hapToSeq);
    }

    private HapToSeq combine(final int[] nArray, HapToSeq hapToSeq) {
        final IntArray intArray = hapToSeq.hap2Seq();
        IntArray intArray2 = new IntArray(){

            @Override
            public int size() {
                return HaplotypeCoder.this.nHaps;
            }

            @Override
            public int get(int n) {
                if (n < HaplotypeCoder.this.nRefHaps) {
                    return nArray[n];
                }
                return intArray.get(n - HaplotypeCoder.this.nRefHaps);
            }
        };
        return new HapToSeq(intArray2, hapToSeq.nSeqs());
    }
}

