/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.IntArray;
import blbutil.IntList;
import java.util.Arrays;

public final class UnsignedByteArray
implements IntArray {
    private final byte[] ba;

    public UnsignedByteArray(byte[] byArray) {
        this.ba = (byte[])byArray.clone();
    }

    public UnsignedByteArray(byte[] byArray, int n, int n2) {
        this.ba = Arrays.copyOfRange(byArray, n, n2);
    }

    public UnsignedByteArray(int[] nArray) {
        this(nArray, 0, nArray.length);
    }

    public UnsignedByteArray(IntList intList) {
        this(intList, 0, intList.size());
    }

    public UnsignedByteArray(int[] nArray, int n, int n2) {
        this.ba = new byte[n2 - n];
        for (int i = n; i < n2; ++i) {
            if (nArray[i] < 0 || nArray[i] > 255) {
                throw new IllegalArgumentException(String.valueOf(nArray[i]));
            }
            this.ba[i - n] = (byte)nArray[i];
        }
    }

    public UnsignedByteArray(IntList intList, int n, int n2) {
        this.ba = new byte[n2 - n];
        for (int i = n; i < n2; ++i) {
            int n3 = intList.get(i);
            if (n3 < 0 || n3 > 255) {
                throw new IllegalArgumentException(String.valueOf(n3));
            }
            this.ba[i - n] = (byte)n3;
        }
    }

    @Override
    public int size() {
        return this.ba.length;
    }

    @Override
    public int get(int n) {
        return this.ba[n] & 0xFF;
    }

    @Override
    public String toString() {
        return this.asString();
    }

    @Override
    public int max() {
        int n = Integer.MIN_VALUE;
        for (byte by : this.ba) {
            int n2 = by & 0xFF;
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public int min() {
        int n = Integer.MAX_VALUE;
        for (byte by : this.ba) {
            int n2 = by & 0xFF;
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }
}

