/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class IntMap<E> {
    private static final int NIL = -1;
    private static final float LOAD_FACTOR = 0.75f;
    private int size;
    private int nBuckets;
    private int[] next;
    private int[] data;
    private int[] keys;
    private List<E> values;
    private int firstFreeIndex;

    public IntMap(int n) {
        if (n < 1 || n > 0x40000000) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int n2 = (int)Math.ceil((float)n / 0.75f) + 1;
        this.allocateArrays(n, n2);
        this.values = new ArrayList(n);
        this.initializeFields(n2);
    }

    private void allocateArrays(int n, int n2) {
        this.next = new int[n2 + n];
        this.data = new int[n2 + n];
        this.keys = new int[n];
    }

    private void initializeFields(int n) {
        this.size = 0;
        this.firstFreeIndex = this.nBuckets = n;
        Arrays.fill(this.next, 0, this.nBuckets, -1);
        for (int i = this.nBuckets; i < this.next.length; ++i) {
            this.next[i] = i + 1;
        }
        this.values.clear();
    }

    private void rehash(int n) {
        if (n > this.size) {
            int n2 = this.size;
            int[] nArray = (int[])this.keys.clone();
            ArrayList<E> arrayList = new ArrayList<E>(this.values);
            int n3 = (int)Math.ceil((float)n / 0.75f);
            this.allocateArrays(n, n3);
            this.initializeFields(n3);
            for (int i = 0; i < n2; ++i) {
                this.put(nArray[i], arrayList.get(i));
            }
        }
    }

    public void clear() {
        this.initializeFields(this.nBuckets);
    }

    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    private int indexOf(int n) {
        int n2 = this.next[this.bucket(n)];
        while (n2 != -1 && this.keys[this.data[n2]] < n) {
            n2 = this.next[n2];
        }
        return n2 != -1 && this.keys[this.data[n2]] == n ? n2 : -1;
    }

    public E put(int n, E e) {
        int n2 = this.prevIndex(n);
        int n3 = this.next[n2];
        if (n3 == -1 || this.keys[this.data[n3]] != n) {
            int n4 = this.firstFreeIndex;
            this.firstFreeIndex = this.next[this.firstFreeIndex];
            this.next[n2] = n4;
            this.data[n4] = this.size;
            this.next[n4] = n3;
            this.keys[this.size] = n;
            this.values.add(e);
            ++this.size;
            if (this.size == this.keys.length) {
                int n5 = 3 * this.keys.length / 2 + 1;
                this.rehash(n5);
            }
            return null;
        }
        return this.values.set(this.data[n3], e);
    }

    public E remove(int n) {
        int n2 = this.prevIndex(n);
        int n3 = this.next[n2];
        if (n3 == -1 || this.keys[this.data[n3]] != n) {
            return null;
        }
        E e = this.values.get(this.data[n3]);
        int n4 = this.data[n3];
        this.next[n2] = this.next[n3];
        this.next[n3] = this.firstFreeIndex;
        this.firstFreeIndex = n3;
        --this.size;
        if (n4 != this.size) {
            n3 = this.indexOf(this.keys[this.size]);
            this.data[n3] = n4;
            this.keys[n4] = this.keys[this.size];
            this.values.set(n4, this.values.get(this.size));
            this.values.remove(this.size);
        }
        return e;
    }

    private int bucket(int n) {
        return Math.abs(71 * n % this.nBuckets);
    }

    private int prevIndex(int n) {
        int n2 = this.bucket(n);
        int n3 = this.next[n2];
        while (n3 != -1 && this.keys[this.data[n3]] < n) {
            n2 = n3;
            n3 = this.next[n3];
        }
        return n2;
    }

    public int key(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.keys[n];
    }

    public E get(int n) {
        int n2 = this.indexOf(n);
        if (n2 == -1) {
            return null;
        }
        return this.values.get(this.data[n2]);
    }

    public int size() {
        return this.size;
    }

    public int[] keys() {
        return Arrays.copyOf(this.keys, this.size);
    }

    public List<E> values() {
        return new ArrayList<E>(this.values);
    }

    public String toString() {
        return Arrays.toString(this.keys());
    }

    private static void main(String[] stringArray) {
        IntMap<Integer> intMap = new IntMap<Integer>(4);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(100);
        Random random = new Random(0L);
        int n = 5000;
        int n2 = 100;
        for (int i = 0; i < n; ++i) {
            Integer n3;
            Integer n4;
            int n5 = i % n2;
            int n6 = random.nextInt();
            double d = random.nextDouble();
            if (d < 0.005) {
                intMap.clear();
                hashMap.clear();
            } else if (d < 0.4) {
                n4 = (Integer)intMap.get(n5);
                n3 = (Integer)hashMap.get(n5);
                assert (n4 == n3 || n4 != null && n3 != null && n4.intValue() == n3.intValue());
            } else if (d < 0.7) {
                n4 = intMap.put(n5, n6);
                n3 = hashMap.put(n5, n6);
                assert (n4 == n3 || n4 != null && n3 != null && n4.intValue() == n3.intValue());
            } else {
                n4 = (Integer)intMap.remove(n5);
                n3 = (Integer)hashMap.remove(n5);
                assert (n4 == n3 || n4 != null && n3 != null && n4.intValue() == n3.intValue());
            }
            assert (intMap.size() == hashMap.size());
        }
    }
}

