# This package will contain the spiders of your Scrapy project
#
# Please refer to the documentation for information on how to create and manage
# your spiders.

import scrapy

from os_scrapy_spage.items import ExampleItem
from os_scrapy_spage.utils import spage


class ExampleSpider(scrapy.Spider):
    """ExampleSpider
    Auto generated by os-scrapy-cookiecuter

    Run:
        scrapy crawl example
    """

    name = "example"

    def start_requests(self):
        yield scrapy.Request("http://example.com/", errback=self.errback)

    def errback(self, failure):
        print(spage(failure))

    def parse(self, response):
        print(spage(response))
        request = response.request
        yield ExampleItem(
            request={
                "url": request.url,
                "method": request.method,
                "headers": request.headers,
                "body": request.body,
            },
            response={
                "status": response.status,
                "headers": response.headers,
                "body": response.body,
            },
            meta=response.meta,
        )
