/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.xml.XMLDocument;

public class XMLOptions
implements RevisionHandler {
    public static final String TAG_OPTION = "option";
    public static final String TAG_OPTIONS = "options";
    public static final String ATT_NAME = "name";
    public static final String ATT_TYPE = "type";
    public static final String ATT_VALUE = "value";
    public static final String VAL_TYPE_FLAG = "flag";
    public static final String VAL_TYPE_SINGLE = "single";
    public static final String VAL_TYPE_HYPHENS = "hyphens";
    public static final String VAL_TYPE_QUOTES = "quotes";
    public static final String VAL_TYPE_CLASSIFIER = "classifier";
    public static final String VAL_TYPE_OPTIONHANDLER = "optionhandler";
    public static final String ROOT_NODE = "options";
    public static final String DOCTYPE = "<!DOCTYPE options\n[\n   <!ELEMENT options (option)*>\n   <!ATTLIST options type CDATA \"optionhandler\">\n   <!ATTLIST options value CDATA \"\">\n   <!ELEMENT option (#PCDATA | options)*>\n   <!ATTLIST option name CDATA #REQUIRED>\n   <!ATTLIST option type (flag | single | hyphens | quotes) \"single\">\n]\n>";
    protected XMLDocument m_XMLDocument = new XMLDocument();

    public XMLOptions() throws Exception {
        this.m_XMLDocument.setRootNode("options");
        this.m_XMLDocument.setDocType(DOCTYPE);
        this.setValidating(true);
    }

    public XMLOptions(String xml) throws Exception {
        this();
        this.getXMLDocument().read(xml);
    }

    public XMLOptions(File file) throws Exception {
        this();
        this.getXMLDocument().read(file);
    }

    public XMLOptions(InputStream stream) throws Exception {
        this();
        this.getXMLDocument().read(stream);
    }

    public XMLOptions(Reader reader) throws Exception {
        this();
        this.getXMLDocument().read(reader);
    }

    public boolean getValidating() {
        return this.m_XMLDocument.getValidating();
    }

    public void setValidating(boolean validating) throws Exception {
        this.m_XMLDocument.setValidating(validating);
    }

    public Document getDocument() {
        this.fixHyphens();
        return this.m_XMLDocument.getDocument();
    }

    public XMLDocument getXMLDocument() {
        this.fixHyphens();
        return this.m_XMLDocument;
    }

    protected void fixHyphens() {
        int i;
        NodeList list = this.m_XMLDocument.findNodes("//option");
        Vector<Element> hyphens = new Vector<Element>();
        for (i = 0; i < list.getLength(); ++i) {
            if (!((Element)list.item(i)).getAttribute(ATT_TYPE).equals(VAL_TYPE_HYPHENS)) continue;
            hyphens.add((Element)list.item(i));
        }
        for (i = 0; i < hyphens.size(); ++i) {
            Node node = (Node)hyphens.get(i);
            boolean isLast = true;
            Node tmpNode = node;
            while (tmpNode.getNextSibling() != null) {
                if (tmpNode.getNextSibling().getNodeType() == 1) {
                    isLast = false;
                    break;
                }
                tmpNode = tmpNode.getNextSibling();
            }
            if (isLast) continue;
            tmpNode = node.getParentNode();
            tmpNode.removeChild(node);
            tmpNode.appendChild(node);
        }
    }

    protected String toCommandLine(Element parent) {
        Vector<String> result = new Vector<String>();
        if (parent.getNodeName().equals("options")) {
            Vector<Element> list = XMLDocument.getChildTags(parent);
            if (parent.getAttribute(ATT_TYPE).equals(VAL_TYPE_CLASSIFIER)) {
                System.err.println("Type 'classifier' is deprecated, use 'optionhandler' instead!");
                parent.setAttribute(ATT_TYPE, VAL_TYPE_OPTIONHANDLER);
            }
            if (parent.getAttribute(ATT_TYPE).equals(VAL_TYPE_OPTIONHANDLER)) {
                result.add(parent.getAttribute(ATT_VALUE));
                if (list.size() > 0 && parent.getParentNode() != null && parent.getParentNode() instanceof Element && ((Element)parent.getParentNode()).getNodeName().equals(TAG_OPTION) && ((Element)parent.getParentNode()).getAttribute(ATT_TYPE).equals(VAL_TYPE_HYPHENS)) {
                    result.add("--");
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                String tmpStr = this.toCommandLine(list.get(i));
                try {
                    String[] params = Utils.splitOptions(tmpStr);
                    for (int n = 0; n < params.length; ++n) {
                        result.add(params[n]);
                    }
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error splitting: " + tmpStr);
                    e.printStackTrace();
                }
            }
        } else if (parent.getNodeName().equals(TAG_OPTION)) {
            Vector<Element> subList = XMLDocument.getChildTags(parent);
            NodeList subNodeList = parent.getChildNodes();
            result.add("-" + parent.getAttribute(ATT_NAME));
            if (parent.getAttribute(ATT_TYPE).equals(VAL_TYPE_SINGLE)) {
                if (subNodeList.getLength() > 0 && subNodeList.item(0).getNodeValue().trim().length() > 0) {
                    result.add(subNodeList.item(0).getNodeValue());
                }
            } else if (parent.getAttribute(ATT_TYPE).equals(VAL_TYPE_QUOTES)) {
                result.add(this.toCommandLine(subList.get(0)));
            } else if (parent.getAttribute(ATT_TYPE).equals(VAL_TYPE_HYPHENS)) {
                String tmpStr = this.toCommandLine(subList.get(0));
                try {
                    String[] params = Utils.splitOptions(tmpStr);
                    for (int n = 0; n < params.length; ++n) {
                        result.add(params[n]);
                    }
                }
                catch (Exception e) {
                    System.err.println("Error splitting: " + tmpStr);
                    e.printStackTrace();
                }
            }
        } else {
            System.err.println("Unsupported tag '" + parent.getNodeName() + "' - skipped!");
        }
        return Utils.joinOptions(result.toArray(new String[result.size()]));
    }

    public String toCommandLine() throws Exception {
        return this.toCommandLine(this.getDocument().getDocumentElement());
    }

    public String[] toArray() throws Exception {
        return Utils.splitOptions(this.toCommandLine());
    }

    public String toString() {
        return this.getXMLDocument().toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            String[] options;
            System.out.println("\nXML:\n\n" + new XMLOptions(args[0]).toString());
            System.out.println("\nCommandline:\n\n" + new XMLOptions(args[0]).toCommandLine());
            System.out.println("\nString array:\n");
            for (String option : options = new XMLOptions(args[0]).toArray()) {
                System.out.println(option);
            }
        }
    }
}

