# --------------------------------------------------------------- Imports ---------------------------------------------------------------- #

# System
from typing import Optional

# Local
from .text_type import TextType
from .utils import get_text

# ---------------------------------------------------------------------------------------------------------------------------------------- #



# ----------------------------------------------------------- class: WikiText ------------------------------------------------------------ #

class WikiText:

    # ------------------------------------------------------------- Init ------------------------------------------------------------- #

    def __init__(
        self,
        text: str,
        type_: TextType
    ):
        self.text = text
        self.type_ = type_


    # -------------------------------------------------------- Public methods -------------------------------------------------------- #

    @classmethod
    def from_element(
        cls,
        element
    ) -> Optional:
        try:
            return cls(get_text(element), TextType(element.name))
        except:
            return None


# ---------------------------------------------------------------------------------------------------------------------------------------- #