# --------------------------------------------------------------- Imports ---------------------------------------------------------------- #

# System
from typing import Optional

# Local
from .utils import get_text

# ---------------------------------------------------------------------------------------------------------------------------------------- #



# ----------------------------------------------------------- class: WikiQuote ----------------------------------------------------------- #

class WikiQuote:

    # ------------------------------------------------------------- Init ------------------------------------------------------------- #

    def __init__(
        self,
        text: str,
        cite: str
    ):
        self.text = text
        self.cite = cite


    # -------------------------------------------------------- Public methods -------------------------------------------------------- #

    @classmethod
    def from_element(
        cls,
        element
    ) -> Optional:
        try:
            return cls(get_text(element.find('p')), get_text(element.find('cite')))
        except:
            return None


# ---------------------------------------------------------------------------------------------------------------------------------------- #