"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Queue = exports.QueueProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const amqp_generated_1 = require("./amqp.generated");
Object.defineProperty(exports, "QueueProperty", { enumerable: true, get: function () { return amqp_generated_1.RosQueue; } });
/**
 * A ROS resource type:  `ALIYUN::AMQP::Queue`
 */
class Queue extends ros.Resource {
    /**
     * Create a new `ALIYUN::AMQP::Queue`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosQueue = new amqp_generated_1.RosQueue(this, id, {
            deadLetterExchange: props.deadLetterExchange,
            maximumPriority: props.maximumPriority,
            instanceId: props.instanceId,
            exclusiveState: props.exclusiveState,
            deadLetterRoutingKey: props.deadLetterRoutingKey,
            virtualHost: props.virtualHost,
            maxLength: props.maxLength,
            autoDeleteState: props.autoDeleteState,
            queueName: props.queueName,
            messageTtl: props.messageTtl,
            autoExpireState: props.autoExpireState,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosQueue;
        this.attrQueueName = rosQueue.attrQueueName;
    }
}
exports.Queue = Queue;
//# sourceMappingURL=data:application/json;base64,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