# AUTOGENERATED! DO NOT EDIT! File to edit: ../209_TransparenceMix.ipynb.

# %% auto 0
__all__ = ['TransparenceMix']

# %% ../209_TransparenceMix.ipynb 2
# library
from .holemakertechnique import HoleMakerTechnique, HoleMakerRandom
from .regionmodifier import RegionModifier
from .iholesfilling import HolesFilling

# others
import cv2
import random
from fastai.basics import *
import numpy as np

# %% ../209_TransparenceMix.ipynb 4
class TransparenceMix(HolesFilling):
    "Defines the amount of holes, the technique used to make them and the probability of apply the technique."
    def __init__(self,
                 holes_num: int = 1, # The amount of holes to make.
                 modifier: "RegionModifier" = None, # The modifier that defines the traditional augments to apply to the selected regions.
                 hole_maker: "HoleMakerTechnique" = None, # The strategy used to make the holes.
                 p: float = 0.5): # The probability of applying this technique.
        hole_maker = hole_maker if hole_maker else HoleMakerRandom()
        super().__init__(modifier, hole_maker)
        self.holes_num = holes_num
        self.p = p

    def before_batch(self):
        "Applies the CutMix technique."
        
        if not self.training:
            return
        
        x, y = tensor(self.x).clone(), tensor(self.y).clone() # tensor is defined in fastai.basics
        for image, mask in zip(self.x, self.y):
            if random.random() < self.p:
                for _ in range(self.holes_num):
                    rand = random.randint(0, x.shape[0] - 1)
                    other_image, other_mask = x[rand], y[rand]
                    xhole, yhole = self.make_hole(mask)
                    sub_image, sub_mask = other_image[:, yhole, xhole], other_mask[yhole, xhole]
                    self.fill_hole(image, mask, xhole, yhole, [sub_image, sub_mask], transparence = True)
