# AUTOGENERATED! DO NOT EDIT! File to edit: ../10_RegionModifier.ipynb.

# %% auto 0
__all__ = ['RegionModifier']

# %% ../10_RegionModifier.ipynb 2
import numpy as np
from functools import reduce
from albumentations.core.composition import Compose

# %% ../10_RegionModifier.ipynb 4
class RegionModifier():
    def __init__(self,
                 taug: Compose = None): # The Compose of the transformations to be applied.
        "Defines the traditional augmentations to be applied."
        self.taug = taug
        
    def apply(self,
              image_region: np.ndarray, # The region of the image to be augmented.
              mask_region: np.ndarray # The region of the mask to be augmented.
        ):
        "Applies the augmnentations to the regions. Those augmnetations can not modify their shapes."
        if self.taug: # and reduce(lambda old, new: old * new, mask_region.shape, 1) != 0:
            transformation = self.taug(image = image_region, mask = mask_region)
            image, mask = transformation["image"], transformation["mask"]
        else:
            image, mask = image_region, mask_region
        
        return image, mask
