# AUTOGENERATED! DO NOT EDIT! File to edit: ../203_HideAndSeek.ipynb.

# %% auto 0
__all__ = ['HideAndSeek']

# %% ../203_HideAndSeek.ipynb 2
# library
from .holemakertechnique import HoleMakerTechnique, HoleMakerPoint
from .regionmodifier import RegionModifier
from .iholesfilling import HolesFilling

# others
import random
import torch
import numpy as np

# %% ../203_HideAndSeek.ipynb 4
class HideAndSeek(HolesFilling):
    "Defines the amount of holes, the probability of deactivation, the technique used to make them and the probability of apply the technique."
    def __init__(self,
                 deactivation_p = 0.1, # The probability of deactivate a region.
                 modifier: "RegionModifier" = None, # The modifier that defines the traditional augments to apply to the selected regions.
                 hole_maker: "HoleMakerTechnique" = None, # The strategy used to make the holes.
                 p = 0.5): # The probability of applying this technique.
        hole_maker = hole_maker if hole_maker else HoleMakerPoint()
        super().__init__(modifier, hole_maker)
        self.deactivation_p = deactivation_p
        self.p = p

    def before_batch(self):
        "Applies the Hide & Seek technique (divides the image into a grid and deactivates some portions with a determinated probability)."
        
        if not self.training:
            return
    
        for image, mask in zip(self.x, self.y):
            if random.random() < self.p:
                shape = image.shape[1:]
                for randy in range(0, shape[0], self.hole_maker.hole_size[0]):
                    for randx in range(0, shape[1], self.hole_maker.hole_size[1]):
                        if random.random() < self.deactivation_p:
                            self.hole_maker.x = randx
                            self.hole_maker.y = randy
                            xhole, yhole = self.make_hole(mask)
                            self.fill_hole(image, mask, xhole, yhole, [torch.min(image), 0])
