# AUTOGENERATED! DO NOT EDIT! File to edit: ../208_CarveMix.ipynb.

# %% auto 0
__all__ = ['CarveMix']

# %% ../208_CarveMix.ipynb 2
# library
from .holemakertechnique import HoleMakerTechnique, HoleMakerROI, HoleMakerBounded
from .regionmodifier import RegionModifier
from .iholesfilling import HolesFilling

# others
import cv2
import random
from fastai.basics import *
import numpy as np

# %% ../208_CarveMix.ipynb 4
class CarveMix(HolesFilling):
    "Defines the amount of holes, the technique used to make them and the probability of apply the technique."
    def __init__(self,
                 holes_num: int = 1, # The amount of holes to make.
                 modifier: "RegionModifier" = None, # The modifier that defines the traditional augments to apply to the selected regions.
                 ROI_class: int = -1, # The class to be used to select the ROI.
                 ROI_area: int = 25, # The minimum area to be selected as a ROI.
                 delta_ratio: float = None, # The ratio of pixels of the ROI that are going to be used. A ratio of 1 takes all the ROI pixels, a ratio < 1 crops the ROI and a ratio > 1 adds more pixels to the ROI. A None ratio takes a random value [0.9, 1.1) in each usage.
                 random_position: bool = False, # Whether the ROI should be added randomly in the image or in the same position it was extracted.
                 p: float = 0.5): # The probability of applying this technique.
        hole_maker = HoleMakerROI(ROI_class, ROI_area, delta_ratio)
        super().__init__(modifier, hole_maker)
        self.holes_num = holes_num
        self.random_position = random_position
        self.p = p

    def before_batch(self):
        "Applies the CutMix technique."
        
        if not self.training:
            return
        
        x, y = tensor(self.x).clone(), tensor(self.y).clone() # tensor is defined in fastai.basics
        for image, mask in zip(self.x, self.y):
            if random.random() < self.p:
                for _ in range(self.holes_num):
                    rand = random.randint(0, x.shape[0] - 1)
                    other_image, other_mask = x[rand], y[rand]
                    other_xhole, other_yhole = self.make_hole(other_mask)
                    sub_image, sub_mask = other_image[:, other_yhole, other_xhole], other_mask[other_yhole, other_xhole]
                    if self.random_position and not other_mask.shape == sub_mask.shape: # if other_mask == sub_mask, a full ROI region is selected and HMBounded can not be used.
                        xhole, yhole = HoleMakerBounded(hole_size = sub_mask.shape).get_hole(mask)
                    else:
                        xhole, yhole = other_xhole, other_yhole

                    self.fill_hole(image, mask, xhole, yhole, [sub_image, sub_mask])
