"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunPowerShellScriptSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const command_simulation_base_1 = require("./command-simulation-base");
class RunPowerShellScriptSimulation extends command_simulation_base_1.CommandSimulationBase {
    constructor(step, props) {
        super();
        this.step = step;
        this.props = props;
    }
    /**
     * Executes the runCommands against the environment provided in the constructor.
     */
    executeStep(inputs) {
        this.step.runCommand.forEach(cmd => {
            const command = cmd.resolve(inputs);
            // TODO what should we enclose the string with if it contains both ' and "
            const quote = command.includes("\'") ? '\"' : '\'';
            this.props.environment.run(`pwsh -c ${quote}${command}${quote}`);
        });
    }
}
exports.RunPowerShellScriptSimulation = RunPowerShellScriptSimulation;
_a = JSII_RTTI_SYMBOL_1;
RunPowerShellScriptSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.RunPowerShellScriptSimulation", version: "0.0.26" };
//# sourceMappingURL=data:application/json;base64,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