"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssertAwsResourceSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_simulation_base_1 = require("./automation-simulation-base");
const aws_api_simulation_1 = require("./aws-api-simulation");
// eslint-disable-next-line
const jp = require('jsonpath');
/**
 * AutomationStep implementation of aws:assertAwsResourceProperty.
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-assertAwsResourceProperty.html
 */
class AssertAwsResourceSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:assertAwsResourceProperty';
        this.assertStep = step;
        this.props = props;
    }
    /**
       * If the value found matches one of the desiredValues, then this function returns. Otherwise it throws.
       * @returns empty object if value matches desiredValues.
       */
    executeStep(inputs) {
        const awsResponse = new aws_api_simulation_1.AwsApiSimulation(this.assertStep, this.props).executeStep(inputs);
        if (this.matchesSelectedResponse(awsResponse)) {
            console.log('Found desired value in AWS response');
            return {};
        }
        else {
            throw new Error('Did not find desired response (' + this.assertStep.desiredValues + ') when selecting '
                + this.assertStep.selector + ' in ' + JSON.stringify(awsResponse));
        }
    }
    matchesSelectedResponse(awsResult) {
        const selectedResponse = this.parseSelectedOrNull(awsResult);
        console.log('Found selected response with selector ' + this.assertStep.selector + ': ' + selectedResponse);
        return selectedResponse != undefined && this.assertStep.desiredValues.includes(selectedResponse);
    }
    /**
       * Perform lookup in the aws result for the json path in the selector.
       */
    parseSelectedOrNull(awsResult) {
        try {
            return jp.query(awsResult, this.assertStep.selector)[0];
        }
        catch (error) {
            console.log('Error found when reading jsonpath: ' + error);
            return undefined;
        }
    }
}
exports.AssertAwsResourceSimulation = AssertAwsResourceSimulation;
_a = JSII_RTTI_SYMBOL_1;
AssertAwsResourceSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AssertAwsResourceSimulation", version: "0.0.26" };
//# sourceMappingURL=data:application/json;base64,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