"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunInstanceStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("../..");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implemenation for aws:runInstance
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-runinstance.html
 */
class RunInstanceStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:runInstances';
        this.imageId = props.imageId;
        this.instanceType = props.instanceType;
        this.minInstanceCount = props.minInstanceCount;
        this.maxInstanceCount = props.maxInstanceCount;
        this.additionalInfo = props.additionalInfo;
        this.blockDeviceMappings = props.blockDeviceMappings;
        this.clientToken = props.clientToken;
        this.disableApiTermination = props.disableApiTermination;
        this.ebsOptimized = props.ebsOptimized;
        this.iamInstanceProfileArn = props.iamInstanceProfileArn;
        this.iamInstanceProfileName = props.iamInstanceProfileName;
        this.instanceInitiatedShutdownBehavior = props.instanceInitiatedShutdownBehavior;
        this.kernelId = props.kernelId;
        this.keyName = props.keyName;
        this.monitoring = props.monitoring;
        this.networkInterfaces = props.networkInterfaces;
        this.placement = props.placement;
        this.privateIpAddress = props.privateIpAddress;
        this.ramdiskId = props.ramdiskId;
        this.securityGroupIds = props.securityGroupIds;
        this.securityGroups = props.securityGroups;
        this.subnetId = props.subnetId;
        this.tagSpecifications = props.tagSpecifications;
        this.userData = props.userData;
    }
    /**
       * @returns IDs and states of the new instances
       */
    listOutputs() {
        return [{
                outputType: __1.DataTypeEnum.STRING_LIST,
                name: 'InstanceIds',
                selector: '$.InstanceIds',
            }, {
                outputType: __1.DataTypeEnum.STRING_LIST,
                name: 'InstanceStates',
                selector: '$.InstanceStates',
            }];
    }
    /**
       * Derives the inputs based on given variables
       * @returns list of required inputs.
       */
    listInputs() {
        const inputs = [
            this.imageId,
            this.instanceType,
            this.minInstanceCount,
            this.maxInstanceCount,
            this.additionalInfo,
            this.blockDeviceMappings,
            this.clientToken,
            this.disableApiTermination,
            this.ebsOptimized,
            this.iamInstanceProfileArn,
            this.iamInstanceProfileName,
            this.instanceInitiatedShutdownBehavior,
            this.kernelId,
            this.keyName,
            this.monitoring,
            this.networkInterfaces,
            this.placement,
            this.privateIpAddress,
            this.ramdiskId,
            this.securityGroupIds,
            this.securityGroups,
            this.subnetId,
            this.tagSpecifications,
            this.userData,
        ];
        const requiredInputs = [];
        for (const input of inputs) {
            requiredInputs.push(...input?.requiredInputs() ?? []);
        }
        return requiredInputs;
    }
    toSsmEntry() {
        const inputMap = {
            ImageId: this.imageId,
            InstanceType: this.instanceType,
            MinInstanceCount: this.minInstanceCount,
            MaxInstanceCount: this.maxInstanceCount,
            AdditionalInfo: this.additionalInfo,
            BlockDeviceMappings: this.blockDeviceMappings,
            ClientToken: this.clientToken,
            DisableApiTermination: this.disableApiTermination,
            EbsOptimized: this.ebsOptimized,
            IamInstanceProfileArn: this.iamInstanceProfileArn,
            IamInstanceProfileName: this.iamInstanceProfileName,
            InstanceInitiatedShutdownBehavior: this.instanceInitiatedShutdownBehavior,
            KernelId: this.kernelId,
            KeyName: this.keyName,
            Monitoring: this.monitoring,
            NetworkInterfaces: this.networkInterfaces,
            Placement: this.placement,
            PrivateIpAddress: this.privateIpAddress,
            RamdiskId: this.ramdiskId,
            SecurityGroupIds: this.securityGroupIds,
            SecurityGroups: this.securityGroups,
            SubnetId: this.subnetId,
            TagSpecifications: this.tagSpecifications,
            UserData: this.userData,
        };
        const inputs = prune_and_transform_record_1.pruneAndTransformRecord(inputMap, x => x.print());
        return super.prepareSsmEntry(inputs);
    }
}
exports.RunInstanceStep = RunInstanceStep;
_a = JSII_RTTI_SYMBOL_1;
RunInstanceStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.RunInstanceStep", version: "0.0.26" };
//# sourceMappingURL=data:application/json;base64,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