import { IGenericVariable, GenericVariable, HardCodedValueBase } from './variable';
/**
 * Number type that can be null
 */
export declare type NullableNumber = number;
/**
 * A number variable
 */
export interface INumberVariable extends IGenericVariable {
    /**
       * Given the execution inputs, return the resolved value of this variable.
       * @param inputs are the execution inputs.
       */
    resolveToNumber(inputs: Record<string, any>): NullableNumber;
}
/**
 * A hard-coded number variable.
 * Used when not dependent on step inputs.
 */
export declare class HardCodedNumber extends HardCodedValueBase<number> implements INumberVariable {
    static of(val: number): HardCodedNumber;
    resolveToNumber(inputs: Record<string, any>): NullableNumber;
    protected assertType(value: any): void;
}
/**
 * A number variable reference.
 * Used to resolve the value from step inputs.
 */
export declare class NumberVariable extends GenericVariable implements INumberVariable {
    static of(reference: string): NumberVariable;
    resolveToNumber(inputs: Record<string, any>): NullableNumber;
    protected assertType(value: any): void;
}
/**
 * Assert that the given value is a NullableNumber.
 * @param value value to assert
 */
export declare function assertNumber(value: any): asserts value is NullableNumber;
/**
 * Whether the given value is a NullableNumber.
 * @param value value to check
 * @returns true if the value is a NullableNumber, otherwise false
 */
export declare function isNumber(value: any): value is NullableNumber;
