import { AutomationStep } from '../parent-steps/automation-step';
/**
 * Class to reference AutomationSteps.
 * The class allows steps to be referenced by the Step object or by the step name.
 */
export declare class StepRef {
    /**
     * Static constructor for creating a reference to a step from an AutomationStep object.
     */
    static fromObject(step: AutomationStep): StepRef;
    /**
     * Static constructor for creating a reference to a step from a step name.
     */
    static fromName(stepName: string): StepRef;
    readonly stepName: string;
    constructor(stepName: string);
    /**
     * Resolve to an AutomationStep object. Provide all the steps in the execution to find the associated step.
     */
    resolve(allStepsInExecution: AutomationStep[]): AutomationStep;
}
