"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SSMDocumentContent = exports.NameDoc = exports.ArnDoc = exports.DocumentSource = exports.S3Content = exports.HttpContent = exports.GitContent = exports.GitHubContent = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class GitHubContent {
    constructor(props) {
        this.sourceType = 'GitHub';
        this.owner = props.owner;
        this.repository = props.repository;
        this.path = props.path;
        this.tokenInfo = props.tokenInfo;
        this.branch = props.branch;
        this.commitId = props.commitId;
        if (this.branch != undefined && this.commitId != undefined) {
            throw new Error('May define either branch or commitId, not both');
        }
    }
    requiredInputs() {
        const inputs = [
            this.owner,
            this.repository,
            this.path,
            this.tokenInfo,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    formatSourceInfo() {
        const sourceInfo = {
            owner: this.owner,
            repository: this.repository,
            path: this.path,
            tokenInfo: this.tokenInfo,
        };
        if (this.branch != undefined) {
            sourceInfo.getOptions = `branch:${this.branch}`;
        }
        if (this.commitId != undefined) {
            sourceInfo.getOptions = `commitID:${this.commitId}`;
        }
        return sourceInfo;
    }
}
exports.GitHubContent = GitHubContent;
_a = JSII_RTTI_SYMBOL_1;
GitHubContent[_a] = { fqn: "@cdklabs/cdk-ssm-documents.GitHubContent", version: "0.0.26" };
class GitContent {
    constructor(props) {
        this.sourceType = 'Git';
        this.userName = props.userName;
        this.password = props.password;
        this.repository = props.repository;
        this.privateSshKey = props.privateSshKey;
        this.skipHostKeyChecking = props.skipHostKeyChecking;
        this.branch = props.branch;
        this.commitId = props.commitId;
    }
    requiredInputs() {
        const inputs = [
            this.repository,
            this.skipHostKeyChecking,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    formatSourceInfo() {
        const sourceInfo = {
            repository: this.repository,
        };
        if (this.skipHostKeyChecking != undefined) {
            sourceInfo.skipHostKeyChecking = this.skipHostKeyChecking;
        }
        if (this.privateSshKey != undefined) {
            sourceInfo.privateSSHKey = this.privateSshKey;
        }
        if (this.userName != undefined) {
            sourceInfo.username = this.userName;
        }
        if (this.password != undefined) {
            sourceInfo.password = this.password;
        }
        if (this.branch != undefined) {
            sourceInfo.getOptions = `branch:${this.branch}`;
        }
        if (this.commitId != undefined) {
            sourceInfo.getOptions = `commitID:${this.commitId}`;
        }
        return sourceInfo;
    }
}
exports.GitContent = GitContent;
_b = JSII_RTTI_SYMBOL_1;
GitContent[_b] = { fqn: "@cdklabs/cdk-ssm-documents.GitContent", version: "0.0.26" };
class HttpContent {
    constructor(props) {
        this.sourceType = 'HTTP';
        this.url = props.url;
        this.allowInsecureDownload = props.allowInsecureDownload;
        this.authMethod = props.authMethod;
    }
    requiredInputs() {
        const inputs = [
            this.url,
            this.allowInsecureDownload,
        ];
        return [...inputs.flatMap(i => i?.requiredInputs() ?? []), ...(this.authMethod?.requiredInputs() ?? [])];
    }
    formatSourceInfo() {
        const sourceInfo = {
            url: this.url,
        };
        if (this.allowInsecureDownload != undefined) {
            sourceInfo.allowInsecureDownload = this.allowInsecureDownload;
        }
        if (this.authMethod != undefined) {
            return {
                ...sourceInfo,
                ...this.authMethod.toEntry(),
            };
        }
        return sourceInfo;
    }
}
exports.HttpContent = HttpContent;
_c = JSII_RTTI_SYMBOL_1;
HttpContent[_c] = { fqn: "@cdklabs/cdk-ssm-documents.HttpContent", version: "0.0.26" };
class S3Content {
    constructor(props) {
        this.sourceType = 'S3';
        this.path = props.path;
    }
    requiredInputs() {
        const inputs = [
            this.path,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    formatSourceInfo() {
        return { path: this.path };
    }
}
exports.S3Content = S3Content;
_d = JSII_RTTI_SYMBOL_1;
S3Content[_d] = { fqn: "@cdklabs/cdk-ssm-documents.S3Content", version: "0.0.26" };
class DocumentSource {
    static fromArn(arn) {
        return new ArnDoc(arn);
    }
    static fromName(name, version) {
        return new NameDoc(name, version);
    }
}
exports.DocumentSource = DocumentSource;
_e = JSII_RTTI_SYMBOL_1;
DocumentSource[_e] = { fqn: "@cdklabs/cdk-ssm-documents.DocumentSource", version: "0.0.26" };
class ArnDoc extends DocumentSource {
    constructor(arn) {
        super();
        this.arn = arn;
    }
    formatRequest() {
        return { Name: this.arn };
    }
    requiredInputs() {
        return this.arn.requiredInputs();
    }
}
exports.ArnDoc = ArnDoc;
_f = JSII_RTTI_SYMBOL_1;
ArnDoc[_f] = { fqn: "@cdklabs/cdk-ssm-documents.ArnDoc", version: "0.0.26" };
class NameDoc extends DocumentSource {
    constructor(name, version) {
        super();
        this.name = name;
        this.version = version;
    }
    formatRequest() {
        if (this.version != undefined) {
            return { Name: this.name.print() + ':' + this.version.print() };
        }
        return { Name: this.name };
    }
    requiredInputs() {
        return [...this.name.requiredInputs(), ...this.version?.requiredInputs() ?? []];
    }
}
exports.NameDoc = NameDoc;
_g = JSII_RTTI_SYMBOL_1;
NameDoc[_g] = { fqn: "@cdklabs/cdk-ssm-documents.NameDoc", version: "0.0.26" };
class SSMDocumentContent {
    constructor(props) {
        this.sourceType = 'SSMDocument';
        this.documentSource = props.documentSource;
    }
    formatSourceInfo() {
        return this.documentSource.formatRequest();
    }
    requiredInputs() {
        return this.documentSource.requiredInputs();
    }
}
exports.SSMDocumentContent = SSMDocumentContent;
_h = JSII_RTTI_SYMBOL_1;
SSMDocumentContent[_h] = { fqn: "@cdklabs/cdk-ssm-documents.SSMDocumentContent", version: "0.0.26" };
//# sourceMappingURL=data:application/json;base64,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