"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IncidentResponse = exports.IncidentTemplate = exports.IncidentResponseAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ssmincidents_1 = require("aws-cdk-lib/aws-ssmincidents");
const constructs_1 = require("constructs");
/**
 * The Action property type specifies the configuration to launch.
 * @link: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmincidents-responseplan-action.html
 */
class IncidentResponseAction {
    constructor(cfnEntry) {
        this.cfnEntry = cfnEntry;
    }
    /**
     * Specify the AutomationDocument to use for the action property.
     */
    static ssmAutomation(automationDocument, role, props) {
        return new IncidentResponseAction({
            ssmAutomation: {
                documentName: automationDocument.cfnDocument.ref,
                roleArn: role.roleArn,
                dynamicParameters: Object.entries(props?.parameters ?? {}).filter(([_k, v]) => v.print().includes('{{')).map(([k, v]) => IncidentResponseAction.toDynamicParam(k, v)),
                parameters: Object.entries(props?.parameters ?? {}).filter(([_k, v]) => !v.print().includes('{{')).map(([k, v]) => IncidentResponseAction.toParam(k, v)),
                targetAccount: props?.targetAccount,
            },
        });
    }
    static ssmAutomationEscapeHatch(ssmAutomationProperty) {
        return new IncidentResponseAction({ ssmAutomation: ssmAutomationProperty });
    }
    static toDynamicParam(key, value) {
        return {
            key: key,
            value: { variable: value.reference },
        };
    }
    static toParam(key, value) {
        return {
            key: key,
            values: [value.print()],
        };
    }
}
exports.IncidentResponseAction = IncidentResponseAction;
_a = JSII_RTTI_SYMBOL_1;
IncidentResponseAction[_a] = { fqn: "@cdklabs/cdk-ssm-documents.IncidentResponseAction", version: "0.0.26" };
/**
 * Provides L2 construct for https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmincidents-responseplan-incidenttemplate.html
 */
class IncidentTemplate {
    constructor(impact, title, props) {
        this.cfnEntry = {
            impact: impact,
            title: title,
            ...props,
        };
    }
    /**
     * Critical impact typically relates to full application failure that impacts many to all customers.
     */
    static critical(title, props) {
        return new IncidentTemplate(1, title, props);
    }
    /**
     * High impact denotes partial application failure with impact to many customers.
     */
    static high(title, props) {
        return new IncidentTemplate(2, title, props);
    }
    /**
     * Medium impact denotes that the application is providing reduced service to customers.
     */
    static medium(title, props) {
        return new IncidentTemplate(3, title, props);
    }
    /**
     * Low impact denotes that customers may not be impacted by the problem yet.
     */
    static low(title, props) {
        return new IncidentTemplate(4, title, props);
    }
    /**
     * No impact denotes that customers aren't currently impacted but urgent action is needed to avoid impact.
     */
    static noImpact(title, props) {
        return new IncidentTemplate(5, title, props);
    }
}
exports.IncidentTemplate = IncidentTemplate;
_b = JSII_RTTI_SYMBOL_1;
IncidentTemplate[_b] = { fqn: "@cdklabs/cdk-ssm-documents.IncidentTemplate", version: "0.0.26" };
/**
 * Provides L2 construct for https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#aws-resource-ssmincidents-responseplan-properties
 */
class IncidentResponse extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.cfnResponsePlan = new aws_ssmincidents_1.CfnResponsePlan(this, 'Resource', {
            actions: props.actions.map(a => a.cfnEntry),
            name: id,
            incidentTemplate: props.incidentTemplate.cfnEntry,
            chatChannel: props.chatChannel,
            tags: props.tags,
            engagements: props.engagements,
            displayName: props.displayName,
        });
    }
}
exports.IncidentResponse = IncidentResponse;
_c = JSII_RTTI_SYMBOL_1;
IncidentResponse[_c] = { fqn: "@cdklabs/cdk-ssm-documents.IncidentResponse", version: "0.0.26" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5jaWRlbnQtcmVzcG9uc2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaW5jaWRlbnQtcmVzcG9uc2UvaW5jaWRlbnQtcmVzcG9uc2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFFQSxtRUFBK0Q7QUFDL0QsMkNBQXVDO0FBa0J2Qzs7O0dBR0c7QUFDSCxNQUFhLHNCQUFzQjtJQW9DakMsWUFBWSxRQUF3QztRQUNsRCxJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztJQUMzQixDQUFDO0lBckNEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLGFBQWEsQ0FBQyxrQkFBc0MsRUFBRSxJQUFVLEVBQUUsS0FBMEI7UUFDeEcsT0FBTyxJQUFJLHNCQUFzQixDQUFDO1lBQ2hDLGFBQWEsRUFBRTtnQkFDYixZQUFZLEVBQUUsa0JBQWtCLENBQUMsV0FBVyxDQUFDLEdBQUc7Z0JBQ2hELE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztnQkFDckIsaUJBQWlCLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsVUFBVSxJQUFJLEVBQUUsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsS0FBSyxFQUFFLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLHNCQUFzQixDQUFDLGNBQWMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7Z0JBQ3JLLFVBQVUsRUFBRSxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxVQUFVLElBQUksRUFBRSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssRUFBRSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxPQUFPLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO2dCQUN4SixhQUFhLEVBQUUsS0FBSyxFQUFFLGFBQWE7YUFDcEM7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU0sTUFBTSxDQUFDLHdCQUF3QixDQUFDLHFCQUE0RDtRQUNqRyxPQUFPLElBQUksc0JBQXNCLENBQUMsRUFBRSxhQUFhLEVBQUUscUJBQXFCLEVBQUUsQ0FBQyxDQUFDO0lBQzlFLENBQUM7SUFFTyxNQUFNLENBQUMsY0FBYyxDQUFDLEdBQVcsRUFBRSxLQUF1QjtRQUNoRSxPQUFPO1lBQ0wsR0FBRyxFQUFFLEdBQUc7WUFDUixLQUFLLEVBQUUsRUFBRSxRQUFRLEVBQXFCLEtBQU0sQ0FBQyxTQUFTLEVBQUU7U0FDekQsQ0FBQztJQUNKLENBQUM7SUFFTyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQVcsRUFBRSxLQUF1QjtRQUN6RCxPQUFPO1lBQ0wsR0FBRyxFQUFFLEdBQUc7WUFDUixNQUFNLEVBQUUsQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7U0FDeEIsQ0FBQztJQUNKLENBQUM7O0FBaENILHdEQXdDQzs7O0FBZ0NEOztHQUVHO0FBQ0gsTUFBYSxnQkFBZ0I7SUFxQzNCLFlBQVksTUFBYyxFQUFFLEtBQWEsRUFBRSxLQUE0QjtRQUNyRSxJQUFJLENBQUMsUUFBUSxHQUFHO1lBQ2QsTUFBTSxFQUFFLE1BQU07WUFDZCxLQUFLLEVBQUUsS0FBSztZQUNaLEdBQUcsS0FBSztTQUNULENBQUM7SUFDSixDQUFDO0lBMUNEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFFBQVEsQ0FBQyxLQUFhLEVBQUUsS0FBNEI7UUFDaEUsT0FBTyxJQUFJLGdCQUFnQixDQUFDLENBQUMsRUFBRSxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFhLEVBQUUsS0FBNEI7UUFDNUQsT0FBTyxJQUFJLGdCQUFnQixDQUFDLENBQUMsRUFBRSxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLE1BQU0sQ0FBQyxLQUFhLEVBQUUsS0FBNEI7UUFDOUQsT0FBTyxJQUFJLGdCQUFnQixDQUFDLENBQUMsRUFBRSxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLEdBQUcsQ0FBQyxLQUFhLEVBQUUsS0FBNEI7UUFDM0QsT0FBTyxJQUFJLGdCQUFnQixDQUFDLENBQUMsRUFBRSxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFFBQVEsQ0FBQyxLQUFhLEVBQUUsS0FBNEI7UUFDaEUsT0FBTyxJQUFJLGdCQUFnQixDQUFDLENBQUMsRUFBRSxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDL0MsQ0FBQzs7QUFsQ0gsNENBNkNDOzs7QUEyQ0Q7O0dBRUc7QUFDSCxNQUFhLGdCQUFpQixTQUFRLHNCQUFTO0lBRTdDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBNEI7UUFDcEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksa0NBQWUsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQzNELE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUM7WUFDM0MsSUFBSSxFQUFFLEVBQUU7WUFDUixnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsUUFBUTtZQUNqRCxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7U0FDL0IsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFkSCw0Q0FlQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENmblRhZywgSVJlc29sdmFibGUgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBSb2xlIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBDZm5SZXNwb25zZVBsYW4gfSBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc3NtaW5jaWRlbnRzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQXV0b21hdGlvbkRvY3VtZW50IH0gZnJvbSAnLi4vZG9jdW1lbnQvYXV0b21hdGlvbi1kb2N1bWVudCc7XG5pbXBvcnQgeyBHZW5lcmljVmFyaWFibGUsIElHZW5lcmljVmFyaWFibGUgfSBmcm9tICcuLi9pbnRlcmZhY2UvdmFyaWFibGVzL3ZhcmlhYmxlJztcblxuZXhwb3J0IGludGVyZmFjZSBTc21BdXRvbWF0aW9uUHJvcHMge1xuICAvKipcbiAgICogVGhlIGFjY291bnQgdGhhdCB0aGUgYXV0b21hdGlvbiBkb2N1bWVudCB3aWxsIGJlIHJ1biBpbi4gVGhpcyBjYW4gYmUgaW4gZWl0aGVyIHRoZSBtYW5hZ2VtZW50IGFjY291bnQgb3IgYW4gYXBwbGljYXRpb24gYWNjb3VudC5cbiAgICogQGxpbms6IGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtc3NtaW5jaWRlbnRzLXJlc3BvbnNlcGxhbi1zc21hdXRvbWF0aW9uLmh0bWwjY2ZuLXNzbWluY2lkZW50cy1yZXNwb25zZXBsYW4tc3NtYXV0b21hdGlvbi10YXJnZXRhY2NvdW50XG4gICAqL1xuICByZWFkb25seSB0YXJnZXRBY2NvdW50Pzogc3RyaW5nO1xuICAvKipcbiAgICogU3BlY2lmeSBlaXRoZXIgU3RyaW5nVmFyaWFibGVzIG9yIEhhcmRDb2RlZFZhbHVlcy5cbiAgICogQGxpbms6IGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXNzbWluY2lkZW50cy1yZXNwb25zZXBsYW4tZHluYW1pY3NzbXBhcmFtZXRlcnZhbHVlLmh0bWxcbiAgICogQGxpbms6IGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXNzbWluY2lkZW50cy1yZXNwb25zZXBsYW4tc3NtcGFyYW1ldGVyLmh0bWxcbiAgICovXG4gIHJlYWRvbmx5IHBhcmFtZXRlcnM6IHsgW25hbWU6IHN0cmluZ106IElHZW5lcmljVmFyaWFibGUgfTtcbn1cblxuLyoqXG4gKiBUaGUgQWN0aW9uIHByb3BlcnR5IHR5cGUgc3BlY2lmaWVzIHRoZSBjb25maWd1cmF0aW9uIHRvIGxhdW5jaC5cbiAqIEBsaW5rOiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1zc21pbmNpZGVudHMtcmVzcG9uc2VwbGFuLWFjdGlvbi5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBJbmNpZGVudFJlc3BvbnNlQWN0aW9uIHtcbiAgLyoqXG4gICAqIFNwZWNpZnkgdGhlIEF1dG9tYXRpb25Eb2N1bWVudCB0byB1c2UgZm9yIHRoZSBhY3Rpb24gcHJvcGVydHkuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHNzbUF1dG9tYXRpb24oYXV0b21hdGlvbkRvY3VtZW50OiBBdXRvbWF0aW9uRG9jdW1lbnQsIHJvbGU6IFJvbGUsIHByb3BzPzogU3NtQXV0b21hdGlvblByb3BzKSB7XG4gICAgcmV0dXJuIG5ldyBJbmNpZGVudFJlc3BvbnNlQWN0aW9uKHtcbiAgICAgIHNzbUF1dG9tYXRpb246IHtcbiAgICAgICAgZG9jdW1lbnROYW1lOiBhdXRvbWF0aW9uRG9jdW1lbnQuY2ZuRG9jdW1lbnQucmVmLFxuICAgICAgICByb2xlQXJuOiByb2xlLnJvbGVBcm4sXG4gICAgICAgIGR5bmFtaWNQYXJhbWV0ZXJzOiBPYmplY3QuZW50cmllcyhwcm9wcz8ucGFyYW1ldGVycyA/PyB7fSkuZmlsdGVyKChbX2ssIHZdKSA9PiB2LnByaW50KCkuaW5jbHVkZXMoJ3t7JykpLm1hcCgoW2ssIHZdKSA9PiBJbmNpZGVudFJlc3BvbnNlQWN0aW9uLnRvRHluYW1pY1BhcmFtKGssIHYpKSxcbiAgICAgICAgcGFyYW1ldGVyczogT2JqZWN0LmVudHJpZXMocHJvcHM/LnBhcmFtZXRlcnMgPz8ge30pLmZpbHRlcigoW19rLCB2XSkgPT4gIXYucHJpbnQoKS5pbmNsdWRlcygne3snKSkubWFwKChbaywgdl0pID0+IEluY2lkZW50UmVzcG9uc2VBY3Rpb24udG9QYXJhbShrLCB2KSksXG4gICAgICAgIHRhcmdldEFjY291bnQ6IHByb3BzPy50YXJnZXRBY2NvdW50LFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBzdGF0aWMgc3NtQXV0b21hdGlvbkVzY2FwZUhhdGNoKHNzbUF1dG9tYXRpb25Qcm9wZXJ0eTogQ2ZuUmVzcG9uc2VQbGFuLlNzbUF1dG9tYXRpb25Qcm9wZXJ0eSkge1xuICAgIHJldHVybiBuZXcgSW5jaWRlbnRSZXNwb25zZUFjdGlvbih7IHNzbUF1dG9tYXRpb246IHNzbUF1dG9tYXRpb25Qcm9wZXJ0eSB9KTtcbiAgfVxuXG4gIHByaXZhdGUgc3RhdGljIHRvRHluYW1pY1BhcmFtKGtleTogc3RyaW5nLCB2YWx1ZTogSUdlbmVyaWNWYXJpYWJsZSk6IENmblJlc3BvbnNlUGxhbi5EeW5hbWljU3NtUGFyYW1ldGVyUHJvcGVydHkge1xuICAgIHJldHVybiB7XG4gICAgICBrZXk6IGtleSxcbiAgICAgIHZhbHVlOiB7IHZhcmlhYmxlOiAoPEdlbmVyaWNWYXJpYWJsZT4gdmFsdWUpLnJlZmVyZW5jZSB9LFxuICAgIH07XG4gIH1cblxuICBwcml2YXRlIHN0YXRpYyB0b1BhcmFtKGtleTogc3RyaW5nLCB2YWx1ZTogSUdlbmVyaWNWYXJpYWJsZSk6IENmblJlc3BvbnNlUGxhbi5Tc21QYXJhbWV0ZXJQcm9wZXJ0eSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGtleToga2V5LFxuICAgICAgdmFsdWVzOiBbdmFsdWUucHJpbnQoKV0sXG4gICAgfTtcbiAgfVxuXG4gIHJlYWRvbmx5IGNmbkVudHJ5OiBDZm5SZXNwb25zZVBsYW4uQWN0aW9uUHJvcGVydHk7XG5cbiAgY29uc3RydWN0b3IoY2ZuRW50cnk6IENmblJlc3BvbnNlUGxhbi5BY3Rpb25Qcm9wZXJ0eSkge1xuICAgIHRoaXMuY2ZuRW50cnkgPSBjZm5FbnRyeTtcbiAgfVxuXG59XG5cbi8qKlxuICogUHJvdmlkZXMgTDIgY29uc3RydWN0IGZvciBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1zc21pbmNpZGVudHMtcmVzcG9uc2VwbGFuLWluY2lkZW50dGVtcGxhdGUuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEluY2lkZW50VGVtcGxhdGVQcm9wcyB7XG4gIC8qKlxuICAgKiBVc2VkIHRvIGNyZWF0ZSBvbmx5IG9uZSBpbmNpZGVudCByZWNvcmQgZm9yIGFuIGluY2lkZW50LlxuICAgKlxuICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXNzbWluY2lkZW50cy1yZXNwb25zZXBsYW4taW5jaWRlbnR0ZW1wbGF0ZS5odG1sI2Nmbi1zc21pbmNpZGVudHMtcmVzcG9uc2VwbGFuLWluY2lkZW50dGVtcGxhdGUtZGVkdXBlc3RyaW5nXG4gICAqL1xuICByZWFkb25seSBkZWR1cGVTdHJpbmc/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBgQ2ZuUmVzcG9uc2VQbGFuLkluY2lkZW50VGVtcGxhdGVQcm9wZXJ0eS5JbmNpZGVudFRhZ3NgXG4gICAqXG4gICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtc3NtaW5jaWRlbnRzLXJlc3BvbnNlcGxhbi1pbmNpZGVudHRlbXBsYXRlLmh0bWwjY2ZuLXNzbWluY2lkZW50cy1yZXNwb25zZXBsYW4taW5jaWRlbnR0ZW1wbGF0ZS1pbmNpZGVudHRhZ3NcbiAgICovXG4gIHJlYWRvbmx5IGluY2lkZW50VGFncz86IEFycmF5PENmblRhZyB8IElSZXNvbHZhYmxlPiB8IElSZXNvbHZhYmxlO1xuICAvKipcbiAgICogVGhlIFNOUyB0YXJnZXRzIHRoYXQgQVdTIENoYXRib3QgdXNlcyB0byBub3RpZnkgdGhlIGNoYXQgY2hhbm5lbCBvZiB1cGRhdGVzIHRvIGFuIGluY2lkZW50LiBZb3UgY2FuIGFsc28gbWFrZSB1cGRhdGVzIHRvIHRoZSBpbmNpZGVudCB0aHJvdWdoIHRoZSBjaGF0IGNoYW5uZWwgdXNpbmcgdGhlIFNOUyB0b3BpY3MuXG4gICAqXG4gICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtc3NtaW5jaWRlbnRzLXJlc3BvbnNlcGxhbi1pbmNpZGVudHRlbXBsYXRlLmh0bWwjY2ZuLXNzbWluY2lkZW50cy1yZXNwb25zZXBsYW4taW5jaWRlbnR0ZW1wbGF0ZS1ub3RpZmljYXRpb250YXJnZXRzXG4gICAqL1xuICByZWFkb25seSBub3RpZmljYXRpb25UYXJnZXRzPzogQXJyYXk8Q2ZuUmVzcG9uc2VQbGFuLk5vdGlmaWNhdGlvblRhcmdldEl0ZW1Qcm9wZXJ0eSB8IElSZXNvbHZhYmxlPiB8IElSZXNvbHZhYmxlO1xuICAvKipcbiAgICogVGhlIHN1bW1hcnkgZGVzY3JpYmVzIHdoYXQgaGFzIGhhcHBlbmVkIGR1cmluZyB0aGUgaW5jaWRlbnQuXG4gICAqXG4gICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtc3NtaW5jaWRlbnRzLXJlc3BvbnNlcGxhbi1pbmNpZGVudHRlbXBsYXRlLmh0bWwjY2ZuLXNzbWluY2lkZW50cy1yZXNwb25zZXBsYW4taW5jaWRlbnR0ZW1wbGF0ZS1zdW1tYXJ5XG4gICAqL1xuICByZWFkb25seSBzdW1tYXJ5Pzogc3RyaW5nO1xufVxuXG4vKipcbiAqIFByb3ZpZGVzIEwyIGNvbnN0cnVjdCBmb3IgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtc3NtaW5jaWRlbnRzLXJlc3BvbnNlcGxhbi1pbmNpZGVudHRlbXBsYXRlLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIEluY2lkZW50VGVtcGxhdGUge1xuICAvKipcbiAgICogQ3JpdGljYWwgaW1wYWN0IHR5cGljYWxseSByZWxhdGVzIHRvIGZ1bGwgYXBwbGljYXRpb24gZmFpbHVyZSB0aGF0IGltcGFjdHMgbWFueSB0byBhbGwgY3VzdG9tZXJzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBjcml0aWNhbCh0aXRsZTogc3RyaW5nLCBwcm9wczogSW5jaWRlbnRUZW1wbGF0ZVByb3BzKTogSW5jaWRlbnRUZW1wbGF0ZSB7XG4gICAgcmV0dXJuIG5ldyBJbmNpZGVudFRlbXBsYXRlKDEsIHRpdGxlLCBwcm9wcyk7XG4gIH1cblxuICAvKipcbiAgICogSGlnaCBpbXBhY3QgZGVub3RlcyBwYXJ0aWFsIGFwcGxpY2F0aW9uIGZhaWx1cmUgd2l0aCBpbXBhY3QgdG8gbWFueSBjdXN0b21lcnMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGhpZ2godGl0bGU6IHN0cmluZywgcHJvcHM6IEluY2lkZW50VGVtcGxhdGVQcm9wcyk6IEluY2lkZW50VGVtcGxhdGUge1xuICAgIHJldHVybiBuZXcgSW5jaWRlbnRUZW1wbGF0ZSgyLCB0aXRsZSwgcHJvcHMpO1xuICB9XG5cbiAgLyoqXG4gICAqIE1lZGl1bSBpbXBhY3QgZGVub3RlcyB0aGF0IHRoZSBhcHBsaWNhdGlvbiBpcyBwcm92aWRpbmcgcmVkdWNlZCBzZXJ2aWNlIHRvIGN1c3RvbWVycy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgbWVkaXVtKHRpdGxlOiBzdHJpbmcsIHByb3BzOiBJbmNpZGVudFRlbXBsYXRlUHJvcHMpOiBJbmNpZGVudFRlbXBsYXRlIHtcbiAgICByZXR1cm4gbmV3IEluY2lkZW50VGVtcGxhdGUoMywgdGl0bGUsIHByb3BzKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBMb3cgaW1wYWN0IGRlbm90ZXMgdGhhdCBjdXN0b21lcnMgbWF5IG5vdCBiZSBpbXBhY3RlZCBieSB0aGUgcHJvYmxlbSB5ZXQuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGxvdyh0aXRsZTogc3RyaW5nLCBwcm9wczogSW5jaWRlbnRUZW1wbGF0ZVByb3BzKTogSW5jaWRlbnRUZW1wbGF0ZSB7XG4gICAgcmV0dXJuIG5ldyBJbmNpZGVudFRlbXBsYXRlKDQsIHRpdGxlLCBwcm9wcyk7XG4gIH1cblxuICAvKipcbiAgICogTm8gaW1wYWN0IGRlbm90ZXMgdGhhdCBjdXN0b21lcnMgYXJlbid0IGN1cnJlbnRseSBpbXBhY3RlZCBidXQgdXJnZW50IGFjdGlvbiBpcyBuZWVkZWQgdG8gYXZvaWQgaW1wYWN0LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBub0ltcGFjdCh0aXRsZTogc3RyaW5nLCBwcm9wczogSW5jaWRlbnRUZW1wbGF0ZVByb3BzKTogSW5jaWRlbnRUZW1wbGF0ZSB7XG4gICAgcmV0dXJuIG5ldyBJbmNpZGVudFRlbXBsYXRlKDUsIHRpdGxlLCBwcm9wcyk7XG4gIH1cbiAgcmVhZG9ubHkgY2ZuRW50cnk6IENmblJlc3BvbnNlUGxhbi5JbmNpZGVudFRlbXBsYXRlUHJvcGVydHk7XG5cbiAgY29uc3RydWN0b3IoaW1wYWN0OiBudW1iZXIsIHRpdGxlOiBzdHJpbmcsIHByb3BzOiBJbmNpZGVudFRlbXBsYXRlUHJvcHMpIHtcbiAgICB0aGlzLmNmbkVudHJ5ID0ge1xuICAgICAgaW1wYWN0OiBpbXBhY3QsXG4gICAgICB0aXRsZTogdGl0bGUsXG4gICAgICAuLi5wcm9wcyxcbiAgICB9O1xuICB9XG5cbn1cblxuLyoqXG4gKiBQcm92aWRlcyBwcm9wcyBJbmNpZGVudFJlc3BvbnNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSW5jaWRlbnRSZXNwb25zZVByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBhY3Rpb25zIHRoYXQgdGhlIHJlc3BvbnNlIHBsYW4gc3RhcnRzIGF0IHRoZSBiZWdpbm5pbmcgb2YgYW4gaW5jaWRlbnQuXG4gICAqL1xuICByZWFkb25seSBhY3Rpb25zOiBJbmNpZGVudFJlc3BvbnNlQWN0aW9uW107XG5cbiAgLyoqXG4gICAqIERldGFpbHMgdXNlZCB0byBjcmVhdGUgYW4gaW5jaWRlbnQgd2hlbiB1c2luZyB0aGlzIHJlc3BvbnNlIHBsYW4uXG4gICAqL1xuICByZWFkb25seSBpbmNpZGVudFRlbXBsYXRlOiBJbmNpZGVudFRlbXBsYXRlO1xuICAvKipcbiAgICogVGhlIEFXUyBDaGF0Ym90IGNoYXQgY2hhbm5lbCB1c2VkIGZvciBjb2xsYWJvcmF0aW9uIGR1cmluZyBhbiBpbmNpZGVudC5cbiAgICpcbiAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3NtaW5jaWRlbnRzLXJlc3BvbnNlcGxhbi5odG1sI2Nmbi1zc21pbmNpZGVudHMtcmVzcG9uc2VwbGFuLWNoYXRjaGFubmVsXG4gICAqL1xuICByZWFkb25seSBjaGF0Q2hhbm5lbD86IENmblJlc3BvbnNlUGxhbi5DaGF0Q2hhbm5lbFByb3BlcnR5IHwgSVJlc29sdmFibGU7XG4gIC8qKlxuICAgKiBUaGUgaHVtYW4gcmVhZGFibGUgbmFtZSBvZiB0aGUgcmVzcG9uc2UgcGxhbi5cbiAgICpcbiAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3NtaW5jaWRlbnRzLXJlc3BvbnNlcGxhbi5odG1sI2Nmbi1zc21pbmNpZGVudHMtcmVzcG9uc2VwbGFuLWRpc3BsYXluYW1lXG4gICAqL1xuICByZWFkb25seSBkaXNwbGF5TmFtZT86IHN0cmluZztcbiAgLyoqXG4gICAqIFRoZSBjb250YWN0cyBhbmQgZXNjYWxhdGlvbiBwbGFucyB0aGF0IHRoZSByZXNwb25zZSBwbGFuIGVuZ2FnZXMgZHVyaW5nIGFuIGluY2lkZW50LlxuICAgKlxuICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zc21pbmNpZGVudHMtcmVzcG9uc2VwbGFuLmh0bWwjY2ZuLXNzbWluY2lkZW50cy1yZXNwb25zZXBsYW4tZW5nYWdlbWVudHNcbiAgICovXG4gIHJlYWRvbmx5IGVuZ2FnZW1lbnRzPzogc3RyaW5nW107XG4gIC8qKlxuICAgKiBBbiBhcnJheSBvZiBrZXktdmFsdWUgcGFpcnMgdG8gYXBwbHkgdG8gdGhpcyByZXNvdXJjZS5cbiAgICpcbiAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbVGFnXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1yZXNvdXJjZS10YWdzLmh0bWwpIC5cbiAgICpcbiAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3NtaW5jaWRlbnRzLXJlc3BvbnNlcGxhbi5odG1sI2Nmbi1zc21pbmNpZGVudHMtcmVzcG9uc2VwbGFuLXRhZ3NcbiAgICovXG4gIHJlYWRvbmx5IHRhZ3M/OiBDZm5UYWdbXTtcbn1cblxuLyoqXG4gKiBQcm92aWRlcyBMMiBjb25zdHJ1Y3QgZm9yIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zc21pbmNpZGVudHMtcmVzcG9uc2VwbGFuLmh0bWwjYXdzLXJlc291cmNlLXNzbWluY2lkZW50cy1yZXNwb25zZXBsYW4tcHJvcGVydGllc1xuICovXG5leHBvcnQgY2xhc3MgSW5jaWRlbnRSZXNwb25zZSBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHJlYWRvbmx5IGNmblJlc3BvbnNlUGxhbjogQ2ZuUmVzcG9uc2VQbGFuO1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSW5jaWRlbnRSZXNwb25zZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMuY2ZuUmVzcG9uc2VQbGFuID0gbmV3IENmblJlc3BvbnNlUGxhbih0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBhY3Rpb25zOiBwcm9wcy5hY3Rpb25zLm1hcChhID0+IGEuY2ZuRW50cnkpLFxuICAgICAgbmFtZTogaWQsXG4gICAgICBpbmNpZGVudFRlbXBsYXRlOiBwcm9wcy5pbmNpZGVudFRlbXBsYXRlLmNmbkVudHJ5LFxuICAgICAgY2hhdENoYW5uZWw6IHByb3BzLmNoYXRDaGFubmVsLFxuICAgICAgdGFnczogcHJvcHMudGFncyxcbiAgICAgIGVuZ2FnZW1lbnRzOiBwcm9wcy5lbmdhZ2VtZW50cyxcbiAgICAgIGRpc3BsYXlOYW1lOiBwcm9wcy5kaXNwbGF5TmFtZSxcbiAgICB9KTtcbiAgfVxufVxuIl19