/**
 * Operation to use for comparing a Choice's or Preconditions with provided value.
 * See https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-branch.html
 * or https://docs.aws.amazon.com/systems-manager/latest/userguide/document-schemas-features.html
 */
export declare enum Operation {
    BOOLEAN_EQUALS = 0,
    CONTAINS = 1,
    ENDS_WITH = 2,
    STARTS_WITH = 3,
    STRING_EQUALS = 4,
    EQUALS_IGNORE_CASE = 5,
    NUMERIC_EQUALS = 6,
    NUMERIC_GREATER = 7,
    NUMERIC_GREATER_OR_EQUALS = 8,
    NUMERIC_LESSER = 9,
    NUMERIC_LESSER_OR_EQUALS = 10
}
export declare class OperationEvaluator {
    static readonly STRING_TO_OPERATION: {
        [name: string]: Operation;
    };
    /**
       * Converts a string to OperationType
       * @param operationName an operation name to return its OperationType
       * @returns an OperationType
       * @throws if operationName is not supported
       */
    static fromOperationName(operationName: string): Operation;
    readonly operation: Operation;
    constructor(operation: Operation);
    /**
       * Evaluates this operation against the provided inputs.
       * @returns true if the evaluation is true. False otherwise.
       */
    evaluate(value1: any, value2: any): boolean;
    /**
       * @returns the string representation used by SSM for the operation.
       */
    toOperationName(): string;
}
