"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormat = exports.Encryption = exports.Machine = exports.Technology = exports.Size = exports.TechnicalAssetType = exports.TechnicalAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const communication_1 = require("./communication");
const model_1 = require("./model");
const resource_1 = require("./resource");
const scope_1 = require("./scope");
class TechnicalAsset extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.type = props.type;
        this.usage = props.usage;
        this.humanUse = props.humanUse;
        this.internet = props.internet;
        this.scope = props.scope ?? scope_1.Scope.inScope();
        this.size = props.size;
        this.technology = props.technology;
        this.tags = props.tags;
        this.machine = props.machine;
        this.encryption = props.encryption;
        this.owner = props.owner;
        this.ciaTriad = props.ciaTriad;
        this.multiTenant = props.multiTenant;
        this.redundant = props.redundant;
        this.customDevelopedParts = props.customDevelopedParts ?? false;
        this.dataFormatsAccepted = props.dataFormatsAccepted;
        this.dataAssetsProcessed = new Set();
        this.dataAssetsStored = new Set();
        this.communications = new Array();
        if (this.tags && this.tags.length > 0) {
            const model = model_1.Model.of(this);
            model.addTags(...this.tags);
        }
        if (props.trustBoundary) {
            props.trustBoundary.addTechnicalAssets(this);
        }
    }
    processes(...assets) {
        assets.forEach((a) => {
            this.dataAssetsProcessed.add(a.uuid);
        });
    }
    stores(...assets) {
        assets.forEach((a) => {
            this.dataAssetsStored.add(a.uuid);
        });
    }
    communicatesWith(id, target, options) {
        const communication = new communication_1.Communication(id, {
            caller: this,
            target: target,
            ...options,
        });
        this.communications.push(communication);
        return communication;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const threagile = {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                type: this.type,
                usage: this.usage,
                used_as_client_by_human: this.humanUse,
                ...this.scope?._toThreagile(),
                size: this.size,
                technology: this.technology,
                tags: Array.from(new Set(this.tags)),
                internet: this.internet,
                machine: this.machine,
                encryption: this.encryption,
                owner: this.owner,
                ...this.ciaTriad._toThreagile(),
                multitenant: this.multiTenant,
                redundant: this.redundant,
                custom_developed_parts: this.customDevelopedParts,
                data_assets_processed: Array.from(this.dataAssetsProcessed),
                data_assets_stored: Array.from(this.dataAssetsStored),
                data_formats_accepted: this.dataFormatsAccepted,
            },
        };
        threagile[this.node.id].communication_links = this.communications.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        return threagile;
    }
}
exports.TechnicalAsset = TechnicalAsset;
_a = JSII_RTTI_SYMBOL_1;
TechnicalAsset[_a] = { fqn: "cdktg.TechnicalAsset", version: "0.0.26" };
var TechnicalAssetType;
(function (TechnicalAssetType) {
    TechnicalAssetType["EXTERNAL_ENTITY"] = "external-entity";
    TechnicalAssetType["PROCESS"] = "process";
    TechnicalAssetType["DATASTORE"] = "datastore";
})(TechnicalAssetType = exports.TechnicalAssetType || (exports.TechnicalAssetType = {}));
var Size;
(function (Size) {
    Size["SYSTEM"] = "system";
    Size["SERVICE"] = "service";
    Size["APPLICATION"] = "application";
    Size["COMPONENT"] = "component";
})(Size = exports.Size || (exports.Size = {}));
var Technology;
(function (Technology) {
    Technology["UNKNOWN"] = "unknown-technology";
    Technology["CLIENT_SYSTEM"] = "client-system";
    Technology["BROWSER"] = "browser";
    Technology["DESKTOP"] = "desktop";
    Technology["MOBILE_APP"] = "mobile-app";
    Technology["DEVOPS_CLIENT"] = "devops-client";
    Technology["WEB_SERVER"] = "web-server";
    Technology["WEB_APPLICATION"] = "web-application";
    Technology["APPLICATION_SERVER"] = "application-server";
    Technology["DATABASE"] = "database";
    Technology["FILE_SERVER"] = "file-server";
    Technology["LOCAL_FILE_SERVER"] = "local-file-system";
    Technology["ERP"] = "erp";
    Technology["CMS"] = "cms";
    Technology["WEB_SERVICE_REST"] = "web-service-rest";
    Technology["WEB_SERVICE_SOAP"] = "web-service-soap";
    Technology["EJB"] = "ejb";
    Technology["SEARCH_INDEX"] = "search-index";
    Technology["SEARCH_ENGINE"] = "search-engine";
    Technology["SERVICE_REGISTRY"] = "service-registry";
    Technology["REVERSE_PROXY"] = "reverse-proxy";
    Technology["LOAD_BALANCER"] = "load-balancer";
    Technology["BUILD_PIPELINE"] = "build-pipeline";
    Technology["SOURCECODE_REPOSITORY"] = "sourcecode-repository";
    Technology["ARTIFACT_REGISTRY"] = "artifact-registry";
    Technology["CODE_INSPECTION_PLATFORM"] = "code-inspection-platform";
    Technology["MONITORING"] = "monitoring";
    Technology["LDAP_SERVER"] = "ldap-server";
    Technology["CONTAINER_PLATFORM"] = "container-platform";
    Technology["BATCH_PROCESSING"] = "batch-processing";
    Technology["EVENT_LISTENER"] = "event-listener";
    Technology["IDENTITIY_PROVIDER"] = "identity-provider";
    Technology["IDENTITY_STORE_LDAP"] = "identity-store-ldap";
    Technology["IDENTITY_STORE_DATABASE"] = "identity-store-database";
    Technology["TOOL"] = "tool";
    Technology["CLI"] = "cli";
    Technology["TASK"] = "task";
    Technology["FUNCTION"] = "function";
    Technology["GATEWAY"] = "gateway";
    Technology["IOT_DEVICE"] = "iot-device";
    Technology["MESSAGE_QUEUE"] = "message-queue";
    Technology["STREAM_PROCESSING"] = "stream-processing";
    Technology["SERVICE_MESH"] = "service-mesh";
    Technology["DATA_LAKE"] = "data-lake";
    Technology["REPORT_ENGINE"] = "report-engine";
    Technology["AI"] = "ai";
    Technology["MAIL_SERVER"] = "mail-server";
    Technology["VAULT"] = "vault";
    Technology["HASM"] = "hsm";
    Technology["WAF"] = "waf";
    Technology["IDS"] = "ids";
    Technology["IPS"] = "ips";
    Technology["SCHEDULER"] = "scheduler";
    Technology["MAINFRAME"] = "mainframe";
    Technology["BLOCK_STORAGE"] = "block-storage";
    Technology["LIBRARY"] = "library";
})(Technology = exports.Technology || (exports.Technology = {}));
var Machine;
(function (Machine) {
    Machine["PHYSICAL"] = "physical";
    Machine["VIRTUAL"] = "virtual";
    Machine["CONTAINER"] = "container";
    Machine["SERVERLESS"] = "serverless";
})(Machine = exports.Machine || (exports.Machine = {}));
var Encryption;
(function (Encryption) {
    Encryption["NONE"] = "none";
    Encryption["TRANSPARENT"] = "transparent";
    Encryption["SYMMETRIC_SHARED_KEY"] = "data-with-symmetric-shared-key";
    Encryption["ASYMMETRIC_SHARED_KEY"] = "data-with-asymmetric-shared-key";
    Encryption["ENDUSER_INDIVIDUAL_KEY"] = "data-with-enduser-individual-key";
})(Encryption = exports.Encryption || (exports.Encryption = {}));
var DataFormat;
(function (DataFormat) {
    DataFormat["JSON"] = "json";
    DataFormat["XML"] = "xml";
    DataFormat["SERIALIZATION"] = "serialization";
    DataFormat["FILE"] = "file";
    DataFormat["CSV"] = "csv";
})(DataFormat = exports.DataFormat || (exports.DataFormat = {}));
//# sourceMappingURL=data:application/json;base64,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