"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Project = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const constructs_1 = require("constructs");
const fs = require("fs-extra");
const manifest_1 = require("./manifest");
const model_1 = require("./model");
class Project extends constructs_1.Construct {
    constructor(props = {}) {
        super(undefined, "");
        this.outdir = props.outdir ?? ".cdktg.out";
        this.skipValidation = props.skipValidation;
        const { version } = fs.readJSONSync(path.join(__dirname, "..", "package.json"));
        if (!fs.existsSync(this.outdir)) {
            fs.mkdirSync(this.outdir, { recursive: true });
        }
        this.manifest = new manifest_1.Manifest(version, this.outdir);
    }
    /**
     * Synthesizes the model to the output directory
     */
    synth() {
        const session = {
            outdir: this.outdir,
            skipValidation: this.skipValidation,
            manifest: this.manifest,
        };
        const models = this.node
            .findAll()
            .filter((c) => c instanceof model_1.Model);
        models.forEach((model) => model.synthesizer.synthesize(session));
        this.manifest.writeToFile();
    }
}
exports.Project = Project;
_a = JSII_RTTI_SYMBOL_1;
Project[_a] = { fqn: "cdktg.Project", version: "0.0.26" };
//# sourceMappingURL=data:application/json;base64,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