"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Aspects = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ASPECTS_SYMBOL = Symbol("cdktg-aspects");
/**
 * Aspects can be applied to CDK tree scopes and can operate on the tree before
 * synthesis.
 */
class Aspects {
    constructor() {
        this._aspects = [];
    }
    /**
     * Returns the `Aspects` object associated with a construct scope.
     * @param scope The scope for which these aspects will apply.
     */
    static of(scope) {
        let aspects = scope[ASPECTS_SYMBOL];
        if (!aspects) {
            aspects = new Aspects();
            Object.defineProperty(scope, ASPECTS_SYMBOL, {
                value: aspects,
                configurable: false,
                enumerable: false,
            });
        }
        return aspects;
    }
    /**
     * Adds an aspect to apply this scope before synthesis.
     * @param aspect The aspect to add.
     */
    add(aspect) {
        this._aspects.push(aspect);
    }
    /**
     * The list of aspects which were directly applied on this scope.
     */
    get all() {
        return [...this._aspects];
    }
}
exports.Aspects = Aspects;
_a = JSII_RTTI_SYMBOL_1;
Aspects[_a] = { fqn: "cdktg.Aspects", version: "0.0.26" };
//# sourceMappingURL=data:application/json;base64,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