# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class UserDetailsDatalakeAvailabilityTopicDateTime(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UserDetailsDatalakeAvailabilityTopicDateTime - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'i_millis': 'int',
            'before_now': 'bool',
            'after_now': 'bool',
            'equal_now': 'bool'
        }

        self.attribute_map = {
            'i_millis': 'iMillis',
            'before_now': 'beforeNow',
            'after_now': 'afterNow',
            'equal_now': 'equalNow'
        }

        self._i_millis = None
        self._before_now = None
        self._after_now = None
        self._equal_now = None

    @property
    def i_millis(self):
        """
        Gets the i_millis of this UserDetailsDatalakeAvailabilityTopicDateTime.


        :return: The i_millis of this UserDetailsDatalakeAvailabilityTopicDateTime.
        :rtype: int
        """
        return self._i_millis

    @i_millis.setter
    def i_millis(self, i_millis):
        """
        Sets the i_millis of this UserDetailsDatalakeAvailabilityTopicDateTime.


        :param i_millis: The i_millis of this UserDetailsDatalakeAvailabilityTopicDateTime.
        :type: int
        """
        
        self._i_millis = i_millis

    @property
    def before_now(self):
        """
        Gets the before_now of this UserDetailsDatalakeAvailabilityTopicDateTime.


        :return: The before_now of this UserDetailsDatalakeAvailabilityTopicDateTime.
        :rtype: bool
        """
        return self._before_now

    @before_now.setter
    def before_now(self, before_now):
        """
        Sets the before_now of this UserDetailsDatalakeAvailabilityTopicDateTime.


        :param before_now: The before_now of this UserDetailsDatalakeAvailabilityTopicDateTime.
        :type: bool
        """
        
        self._before_now = before_now

    @property
    def after_now(self):
        """
        Gets the after_now of this UserDetailsDatalakeAvailabilityTopicDateTime.


        :return: The after_now of this UserDetailsDatalakeAvailabilityTopicDateTime.
        :rtype: bool
        """
        return self._after_now

    @after_now.setter
    def after_now(self, after_now):
        """
        Sets the after_now of this UserDetailsDatalakeAvailabilityTopicDateTime.


        :param after_now: The after_now of this UserDetailsDatalakeAvailabilityTopicDateTime.
        :type: bool
        """
        
        self._after_now = after_now

    @property
    def equal_now(self):
        """
        Gets the equal_now of this UserDetailsDatalakeAvailabilityTopicDateTime.


        :return: The equal_now of this UserDetailsDatalakeAvailabilityTopicDateTime.
        :rtype: bool
        """
        return self._equal_now

    @equal_now.setter
    def equal_now(self, equal_now):
        """
        Sets the equal_now of this UserDetailsDatalakeAvailabilityTopicDateTime.


        :param equal_now: The equal_now of this UserDetailsDatalakeAvailabilityTopicDateTime.
        :type: bool
        """
        
        self._equal_now = equal_now

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

