# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class MessagingRecipient(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        MessagingRecipient - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'nickname': 'str',
            'id': 'str',
            'image': 'str',
            'first_name': 'str',
            'last_name': 'str',
            'email': 'str'
        }

        self.attribute_map = {
            'nickname': 'nickname',
            'id': 'id',
            'image': 'image',
            'first_name': 'firstName',
            'last_name': 'lastName',
            'email': 'email'
        }

        self._nickname = None
        self._id = None
        self._image = None
        self._first_name = None
        self._last_name = None
        self._email = None

    @property
    def nickname(self):
        """
        Gets the nickname of this MessagingRecipient.
        Nickname/user name

        :return: The nickname of this MessagingRecipient.
        :rtype: str
        """
        return self._nickname

    @nickname.setter
    def nickname(self, nickname):
        """
        Sets the nickname of this MessagingRecipient.
        Nickname/user name

        :param nickname: The nickname of this MessagingRecipient.
        :type: str
        """
        
        self._nickname = nickname

    @property
    def id(self):
        """
        Gets the id of this MessagingRecipient.
        The recipient identifier specific for particular channel/integration. This is required when sending a message.

        :return: The id of this MessagingRecipient.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MessagingRecipient.
        The recipient identifier specific for particular channel/integration. This is required when sending a message.

        :param id: The id of this MessagingRecipient.
        :type: str
        """
        
        self._id = id

    @property
    def image(self):
        """
        Gets the image of this MessagingRecipient.
        Avatar image

        :return: The image of this MessagingRecipient.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """
        Sets the image of this MessagingRecipient.
        Avatar image

        :param image: The image of this MessagingRecipient.
        :type: str
        """
        
        self._image = image

    @property
    def first_name(self):
        """
        Gets the first_name of this MessagingRecipient.
        Sender's first name

        :return: The first_name of this MessagingRecipient.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        Sets the first_name of this MessagingRecipient.
        Sender's first name

        :param first_name: The first_name of this MessagingRecipient.
        :type: str
        """
        
        self._first_name = first_name

    @property
    def last_name(self):
        """
        Gets the last_name of this MessagingRecipient.
        Sender's last name

        :return: The last_name of this MessagingRecipient.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Sets the last_name of this MessagingRecipient.
        Sender's last name

        :param last_name: The last_name of this MessagingRecipient.
        :type: str
        """
        
        self._last_name = last_name

    @property
    def email(self):
        """
        Gets the email of this MessagingRecipient.
        Sender's email address

        :return: The email of this MessagingRecipient.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this MessagingRecipient.
        Sender's email address

        :param email: The email of this MessagingRecipient.
        :type: str
        """
        
        self._email = email

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

