# -*- coding: utf-8 -*-
"""
    testflows._core.contrib.pygments.lexers._mapping
    ~~~~~~~~~~~~~~~~~~~~~~~~

    Lexer mapping definitions. This file is generated by itself. Everytime
    you change something on a builtin lexer definition, run this script from
    the lexers folder to update it.

    Do not alter the LEXERS dictionary by hand.

    :copyright: Copyright 2006-2014, 2016 by the Pygments team, see AUTHORS.
    :license: BSD, see LICENSE for details.
"""

from __future__ import print_function

LEXERS = {
    'ABAPLexer': ('testflows._core.contrib.pygments.lexers.business', 'ABAP', ('abap',), ('*.abap', '*.ABAP'), ('text/x-abap',)),
    'APLLexer': ('testflows._core.contrib.pygments.lexers.apl', 'APL', ('apl',), ('*.apl',), ()),
    'AbnfLexer': ('testflows._core.contrib.pygments.lexers.grammar_notation', 'ABNF', ('abnf',), ('*.abnf',), ('text/x-abnf',)),
    'ActionScript3Lexer': ('testflows._core.contrib.pygments.lexers.actionscript', 'ActionScript 3', ('as3', 'actionscript3'), ('*.as',), ('application/x-actionscript3', 'text/x-actionscript3', 'text/actionscript3')),
    'ActionScriptLexer': ('testflows._core.contrib.pygments.lexers.actionscript', 'ActionScript', ('as', 'actionscript'), ('*.as',), ('application/x-actionscript', 'text/x-actionscript', 'text/actionscript')),
    'AdaLexer': ('testflows._core.contrib.pygments.lexers.pascal', 'Ada', ('ada', 'ada95', 'ada2005'), ('*.adb', '*.ads', '*.ada'), ('text/x-ada',)),
    'AdlLexer': ('testflows._core.contrib.pygments.lexers.archetype', 'ADL', ('adl',), ('*.adl', '*.adls', '*.adlf', '*.adlx'), ()),
    'AgdaLexer': ('testflows._core.contrib.pygments.lexers.haskell', 'Agda', ('agda',), ('*.agda',), ('text/x-agda',)),
    'AheuiLexer': ('testflows._core.contrib.pygments.lexers.esoteric', 'Aheui', ('aheui',), ('*.aheui',), ()),
    'AlloyLexer': ('testflows._core.contrib.pygments.lexers.dsls', 'Alloy', ('alloy',), ('*.als',), ('text/x-alloy',)),
    'AmbientTalkLexer': ('testflows._core.contrib.pygments.lexers.ambient', 'AmbientTalk', ('at', 'ambienttalk', 'ambienttalk/2'), ('*.at',), ('text/x-ambienttalk',)),
    'AmplLexer': ('testflows._core.contrib.pygments.lexers.ampl', 'Ampl', ('ampl',), ('*.run',), ()),
    'Angular2HtmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML + Angular2', ('html+ng2',), ('*.ng2',), ()),
    'Angular2Lexer': ('testflows._core.contrib.pygments.lexers.templates', 'Angular2', ('ng2',), (), ()),
    'AntlrActionScriptLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'ANTLR With ActionScript Target', ('antlr-as', 'antlr-actionscript'), ('*.G', '*.g'), ()),
    'AntlrCSharpLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'ANTLR With C# Target', ('antlr-csharp', 'antlr-c#'), ('*.G', '*.g'), ()),
    'AntlrCppLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'ANTLR With CPP Target', ('antlr-cpp',), ('*.G', '*.g'), ()),
    'AntlrJavaLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'ANTLR With Java Target', ('antlr-java',), ('*.G', '*.g'), ()),
    'AntlrLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'ANTLR', ('antlr',), (), ()),
    'AntlrObjectiveCLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'ANTLR With ObjectiveC Target', ('antlr-objc',), ('*.G', '*.g'), ()),
    'AntlrPerlLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'ANTLR With Perl Target', ('antlr-perl',), ('*.G', '*.g'), ()),
    'AntlrPythonLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'ANTLR With Python Target', ('antlr-python',), ('*.G', '*.g'), ()),
    'AntlrRubyLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'ANTLR With Ruby Target', ('antlr-ruby', 'antlr-rb'), ('*.G', '*.g'), ()),
    'ApacheConfLexer': ('testflows._core.contrib.pygments.lexers.configs', 'ApacheConf', ('apacheconf', 'aconf', 'apache'), ('.htaccess', 'apache.conf', 'apache2.conf'), ('text/x-apacheconf',)),
    'AppleScriptLexer': ('testflows._core.contrib.pygments.lexers.scripting', 'AppleScript', ('applescript',), ('*.applescript',), ()),
    'ArduinoLexer': ('testflows._core.contrib.pygments.lexers.c_like', 'Arduino', ('arduino',), ('*.ino',), ('text/x-arduino',)),
    'AspectJLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'AspectJ', ('aspectj',), ('*.aj',), ('text/x-aspectj',)),
    'AsymptoteLexer': ('testflows._core.contrib.pygments.lexers.graphics', 'Asymptote', ('asy', 'asymptote'), ('*.asy',), ('text/x-asymptote',)),
    'AugeasLexer': ('testflows._core.contrib.pygments.lexers.configs', 'Augeas', ('augeas',), ('*.aug',), ()),
    'AutoItLexer': ('testflows._core.contrib.pygments.lexers.automation', 'AutoIt', ('autoit',), ('*.au3',), ('text/x-autoit',)),
    'AutohotkeyLexer': ('testflows._core.contrib.pygments.lexers.automation', 'autohotkey', ('ahk', 'autohotkey'), ('*.ahk', '*.ahkl'), ('text/x-autohotkey',)),
    'AwkLexer': ('testflows._core.contrib.pygments.lexers.textedit', 'Awk', ('awk', 'gawk', 'mawk', 'nawk'), ('*.awk',), ('application/x-awk',)),
    'BBCBasicLexer': ('testflows._core.contrib.pygments.lexers.basic', 'BBC Basic', ('bbcbasic',), ('*.bbc',), ()),
    'BBCodeLexer': ('testflows._core.contrib.pygments.lexers.markup', 'BBCode', ('bbcode',), (), ('text/x-bbcode',)),
    'BCLexer': ('testflows._core.contrib.pygments.lexers.algebra', 'BC', ('bc',), ('*.bc',), ()),
    'BSTLexer': ('testflows._core.contrib.pygments.lexers.bibtex', 'BST', ('bst', 'bst-pybtex'), ('*.bst',), ()),
    'BaseMakefileLexer': ('testflows._core.contrib.pygments.lexers.make', 'Base Makefile', ('basemake',), (), ()),
    'BashLexer': ('testflows._core.contrib.pygments.lexers.shell', 'Bash', ('bash', 'sh', 'ksh', 'zsh', 'shell'), ('*.sh', '*.ksh', '*.bash', '*.ebuild', '*.eclass', '*.exheres-0', '*.exlib', '*.zsh', '.bashrc', 'bashrc', '.bash_*', 'bash_*', 'zshrc', '.zshrc', 'PKGBUILD'), ('application/x-sh', 'application/x-shellscript', 'text/x-shellscript')),
    'BashSessionLexer': ('testflows._core.contrib.pygments.lexers.shell', 'Bash Session', ('console', 'shell-session'), ('*.sh-session', '*.shell-session'), ('application/x-shell-session', 'application/x-sh-session')),
    'BatchLexer': ('testflows._core.contrib.pygments.lexers.shell', 'Batchfile', ('bat', 'batch', 'dosbatch', 'winbatch'), ('*.bat', '*.cmd'), ('application/x-dos-batch',)),
    'BefungeLexer': ('testflows._core.contrib.pygments.lexers.esoteric', 'Befunge', ('befunge',), ('*.befunge',), ('application/x-befunge',)),
    'BibTeXLexer': ('testflows._core.contrib.pygments.lexers.bibtex', 'BibTeX', ('bib', 'bibtex'), ('*.bib',), ('text/x-bibtex',)),
    'BlitzBasicLexer': ('testflows._core.contrib.pygments.lexers.basic', 'BlitzBasic', ('blitzbasic', 'b3d', 'bplus'), ('*.bb', '*.decls'), ('text/x-bb',)),
    'BlitzMaxLexer': ('testflows._core.contrib.pygments.lexers.basic', 'BlitzMax', ('blitzmax', 'bmax'), ('*.bmx',), ('text/x-bmx',)),
    'BnfLexer': ('testflows._core.contrib.pygments.lexers.grammar_notation', 'BNF', ('bnf',), ('*.bnf',), ('text/x-bnf',)),
    'BoaLexer': ('testflows._core.contrib.pygments.lexers.boa', 'Boa', ('boa',), ('*.boa',), ()),
    'BooLexer': ('testflows._core.contrib.pygments.lexers.dotnet', 'Boo', ('boo',), ('*.boo',), ('text/x-boo',)),
    'BoogieLexer': ('testflows._core.contrib.pygments.lexers.verification', 'Boogie', ('boogie',), ('*.bpl',), ()),
    'BrainfuckLexer': ('testflows._core.contrib.pygments.lexers.esoteric', 'Brainfuck', ('brainfuck', 'bf'), ('*.bf', '*.b'), ('application/x-brainfuck',)),
    'BugsLexer': ('testflows._core.contrib.pygments.lexers.modeling', 'BUGS', ('bugs', 'winbugs', 'openbugs'), ('*.bug',), ()),
    'CAmkESLexer': ('testflows._core.contrib.pygments.lexers.esoteric', 'CAmkES', ('camkes', 'idl4'), ('*.camkes', '*.idl4'), ()),
    'CLexer': ('testflows._core.contrib.pygments.lexers.c_cpp', 'C', ('c',), ('*.c', '*.h', '*.idc'), ('text/x-chdr', 'text/x-csrc')),
    'CMakeLexer': ('testflows._core.contrib.pygments.lexers.make', 'CMake', ('cmake',), ('*.cmake', 'CMakeLists.txt'), ('text/x-cmake',)),
    'CObjdumpLexer': ('testflows._core.contrib.pygments.lexers.asm', 'c-objdump', ('c-objdump',), ('*.c-objdump',), ('text/x-c-objdump',)),
    'CPSALexer': ('testflows._core.contrib.pygments.lexers.lisp', 'CPSA', ('cpsa',), ('*.cpsa',), ()),
    'CSharpAspxLexer': ('testflows._core.contrib.pygments.lexers.dotnet', 'aspx-cs', ('aspx-cs',), ('*.aspx', '*.asax', '*.ascx', '*.ashx', '*.asmx', '*.axd'), ()),
    'CSharpLexer': ('testflows._core.contrib.pygments.lexers.dotnet', 'C#', ('csharp', 'c#'), ('*.cs',), ('text/x-csharp',)),
    'Ca65Lexer': ('testflows._core.contrib.pygments.lexers.asm', 'ca65 assembler', ('ca65',), ('*.s',), ()),
    'CadlLexer': ('testflows._core.contrib.pygments.lexers.archetype', 'cADL', ('cadl',), ('*.cadl',), ()),
    'CapDLLexer': ('testflows._core.contrib.pygments.lexers.esoteric', 'CapDL', ('capdl',), ('*.cdl',), ()),
    'CapnProtoLexer': ('testflows._core.contrib.pygments.lexers.capnproto', "Cap'n Proto", ('capnp',), ('*.capnp',), ()),
    'CbmBasicV2Lexer': ('testflows._core.contrib.pygments.lexers.basic', 'CBM BASIC V2', ('cbmbas',), ('*.bas',), ()),
    'CeylonLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Ceylon', ('ceylon',), ('*.ceylon',), ('text/x-ceylon',)),
    'Cfengine3Lexer': ('testflows._core.contrib.pygments.lexers.configs', 'CFEngine3', ('cfengine3', 'cf3'), ('*.cf',), ()),
    'ChaiscriptLexer': ('testflows._core.contrib.pygments.lexers.scripting', 'ChaiScript', ('chai', 'chaiscript'), ('*.chai',), ('text/x-chaiscript', 'application/x-chaiscript')),
    'ChapelLexer': ('testflows._core.contrib.pygments.lexers.chapel', 'Chapel', ('chapel', 'chpl'), ('*.chpl',), ()),
    'CharmciLexer': ('testflows._core.contrib.pygments.lexers.c_like', 'Charmci', ('charmci',), ('*.ci',), ()),
    'CheetahHtmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML+Cheetah', ('html+cheetah', 'html+spitfire', 'htmlcheetah'), (), ('text/html+cheetah', 'text/html+spitfire')),
    'CheetahJavascriptLexer': ('testflows._core.contrib.pygments.lexers.templates', 'JavaScript+Cheetah', ('js+cheetah', 'javascript+cheetah', 'js+spitfire', 'javascript+spitfire'), (), ('application/x-javascript+cheetah', 'text/x-javascript+cheetah', 'text/javascript+cheetah', 'application/x-javascript+spitfire', 'text/x-javascript+spitfire', 'text/javascript+spitfire')),
    'CheetahLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Cheetah', ('cheetah', 'spitfire'), ('*.tmpl', '*.spt'), ('application/x-cheetah', 'application/x-spitfire')),
    'CheetahXmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'XML+Cheetah', ('xml+cheetah', 'xml+spitfire'), (), ('application/xml+cheetah', 'application/xml+spitfire')),
    'CirruLexer': ('testflows._core.contrib.pygments.lexers.webmisc', 'Cirru', ('cirru',), ('*.cirru',), ('text/x-cirru',)),
    'ClayLexer': ('testflows._core.contrib.pygments.lexers.c_like', 'Clay', ('clay',), ('*.clay',), ('text/x-clay',)),
    'CleanLexer': ('testflows._core.contrib.pygments.lexers.clean', 'Clean', ('clean',), ('*.icl', '*.dcl'), ()),
    'ClojureLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Clojure', ('clojure', 'clj'), ('*.clj',), ('text/x-clojure', 'application/x-clojure')),
    'ClojureScriptLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'ClojureScript', ('clojurescript', 'cljs'), ('*.cljs',), ('text/x-clojurescript', 'application/x-clojurescript')),
    'CobolFreeformatLexer': ('testflows._core.contrib.pygments.lexers.business', 'COBOLFree', ('cobolfree',), ('*.cbl', '*.CBL'), ()),
    'CobolLexer': ('testflows._core.contrib.pygments.lexers.business', 'COBOL', ('cobol',), ('*.cob', '*.COB', '*.cpy', '*.CPY'), ('text/x-cobol',)),
    'CoffeeScriptLexer': ('testflows._core.contrib.pygments.lexers.javascript', 'CoffeeScript', ('coffee-script', 'coffeescript', 'coffee'), ('*.coffee',), ('text/coffeescript',)),
    'ColdfusionCFCLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Coldfusion CFC', ('cfc',), ('*.cfc',), ()),
    'ColdfusionHtmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Coldfusion HTML', ('cfm',), ('*.cfm', '*.cfml'), ('application/x-coldfusion',)),
    'ColdfusionLexer': ('testflows._core.contrib.pygments.lexers.templates', 'cfstatement', ('cfs',), (), ()),
    'CommonLispLexer': ('testflows._core.contrib.pygments.lexers.lisp', 'Common Lisp', ('common-lisp', 'cl', 'lisp'), ('*.cl', '*.lisp'), ('text/x-common-lisp',)),
    'ComponentPascalLexer': ('testflows._core.contrib.pygments.lexers.oberon', 'Component Pascal', ('componentpascal', 'cp'), ('*.cp', '*.cps'), ('text/x-component-pascal',)),
    'CoqLexer': ('testflows._core.contrib.pygments.lexers.theorem', 'Coq', ('coq',), ('*.v',), ('text/x-coq',)),
    'CppLexer': ('testflows._core.contrib.pygments.lexers.c_cpp', 'C++', ('cpp', 'c++'), ('*.cpp', '*.hpp', '*.c++', '*.h++', '*.cc', '*.hh', '*.cxx', '*.hxx', '*.C', '*.H', '*.cp', '*.CPP'), ('text/x-c++hdr', 'text/x-c++src')),
    'CppObjdumpLexer': ('testflows._core.contrib.pygments.lexers.asm', 'cpp-objdump', ('cpp-objdump', 'c++-objdumb', 'cxx-objdump'), ('*.cpp-objdump', '*.c++-objdump', '*.cxx-objdump'), ('text/x-cpp-objdump',)),
    'CrmshLexer': ('testflows._core.contrib.pygments.lexers.dsls', 'Crmsh', ('crmsh', 'pcmk'), ('*.crmsh', '*.pcmk'), ()),
    'CrocLexer': ('testflows._core.contrib.pygments.lexers.d', 'Croc', ('croc',), ('*.croc',), ('text/x-crocsrc',)),
    'CryptolLexer': ('testflows._core.contrib.pygments.lexers.haskell', 'Cryptol', ('cryptol', 'cry'), ('*.cry',), ('text/x-cryptol',)),
    'CrystalLexer': ('testflows._core.contrib.pygments.lexers.crystal', 'Crystal', ('cr', 'crystal'), ('*.cr',), ('text/x-crystal',)),
    'CsoundDocumentLexer': ('testflows._core.contrib.pygments.lexers.csound', 'Csound Document', ('csound-document', 'csound-csd'), ('*.csd',), ()),
    'CsoundOrchestraLexer': ('testflows._core.contrib.pygments.lexers.csound', 'Csound Orchestra', ('csound', 'csound-orc'), ('*.orc', '*.udo'), ()),
    'CsoundScoreLexer': ('testflows._core.contrib.pygments.lexers.csound', 'Csound Score', ('csound-score', 'csound-sco'), ('*.sco',), ()),
    'CssDjangoLexer': ('testflows._core.contrib.pygments.lexers.templates', 'CSS+Django/Jinja', ('css+django', 'css+jinja'), (), ('text/css+django', 'text/css+jinja')),
    'CssErbLexer': ('testflows._core.contrib.pygments.lexers.templates', 'CSS+Ruby', ('css+erb', 'css+ruby'), (), ('text/css+ruby',)),
    'CssGenshiLexer': ('testflows._core.contrib.pygments.lexers.templates', 'CSS+Genshi Text', ('css+genshitext', 'css+genshi'), (), ('text/css+genshi',)),
    'CssLexer': ('testflows._core.contrib.pygments.lexers.css', 'CSS', ('css',), ('*.css',), ('text/css',)),
    'CssPhpLexer': ('testflows._core.contrib.pygments.lexers.templates', 'CSS+PHP', ('css+php',), (), ('text/css+php',)),
    'CssSmartyLexer': ('testflows._core.contrib.pygments.lexers.templates', 'CSS+Smarty', ('css+smarty',), (), ('text/css+smarty',)),
    'CudaLexer': ('testflows._core.contrib.pygments.lexers.c_like', 'CUDA', ('cuda', 'cu'), ('*.cu', '*.cuh'), ('text/x-cuda',)),
    'CypherLexer': ('testflows._core.contrib.pygments.lexers.graph', 'Cypher', ('cypher',), ('*.cyp', '*.cypher'), ()),
    'CythonLexer': ('testflows._core.contrib.pygments.lexers.python', 'Cython', ('cython', 'pyx', 'pyrex'), ('*.pyx', '*.pxd', '*.pxi'), ('text/x-cython', 'application/x-cython')),
    'DLexer': ('testflows._core.contrib.pygments.lexers.d', 'D', ('d',), ('*.d', '*.di'), ('text/x-dsrc',)),
    'DObjdumpLexer': ('testflows._core.contrib.pygments.lexers.asm', 'd-objdump', ('d-objdump',), ('*.d-objdump',), ('text/x-d-objdump',)),
    'DarcsPatchLexer': ('testflows._core.contrib.pygments.lexers.diff', 'Darcs Patch', ('dpatch',), ('*.dpatch', '*.darcspatch'), ()),
    'DartLexer': ('testflows._core.contrib.pygments.lexers.javascript', 'Dart', ('dart',), ('*.dart',), ('text/x-dart',)),
    'Dasm16Lexer': ('testflows._core.contrib.pygments.lexers.asm', 'DASM16', ('dasm16',), ('*.dasm16', '*.dasm'), ('text/x-dasm16',)),
    'DebianControlLexer': ('testflows._core.contrib.pygments.lexers.installers', 'Debian Control file', ('control', 'debcontrol'), ('control',), ()),
    'DelphiLexer': ('testflows._core.contrib.pygments.lexers.pascal', 'Delphi', ('delphi', 'pas', 'pascal', 'objectpascal'), ('*.pas', '*.dpr'), ('text/x-pascal',)),
    'DgLexer': ('testflows._core.contrib.pygments.lexers.python', 'dg', ('dg',), ('*.dg',), ('text/x-dg',)),
    'DiffLexer': ('testflows._core.contrib.pygments.lexers.diff', 'Diff', ('diff', 'udiff'), ('*.diff', '*.patch'), ('text/x-diff', 'text/x-patch')),
    'DjangoLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Django/Jinja', ('django', 'jinja'), (), ('application/x-django-templating', 'application/x-jinja')),
    'DockerLexer': ('testflows._core.contrib.pygments.lexers.configs', 'Docker', ('docker', 'dockerfile'), ('Dockerfile', '*.docker'), ('text/x-dockerfile-config',)),
    'DtdLexer': ('testflows._core.contrib.pygments.lexers.html', 'DTD', ('dtd',), ('*.dtd',), ('application/xml-dtd',)),
    'DuelLexer': ('testflows._core.contrib.pygments.lexers.webmisc', 'Duel', ('duel', 'jbst', 'jsonml+bst'), ('*.duel', '*.jbst'), ('text/x-duel', 'text/x-jbst')),
    'DylanConsoleLexer': ('testflows._core.contrib.pygments.lexers.dylan', 'Dylan session', ('dylan-console', 'dylan-repl'), ('*.dylan-console',), ('text/x-dylan-console',)),
    'DylanLexer': ('testflows._core.contrib.pygments.lexers.dylan', 'Dylan', ('dylan',), ('*.dylan', '*.dyl', '*.intr'), ('text/x-dylan',)),
    'DylanLidLexer': ('testflows._core.contrib.pygments.lexers.dylan', 'DylanLID', ('dylan-lid', 'lid'), ('*.lid', '*.hdp'), ('text/x-dylan-lid',)),
    'ECLLexer': ('testflows._core.contrib.pygments.lexers.ecl', 'ECL', ('ecl',), ('*.ecl',), ('application/x-ecl',)),
    'ECLexer': ('testflows._core.contrib.pygments.lexers.c_like', 'eC', ('ec',), ('*.ec', '*.eh'), ('text/x-echdr', 'text/x-ecsrc')),
    'EarlGreyLexer': ('testflows._core.contrib.pygments.lexers.javascript', 'Earl Grey', ('earl-grey', 'earlgrey', 'eg'), ('*.eg',), ('text/x-earl-grey',)),
    'EasytrieveLexer': ('testflows._core.contrib.pygments.lexers.scripting', 'Easytrieve', ('easytrieve',), ('*.ezt', '*.mac'), ('text/x-easytrieve',)),
    'EbnfLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'EBNF', ('ebnf',), ('*.ebnf',), ('text/x-ebnf',)),
    'EiffelLexer': ('testflows._core.contrib.pygments.lexers.eiffel', 'Eiffel', ('eiffel',), ('*.e',), ('text/x-eiffel',)),
    'ElixirConsoleLexer': ('testflows._core.contrib.pygments.lexers.erlang', 'Elixir iex session', ('iex',), (), ('text/x-elixir-shellsession',)),
    'ElixirLexer': ('testflows._core.contrib.pygments.lexers.erlang', 'Elixir', ('elixir', 'ex', 'exs'), ('*.ex', '*.exs'), ('text/x-elixir',)),
    'ElmLexer': ('testflows._core.contrib.pygments.lexers.elm', 'Elm', ('elm',), ('*.elm',), ('text/x-elm',)),
    'EmacsLispLexer': ('testflows._core.contrib.pygments.lexers.lisp', 'EmacsLisp', ('emacs', 'elisp', 'emacs-lisp'), ('*.el',), ('text/x-elisp', 'application/x-elisp')),
    'EmailLexer': ('testflows._core.contrib.pygments.lexers.email', 'E-mail', ('email', 'eml'), ('*.eml',), ('message/rfc822',)),
    'ErbLexer': ('testflows._core.contrib.pygments.lexers.templates', 'ERB', ('erb',), (), ('application/x-ruby-templating',)),
    'ErlangLexer': ('testflows._core.contrib.pygments.lexers.erlang', 'Erlang', ('erlang',), ('*.erl', '*.hrl', '*.es', '*.escript'), ('text/x-erlang',)),
    'ErlangShellLexer': ('testflows._core.contrib.pygments.lexers.erlang', 'Erlang erl session', ('erl',), ('*.erl-sh',), ('text/x-erl-shellsession',)),
    'EvoqueHtmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML+Evoque', ('html+evoque',), ('*.html',), ('text/html+evoque',)),
    'EvoqueLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Evoque', ('evoque',), ('*.evoque',), ('application/x-evoque',)),
    'EvoqueXmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'XML+Evoque', ('xml+evoque',), ('*.xml',), ('application/xml+evoque',)),
    'EzhilLexer': ('testflows._core.contrib.pygments.lexers.ezhil', 'Ezhil', ('ezhil',), ('*.n',), ('text/x-ezhil',)),
    'FSharpLexer': ('testflows._core.contrib.pygments.lexers.dotnet', 'F#', ('fsharp', 'f#'), ('*.fs', '*.fsi'), ('text/x-fsharp',)),
    'FactorLexer': ('testflows._core.contrib.pygments.lexers.factor', 'Factor', ('factor',), ('*.factor',), ('text/x-factor',)),
    'FancyLexer': ('testflows._core.contrib.pygments.lexers.ruby', 'Fancy', ('fancy', 'fy'), ('*.fy', '*.fancypack'), ('text/x-fancysrc',)),
    'FantomLexer': ('testflows._core.contrib.pygments.lexers.fantom', 'Fantom', ('fan',), ('*.fan',), ('application/x-fantom',)),
    'FelixLexer': ('testflows._core.contrib.pygments.lexers.felix', 'Felix', ('felix', 'flx'), ('*.flx', '*.flxh'), ('text/x-felix',)),
    'FennelLexer': ('testflows._core.contrib.pygments.lexers.lisp', 'Fennel', ('fennel', 'fnl'), ('*.fnl',), ()),
    'FishShellLexer': ('testflows._core.contrib.pygments.lexers.shell', 'Fish', ('fish', 'fishshell'), ('*.fish', '*.load'), ('application/x-fish',)),
    'FlatlineLexer': ('testflows._core.contrib.pygments.lexers.dsls', 'Flatline', ('flatline',), (), ('text/x-flatline',)),
    'FloScriptLexer': ('testflows._core.contrib.pygments.lexers.floscript', 'FloScript', ('floscript', 'flo'), ('*.flo',), ()),
    'ForthLexer': ('testflows._core.contrib.pygments.lexers.forth', 'Forth', ('forth',), ('*.frt', '*.fs'), ('application/x-forth',)),
    'FortranFixedLexer': ('testflows._core.contrib.pygments.lexers.fortran', 'FortranFixed', ('fortranfixed',), ('*.f', '*.F'), ()),
    'FortranLexer': ('testflows._core.contrib.pygments.lexers.fortran', 'Fortran', ('fortran',), ('*.f03', '*.f90', '*.F03', '*.F90'), ('text/x-fortran',)),
    'FoxProLexer': ('testflows._core.contrib.pygments.lexers.foxpro', 'FoxPro', ('foxpro', 'vfp', 'clipper', 'xbase'), ('*.PRG', '*.prg'), ()),
    'FreeFemLexer': ('testflows._core.contrib.pygments.lexers.freefem', 'Freefem', ('freefem',), ('*.edp',), ('text/x-freefem',)),
    'GAPLexer': ('testflows._core.contrib.pygments.lexers.algebra', 'GAP', ('gap',), ('*.g', '*.gd', '*.gi', '*.gap'), ()),
    'GLShaderLexer': ('testflows._core.contrib.pygments.lexers.graphics', 'GLSL', ('glsl',), ('*.vert', '*.frag', '*.geo'), ('text/x-glslsrc',)),
    'GasLexer': ('testflows._core.contrib.pygments.lexers.asm', 'GAS', ('gas', 'asm'), ('*.s', '*.S'), ('text/x-gas',)),
    'GenshiLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Genshi', ('genshi', 'kid', 'xml+genshi', 'xml+kid'), ('*.kid',), ('application/x-genshi', 'application/x-kid')),
    'GenshiTextLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Genshi Text', ('genshitext',), (), ('application/x-genshi-text', 'text/x-genshi')),
    'GettextLexer': ('testflows._core.contrib.pygments.lexers.textfmts', 'Gettext Catalog', ('pot', 'po'), ('*.pot', '*.po'), ('application/x-gettext', 'text/x-gettext', 'text/gettext')),
    'GherkinLexer': ('testflows._core.contrib.pygments.lexers.testing', 'Gherkin', ('cucumber', 'gherkin'), ('*.feature',), ('text/x-gherkin',)),
    'GnuplotLexer': ('testflows._core.contrib.pygments.lexers.graphics', 'Gnuplot', ('gnuplot',), ('*.plot', '*.plt'), ('text/x-gnuplot',)),
    'GoLexer': ('testflows._core.contrib.pygments.lexers.go', 'Go', ('go',), ('*.go',), ('text/x-gosrc',)),
    'GoloLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Golo', ('golo',), ('*.golo',), ()),
    'GoodDataCLLexer': ('testflows._core.contrib.pygments.lexers.business', 'GoodData-CL', ('gooddata-cl',), ('*.gdc',), ('text/x-gooddata-cl',)),
    'GosuLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Gosu', ('gosu',), ('*.gs', '*.gsx', '*.gsp', '*.vark'), ('text/x-gosu',)),
    'GosuTemplateLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Gosu Template', ('gst',), ('*.gst',), ('text/x-gosu-template',)),
    'GroffLexer': ('testflows._core.contrib.pygments.lexers.markup', 'Groff', ('groff', 'nroff', 'man'), ('*.[1234567]', '*.man'), ('application/x-troff', 'text/troff')),
    'GroovyLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Groovy', ('groovy',), ('*.groovy', '*.gradle'), ('text/x-groovy',)),
    'HLSLShaderLexer': ('testflows._core.contrib.pygments.lexers.graphics', 'HLSL', ('hlsl',), ('*.hlsl', '*.hlsli'), ('text/x-hlsl',)),
    'HamlLexer': ('testflows._core.contrib.pygments.lexers.html', 'Haml', ('haml',), ('*.haml',), ('text/x-haml',)),
    'HandlebarsHtmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML+Handlebars', ('html+handlebars',), ('*.handlebars', '*.hbs'), ('text/html+handlebars', 'text/x-handlebars-template')),
    'HandlebarsLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Handlebars', ('handlebars',), (), ()),
    'HaskellLexer': ('testflows._core.contrib.pygments.lexers.haskell', 'Haskell', ('haskell', 'hs'), ('*.hs',), ('text/x-haskell',)),
    'HaxeLexer': ('testflows._core.contrib.pygments.lexers.haxe', 'Haxe', ('hx', 'haxe', 'hxsl'), ('*.hx', '*.hxsl'), ('text/haxe', 'text/x-haxe', 'text/x-hx')),
    'HexdumpLexer': ('testflows._core.contrib.pygments.lexers.hexdump', 'Hexdump', ('hexdump',), (), ()),
    'HsailLexer': ('testflows._core.contrib.pygments.lexers.asm', 'HSAIL', ('hsail', 'hsa'), ('*.hsail',), ('text/x-hsail',)),
    'HspecLexer': ('testflows._core.contrib.pygments.lexers.haskell', 'Hspec', ('hspec',), (), ()),
    'HtmlDjangoLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML+Django/Jinja', ('html+django', 'html+jinja', 'htmldjango'), (), ('text/html+django', 'text/html+jinja')),
    'HtmlGenshiLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML+Genshi', ('html+genshi', 'html+kid'), (), ('text/html+genshi',)),
    'HtmlLexer': ('testflows._core.contrib.pygments.lexers.html', 'HTML', ('html',), ('*.html', '*.htm', '*.xhtml', '*.xslt'), ('text/html', 'application/xhtml+xml')),
    'HtmlPhpLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML+PHP', ('html+php',), ('*.phtml',), ('application/x-php', 'application/x-httpd-php', 'application/x-httpd-php3', 'application/x-httpd-php4', 'application/x-httpd-php5')),
    'HtmlSmartyLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML+Smarty', ('html+smarty',), (), ('text/html+smarty',)),
    'HttpLexer': ('testflows._core.contrib.pygments.lexers.textfmts', 'HTTP', ('http',), (), ()),
    'HxmlLexer': ('testflows._core.contrib.pygments.lexers.haxe', 'Hxml', ('haxeml', 'hxml'), ('*.hxml',), ()),
    'HyLexer': ('testflows._core.contrib.pygments.lexers.lisp', 'Hy', ('hylang',), ('*.hy',), ('text/x-hy', 'application/x-hy')),
    'HybrisLexer': ('testflows._core.contrib.pygments.lexers.scripting', 'Hybris', ('hybris', 'hy'), ('*.hy', '*.hyb'), ('text/x-hybris', 'application/x-hybris')),
    'IDLLexer': ('testflows._core.contrib.pygments.lexers.idl', 'IDL', ('idl',), ('*.pro',), ('text/idl',)),
    'IconLexer': ('testflows._core.contrib.pygments.lexers.unicon', 'Icon', ('icon',), ('*.icon', '*.ICON'), ()),
    'IdrisLexer': ('testflows._core.contrib.pygments.lexers.haskell', 'Idris', ('idris', 'idr'), ('*.idr',), ('text/x-idris',)),
    'IgorLexer': ('testflows._core.contrib.pygments.lexers.igor', 'Igor', ('igor', 'igorpro'), ('*.ipf',), ('text/ipf',)),
    'Inform6Lexer': ('testflows._core.contrib.pygments.lexers.int_fiction', 'Inform 6', ('inform6', 'i6'), ('*.inf',), ()),
    'Inform6TemplateLexer': ('testflows._core.contrib.pygments.lexers.int_fiction', 'Inform 6 template', ('i6t',), ('*.i6t',), ()),
    'Inform7Lexer': ('testflows._core.contrib.pygments.lexers.int_fiction', 'Inform 7', ('inform7', 'i7'), ('*.ni', '*.i7x'), ()),
    'IniLexer': ('testflows._core.contrib.pygments.lexers.configs', 'INI', ('ini', 'cfg', 'dosini'), ('*.ini', '*.cfg', '*.inf'), ('text/x-ini', 'text/inf')),
    'IoLexer': ('testflows._core.contrib.pygments.lexers.iolang', 'Io', ('io',), ('*.io',), ('text/x-iosrc',)),
    'IokeLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Ioke', ('ioke', 'ik'), ('*.ik',), ('text/x-iokesrc',)),
    'IrcLogsLexer': ('testflows._core.contrib.pygments.lexers.textfmts', 'IRC logs', ('irc',), ('*.weechatlog',), ('text/x-irclog',)),
    'IsabelleLexer': ('testflows._core.contrib.pygments.lexers.theorem', 'Isabelle', ('isabelle',), ('*.thy',), ('text/x-isabelle',)),
    'JLexer': ('testflows._core.contrib.pygments.lexers.j', 'J', ('j',), ('*.ijs',), ('text/x-j',)),
    'JagsLexer': ('testflows._core.contrib.pygments.lexers.modeling', 'JAGS', ('jags',), ('*.jag', '*.bug'), ()),
    'JasminLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Jasmin', ('jasmin', 'jasminxt'), ('*.j',), ()),
    'JavaLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Java', ('java',), ('*.java',), ('text/x-java',)),
    'JavascriptDjangoLexer': ('testflows._core.contrib.pygments.lexers.templates', 'JavaScript+Django/Jinja', ('js+django', 'javascript+django', 'js+jinja', 'javascript+jinja'), (), ('application/x-javascript+django', 'application/x-javascript+jinja', 'text/x-javascript+django', 'text/x-javascript+jinja', 'text/javascript+django', 'text/javascript+jinja')),
    'JavascriptErbLexer': ('testflows._core.contrib.pygments.lexers.templates', 'JavaScript+Ruby', ('js+erb', 'javascript+erb', 'js+ruby', 'javascript+ruby'), (), ('application/x-javascript+ruby', 'text/x-javascript+ruby', 'text/javascript+ruby')),
    'JavascriptGenshiLexer': ('testflows._core.contrib.pygments.lexers.templates', 'JavaScript+Genshi Text', ('js+genshitext', 'js+genshi', 'javascript+genshitext', 'javascript+genshi'), (), ('application/x-javascript+genshi', 'text/x-javascript+genshi', 'text/javascript+genshi')),
    'JavascriptLexer': ('testflows._core.contrib.pygments.lexers.javascript', 'JavaScript', ('js', 'javascript'), ('*.js', '*.jsm'), ('application/javascript', 'application/x-javascript', 'text/x-javascript', 'text/javascript')),
    'JavascriptPhpLexer': ('testflows._core.contrib.pygments.lexers.templates', 'JavaScript+PHP', ('js+php', 'javascript+php'), (), ('application/x-javascript+php', 'text/x-javascript+php', 'text/javascript+php')),
    'JavascriptSmartyLexer': ('testflows._core.contrib.pygments.lexers.templates', 'JavaScript+Smarty', ('js+smarty', 'javascript+smarty'), (), ('application/x-javascript+smarty', 'text/x-javascript+smarty', 'text/javascript+smarty')),
    'JclLexer': ('testflows._core.contrib.pygments.lexers.scripting', 'JCL', ('jcl',), ('*.jcl',), ('text/x-jcl',)),
    'JsgfLexer': ('testflows._core.contrib.pygments.lexers.grammar_notation', 'JSGF', ('jsgf',), ('*.jsgf',), ('application/jsgf', 'application/x-jsgf', 'text/jsgf')),
    'JsonBareObjectLexer': ('testflows._core.contrib.pygments.lexers.data', 'JSONBareObject', ('json-object',), (), ('application/json-object',)),
    'JsonLdLexer': ('testflows._core.contrib.pygments.lexers.data', 'JSON-LD', ('jsonld', 'json-ld'), ('*.jsonld',), ('application/ld+json',)),
    'JsonLexer': ('testflows._core.contrib.pygments.lexers.data', 'JSON', ('json',), ('*.json',), ('application/json',)),
    'JspLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Java Server Page', ('jsp',), ('*.jsp',), ('application/x-jsp',)),
    'JuliaConsoleLexer': ('testflows._core.contrib.pygments.lexers.julia', 'Julia console', ('jlcon',), (), ()),
    'JuliaLexer': ('testflows._core.contrib.pygments.lexers.julia', 'Julia', ('julia', 'jl'), ('*.jl',), ('text/x-julia', 'application/x-julia')),
    'JuttleLexer': ('testflows._core.contrib.pygments.lexers.javascript', 'Juttle', ('juttle', 'juttle'), ('*.juttle',), ('application/juttle', 'application/x-juttle', 'text/x-juttle', 'text/juttle')),
    'KalLexer': ('testflows._core.contrib.pygments.lexers.javascript', 'Kal', ('kal',), ('*.kal',), ('text/kal', 'application/kal')),
    'KconfigLexer': ('testflows._core.contrib.pygments.lexers.configs', 'Kconfig', ('kconfig', 'menuconfig', 'linux-config', 'kernel-config'), ('Kconfig', '*Config.in*', 'external.in*', 'standard-modules.in'), ('text/x-kconfig',)),
    'KokaLexer': ('testflows._core.contrib.pygments.lexers.haskell', 'Koka', ('koka',), ('*.kk', '*.kki'), ('text/x-koka',)),
    'KotlinLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Kotlin', ('kotlin',), ('*.kt',), ('text/x-kotlin',)),
    'LSLLexer': ('testflows._core.contrib.pygments.lexers.scripting', 'LSL', ('lsl',), ('*.lsl',), ('text/x-lsl',)),
    'LassoCssLexer': ('testflows._core.contrib.pygments.lexers.templates', 'CSS+Lasso', ('css+lasso',), (), ('text/css+lasso',)),
    'LassoHtmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML+Lasso', ('html+lasso',), (), ('text/html+lasso', 'application/x-httpd-lasso', 'application/x-httpd-lasso[89]')),
    'LassoJavascriptLexer': ('testflows._core.contrib.pygments.lexers.templates', 'JavaScript+Lasso', ('js+lasso', 'javascript+lasso'), (), ('application/x-javascript+lasso', 'text/x-javascript+lasso', 'text/javascript+lasso')),
    'LassoLexer': ('testflows._core.contrib.pygments.lexers.javascript', 'Lasso', ('lasso', 'lassoscript'), ('*.lasso', '*.lasso[89]'), ('text/x-lasso',)),
    'LassoXmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'XML+Lasso', ('xml+lasso',), (), ('application/xml+lasso',)),
    'LeanLexer': ('testflows._core.contrib.pygments.lexers.theorem', 'Lean', ('lean',), ('*.lean',), ('text/x-lean',)),
    'LessCssLexer': ('testflows._core.contrib.pygments.lexers.css', 'LessCss', ('less',), ('*.less',), ('text/x-less-css',)),
    'LighttpdConfLexer': ('testflows._core.contrib.pygments.lexers.configs', 'Lighttpd configuration file', ('lighty', 'lighttpd'), (), ('text/x-lighttpd-conf',)),
    'LimboLexer': ('testflows._core.contrib.pygments.lexers.inferno', 'Limbo', ('limbo',), ('*.b',), ('text/limbo',)),
    'LiquidLexer': ('testflows._core.contrib.pygments.lexers.templates', 'liquid', ('liquid',), ('*.liquid',), ()),
    'LiterateAgdaLexer': ('testflows._core.contrib.pygments.lexers.haskell', 'Literate Agda', ('lagda', 'literate-agda'), ('*.lagda',), ('text/x-literate-agda',)),
    'LiterateCryptolLexer': ('testflows._core.contrib.pygments.lexers.haskell', 'Literate Cryptol', ('lcry', 'literate-cryptol', 'lcryptol'), ('*.lcry',), ('text/x-literate-cryptol',)),
    'LiterateHaskellLexer': ('testflows._core.contrib.pygments.lexers.haskell', 'Literate Haskell', ('lhs', 'literate-haskell', 'lhaskell'), ('*.lhs',), ('text/x-literate-haskell',)),
    'LiterateIdrisLexer': ('testflows._core.contrib.pygments.lexers.haskell', 'Literate Idris', ('lidr', 'literate-idris', 'lidris'), ('*.lidr',), ('text/x-literate-idris',)),
    'LiveScriptLexer': ('testflows._core.contrib.pygments.lexers.javascript', 'LiveScript', ('live-script', 'livescript'), ('*.ls',), ('text/livescript',)),
    'LlvmLexer': ('testflows._core.contrib.pygments.lexers.asm', 'LLVM', ('llvm',), ('*.ll',), ('text/x-llvm',)),
    'LogosLexer': ('testflows._core.contrib.pygments.lexers.objective', 'Logos', ('logos',), ('*.x', '*.xi', '*.xm', '*.xmi'), ('text/x-logos',)),
    'LogtalkLexer': ('testflows._core.contrib.pygments.lexers.prolog', 'Logtalk', ('logtalk',), ('*.lgt', '*.logtalk'), ('text/x-logtalk',)),
    'LuaLexer': ('testflows._core.contrib.pygments.lexers.scripting', 'Lua', ('lua',), ('*.lua', '*.wlua'), ('text/x-lua', 'application/x-lua')),
    'MIMELexer': ('testflows._core.contrib.pygments.lexers.mime', 'MIME', ('mime',), (), ('multipart/mixed', 'multipart/related', 'multipart/alternative')),
    'MOOCodeLexer': ('testflows._core.contrib.pygments.lexers.scripting', 'MOOCode', ('moocode', 'moo'), ('*.moo',), ('text/x-moocode',)),
    'MSDOSSessionLexer': ('testflows._core.contrib.pygments.lexers.shell', 'MSDOS Session', ('doscon',), (), ()),
    'MakefileLexer': ('testflows._core.contrib.pygments.lexers.make', 'Makefile', ('make', 'makefile', 'mf', 'bsdmake'), ('*.mak', '*.mk', 'Makefile', 'makefile', 'Makefile.*', 'GNUmakefile'), ('text/x-makefile',)),
    'MakoCssLexer': ('testflows._core.contrib.pygments.lexers.templates', 'CSS+Mako', ('css+mako',), (), ('text/css+mako',)),
    'MakoHtmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML+Mako', ('html+mako',), (), ('text/html+mako',)),
    'MakoJavascriptLexer': ('testflows._core.contrib.pygments.lexers.templates', 'JavaScript+Mako', ('js+mako', 'javascript+mako'), (), ('application/x-javascript+mako', 'text/x-javascript+mako', 'text/javascript+mako')),
    'MakoLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Mako', ('mako',), ('*.mao',), ('application/x-mako',)),
    'MakoXmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'XML+Mako', ('xml+mako',), (), ('application/xml+mako',)),
    'MaqlLexer': ('testflows._core.contrib.pygments.lexers.business', 'MAQL', ('maql',), ('*.maql',), ('text/x-gooddata-maql', 'application/x-gooddata-maql')),
    'MarkdownLexer': ('testflows._core.contrib.pygments.lexers.markup', 'markdown', ('md',), ('*.md',), ('text/x-markdown',)),
    'MaskLexer': ('testflows._core.contrib.pygments.lexers.javascript', 'Mask', ('mask',), ('*.mask',), ('text/x-mask',)),
    'MasonLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Mason', ('mason',), ('*.m', '*.mhtml', '*.mc', '*.mi', 'autohandler', 'dhandler'), ('application/x-mason',)),
    'MathematicaLexer': ('testflows._core.contrib.pygments.lexers.algebra', 'Mathematica', ('mathematica', 'mma', 'nb'), ('*.nb', '*.cdf', '*.nbp', '*.ma'), ('application/mathematica', 'application/vnd.wolfram.mathematica', 'application/vnd.wolfram.mathematica.package', 'application/vnd.wolfram.cdf')),
    'MatlabLexer': ('testflows._core.contrib.pygments.lexers.matlab', 'Matlab', ('matlab',), ('*.m',), ('text/matlab',)),
    'MatlabSessionLexer': ('testflows._core.contrib.pygments.lexers.matlab', 'Matlab session', ('matlabsession',), (), ()),
    'MiniDLexer': ('testflows._core.contrib.pygments.lexers.d', 'MiniD', ('minid',), (), ('text/x-minidsrc',)),
    'ModelicaLexer': ('testflows._core.contrib.pygments.lexers.modeling', 'Modelica', ('modelica',), ('*.mo',), ('text/x-modelica',)),
    'Modula2Lexer': ('testflows._core.contrib.pygments.lexers.modula2', 'Modula-2', ('modula2', 'm2'), ('*.def', '*.mod'), ('text/x-modula2',)),
    'MoinWikiLexer': ('testflows._core.contrib.pygments.lexers.markup', 'MoinMoin/Trac Wiki markup', ('trac-wiki', 'moin'), (), ('text/x-trac-wiki',)),
    'MonkeyLexer': ('testflows._core.contrib.pygments.lexers.basic', 'Monkey', ('monkey',), ('*.monkey',), ('text/x-monkey',)),
    'MonteLexer': ('testflows._core.contrib.pygments.lexers.monte', 'Monte', ('monte',), ('*.mt',), ()),
    'MoonScriptLexer': ('testflows._core.contrib.pygments.lexers.scripting', 'MoonScript', ('moon', 'moonscript'), ('*.moon',), ('text/x-moonscript', 'application/x-moonscript')),
    'MozPreprocCssLexer': ('testflows._core.contrib.pygments.lexers.markup', 'CSS+mozpreproc', ('css+mozpreproc',), ('*.css.in',), ()),
    'MozPreprocHashLexer': ('testflows._core.contrib.pygments.lexers.markup', 'mozhashpreproc', ('mozhashpreproc',), (), ()),
    'MozPreprocJavascriptLexer': ('testflows._core.contrib.pygments.lexers.markup', 'Javascript+mozpreproc', ('javascript+mozpreproc',), ('*.js.in',), ()),
    'MozPreprocPercentLexer': ('testflows._core.contrib.pygments.lexers.markup', 'mozpercentpreproc', ('mozpercentpreproc',), (), ()),
    'MozPreprocXulLexer': ('testflows._core.contrib.pygments.lexers.markup', 'XUL+mozpreproc', ('xul+mozpreproc',), ('*.xul.in',), ()),
    'MqlLexer': ('testflows._core.contrib.pygments.lexers.c_like', 'MQL', ('mql', 'mq4', 'mq5', 'mql4', 'mql5'), ('*.mq4', '*.mq5', '*.mqh'), ('text/x-mql',)),
    'MscgenLexer': ('testflows._core.contrib.pygments.lexers.dsls', 'Mscgen', ('mscgen', 'msc'), ('*.msc',), ()),
    'MuPADLexer': ('testflows._core.contrib.pygments.lexers.algebra', 'MuPAD', ('mupad',), ('*.mu',), ()),
    'MxmlLexer': ('testflows._core.contrib.pygments.lexers.actionscript', 'MXML', ('mxml',), ('*.mxml',), ()),
    'MySqlLexer': ('testflows._core.contrib.pygments.lexers.sql', 'MySQL', ('mysql',), (), ('text/x-mysql',)),
    'MyghtyCssLexer': ('testflows._core.contrib.pygments.lexers.templates', 'CSS+Myghty', ('css+myghty',), (), ('text/css+myghty',)),
    'MyghtyHtmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML+Myghty', ('html+myghty',), (), ('text/html+myghty',)),
    'MyghtyJavascriptLexer': ('testflows._core.contrib.pygments.lexers.templates', 'JavaScript+Myghty', ('js+myghty', 'javascript+myghty'), (), ('application/x-javascript+myghty', 'text/x-javascript+myghty', 'text/javascript+mygthy')),
    'MyghtyLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Myghty', ('myghty',), ('*.myt', 'autodelegate'), ('application/x-myghty',)),
    'MyghtyXmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'XML+Myghty', ('xml+myghty',), (), ('application/xml+myghty',)),
    'NCLLexer': ('testflows._core.contrib.pygments.lexers.ncl', 'NCL', ('ncl',), ('*.ncl',), ('text/ncl',)),
    'NSISLexer': ('testflows._core.contrib.pygments.lexers.installers', 'NSIS', ('nsis', 'nsi', 'nsh'), ('*.nsi', '*.nsh'), ('text/x-nsis',)),
    'NasmLexer': ('testflows._core.contrib.pygments.lexers.asm', 'NASM', ('nasm',), ('*.asm', '*.ASM'), ('text/x-nasm',)),
    'NasmObjdumpLexer': ('testflows._core.contrib.pygments.lexers.asm', 'objdump-nasm', ('objdump-nasm',), ('*.objdump-intel',), ('text/x-nasm-objdump',)),
    'NemerleLexer': ('testflows._core.contrib.pygments.lexers.dotnet', 'Nemerle', ('nemerle',), ('*.n',), ('text/x-nemerle',)),
    'NesCLexer': ('testflows._core.contrib.pygments.lexers.c_like', 'nesC', ('nesc',), ('*.nc',), ('text/x-nescsrc',)),
    'NewLispLexer': ('testflows._core.contrib.pygments.lexers.lisp', 'NewLisp', ('newlisp',), ('*.lsp', '*.nl', '*.kif'), ('text/x-newlisp', 'application/x-newlisp')),
    'NewspeakLexer': ('testflows._core.contrib.pygments.lexers.smalltalk', 'Newspeak', ('newspeak',), ('*.ns2',), ('text/x-newspeak',)),
    'NginxConfLexer': ('testflows._core.contrib.pygments.lexers.configs', 'Nginx configuration file', ('nginx',), ('nginx.conf',), ('text/x-nginx-conf',)),
    'NimrodLexer': ('testflows._core.contrib.pygments.lexers.nimrod', 'Nimrod', ('nim', 'nimrod'), ('*.nim', '*.nimrod'), ('text/x-nim',)),
    'NitLexer': ('testflows._core.contrib.pygments.lexers.nit', 'Nit', ('nit',), ('*.nit',), ()),
    'NixLexer': ('testflows._core.contrib.pygments.lexers.nix', 'Nix', ('nixos', 'nix'), ('*.nix',), ('text/x-nix',)),
    'NotmuchLexer': ('testflows._core.contrib.pygments.lexers.textfmts', 'Notmuch', ('notmuch',), (), ()),
    'NuSMVLexer': ('testflows._core.contrib.pygments.lexers.smv', 'NuSMV', ('nusmv',), ('*.smv',), ()),
    'NumPyLexer': ('testflows._core.contrib.pygments.lexers.python', 'NumPy', ('numpy',), (), ()),
    'ObjdumpLexer': ('testflows._core.contrib.pygments.lexers.asm', 'objdump', ('objdump',), ('*.objdump',), ('text/x-objdump',)),
    'ObjectiveCLexer': ('testflows._core.contrib.pygments.lexers.objective', 'Objective-C', ('objective-c', 'objectivec', 'obj-c', 'objc'), ('*.m', '*.h'), ('text/x-objective-c',)),
    'ObjectiveCppLexer': ('testflows._core.contrib.pygments.lexers.objective', 'Objective-C++', ('objective-c++', 'objectivec++', 'obj-c++', 'objc++'), ('*.mm', '*.hh'), ('text/x-objective-c++',)),
    'ObjectiveJLexer': ('testflows._core.contrib.pygments.lexers.javascript', 'Objective-J', ('objective-j', 'objectivej', 'obj-j', 'objj'), ('*.j',), ('text/x-objective-j',)),
    'OcamlLexer': ('testflows._core.contrib.pygments.lexers.ml', 'OCaml', ('ocaml',), ('*.ml', '*.mli', '*.mll', '*.mly'), ('text/x-ocaml',)),
    'OctaveLexer': ('testflows._core.contrib.pygments.lexers.matlab', 'Octave', ('octave',), ('*.m',), ('text/octave',)),
    'OdinLexer': ('testflows._core.contrib.pygments.lexers.archetype', 'ODIN', ('odin',), ('*.odin',), ('text/odin',)),
    'OocLexer': ('testflows._core.contrib.pygments.lexers.ooc', 'Ooc', ('ooc',), ('*.ooc',), ('text/x-ooc',)),
    'OpaLexer': ('testflows._core.contrib.pygments.lexers.ml', 'Opa', ('opa',), ('*.opa',), ('text/x-opa',)),
    'OpenEdgeLexer': ('testflows._core.contrib.pygments.lexers.business', 'OpenEdge ABL', ('openedge', 'abl', 'progress'), ('*.p', '*.cls'), ('text/x-openedge', 'application/x-openedge')),
    'PacmanConfLexer': ('testflows._core.contrib.pygments.lexers.configs', 'PacmanConf', ('pacmanconf',), ('pacman.conf',), ()),
    'PanLexer': ('testflows._core.contrib.pygments.lexers.dsls', 'Pan', ('pan',), ('*.pan',), ()),
    'ParaSailLexer': ('testflows._core.contrib.pygments.lexers.parasail', 'ParaSail', ('parasail',), ('*.psi', '*.psl'), ('text/x-parasail',)),
    'PawnLexer': ('testflows._core.contrib.pygments.lexers.pawn', 'Pawn', ('pawn',), ('*.p', '*.pwn', '*.inc'), ('text/x-pawn',)),
    'Perl6Lexer': ('testflows._core.contrib.pygments.lexers.perl', 'Perl6', ('perl6', 'pl6'), ('*.pl', '*.pm', '*.nqp', '*.p6', '*.6pl', '*.p6l', '*.pl6', '*.6pm', '*.p6m', '*.pm6', '*.t'), ('text/x-perl6', 'application/x-perl6')),
    'PerlLexer': ('testflows._core.contrib.pygments.lexers.perl', 'Perl', ('perl', 'pl'), ('*.pl', '*.pm', '*.t'), ('text/x-perl', 'application/x-perl')),
    'PhpLexer': ('testflows._core.contrib.pygments.lexers.php', 'PHP', ('php', 'php3', 'php4', 'php5'), ('*.php', '*.php[345]', '*.inc'), ('text/x-php',)),
    'PigLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Pig', ('pig',), ('*.pig',), ('text/x-pig',)),
    'PikeLexer': ('testflows._core.contrib.pygments.lexers.c_like', 'Pike', ('pike',), ('*.pike', '*.pmod'), ('text/x-pike',)),
    'PkgConfigLexer': ('testflows._core.contrib.pygments.lexers.configs', 'PkgConfig', ('pkgconfig',), ('*.pc',), ()),
    'PlPgsqlLexer': ('testflows._core.contrib.pygments.lexers.sql', 'PL/pgSQL', ('plpgsql',), (), ('text/x-plpgsql',)),
    'PonyLexer': ('testflows._core.contrib.pygments.lexers.pony', 'Pony', ('pony',), ('*.pony',), ()),
    'PostScriptLexer': ('testflows._core.contrib.pygments.lexers.graphics', 'PostScript', ('postscript', 'postscr'), ('*.ps', '*.eps'), ('application/postscript',)),
    'PostgresConsoleLexer': ('testflows._core.contrib.pygments.lexers.sql', 'PostgreSQL console (psql)', ('psql', 'postgresql-console', 'postgres-console'), (), ('text/x-postgresql-psql',)),
    'PostgresLexer': ('testflows._core.contrib.pygments.lexers.sql', 'PostgreSQL SQL dialect', ('postgresql', 'postgres'), (), ('text/x-postgresql',)),
    'PovrayLexer': ('testflows._core.contrib.pygments.lexers.graphics', 'POVRay', ('pov',), ('*.pov', '*.inc'), ('text/x-povray',)),
    'PowerShellLexer': ('testflows._core.contrib.pygments.lexers.shell', 'PowerShell', ('powershell', 'posh', 'ps1', 'psm1'), ('*.ps1', '*.psm1'), ('text/x-powershell',)),
    'PowerShellSessionLexer': ('testflows._core.contrib.pygments.lexers.shell', 'PowerShell Session', ('ps1con',), (), ()),
    'PraatLexer': ('testflows._core.contrib.pygments.lexers.praat', 'Praat', ('praat',), ('*.praat', '*.proc', '*.psc'), ()),
    'PrologLexer': ('testflows._core.contrib.pygments.lexers.prolog', 'Prolog', ('prolog',), ('*.ecl', '*.prolog', '*.pro', '*.pl'), ('text/x-prolog',)),
    'PropertiesLexer': ('testflows._core.contrib.pygments.lexers.configs', 'Properties', ('properties', 'jproperties'), ('*.properties',), ('text/x-java-properties',)),
    'ProtoBufLexer': ('testflows._core.contrib.pygments.lexers.dsls', 'Protocol Buffer', ('protobuf', 'proto'), ('*.proto',), ()),
    'PugLexer': ('testflows._core.contrib.pygments.lexers.html', 'Pug', ('pug', 'jade'), ('*.pug', '*.jade'), ('text/x-pug', 'text/x-jade')),
    'PuppetLexer': ('testflows._core.contrib.pygments.lexers.dsls', 'Puppet', ('puppet',), ('*.pp',), ()),
    'PyPyLogLexer': ('testflows._core.contrib.pygments.lexers.console', 'PyPy Log', ('pypylog', 'pypy'), ('*.pypylog',), ('application/x-pypylog',)),
    'Python2Lexer': ('testflows._core.contrib.pygments.lexers.python', 'Python 2.x', ('python2', 'py2'), (), ('text/x-python2', 'application/x-python2')),
    'Python2TracebackLexer': ('testflows._core.contrib.pygments.lexers.python', 'Python 2.x Traceback', ('py2tb',), ('*.py2tb',), ('text/x-python2-traceback',)),
    'PythonConsoleLexer': ('testflows._core.contrib.pygments.lexers.python', 'Python console session', ('pycon',), (), ('text/x-python-doctest',)),
    'PythonLexer': ('testflows._core.contrib.pygments.lexers.python', 'Python', ('python', 'py', 'sage', 'python3', 'py3'), ('*.py', '*.pyw', '*.jy', '*.sage', '*.sc', 'SConstruct', 'SConscript', '*.bzl', 'BUCK', 'BUILD', 'BUILD.bazel', 'WORKSPACE', '*.tac'), ('text/x-python', 'application/x-python', 'text/x-python3', 'application/x-python3')),
    'PythonTracebackLexer': ('testflows._core.contrib.pygments.lexers.python', 'Python Traceback', ('pytb', 'py3tb'), ('*.pytb', '*.py3tb'), ('text/x-python-traceback', 'text/x-python3-traceback')),
    'QBasicLexer': ('testflows._core.contrib.pygments.lexers.basic', 'QBasic', ('qbasic', 'basic'), ('*.BAS', '*.bas'), ('text/basic',)),
    'QVToLexer': ('testflows._core.contrib.pygments.lexers.qvt', 'QVTO', ('qvto', 'qvt'), ('*.qvto',), ()),
    'QmlLexer': ('testflows._core.contrib.pygments.lexers.webmisc', 'QML', ('qml', 'qbs'), ('*.qml', '*.qbs'), ('application/x-qml', 'application/x-qt.qbs+qml')),
    'RConsoleLexer': ('testflows._core.contrib.pygments.lexers.r', 'RConsole', ('rconsole', 'rout'), ('*.Rout',), ()),
    'RNCCompactLexer': ('testflows._core.contrib.pygments.lexers.rnc', 'Relax-NG Compact', ('rnc', 'rng-compact'), ('*.rnc',), ()),
    'RPMSpecLexer': ('testflows._core.contrib.pygments.lexers.installers', 'RPMSpec', ('spec',), ('*.spec',), ('text/x-rpm-spec',)),
    'RacketLexer': ('testflows._core.contrib.pygments.lexers.lisp', 'Racket', ('racket', 'rkt'), ('*.rkt', '*.rktd', '*.rktl'), ('text/x-racket', 'application/x-racket')),
    'RagelCLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'Ragel in C Host', ('ragel-c',), ('*.rl',), ()),
    'RagelCppLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'Ragel in CPP Host', ('ragel-cpp',), ('*.rl',), ()),
    'RagelDLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'Ragel in D Host', ('ragel-d',), ('*.rl',), ()),
    'RagelEmbeddedLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'Embedded Ragel', ('ragel-em',), ('*.rl',), ()),
    'RagelJavaLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'Ragel in Java Host', ('ragel-java',), ('*.rl',), ()),
    'RagelLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'Ragel', ('ragel',), (), ()),
    'RagelObjectiveCLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'Ragel in Objective C Host', ('ragel-objc',), ('*.rl',), ()),
    'RagelRubyLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'Ragel in Ruby Host', ('ragel-ruby', 'ragel-rb'), ('*.rl',), ()),
    'RawTokenLexer': ('testflows._core.contrib.pygments.lexers.special', 'Raw token data', ('raw',), (), ('application/x-pygments-tokens',)),
    'RdLexer': ('testflows._core.contrib.pygments.lexers.r', 'Rd', ('rd',), ('*.Rd',), ('text/x-r-doc',)),
    'RebolLexer': ('testflows._core.contrib.pygments.lexers.rebol', 'REBOL', ('rebol',), ('*.r', '*.r3', '*.reb'), ('text/x-rebol',)),
    'RedLexer': ('testflows._core.contrib.pygments.lexers.rebol', 'Red', ('red', 'red/system'), ('*.red', '*.reds'), ('text/x-red', 'text/x-red-system')),
    'RedcodeLexer': ('testflows._core.contrib.pygments.lexers.esoteric', 'Redcode', ('redcode',), ('*.cw',), ()),
    'RegeditLexer': ('testflows._core.contrib.pygments.lexers.configs', 'reg', ('registry',), ('*.reg',), ('text/x-windows-registry',)),
    'ResourceLexer': ('testflows._core.contrib.pygments.lexers.resource', 'ResourceBundle', ('resource', 'resourcebundle'), (), ()),
    'RexxLexer': ('testflows._core.contrib.pygments.lexers.scripting', 'Rexx', ('rexx', 'arexx'), ('*.rexx', '*.rex', '*.rx', '*.arexx'), ('text/x-rexx',)),
    'RhtmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'RHTML', ('rhtml', 'html+erb', 'html+ruby'), ('*.rhtml',), ('text/html+ruby',)),
    'RoboconfGraphLexer': ('testflows._core.contrib.pygments.lexers.roboconf', 'Roboconf Graph', ('roboconf-graph',), ('*.graph',), ()),
    'RoboconfInstancesLexer': ('testflows._core.contrib.pygments.lexers.roboconf', 'Roboconf Instances', ('roboconf-instances',), ('*.instances',), ()),
    'RobotFrameworkLexer': ('testflows._core.contrib.pygments.lexers.robotframework', 'RobotFramework', ('robotframework',), ('*.robot',), ('text/x-robotframework',)),
    'RqlLexer': ('testflows._core.contrib.pygments.lexers.sql', 'RQL', ('rql',), ('*.rql',), ('text/x-rql',)),
    'RslLexer': ('testflows._core.contrib.pygments.lexers.dsls', 'RSL', ('rsl',), ('*.rsl',), ('text/rsl',)),
    'RstLexer': ('testflows._core.contrib.pygments.lexers.markup', 'reStructuredText', ('rst', 'rest', 'restructuredtext'), ('*.rst', '*.rest'), ('text/x-rst', 'text/prs.fallenstein.rst')),
    'RtsLexer': ('testflows._core.contrib.pygments.lexers.trafficscript', 'TrafficScript', ('rts', 'trafficscript'), ('*.rts',), ()),
    'RubyConsoleLexer': ('testflows._core.contrib.pygments.lexers.ruby', 'Ruby irb session', ('rbcon', 'irb'), (), ('text/x-ruby-shellsession',)),
    'RubyLexer': ('testflows._core.contrib.pygments.lexers.ruby', 'Ruby', ('rb', 'ruby', 'duby'), ('*.rb', '*.rbw', 'Rakefile', '*.rake', '*.gemspec', '*.rbx', '*.duby', 'Gemfile'), ('text/x-ruby', 'application/x-ruby')),
    'RustLexer': ('testflows._core.contrib.pygments.lexers.rust', 'Rust', ('rust', 'rs'), ('*.rs', '*.rs.in'), ('text/rust',)),
    'SASLexer': ('testflows._core.contrib.pygments.lexers.sas', 'SAS', ('sas',), ('*.SAS', '*.sas'), ('text/x-sas', 'text/sas', 'application/x-sas')),
    'SLexer': ('testflows._core.contrib.pygments.lexers.r', 'S', ('splus', 's', 'r'), ('*.S', '*.R', '.Rhistory', '.Rprofile', '.Renviron'), ('text/S-plus', 'text/S', 'text/x-r-source', 'text/x-r', 'text/x-R', 'text/x-r-history', 'text/x-r-profile')),
    'SMLLexer': ('testflows._core.contrib.pygments.lexers.ml', 'Standard ML', ('sml',), ('*.sml', '*.sig', '*.fun'), ('text/x-standardml', 'application/x-standardml')),
    'SarlLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'SARL', ('sarl',), ('*.sarl',), ('text/x-sarl',)),
    'SassLexer': ('testflows._core.contrib.pygments.lexers.css', 'Sass', ('sass',), ('*.sass',), ('text/x-sass',)),
    'ScalaLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Scala', ('scala',), ('*.scala',), ('text/x-scala',)),
    'ScamlLexer': ('testflows._core.contrib.pygments.lexers.html', 'Scaml', ('scaml',), ('*.scaml',), ('text/x-scaml',)),
    'ScdocLexer': ('testflows._core.contrib.pygments.lexers.scdoc', 'scdoc', ('scdoc', 'scd'), ('*.scd', '*.scdoc'), ()),
    'SchemeLexer': ('testflows._core.contrib.pygments.lexers.lisp', 'Scheme', ('scheme', 'scm'), ('*.scm', '*.ss'), ('text/x-scheme', 'application/x-scheme')),
    'ScilabLexer': ('testflows._core.contrib.pygments.lexers.matlab', 'Scilab', ('scilab',), ('*.sci', '*.sce', '*.tst'), ('text/scilab',)),
    'ScssLexer': ('testflows._core.contrib.pygments.lexers.css', 'SCSS', ('scss',), ('*.scss',), ('text/x-scss',)),
    'ShExCLexer': ('testflows._core.contrib.pygments.lexers.rdf', 'ShExC', ('shexc', 'shex'), ('*.shex',), ('text/shex',)),
    'ShenLexer': ('testflows._core.contrib.pygments.lexers.lisp', 'Shen', ('shen',), ('*.shen',), ('text/x-shen', 'application/x-shen')),
    'SilverLexer': ('testflows._core.contrib.pygments.lexers.verification', 'Silver', ('silver',), ('*.sil', '*.vpr'), ()),
    'SlashLexer': ('testflows._core.contrib.pygments.lexers.slash', 'Slash', ('slash',), ('*.sl',), ()),
    'SlimLexer': ('testflows._core.contrib.pygments.lexers.webmisc', 'Slim', ('slim',), ('*.slim',), ('text/x-slim',)),
    'SlurmBashLexer': ('testflows._core.contrib.pygments.lexers.shell', 'Slurm', ('slurm', 'sbatch'), ('*.sl',), ()),
    'SmaliLexer': ('testflows._core.contrib.pygments.lexers.dalvik', 'Smali', ('smali',), ('*.smali',), ('text/smali',)),
    'SmalltalkLexer': ('testflows._core.contrib.pygments.lexers.smalltalk', 'Smalltalk', ('smalltalk', 'squeak', 'st'), ('*.st',), ('text/x-smalltalk',)),
    'SmartGameFormatLexer': ('testflows._core.contrib.pygments.lexers.sgf', 'SmartGameFormat', ('sgf',), ('*.sgf',), ()),
    'SmartyLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Smarty', ('smarty',), ('*.tpl',), ('application/x-smarty',)),
    'SnobolLexer': ('testflows._core.contrib.pygments.lexers.snobol', 'Snobol', ('snobol',), ('*.snobol',), ('text/x-snobol',)),
    'SnowballLexer': ('testflows._core.contrib.pygments.lexers.dsls', 'Snowball', ('snowball',), ('*.sbl',), ()),
    'SolidityLexer': ('testflows._core.contrib.pygments.lexers.solidity', 'Solidity', ('solidity',), ('*.sol',), ()),
    'SourcePawnLexer': ('testflows._core.contrib.pygments.lexers.pawn', 'SourcePawn', ('sp',), ('*.sp',), ('text/x-sourcepawn',)),
    'SourcesListLexer': ('testflows._core.contrib.pygments.lexers.installers', 'Debian Sourcelist', ('sourceslist', 'sources.list', 'debsources'), ('sources.list',), ()),
    'SparqlLexer': ('testflows._core.contrib.pygments.lexers.rdf', 'SPARQL', ('sparql',), ('*.rq', '*.sparql'), ('application/sparql-query',)),
    'SqlLexer': ('testflows._core.contrib.pygments.lexers.sql', 'SQL', ('sql',), ('*.sql',), ('text/x-sql',)),
    'SqliteConsoleLexer': ('testflows._core.contrib.pygments.lexers.sql', 'sqlite3con', ('sqlite3',), ('*.sqlite3-console',), ('text/x-sqlite3-console',)),
    'SquidConfLexer': ('testflows._core.contrib.pygments.lexers.configs', 'SquidConf', ('squidconf', 'squid.conf', 'squid'), ('squid.conf',), ('text/x-squidconf',)),
    'SspLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Scalate Server Page', ('ssp',), ('*.ssp',), ('application/x-ssp',)),
    'StanLexer': ('testflows._core.contrib.pygments.lexers.modeling', 'Stan', ('stan',), ('*.stan',), ()),
    'StataLexer': ('testflows._core.contrib.pygments.lexers.stata', 'Stata', ('stata', 'do'), ('*.do', '*.ado'), ('text/x-stata', 'text/stata', 'application/x-stata')),
    'SuperColliderLexer': ('testflows._core.contrib.pygments.lexers.supercollider', 'SuperCollider', ('sc', 'supercollider'), ('*.sc', '*.scd'), ('application/supercollider', 'text/supercollider')),
    'SwiftLexer': ('testflows._core.contrib.pygments.lexers.objective', 'Swift', ('swift',), ('*.swift',), ('text/x-swift',)),
    'SwigLexer': ('testflows._core.contrib.pygments.lexers.c_like', 'SWIG', ('swig',), ('*.swg', '*.i'), ('text/swig',)),
    'SystemVerilogLexer': ('testflows._core.contrib.pygments.lexers.hdl', 'systemverilog', ('systemverilog', 'sv'), ('*.sv', '*.svh'), ('text/x-systemverilog',)),
    'TAPLexer': ('testflows._core.contrib.pygments.lexers.testing', 'TAP', ('tap',), ('*.tap',), ()),
    'TOMLLexer': ('testflows._core.contrib.pygments.lexers.configs', 'TOML', ('toml',), ('*.toml',), ()),
    'Tads3Lexer': ('testflows._core.contrib.pygments.lexers.int_fiction', 'TADS 3', ('tads3',), ('*.t',), ()),
    'TasmLexer': ('testflows._core.contrib.pygments.lexers.asm', 'TASM', ('tasm',), ('*.asm', '*.ASM', '*.tasm'), ('text/x-tasm',)),
    'TclLexer': ('testflows._core.contrib.pygments.lexers.tcl', 'Tcl', ('tcl',), ('*.tcl', '*.rvt'), ('text/x-tcl', 'text/x-script.tcl', 'application/x-tcl')),
    'TcshLexer': ('testflows._core.contrib.pygments.lexers.shell', 'Tcsh', ('tcsh', 'csh'), ('*.tcsh', '*.csh'), ('application/x-csh',)),
    'TcshSessionLexer': ('testflows._core.contrib.pygments.lexers.shell', 'Tcsh Session', ('tcshcon',), (), ()),
    'TeaTemplateLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Tea', ('tea',), ('*.tea',), ('text/x-tea',)),
    'TeraTermLexer': ('testflows._core.contrib.pygments.lexers.teraterm', 'Tera Term macro', ('ttl', 'teraterm', 'teratermmacro'), ('*.ttl',), ('text/x-teratermmacro',)),
    'TermcapLexer': ('testflows._core.contrib.pygments.lexers.configs', 'Termcap', ('termcap',), ('termcap', 'termcap.src'), ()),
    'TerminfoLexer': ('testflows._core.contrib.pygments.lexers.configs', 'Terminfo', ('terminfo',), ('terminfo', 'terminfo.src'), ()),
    'TerraformLexer': ('testflows._core.contrib.pygments.lexers.configs', 'Terraform', ('terraform', 'tf'), ('*.tf',), ('application/x-tf', 'application/x-terraform')),
    'TestFlowsLexer': ('testflows._core.contrib.pygments.lexers.testflows', 'TestFlows', ('testflows',), ('*.tfs',), ()),
    'TexLexer': ('testflows._core.contrib.pygments.lexers.markup', 'TeX', ('tex', 'latex'), ('*.tex', '*.aux', '*.toc'), ('text/x-tex', 'text/x-latex')),
    'TextLexer': ('testflows._core.contrib.pygments.lexers.special', 'Text only', ('text',), ('*.txt',), ('text/plain',)),
    'ThriftLexer': ('testflows._core.contrib.pygments.lexers.dsls', 'Thrift', ('thrift',), ('*.thrift',), ('application/x-thrift',)),
    'TodotxtLexer': ('testflows._core.contrib.pygments.lexers.textfmts', 'Todotxt', ('todotxt',), ('todo.txt', '*.todotxt'), ('text/x-todo',)),
    'TransactSqlLexer': ('testflows._core.contrib.pygments.lexers.sql', 'Transact-SQL', ('tsql', 't-sql'), ('*.sql',), ('text/x-tsql',)),
    'TreetopLexer': ('testflows._core.contrib.pygments.lexers.parsers', 'Treetop', ('treetop',), ('*.treetop', '*.tt'), ()),
    'TurtleLexer': ('testflows._core.contrib.pygments.lexers.rdf', 'Turtle', ('turtle',), ('*.ttl',), ('text/turtle', 'application/x-turtle')),
    'TwigHtmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML+Twig', ('html+twig',), ('*.twig',), ('text/html+twig',)),
    'TwigLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Twig', ('twig',), (), ('application/x-twig',)),
    'TypeScriptLexer': ('testflows._core.contrib.pygments.lexers.javascript', 'TypeScript', ('ts', 'typescript'), ('*.ts', '*.tsx'), ('text/x-typescript',)),
    'TypoScriptCssDataLexer': ('testflows._core.contrib.pygments.lexers.typoscript', 'TypoScriptCssData', ('typoscriptcssdata',), (), ()),
    'TypoScriptHtmlDataLexer': ('testflows._core.contrib.pygments.lexers.typoscript', 'TypoScriptHtmlData', ('typoscripthtmldata',), (), ()),
    'TypoScriptLexer': ('testflows._core.contrib.pygments.lexers.typoscript', 'TypoScript', ('typoscript',), ('*.typoscript',), ('text/x-typoscript',)),
    'UcodeLexer': ('testflows._core.contrib.pygments.lexers.unicon', 'ucode', ('ucode',), ('*.u', '*.u1', '*.u2'), ()),
    'UniconLexer': ('testflows._core.contrib.pygments.lexers.unicon', 'Unicon', ('unicon',), ('*.icn',), ('text/unicon',)),
    'UrbiscriptLexer': ('testflows._core.contrib.pygments.lexers.urbi', 'UrbiScript', ('urbiscript',), ('*.u',), ('application/x-urbiscript',)),
    'VBScriptLexer': ('testflows._core.contrib.pygments.lexers.basic', 'VBScript', ('vbscript',), ('*.vbs', '*.VBS'), ()),
    'VCLLexer': ('testflows._core.contrib.pygments.lexers.varnish', 'VCL', ('vcl',), ('*.vcl',), ('text/x-vclsrc',)),
    'VCLSnippetLexer': ('testflows._core.contrib.pygments.lexers.varnish', 'VCLSnippets', ('vclsnippets', 'vclsnippet'), (), ('text/x-vclsnippet',)),
    'VCTreeStatusLexer': ('testflows._core.contrib.pygments.lexers.console', 'VCTreeStatus', ('vctreestatus',), (), ()),
    'VGLLexer': ('testflows._core.contrib.pygments.lexers.dsls', 'VGL', ('vgl',), ('*.rpf',), ()),
    'ValaLexer': ('testflows._core.contrib.pygments.lexers.c_like', 'Vala', ('vala', 'vapi'), ('*.vala', '*.vapi'), ('text/x-vala',)),
    'VbNetAspxLexer': ('testflows._core.contrib.pygments.lexers.dotnet', 'aspx-vb', ('aspx-vb',), ('*.aspx', '*.asax', '*.ascx', '*.ashx', '*.asmx', '*.axd'), ()),
    'VbNetLexer': ('testflows._core.contrib.pygments.lexers.dotnet', 'VB.net', ('vb.net', 'vbnet'), ('*.vb', '*.bas'), ('text/x-vbnet', 'text/x-vba')),
    'VelocityHtmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'HTML+Velocity', ('html+velocity',), (), ('text/html+velocity',)),
    'VelocityLexer': ('testflows._core.contrib.pygments.lexers.templates', 'Velocity', ('velocity',), ('*.vm', '*.fhtml'), ()),
    'VelocityXmlLexer': ('testflows._core.contrib.pygments.lexers.templates', 'XML+Velocity', ('xml+velocity',), (), ('application/xml+velocity',)),
    'VerilogLexer': ('testflows._core.contrib.pygments.lexers.hdl', 'verilog', ('verilog', 'v'), ('*.v',), ('text/x-verilog',)),
    'VhdlLexer': ('testflows._core.contrib.pygments.lexers.hdl', 'vhdl', ('vhdl',), ('*.vhdl', '*.vhd'), ('text/x-vhdl',)),
    'VimLexer': ('testflows._core.contrib.pygments.lexers.textedit', 'VimL', ('vim',), ('*.vim', '.vimrc', '.exrc', '.gvimrc', '_vimrc', '_exrc', '_gvimrc', 'vimrc', 'gvimrc'), ('text/x-vim',)),
    'WDiffLexer': ('testflows._core.contrib.pygments.lexers.diff', 'WDiff', ('wdiff',), ('*.wdiff',), ()),
    'WhileyLexer': ('testflows._core.contrib.pygments.lexers.whiley', 'Whiley', ('whiley',), ('*.whiley',), ('text/x-whiley',)),
    'X10Lexer': ('testflows._core.contrib.pygments.lexers.x10', 'X10', ('x10', 'xten'), ('*.x10',), ('text/x-x10',)),
    'XQueryLexer': ('testflows._core.contrib.pygments.lexers.webmisc', 'XQuery', ('xquery', 'xqy', 'xq', 'xql', 'xqm'), ('*.xqy', '*.xquery', '*.xq', '*.xql', '*.xqm'), ('text/xquery', 'application/xquery')),
    'XmlDjangoLexer': ('testflows._core.contrib.pygments.lexers.templates', 'XML+Django/Jinja', ('xml+django', 'xml+jinja'), (), ('application/xml+django', 'application/xml+jinja')),
    'XmlErbLexer': ('testflows._core.contrib.pygments.lexers.templates', 'XML+Ruby', ('xml+erb', 'xml+ruby'), (), ('application/xml+ruby',)),
    'XmlLexer': ('testflows._core.contrib.pygments.lexers.html', 'XML', ('xml',), ('*.xml', '*.xsl', '*.rss', '*.xslt', '*.xsd', '*.wsdl', '*.wsf'), ('text/xml', 'application/xml', 'image/svg+xml', 'application/rss+xml', 'application/atom+xml')),
    'XmlPhpLexer': ('testflows._core.contrib.pygments.lexers.templates', 'XML+PHP', ('xml+php',), (), ('application/xml+php',)),
    'XmlSmartyLexer': ('testflows._core.contrib.pygments.lexers.templates', 'XML+Smarty', ('xml+smarty',), (), ('application/xml+smarty',)),
    'XorgLexer': ('testflows._core.contrib.pygments.lexers.xorg', 'Xorg', ('xorg.conf',), ('xorg.conf',), ()),
    'XsltLexer': ('testflows._core.contrib.pygments.lexers.html', 'XSLT', ('xslt',), ('*.xsl', '*.xslt', '*.xpl'), ('application/xsl+xml', 'application/xslt+xml')),
    'XtendLexer': ('testflows._core.contrib.pygments.lexers.jvm', 'Xtend', ('xtend',), ('*.xtend',), ('text/x-xtend',)),
    'XtlangLexer': ('testflows._core.contrib.pygments.lexers.lisp', 'xtlang', ('extempore',), ('*.xtm',), ()),
    'YamlJinjaLexer': ('testflows._core.contrib.pygments.lexers.templates', 'YAML+Jinja', ('yaml+jinja', 'salt', 'sls'), ('*.sls',), ('text/x-yaml+jinja', 'text/x-sls')),
    'YamlLexer': ('testflows._core.contrib.pygments.lexers.data', 'YAML', ('yaml',), ('*.yaml', '*.yml'), ('text/x-yaml',)),
    'ZeekLexer': ('testflows._core.contrib.pygments.lexers.dsls', 'Zeek', ('zeek', 'bro'), ('*.zeek', '*.bro'), ()),
    'ZephirLexer': ('testflows._core.contrib.pygments.lexers.php', 'Zephir', ('zephir',), ('*.zep',), ()),
    'ZigLexer': ('testflows._core.contrib.pygments.lexers.zig', 'Zig', ('zig',), ('*.zig',), ('text/zig',)),
}

if __name__ == '__main__':  # pragma: no cover
    import sys
    import os

    # lookup lexers
    found_lexers = []
    sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..', '..'))
    for root, dirs, files in os.walk('.'):
        for filename in files:
            if filename.endswith('.py') and not filename.startswith('_'):
                module_name = 'testflows._core.contrib.pygments.lexers%s.%s' % (
                    root[1:].replace('/', '.'), filename[:-3])
                print(module_name)
                module = __import__(module_name, None, None, [''])
                for lexer_name in module.__all__:
                    lexer = getattr(module, lexer_name)
                    found_lexers.append(
                        '%r: %r' % (lexer_name,
                                    (module_name,
                                     lexer.name,
                                     tuple(lexer.aliases),
                                     tuple(lexer.filenames),
                                     tuple(lexer.mimetypes))))
    # sort them to make the diff minimal
    found_lexers.sort()

    # extract useful sourcecode from this file
    with open(__file__) as fp:
        content = fp.read()
        # replace crnl to nl for Windows.
        #
        # Note that, originally, contributers should keep nl of master
        # repository, for example by using some kind of automatic
        # management EOL, like `EolExtension
        #  <https://www.mercurial-scm.org/wiki/EolExtension>`.
        content = content.replace("\r\n", "\n")
    header = content[:content.find('LEXERS = {')]
    footer = content[content.find("if __name__ == '__main__':"):]

    # write new file
    with open(__file__, 'w') as fp:
        fp.write(header)
        fp.write('LEXERS = {\n    %s,\n}\n\n' % ',\n    '.join(found_lexers))
        fp.write(footer)

    print ('=== %d lexers processed.' % len(found_lexers))
