
class ServiceProps:
    """Service Props class for API settings and endpoints."""

    # Base URL for API requests
    BASE_URL = "https://web.gopocket.in/"
    API_NAME = "Codifi ProTrade - Python Library"
    CONTRACT_BASE_URL = "https://web.gopocket.in/contract/csv/"

    # Endpoints for authorization
    GET_VENDOR_SESSION = "open-api/order/v1/vendor/getUserDetails"

    # Endpoint for client profile
    GET_PROFILE = "open-api/order/v1/profile/"

    # Endpoint for funds
    GET_FUNDS = "open-api/order/v1/limits/"

    # Endpoints for positions and holdings
    GET_POSITIONS = "open-api/order/v1/positions"
    GET_HOLDINGS = "open-api/order/v1/holdings"

    # Endpoints for position conversion & margin
    POSITION_CONVERSION = "open-api/order/v1/conversion"
    SINGLE_ORDER_MARGIN = "open-api/order/v1/orders/checkMargin"

    # Endpoints for orders
    ORDER_EXECUTE = "open-api/order/v1/orders/placeorder"
    ORDER_MODIFY = "open-api/order/v1/orders/modify/"
    ORDER_CANCEL = "open-api/order/v1/orders/cancel/"
    EXIT_BRACKET_ORDER = "open-api/order/v1/orders/exit/sno"
    POSITION_SQR_OFF = "open-api/order/v1/orders/positions/sqroff"

    # Endpoints for orders details
    GET_ORDER_BOOK = "open-api/order/v1/orders/book"
    GET_TRADE_BOOK = "open-api/order/v1/orders/trades"
    GET_ORDER_HISTORY = "open-api/order/v1/orders/history/"

    # Placeholder for chart history endpoint
    GET_CHART_HISTORY = ""  # Replace with a valid endpoint or remove if not needed

    @staticmethod
    def get_full_url(endpoint):
        """Return full URL for a given endpoint."""
        return f"{ServiceProps.BASE_URL}{endpoint}"


