# Creative Commons Legal Code
#
# CC0 1.0 Universal
#
#     CREATIVE COMMONS CORPORATION IS NOT A LAW FIRM AND DOES NOT PROVIDE
#     LEGAL SERVICES. DISTRIBUTION OF THIS DOCUMENT DOES NOT CREATE AN
#     ATTORNEY-CLIENT RELATIONSHIP. CREATIVE COMMONS PROVIDES THIS
#     INFORMATION ON AN "AS-IS" BASIS. CREATIVE COMMONS MAKES NO WARRANTIES
#     REGARDING THE USE OF THIS DOCUMENT OR THE INFORMATION OR WORKS
#     PROVIDED HEREUNDER, AND DISCLAIMS LIABILITY FOR DAMAGES RESULTING FROM
#     THE USE OF THIS DOCUMENT OR THE INFORMATION OR WORKS PROVIDED
#     HEREUNDER.
#
# Statement of Purpose
#
# The laws of most jurisdictions throughout the world automatically confer
# exclusive Copyright and Related Rights (defined below) upon the creator
# and subsequent owner(s) (each and all, an "owner") of an original work of
# authorship and/or a database (each, a "Work").
#
# Certain owners wish to permanently relinquish those rights to a Work for
# the purpose of contributing to a commons of creative, cultural and
# scientific works ("Commons") that the public can reliably and without fear
# of later claims of infringement build upon, modify, incorporate in other
# works, reuse and redistribute as freely as possible in any form whatsoever
# and for any purposes, including without limitation commercial purposes.
# These owners may contribute to the Commons to promote the ideal of a free
# culture and the further production of creative, cultural and scientific
# works, or to gain reputation or greater distribution for their Work in
# part through the use and efforts of others.
#
# For these and/or other purposes and motivations, and without any
# expectation of additional consideration or compensation, the person
# associating CC0 with a Work (the "Affirmer"), to the extent that he or she
# is an owner of Copyright and Related Rights in the Work, voluntarily
# elects to apply CC0 to the Work and publicly distribute the Work under its
# terms, with knowledge of his or her Copyright and Related Rights in the
# Work and the meaning and intended legal effect of CC0 on those rights.
#
# 1. Copyright and Related Rights. A Work made available under CC0 may be
# protected by copyright and related or neighboring rights ("Copyright and
# Related Rights"). Copyright and Related Rights include, but are not
# limited to, the following:
#
#   i. the right to reproduce, adapt, distribute, perform, display,
#      communicate, and translate a Work;
#  ii. moral rights retained by the original author(s) and/or performer(s);
# iii. publicity and privacy rights pertaining to a person's image or
#      likeness depicted in a Work;
#  iv. rights protecting against unfair competition in regards to a Work,
#      subject to the limitations in paragraph 4(a), below;
#   v. rights protecting the extraction, dissemination, use and reuse of data
#      in a Work;
#  vi. database rights (such as those arising under Directive 96/9/EC of the
#      European Parliament and of the Council of 11 March 1996 on the legal
#      protection of databases, and under any national implementation
#      thereof, including any amended or successor version of such
#      directive); and
# vii. other similar, equivalent or corresponding rights throughout the
#      world based on applicable law or treaty, and any national
#      implementations thereof.
#
# 2. Waiver. To the greatest extent permitted by, but not in contravention
# of, applicable law, Affirmer hereby overtly, fully, permanently,
# irrevocably and unconditionally waives, abandons, and surrenders all of
# Affirmer's Copyright and Related Rights and associated claims and causes
# of action, whether now known or unknown (including existing as well as
# future claims and causes of action), in the Work (i) in all territories
# worldwide, (ii) for the maximum duration provided by applicable law or
# treaty (including future time extensions), (iii) in any current or future
# medium and for any number of copies, and (iv) for any purpose whatsoever,
# including without limitation commercial, advertising or promotional
# purposes (the "Waiver"). Affirmer makes the Waiver for the benefit of each
# member of the public at large and to the detriment of Affirmer's heirs and
# successors, fully intending that such Waiver shall not be subject to
# revocation, rescission, cancellation, termination, or any other legal or
# equitable action to disrupt the quiet enjoyment of the Work by the public
# as contemplated by Affirmer's express Statement of Purpose.
#
# 3. Public License Fallback. Should any part of the Waiver for any reason
# be judged legally invalid or ineffective under applicable law, then the
# Waiver shall be preserved to the maximum extent permitted taking into
# account Affirmer's express Statement of Purpose. In addition, to the
# extent the Waiver is so judged Affirmer hereby grants to each affected
# person a royalty-free, non transferable, non sublicensable, non exclusive,
# irrevocable and unconditional license to exercise Affirmer's Copyright and
# Related Rights in the Work (i) in all territories worldwide, (ii) for the
# maximum duration provided by applicable law or treaty (including future
# time extensions), (iii) in any current or future medium and for any number
# of copies, and (iv) for any purpose whatsoever, including without
# limitation commercial, advertising or promotional purposes (the
# "License"). The License shall be deemed effective as of the date CC0 was
# applied by Affirmer to the Work. Should any part of the License for any
# reason be judged legally invalid or ineffective under applicable law, such
# partial invalidity or ineffectiveness shall not invalidate the remainder
# of the License, and in such case Affirmer hereby affirms that he or she
# will not (i) exercise any of his or her remaining Copyright and Related
# Rights in the Work or (ii) assert any associated claims and causes of
# action with respect to the Work, in either case contrary to Affirmer's
# express Statement of Purpose.
#
# 4. Limitations and Disclaimers.
#
#  a. No trademark or patent rights held by Affirmer are waived, abandoned,
#     surrendered, licensed or otherwise affected by this document.
#  b. Affirmer offers the Work as-is and makes no representations or
#     warranties of any kind concerning the Work, express, implied,
#     statutory or otherwise, including without limitation warranties of
#     title, merchantability, fitness for a particular purpose, non
#     infringement, or the absence of latent or other defects, accuracy, or
#     the present or absence of errors, whether or not discoverable, all to
#     the greatest extent permissible under applicable law.
#  c. Affirmer disclaims responsibility for clearing rights of other persons
#     that may apply to the Work or any use thereof, including without
#     limitation any person's Copyright and Related Rights in the Work.
#     Further, Affirmer disclaims responsibility for obtaining any necessary
#     consents, permissions or other rights required for any use of the
#     Work.
#  d. Affirmer understands and acknowledges that Creative Commons is not a
#     party to this document and has no duty or obligation with respect to
#     this CC0 or use of the Work.

# This file was compiled from a KSY format file downloaded from:
# https://github.com/kaitai-io/kaitai_struct_formats


# This is a generated file! Please edit source .ksy file and use kaitai-struct-compiler to rebuild

from pkg_resources import parse_version
import kaitaistruct
from kaitaistruct import KaitaiStruct, KaitaiStream, BytesIO
import collections


if parse_version(kaitaistruct.__version__) < parse_version('0.9'):
    raise Exception("Incompatible Kaitai Struct Python API: 0.9 or later is required, but you have %s" % (kaitaistruct.__version__))

class AvantesRoh60(KaitaiStruct):
    """Avantes USB spectrometers are supplied with a Windows binary which
    generates one ROH and one RCM file when the user clicks "Save
    experiment". In the version of 6.0, the ROH file contains a header
    of 22 four-byte floats, then the spectrum as a float array and a
    footer of 3 floats. The first and last pixel numbers are specified in the
    header and determine the (length+1) of the spectral data. In the tested
    files, the length is (2032-211-1)=1820 pixels, but Kaitai determines this
    automatically anyway.
    
    The wavelength calibration is stored as a polynomial with coefficients
    of 'wlintercept', 'wlx1', ... 'wlx4', the argument of which is the
    (pixel number + 1), as found out by comparing with the original
    Avantes converted data files. There is no intensity calibration saved,
    but it is recommended to do it in your program - the CCD in the spectrometer
    is so uneven that one should prepare exact pixel-to-pixel calibration curves
    to get reasonable spectral results.
    
    The rest of the header floats is not known to the author. Note that the
    newer version of Avantes software has a different format, see also
    <https://www.mathworks.com/matlabcentral/fileexchange/37103-avantes-to-matlab>
    
    The RCM file contains the user-specified comment, so it may be useful
    for automatic conversion of data. You may wish to divide the spectra by
    the integration time before comparing them.
    
    Written and tested by Filip Dominec, 2017-2018
    """
    SEQ_FIELDS = ["unknown1", "wlintercept", "wlx1", "wlx2", "wlx3", "wlx4", "unknown2", "ipixfirst", "ipixlast", "unknown3", "spectrum", "integration_ms", "averaging", "pixel_smoothing"]
    def __init__(self, _io, _parent=None, _root=None):
        self._io = _io
        self._parent = _parent
        self._root = _root if _root else self
        self._debug = collections.defaultdict(dict)

    def _read(self):
        self._debug['unknown1']['start'] = self._io.pos()
        self.unknown1 = self._io.read_f4le()
        self._debug['unknown1']['end'] = self._io.pos()
        self._debug['wlintercept']['start'] = self._io.pos()
        self.wlintercept = self._io.read_f4le()
        self._debug['wlintercept']['end'] = self._io.pos()
        self._debug['wlx1']['start'] = self._io.pos()
        self.wlx1 = self._io.read_f4le()
        self._debug['wlx1']['end'] = self._io.pos()
        self._debug['wlx2']['start'] = self._io.pos()
        self.wlx2 = self._io.read_f4le()
        self._debug['wlx2']['end'] = self._io.pos()
        self._debug['wlx3']['start'] = self._io.pos()
        self.wlx3 = self._io.read_f4le()
        self._debug['wlx3']['end'] = self._io.pos()
        self._debug['wlx4']['start'] = self._io.pos()
        self.wlx4 = self._io.read_f4le()
        self._debug['wlx4']['end'] = self._io.pos()
        self._debug['unknown2']['start'] = self._io.pos()
        self.unknown2 = [None] * (9)
        for i in range(9):
            if not 'arr' in self._debug['unknown2']:
                self._debug['unknown2']['arr'] = []
            self._debug['unknown2']['arr'].append({'start': self._io.pos()})
            self.unknown2[i] = self._io.read_f4le()
            self._debug['unknown2']['arr'][i]['end'] = self._io.pos()

        self._debug['unknown2']['end'] = self._io.pos()
        self._debug['ipixfirst']['start'] = self._io.pos()
        self.ipixfirst = self._io.read_f4le()
        self._debug['ipixfirst']['end'] = self._io.pos()
        self._debug['ipixlast']['start'] = self._io.pos()
        self.ipixlast = self._io.read_f4le()
        self._debug['ipixlast']['end'] = self._io.pos()
        self._debug['unknown3']['start'] = self._io.pos()
        self.unknown3 = [None] * (4)
        for i in range(4):
            if not 'arr' in self._debug['unknown3']:
                self._debug['unknown3']['arr'] = []
            self._debug['unknown3']['arr'].append({'start': self._io.pos()})
            self.unknown3[i] = self._io.read_f4le()
            self._debug['unknown3']['arr'][i]['end'] = self._io.pos()

        self._debug['unknown3']['end'] = self._io.pos()
        self._debug['spectrum']['start'] = self._io.pos()
        self.spectrum = [None] * (((int(self.ipixlast) - int(self.ipixfirst)) - 1))
        for i in range(((int(self.ipixlast) - int(self.ipixfirst)) - 1)):
            if not 'arr' in self._debug['spectrum']:
                self._debug['spectrum']['arr'] = []
            self._debug['spectrum']['arr'].append({'start': self._io.pos()})
            self.spectrum[i] = self._io.read_f4le()
            self._debug['spectrum']['arr'][i]['end'] = self._io.pos()

        self._debug['spectrum']['end'] = self._io.pos()
        self._debug['integration_ms']['start'] = self._io.pos()
        self.integration_ms = self._io.read_f4le()
        self._debug['integration_ms']['end'] = self._io.pos()
        self._debug['averaging']['start'] = self._io.pos()
        self.averaging = self._io.read_f4le()
        self._debug['averaging']['end'] = self._io.pos()
        self._debug['pixel_smoothing']['start'] = self._io.pos()
        self.pixel_smoothing = self._io.read_f4le()
        self._debug['pixel_smoothing']['end'] = self._io.pos()


