# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['use_case_outcome']

package_data = \
{'': ['*']}

install_requires = \
['swimlane>=10.9.1,<11.0.0']

setup_kwargs = {
    'name': 'use-case-outcome',
    'version': '1.2.0',
    'description': 'Package for collecting information about the execution of a use case',
    'long_description': '# Use Case Outcome\n\nA Python package that records logs and metrics throughout the execution of a Use Case ran in Swimlane. This allows us to easily save a record within our Use Case Outcome application to diagnose issues with Use Cases much quicker.\n\n## In this README :point_down:\n\n- [Setup](#setup)\n- [Usage](#usage)\n  - [Initial setup](#initial-setup)\n  - [Creating releases](#creating-releases)\n- [Functionality](#functionality)\n- [Contributing](#contributing)\n\n## Usage\n\n### Initial setup\n\n1. Simply install the package\n\n`pip install use_case_outcome` or `pip install use_case_outcome==1.0.0`\n\n2. Import it into your module:\n\n```python\nfrom use_case_outcome import UseCaseOutcome\n```\n\n3. Initialise your own instance of `UseCaseOutcome`\n\n```python\nuco = UseCaseOutcome(swimlane, "Application Name", "Integration Name", extra_key_value="test")\n```\n\n4. Start your use case. This will start your timer and you can log your logs, metrics and fields changed as you go through. Please refer to [Functionality](#functionality)\n\n```python\nuco.start()\n```\n\n### Creating releases\n\n#### Manually\n\nIf you wish to build and deploy a release of this package manually from your own machine, you can do that via the `poetry CLI`. Please ensure that you have a value key setup to access PyPi with Poetry. Please see the docs for poetry [here](https://python-poetry.org/docs/repositories/#configuring-credentials)\n\nBuild the package:\n\nPoetry uses the `pyproject.toml` file for it\'s config when you run commands within this directory, so it gets all of it\'s information about the package from there including any dependencies and where to look for the modules.\n\n```bash\npoetry build\n```\n\nPublish the packagee:\n\nOnce you have your creds setup with PyPi and you\'re ready to publish, you should be able to publish by using the below command\n\n```bash\npoetry publish\n```\n\n## Functionality\n\n### UseCaseOutcome class\n\n#### Properties\n\n* `sl` - Swimlane instance\n* `app_name` - The application name that the Use Case belongs to\n* `integration_name` - The integration that is running\n* `default_fields` - Any default fields that you want available on every log\n* `logs` - All of the logs that get logged during the execution of a use case\n* `metrics` - All of the metrics that get logged during the execution of a use case\n* `fields_changed` - All of the fields changed that get logged during the execution of a use case\n* `use_case_started` - The timestamp of when the use case was started (see `start()` method below)\n* `arbitrary_record_fields` - This is to protect future enhancements to the UseCaseOutcome application. Applications can make use of new fields without having to update this package\n\n#### Methods\n\n`__init__(self, sl: Swimlane, app_name: str, integration_name: str, **default_fields)`:\n\nParameters:\n\n    * sl: Swimlane - The Swimlane instance that you instantiate inside of your Use Case\n    * app_name: str - The application name that triggered the use case\n    * integration_name: str - The integration that is executing\n    * default_fields: kwargs - This is a kwargs argument allowing you to pass in default fields for your logs. This means any fields passed in via this parameter will be available on every log\n\n`start(self)`:\n\n> The `start()` method is called at the start of a Use Case and records the time that it starts on the UseCaseOutcome object\n\n`update_field(self, field_name: str, field_value: str)`:\n\n> Update field is used to update a field inside of the Use Case Outcome application. It remains dynamic to ensure that as fields get added to the Use Case Outcome application, we don\'t have to apply updated to this package\n\nParameters:\n\n    * field_name: str - The field name on the Use Case Outcome application you wish to update. To conform with Python standards, we have some processing on the field names and so they have to be in a certain format. Example : If the field in the Use Case Outcome application is `Saim Case Created`, then the `field_name` you would pass into this method would be `saim_case_created`. **IMPORTANT: We must ensure that fields in the Use Case Outcome application conform with this format : Saim Case Created. Each word capitalised and separated by a space**\n    * field_value: str - The value you wish to set the field to in the Use Case Outcome application\n\n`submit(self, status: Literal["Success", "Failed"], record: Record, auto_closed: bool = False)`:\n\n> This is what you will run at the end, once you have finished the use case. This will take all of the logs, metrics and other pieces of information you have gathered during the executing of your use case and create a record in the Use Case Outcome application allowing you to see them all in a single record\n\nParameters:\n\n    * status: Literal["Success", "Failed"] - The status of which the use case was. Currently only either a complete success, or a complete failure\n    * record: Record - The record the Use Case is running for\n    * auto_closed: Bool = False - Whether or not the execution of the use case caused an auto-closure of that current record or not\n\n`duration(self, end_time: DateTime) -> float`:\n\n> A helper method that simply takes in an end time and gets the duration between the `start_time` on the object and the end time that was passed in\n\nParameters:\n\n    * end_time: DateTime - It uses this time, and the start time registered when running the `start()` method to work out an overall duration. This method is ran as part of the `submit` method so is nothing you have to worry about in a use case\n\nReturns:\n\n    * duration: float - The duration in seconds between `self.start_time` and the `end_time` parameter\n\n`create_uco_record(self, data: Dict[str, Any], record: Record)`\n\n> This is responsible for taking the data that has been processed inside of the object already and creating the Use Case Outcome application which allows us to refer back to this data at a later date. This method is called within the `submit()` method and so is nothing you have to worry about inside of your use case\n\nParameters:\n\n    * data: Dict[str, Any] - This is the data you want to unpack to create the actual record. The data processing has already been done within the `submit()` method\n    * record: Record - The originating record that is creating the Use Case Outcome record. This will allow us to add a reference back to that originating record\n\n`log(self, level: str, **kwargs)`\n\n> This is a generic log method which allows us to create logs to be created in the Use Case Outcome record. The levels allowed are as per below. Kwargs allows you to pass any number of arbitrary key/value pairs into your logs allowing for ultimate flexibility\n\nLevels allowed : `_LEVELS = ["debug", "info", "warning", "error", "critical"]`\n\nParameters:\n\n    * level: str - The level, as a string. It must be one of those defined in `_LEVELS` as outlined above\n    * **kwargs - Each log may require different amounts of information to provide different pieces of contextual information to that log, depending on what it\'s doing. That\'s what kwargs allows us to do, each log will have full flexibility in terms of what data it can provide to that particular log\n\n`metric(self, metric_name: str, metric_value: Any)`:\n\n> This is a method, similar to the log method that allows you to create metrics on the fly during the execution of your use case. You can only ever create one metric/value at one time\n\nParameters:\n\n    * metric_name: str - The name of your metric\n    * metric_value: Any - The value of your metric\n\n`record_saved(self)`:\n\n> This is ran whenever you have ran the `save()` or `patch()` method on your record within your use case. This will then record that time against all fields taht were changed as part of that process\n\n`field_changed(self, field_name: str, old_field_value: str, new_field_value: str)`:\n\n> This method allows us to register whenever a field is changed within your use case. For example if you\'re setting `analysis complete` to `YES`, then this would be an opportunity to run this method. When you run the `record_saved` method, it will go through the fields and record a timestamp against when they changed\n\nParameters:\n\n    * field_name: str - The field name that we have changed the value of\n    * old_field_value: str - The old field value, the value we are changing from\n    * new_field_value: str - This is the value we have changed to\n\n`_normalise_logs(self)`:\n\n> The widget responsible for displaying the logs, requires there to be the exact same fields available in each log. This is a problem with the setup we have, as each log can contain any arbitrary key/value pairs and therefore by default this isn\'t the case. This method will iterate over all of the logs ensuring that they contain all of the same key/value pairs - allowing our widget to work\n\n`_normalise_keys(d: dict)`:\n\n> A helper method to normalise the keys of the dictionary that is passed in. It will iterate over all of the keys, replace the `_` with a `space` and replacing the start of each word with a capitalised letter. `create_saim_case` becomes `Create Saim Case`\n\nParameters:\n\n    * d: dict - The data of which we want to normalise the keys for\n\n## Contributing\n\nTo contribute to this project, please just Git Clone the project and ensure a pull request is raised and assigned to an applicable person\n',
    'author': 'Ross Bown',
    'author_email': 'rossbo@softcat.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
