/*
 * Decompiled with CFR 0.152.
 */
package spec;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.AmbiguousApplyExpResolverExpTransformer;
import spec.CVLErrorLogger;
import spec.cvlast.CVLAstTransformer;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLCmdTransformer;
import spec.cvlast.CVLErrorType;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLInbuiltStructTypes;
import spec.cvlast.CVLLhs;
import spec.cvlast.CVLLocation;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLSymbolTable;
import spec.cvlast.CVLType;
import spec.cvlast.HasCVLErrorLogger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lspec/AmbiguousApplyExpressionResolver;", "Lspec/cvlast/CVLAstTransformer;", "Lspec/cvlast/HasCVLErrorLogger;", "symbolTable", "Lspec/cvlast/CVLSymbolTable;", "errorLogger", "Lspec/CVLErrorLogger;", "(Lspec/cvlast/CVLSymbolTable;Lspec/CVLErrorLogger;)V", "getErrorLogger", "()Lspec/CVLErrorLogger;", "getSymbolTable", "()Lspec/cvlast/CVLSymbolTable;", "Shared"})
public final class AmbiguousApplyExpressionResolver
extends CVLAstTransformer
implements HasCVLErrorLogger {
    @NotNull
    private final CVLSymbolTable symbolTable;
    @NotNull
    private final CVLErrorLogger errorLogger;

    public AmbiguousApplyExpressionResolver(final @NotNull CVLSymbolTable symbolTable, final @NotNull CVLErrorLogger errorLogger) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(errorLogger, "errorLogger");
        AmbiguousApplyExpResolverExpTransformer ambiguousApplyExpResolverExpTransformer = new AmbiguousApplyExpResolverExpTransformer(symbolTable, errorLogger);
        super(new CVLCmdTransformer(ambiguousApplyExpResolverExpTransformer){

            @Override
            @NotNull
            public CVLCmd def(@NotNull CVLCmd.Simple.Definition cmd) {
                Intrinsics.checkNotNullParameter(cmd, "cmd");
                CVLCmd.Simple.Definition newCmd2 = cmd;
                if (cmd.getIdL().size() == 1) {
                    CVLType type;
                    String string2 = CollectionsKt.first(cmd.getIdL()).getIdLhs().getId();
                    CVLScope cVLScope = cmd.getScope();
                    Intrinsics.checkNotNull(cVLScope);
                    CVLSymbolTable.SymbolInfo symbolInfo = symbolTable.lookUpNonFunctionLikeSymbol(string2, cVLScope);
                    CVLType cVLType = type = symbolInfo == null ? null : symbolInfo.getCVLType();
                    if (Intrinsics.areEqual(type, CVLInbuiltStructTypes.methodType.getCvlType()) && cmd.getExp() instanceof CVLExp.AmbiguousApplyExp) {
                        newCmd2 = CVLCmd.Simple.Definition.copy$default(cmd, null, null, null, AmbiguousApplyExpResolverExpTransformer.Companion.funIdExp$default(AmbiguousApplyExpResolverExpTransformer.Companion, (CVLExp.AmbiguousApplyExp)cmd.getExp(), symbolTable, errorLogger, null, 8, null), null, 23, null);
                    }
                }
                return super.def(newCmd2);
            }

            @Override
            @NotNull
            public CVLCmd ambiguousApplyCmd(@NotNull CVLCmd.Simple.AmbiguousApply cmd) {
                CVLCmd cVLCmd;
                Intrinsics.checkNotNullParameter(cmd, "cmd");
                CVLExp ambiguousExpResolved = this.getTransform().ambiguousApply(cmd.getExp());
                if (ambiguousExpResolved instanceof CVLExp.ApplyExp) {
                    cVLCmd = new CVLCmd.Simple.Apply(cmd.getLoc(), (CVLExp.ApplyExp)ambiguousExpResolved, cmd.getScope());
                } else if (ambiguousExpResolved instanceof CVLExp.Constant.FunctionIdExp) {
                    errorLogger.error("A FunctionIdExp should not be used as a command", cmd.getLoc());
                    cVLCmd = cmd;
                } else {
                    throw new IllegalStateException("ambigious apply exp was resolved to something else than an apply and a function id -- revise!".toString());
                }
                return cVLCmd;
            }
        });
        this.symbolTable = symbolTable;
        this.errorLogger = errorLogger;
        if (!(this.symbolTable.getUserDefinedTypeResolver() != null)) {
            boolean bl = false;
            String string2 = "Ambiguous Apply Resolver must take a symbol table with a non-null user defined type resolver";
            throw new IllegalStateException(string2.toString());
        }
    }

    @NotNull
    public final CVLSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @Override
    @NotNull
    public CVLErrorLogger getErrorLogger() {
        return this.errorLogger;
    }

    @Override
    public void syntaxError(@NotNull CVLLocation loc, @NotNull String message) {
        HasCVLErrorLogger.DefaultImpls.syntaxError(this, loc, message);
    }

    @Override
    @NotNull
    public CVLErrorType typeError(@NotNull CVLLhs lhs, @NotNull CVLLocation loc, @NotNull String message) {
        return HasCVLErrorLogger.DefaultImpls.typeError((HasCVLErrorLogger)this, lhs, loc, message);
    }

    @Override
    @NotNull
    public CVLErrorType typeError(@NotNull CVLExp exp, @NotNull CVLLocation loc, @NotNull String message) {
        return HasCVLErrorLogger.DefaultImpls.typeError((HasCVLErrorLogger)this, exp, loc, message);
    }

    @Override
    @NotNull
    public CVLErrorType typeError(@NotNull CVLExp exp, @NotNull CVLLocation loc) {
        return HasCVLErrorLogger.DefaultImpls.typeError(this, exp, loc);
    }
}

