<img src="logo/logo_640.png" width="240" height="240">

### dyconnmap
A neuroimaging module for dynamic connectome mapping.

[![Build Status](https://travis-ci.org/makism/dyconnmap.svg?branch=master)](https://travis-ci.org/makism/dyconnmap) [![Coverage Status](https://coveralls.io/repos/github/makism/dyconnmap/badge.svg?branch=master)](https://coveralls.io/github/makism/dyconnmap?branch=master) [![Codacy Badge](https://api.codacy.com/project/badge/Grade/70dff7603f5849f79e703f852d1b5ae3)](https://www.codacy.com/app/makism/dyconnmap?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=makism/dyconnmap&amp;utm_campaign=Badge_Grade) [![Documentation Status](https://readthedocs.org/projects/dyconnmap/badge/?version=latest)](https://dyconnmap.readthedocs.io/?badge=latest)
 [![Licence](https://img.shields.io/badge/Licence-BSD-blue.svg)](https://opensource.org/licenses/BSD-3-Clause) ![python-3.6](https://img.shields.io/pypi/pyversions/dyconnmap) [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/makism/dyconnmap/master?filepath=tutorials)
 
[![PyPI version](https://badge.fury.io/py/dyconnmap.svg)](https://badge.fury.io/py/dyconnmap) [![Anaconda-Server Badge](https://anaconda.org/makism/dyconnmap/badges/version.svg)](https://anaconda.org/makism/dyconnmap) ![Whenenver a new tag is pushed; a wheel distribution is uploada on the Test PyPI index.](https://github.com/makism/dyconnmap/workflows/publish-test-pypi/badge.svg)

---

financially sponsored by [Brain Innovation B.V.](https://www.brainvoyager.com)

---


_dyconnmap_ (abbreviated from “dynamic connectome mapping”), a neuroimaging python module specifically designed for estimating the dynamic connectivity and analyzing complex brain networks; from neurophysiological data such as electroencephalogram (EEG), magnetoencephalography (MEG) and functional magnetic resonance imaging (fMRI) recordings. It includes numerous submodules to work with, such as chronnectomics and graph-theoretical algorithms, (symbolic) time series and statistical methods.

This is an ongoing effort to develop the module further and extend it by adding more algorithms related to graph analysis and statistical approaches. Considering the increasing acceptance and usage of python in analyzing neuroimaging data, we firmly believe that the module will be a great addition in every practitioner's toolbox engaged in brain connectivity analysis.

Built on [NumPy](http://www.numpy.org/), [SciPy](http://www.scipy.org/), [matplotlib](http://matplotlib.org/) and [networkx](https://networkx.github.io/).

#### Workflow outline

![workflow](docs/v2_pipeline.png)


#### Publications

* [poster presented @ 13th International Conference for Cognitive Neuroscience in Amsterdam \(ICON2017\)](https://f1000research.com/posters/6-1638) [![DOI](https://img.shields.io/badge/DOI-10.7490%2Ff1000research.1114652.1-blue.svg)](http://dx.doi.org/10.7490/f1000research.1114652.1) [under the previous name "dyfunconn"]

#### Resources

* [Installation](https://github.com/makism/dyconnmap/blob/master/INSTALL.md)

* [Documenation](http://dyconnmap.readthedocs.io/?badge=latest)

* [Tutorials](https://github.com/makism/dyconnmap/tree/master/tutorials)

* [Examples](https://github.com/makism/dyconnmap/tree/master/examples)


#### Cittation

If you use _dyconnmap_ or _dyfunconn_ in a published work, please consider citing.

<table align="center">
    <tr>
        <td align="left">1.</td>
        <td align="left">Marimpis, A. D., & Dimitriadis, S. I. (2017). dyfunncon: dynamic functional connectivity–a neuroimaging Python module. F1000Research, 6. https://doi.org/10.7490/f1000research.1114652.1</td>
    </tr>
</table>

