from typing import Dict, List

VOWELS = set("aeiouy")

PUNCTUATION = set(",.?;:'")

LI_ENDINGS = set("cdeghkmnrt")

DOUBLE_CONSONANTS = ("bb", "dd", "ff", "gg", "mm", "nn", "pp", "rr", "tt")

STOPWORDS = {
    "a",
    "about",
    "above",
    "after",
    "again",
    "against",
    "all",
    "am",
    "an",
    "and",
    "any",
    "are",
    "as",
    "at",
    "be",
    "because",
    "been",
    "before",
    "being",
    "below",
    "between",
    "both",
    "but",
    "by",
    "can",
    "did",
    "do",
    "does",
    "doing",
    "don",
    "down",
    "during",
    "each",
    "few",
    "for",
    "from",
    "further",
    "had",
    "has",
    "have",
    "having",
    "he",
    "her",
    "here",
    "hers",
    "herself",
    "him",
    "himself",
    "his",
    "how",
    "i",
    "if",
    "in",
    "into",
    "is",
    "it",
    "its",
    "itself",
    "just",
    "me",
    "more",
    "most",
    "my",
    "myself",
    "no",
    "nor",
    "not",
    "now",
    "of",
    "off",
    "on",
    "once",
    "only",
    "or",
    "other",
    "our",
    "ours",
    "ourselves",
    "out",
    "over",
    "own",
    "s",
    "same",
    "she",
    "should",
    "so",
    "some",
    "such",
    "t",
    "than",
    "that",
    "the",
    "their",
    "theirs",
    "them",
    "themselves",
    "then",
    "there",
    "these",
    "they",
    "this",
    "those",
    "through",
    "to",
    "too",
    "under",
    "until",
    "up",
    "very",
    "was",
    "we",
    "were",
    "what",
    "when",
    "where",
    "which",
    "while",
    "who",
    "whom",
    "why",
    "will",
    "with",
}

EXCEPTIONS = {
    "andes": "andes",
    "bias": "bias",
    "canning": "canning",
    "cannings": "canning",
    "dying": "die",
    "exceed": "exceed",
    "exceeds": "exceed",
    "exceeded": "exceed",
    "exceeding": "exceed",
    "gently": "gentl",
    "herring": "herring",
    "herrings": "herring",
    "inning": "inning",
    "innings": "inning",
    "lying": "lie",
    "news": "news",
    "outing": "outing",
    "outings": "outing",
    "proceed": "proceed",
    "proceeds": "proceed",
    "proceeded": "proceed",
    "proceeding": "proceed",
    "succeed": "succeed",
    "succeeds": "succeed",
    "succeeded": "succeed",
    "succeeding": "succeed",
    "tying": "tie",
    "ugly": "ugli",
    "affably": "affabl",
    "agreeably": "agreeabl",
    "ami": "ami",
    "amiably": "amiabl",
    "ascendancy": "ascend",
    "considerably": "consider",
    "damn": "damn",
    "damnably": "damnabl",
    "ear": "ear",
    "early": "earli",
    "earring": "earring",
    "earrings": "earring",
    "eating": "eat",
    "eaves": "eav",
    "elegancies": "eleg",
    "expectancy": "expect",
    "idly": "idl",
    "inconstancy": "inconst",
    "insufferably": "insuffer",
    "intolerably": "intoler",
    "lieutenancies": "lieuten",
    "not": "not",
    "notably": "notabl",
    "occupancy": "occup",
    "only": "onli",
    "oozes": "ooz",
    "palpably": "palpabl",
    "peaceably": "peaceabl",
    "pitiably": "pitiabl",
    "probably": "probabl",
    "proportionably": "proportion",
    "significancy": "signific",
    "sing": "sing",
    "singly": "singl",
    "skies": "sky",
    "sky": "sky",
    "suit": "suit",
    "suitably": "suitabl",
    "sycophancy": "sycoph",
    "unquestionably": "unquestion",
    "ease": "eas",
    "eine": "ein",
    "ooze": "ooz",
    "ouse": "ous",
}

SUFFIX_FIRST_LETTER_MAP: List[Dict[str, List[str]]] = [
    {},
    {"d": ["eed", "ed"], "g": ["ing"], "y": ["eedly", "ingly", "edly"]},
    {
        "i": [
            "biliti",
            "lessli",
            "entli",
            "aliti",
            "ousli",
            "iviti",
            "fulli",
            "enci",
            "anci",
            "abli",
            "alli",
            "bli",
            "ogi",
            "li",
        ],
        "l": ["ational", "tional"],
        "m": ["alism"],
        "n": ["ization", "ation"],
        "r": ["izer", "ator"],
        "s": ["fulness", "ousness", "iveness"],
    },
    {
        "e": ["alize", "icate", "ative"],
        "i": ["iciti"],
        "l": ["ational", "tional", "ical", "ful"],
        "s": ["ness"],
    },
    {
        "c": ["ic"],
        "e": ["ance", "ence", "able", "ible", "ate", "ive", "ize"],
        "i": ["iti"],
        "l": ["al"],
        "m": ["ism"],
        "n": ["ion"],
        "r": ["er"],
        "s": ["ous"],
        "t": ["ement", "ment", "ant", "ent"],
    },
]
