# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/apiref.ipynb (unless otherwise specified).

__all__ = ['Parsed', 'ParsedFunc']

# Cell
from fastcore.all import Path, L, risinstance, test_eq
import ast, re

# Cell
class Parsed:
    def __init__(self, tree):
        self.tree = tree
        self.docstring = ast.get_docstring(tree)

    def __getattr__(self, a):
        return getattr(self.tree, a)

# Cell
class ParsedFunc(Parsed):
    "Parse a function in a way that is amenable to show in the docs."
    def __init__(self, tree):
        assert isinstance(tree, ast.FunctionDef), f"Cannot parse non-function type: {type(tree)}."
        super().__init__(tree)
        self.dirty_ds = ast.get_docstring(tree, clean=False)
        self.args = ast.unparse(tree.args)
        _returns = getattr(tree, 'returns')
        self.returns = ast.unparse(_returns) if _returns else None
        self.body = self.get_body()
        self.decorators = [ast.unparse(d) for d in tree.decorator_list]

    def get_body(self):
        body = ast.unparse(self.tree.body).encode('utf-8').decode('unicode_escape')
        docstring = f"'{ast.get_docstring(self.tree, clean=False)}'\n"
        return body.replace(docstring, '')

    @property
    def include(self):
        "If this function should be shown in the docs or not."
        return self.name == '__init__' or (not self.name.startswith('_') and 'property' not in self.decorators)