#
# solver_porting.py
#
# Description:
#   Hard code the solution values from the paper
#   Sin-Chung Chang,
#   "The Method of Space-Time Conservation Element 
#   and Solution Element - A New Approach for Solving the Navier-Stokes
#   and Euler Equations",
#   Journal of Computational Physics, Volume 119,
#   Issue 2, July 1995, Pages 295-324.
#
#   These values are caculated my python program ported from the
#   demo example written in fortran in the paper above.
#
#   These two functions generated from the same python program
#   but one with high precision.
#

def get_specific_solution_for_unit_test():
    solution_porting = [
        (-0.505000, 1.000000, 0.000000, 1.000000),
        (-0.495000, 1.000000, 0.000000, 1.000000),
        (-0.485000, 1.000000, 0.000000, 1.000000),
        (-0.475000, 1.000000, 0.000000, 1.000000),
        (-0.465000, 1.000000, 0.000000, 1.000000),
        (-0.455000, 1.000000, 0.000000, 1.000000),
        (-0.445000, 1.000000, 0.000000, 1.000000),
        (-0.435000, 1.000000, 0.000000, 1.000000),
        (-0.425000, 1.000000, 0.000000, 1.000000),
        (-0.415000, 1.000000, 0.000000, 1.000000),
        (-0.405000, 1.000000, 0.000000, 1.000000),
        (-0.395000, 1.000000, 0.000000, 1.000000),
        (-0.385000, 1.000000, 0.000000, 1.000000),
        (-0.375000, 1.000000, 0.000000, 1.000000),
        (-0.365000, 1.000000, 0.000000, 1.000000),
        (-0.355000, 1.000000, 0.000000, 1.000000),
        (-0.345000, 1.000000, 0.000000, 1.000000),
        (-0.335000, 1.000000, 0.000000, 1.000000),
        (-0.325000, 1.000000, 0.000000, 1.000000),
        (-0.315000, 1.000000, 0.000001, 0.999990),
        (-0.305000, 0.999996, 0.000004, 0.999990),
        (-0.295000, 0.999976, 0.000028, 0.999960),
        (-0.285000, 0.999871, 0.000153, 0.999810),
        (-0.275000, 0.999414, 0.000694, 0.999170),
        (-0.265000, 0.997818, 0.002584, 0.996940),
        (-0.255000, 0.993421, 0.007803, 0.990800),
        (-0.245000, 0.983967, 0.019086, 0.977630),
        (-0.235000, 0.967934, 0.038418, 0.955410),
        (-0.225000, 0.945706, 0.065654, 0.924830),
        (-0.215000, 0.919136, 0.098909, 0.888630),
        (-0.205000, 0.890232, 0.135996, 0.849670),
        (-0.195000, 0.860418, 0.175310, 0.809950),
        (-0.185000, 0.830502, 0.215915, 0.770550),
        (-0.175000, 0.800906, 0.257311, 0.732020),
        (-0.165000, 0.771847, 0.299228, 0.694620),
        (-0.155000, 0.743447, 0.341510, 0.658480),
        (-0.145000, 0.715776, 0.384050, 0.623660),
        (-0.135000, 0.688881, 0.426769, 0.590190),
        (-0.125000, 0.662794, 0.469599, 0.558070),
        (-0.115000, 0.637537, 0.512474, 0.527300),
        (-0.105000, 0.613125, 0.555333, 0.497870),
        (-0.095000, 0.589570, 0.598112, 0.469770),
        (-0.085000, 0.566880, 0.640745, 0.442980),
        (-0.075000, 0.545061, 0.683162, 0.417490),
        (-0.065000, 0.524125, 0.725267, 0.393290),
        (-0.055000, 0.504121, 0.766883, 0.370400),
        (-0.045000, 0.485219, 0.807533, 0.349020),
        (-0.035000, 0.467990, 0.845786, 0.329740),
        (-0.025000, 0.453912, 0.877936, 0.314190),
        (-0.015000, 0.445312, 0.897992, 0.304800),
        (-0.005000, 0.442658, 0.904249, 0.301940),
        ( 0.005000, 0.442772, 0.904002, 0.302070),
        ( 0.015000, 0.444581, 0.899744, 0.304060),
        ( 0.025000, 0.446652, 0.894841, 0.306330),
        ( 0.035000, 0.447224, 0.893443, 0.306970),
        ( 0.045000, 0.447163, 0.893599, 0.306900),
        ( 0.055000, 0.446890, 0.894281, 0.306590),
        ( 0.065000, 0.446835, 0.894505, 0.306480),
        ( 0.075000, 0.446873, 0.894351, 0.306550),
        ( 0.085000, 0.446797, 0.894104, 0.306670),
        ( 0.095000, 0.446632, 0.893997, 0.306740),
        ( 0.105000, 0.446665, 0.893903, 0.306780),
        ( 0.115000, 0.447449, 0.893828, 0.306790),
        ( 0.125000, 0.448803, 0.893843, 0.306710),
        ( 0.135000, 0.449307, 0.893970, 0.306610),
        ( 0.145000, 0.446953, 0.894360, 0.306550),
        ( 0.155000, 0.424999, 0.896761, 0.306480),
        ( 0.165000, 0.376460, 0.902293, 0.306370),
        ( 0.175000, 0.323083, 0.908606, 0.306320),
        ( 0.185000, 0.283863, 0.913549, 0.306240),
        ( 0.195000, 0.263120, 0.916182, 0.306270),
        ( 0.205000, 0.255465, 0.916996, 0.306250),
        ( 0.215000, 0.253829, 0.917267, 0.306240),
        ( 0.225000, 0.253852, 0.917300, 0.306280),
        ( 0.235000, 0.254354, 0.917099, 0.306320),
        ( 0.245000, 0.254848, 0.917298, 0.306330),
        ( 0.255000, 0.255146, 0.917121, 0.306240),
        ( 0.265000, 0.255278, 0.916872, 0.306210),
        ( 0.275000, 0.255309, 0.917358, 0.306380),
        ( 0.285000, 0.255084, 0.917145, 0.306250),
        ( 0.295000, 0.255001, 0.916996, 0.306300),
        ( 0.305000, 0.255013, 0.917194, 0.306380),
        ( 0.315000, 0.254891, 0.917686, 0.306140),
        ( 0.325000, 0.254764, 0.917755, 0.306050),
        ( 0.335000, 0.254647, 0.917552, 0.306570),
        ( 0.345000, 0.257049, 0.921870, 0.308520),
        ( 0.355000, 0.246171, 0.878439, 0.292370),
        ( 0.365000, 0.133610, 0.075640, 0.110350),
        ( 0.375000, 0.125018, 0.000152, 0.100020),
        ( 0.385000, 0.125000, 0.000000, 0.100000),
        ( 0.395000, 0.125000, 0.000000, 0.100000),
        ( 0.405000, 0.125000, 0.000000, 0.100000),
        ( 0.415000, 0.125000, 0.000000, 0.100000),
        ( 0.425000, 0.125000, 0.000000, 0.100000),
        ( 0.435000, 0.125000, 0.000000, 0.100000),
        ( 0.445000, 0.125000, 0.000000, 0.100000),
        ( 0.455000, 0.125000, 0.000000, 0.100000),
        ( 0.465000, 0.125000, 0.000000, 0.100000),
        ( 0.475000, 0.125000, 0.000000, 0.100000),
        ( 0.485000, 0.125000, 0.000000, 0.100000),
        ( 0.495000, 0.125000, 0.000000, 0.100000),
        ( 0.505000, 0.125000, 0.000000, 0.100000)
        ]

    return solution_porting

def get_specific_solution_for_unit_test_high_precision():
    solution_porting = [
        (-0.505, 1.0, 0.0, 1.0),
        (-0.495, 1.0, 1.1102230246251565e-16, 0.99999999999999978),
        (-0.48499999999999999, 1.0, 1.1102230246251565e-16, 0.99999999999999978),
        (-0.47499999999999998, 1.0, 1.1102230246251565e-16, 0.99999999999999978),
        (-0.46499999999999997, 1.0, 1.1102230246251565e-16, 0.99999999999999978),
        (-0.45499999999999996, 1.0, 1.1102230246251565e-16, 0.99999999999999978),
        (-0.44499999999999995, 1.0, 1.1102230246251565e-16, 0.99999999999999978),
        (-0.43499999999999994, 1.0, 1.1102230246251565e-16, 0.99999999999999978),
        (-0.42499999999999993, 1.0, 1.1102230246251565e-16, 0.99999999999999978),
        (-0.41499999999999992, 1.0, 1.1102230246251565e-16, 0.99999999999999978),
        (-0.40499999999999992, 1.0, 1.1102230246251565e-16, 0.99999999999999978),
        (-0.39499999999999991, 0.99999999999999978, 2.7755575615628918e-16, 0.99999999999999944),
        (-0.3849999999999999, 0.99999999999999467, 6.4670491184415716e-15, 0.99999999999999234),
        (-0.37499999999999989, 0.99999999999988776, 1.3308798507695558e-13, 0.99999999999984257),
        (-0.36499999999999988, 0.99999999999795142, 2.4237278850641443e-12, 0.99999999999713185),
        (-0.35499999999999987, 0.99999999996762634, 3.8304831530130371e-11, 0.99999999995467714),
        (-0.34499999999999986, 0.9999999995562131, 5.2509580040759933e-10, 0.99999999937869855),
        (-0.33499999999999985, 0.99999999472607115, 6.2401971419523565e-09, 0.99999999261649919),
        (-0.32499999999999984, 0.99999994577382079, 6.4161282047119177e-08, 0.99999992408334937),
        (-0.31499999999999984, 0.99999951928196795, 5.6879332200680462e-07, 0.99999932699485283),
        (-0.30499999999999983, 0.99999634481101307, 4.3248824814959905e-06, 0.99999488274087778),
        (-0.29499999999999982, 0.99997633737099978, 2.79981985962474e-05, 0.99996687254024597),
        (-0.28499999999999981, 0.99987088139365798, 0.00015278136209548727, 0.99981924026677849),
        (-0.2749999999999998, 0.99941378043705476, 0.00069375744886315566, 0.99917941692171297),
        (-0.26499999999999979, 0.99781788235911262, 0.0025838519965398011, 0.99694667070431586),
        (-0.25499999999999978, 0.99342121495457225, 0.0078025845316690946, 0.99080377644372952),
        (-0.24499999999999977, 0.98396664008085244, 0.019085577438586857, 0.97763274444798665),
        (-0.23499999999999976, 0.96793363368888941, 0.038418196061865424, 0.95541204434804472),
        (-0.22499999999999976, 0.94570644798043035, 0.065654265643744547, 0.92483779493022644),
        (-0.21499999999999975, 0.91913571997302768, 0.098909427615020667, 0.88863525073537986),
        (-0.20499999999999974, 0.89023221601523495, 0.13599566576005953, 0.84967793214624232),
        (-0.19499999999999973, 0.86041780219813813, 0.17531012301721785, 0.80995068909265133),
        (-0.18499999999999972, 0.8305020195811702, 0.21591521730211277, 0.77055070706890127),
        (-0.17499999999999971, 0.8009056282617506, 0.25731095878337934, 0.7320223185641187),
        (-0.1649999999999997, 0.77184714843620994, 0.29922837596343643, 0.69462654528961598),
        (-0.15499999999999969, 0.74344677036077855, 0.34150984863445688, 0.6584888001930933),
        (-0.14499999999999968, 0.71577615716384058, 0.3840502790961422, 0.62366900266734182),
        (-0.13499999999999968, 0.68888144418494501, 0.42676943038587994, 0.59019377200083745),
        (-0.12499999999999968, 0.6627941455413211, 0.46959860870295073, 0.55807162556304857),
        (-0.11499999999999969, 0.63753660526589484, 0.51247390933368231, 0.52730052843980701),
        (-0.10499999999999969, 0.61312484769809938, 0.55533265985338043, 0.49787180099864842),
        (-0.094999999999999696, 0.58957011850181684, 0.59811153812036699, 0.4697721936664796),
        (-0.084999999999999701, 0.56688001778671482, 0.64074509894323095, 0.44298533199781343),
        (-0.074999999999999706, 0.54506080995274542, 0.68316169419725314, 0.41749444939192293),
        (-0.064999999999999711, 0.52412533713855136, 0.72526708274475149, 0.39329151342581087),
        (-0.054999999999999709, 0.50412059320145031, 0.7668829674339982, 0.3704086642557895),
        (-0.044999999999999707, 0.48521942621212033, 0.8075325790323119, 0.34902157047542365),
        (-0.034999999999999705, 0.46798952801415838, 0.84578618076008127, 0.32974685351833127),
        (-0.024999999999999703, 0.4539124843363786, 0.87793571859933139, 0.3141914269987745),
        (-0.014999999999999703, 0.4453117097494409, 0.8979921479041113, 0.3048070144768753),
        (-0.0049999999999997026, 0.44265849796839962, 0.90424912589460049, 0.30194110396148455),
        (0.0050000000000002976, 0.44277152604102954, 0.90400167161754941, 0.30207396109955731),
        (0.015000000000000298, 0.44458074109625789, 0.89974424674017883, 0.30406154478259872),
        (0.0250000000000003, 0.44665186574379889, 0.89484127842442829, 0.30633620659817651),
        (0.035000000000000302, 0.44722415984760716, 0.89344336715923944, 0.3069767246505235),
        (0.045000000000000304, 0.44716266478033079, 0.89359856206472299, 0.30690395534340742),
        (0.055000000000000306, 0.44689000763788234, 0.89428145391403135, 0.30659011440665951),
        (0.065000000000000308, 0.44683455389593113, 0.89450478975743941, 0.30648208370927321),
        (0.075000000000000303, 0.44687343951557484, 0.89435080463668515, 0.30655575368395022),
        (0.085000000000000298, 0.44679662179222007, 0.89410446777149932, 0.30667701988019136),
        (0.095000000000000293, 0.44663194699514586, 0.89399670954746402, 0.3067426275793218),
        (0.10500000000000029, 0.44666498067017296, 0.8939032368159131, 0.30678067827130739),
        (0.11500000000000028, 0.44744939615633389, 0.8938283386254392, 0.30679034686021484),
        (0.12500000000000028, 0.44880262918560282, 0.89384265926379181, 0.30671165608649037),
        (0.13500000000000029, 0.44930671664614646, 0.8939701751341157, 0.30661316478296419),
        (0.1450000000000003, 0.44695294693653559, 0.89436014525089413, 0.30655123374810866),
        (0.1550000000000003, 0.42499884313690589, 0.8967607749926938, 0.30648056991207406),
        (0.16500000000000031, 0.37646019200020114, 0.90229316109419666, 0.3063749421769546),
        (0.17500000000000032, 0.32308346953859418, 0.9086059712367901, 0.30632068302060489),
        (0.18500000000000033, 0.28386306263008648, 0.91354863178497869, 0.30624468303654856),
        (0.19500000000000034, 0.26312012485796243, 0.91618236506234674, 0.30627926864421728),
        (0.20500000000000035, 0.25546475796037754, 0.91699628286383128, 0.30625564741653527),
        (0.21500000000000036, 0.25382887050832692, 0.91726748768940347, 0.30624466686916185),
        (0.22500000000000037, 0.25385244118957323, 0.91730025383922331, 0.30628818557740017),
        (0.23500000000000038, 0.25435421897952837, 0.91709938305572969, 0.30632175500661168),
        (0.24500000000000038, 0.25484785803655347, 0.91729763126993402, 0.30633152306973305),
        (0.25500000000000039, 0.25514629256535842, 0.91712073191552634, 0.30624259391310038),
        (0.2650000000000004, 0.25527804138560317, 0.91687215887997642, 0.30621371074195036),
        (0.27500000000000041, 0.2553086860042269, 0.9173579272884218, 0.306381349096989),
        (0.28500000000000042, 0.25508421322101449, 0.91714513017949251, 0.30625145391872971),
        (0.29500000000000043, 0.25500112971314676, 0.91699589381745272, 0.30630793033357473),
        (0.30500000000000044, 0.25501325412451314, 0.91719423148529511, 0.30637974594764761),
        (0.31500000000000045, 0.2548911547607271, 0.91768611502897424, 0.30614465035840854),
        (0.32500000000000046, 0.2547644714837658, 0.91775514645688094, 0.30605138955358835),
        (0.33500000000000046, 0.2546465556459554, 0.91755181317584589, 0.30657038190930797),
        (0.34500000000000047, 0.25704850786977601, 0.92186989259160956, 0.3085287750393364),
        (0.35500000000000048, 0.24617054290848731, 0.8784393859773485, 0.29236958085661585),
        (0.36500000000000049, 0.13360953118193081, 0.07564047374232051, 0.11035282175804639),
        (0.3750000000000005, 0.12501790423176928, 0.00015158938150652916, 0.10002005518613435),
        (0.38500000000000051, 0.12500002915548108, 2.4684206810964962e-07, 0.1000000326541411),
        (0.39500000000000052, 0.12500000004718731, 3.9950684412222107e-10, 0.10000000005284979),
        (0.40500000000000053, 0.12500000000007638, 6.4678817857060536e-13, 0.10000000000008555),
        (0.41500000000000054, 0.12500000000000014, 1.0269562977782686e-15, 0.10000000000000016),
        (0.42500000000000054, 0.125, 8.3266726846886741e-17, 0.10000000000000002),
        (0.43500000000000055, 0.125, 8.3266726846886741e-17, 0.10000000000000002),
        (0.44500000000000056, 0.125, 8.3266726846886741e-17, 0.10000000000000002),
        (0.45500000000000057, 0.125, 8.3266726846886741e-17, 0.10000000000000002),
        (0.46500000000000058, 0.125, 8.3266726846886741e-17, 0.10000000000000002),
        (0.47500000000000059, 0.125, 8.3266726846886741e-17, 0.10000000000000002),
        (0.4850000000000006, 0.125, 8.3266726846886741e-17, 0.10000000000000002),
        (0.49500000000000061, 0.125, 8.3266726846886741e-17, 0.10000000000000002),
        (0.50500000000000056, 0.125, 0.0, 0.10000000000000001)]

    return solution_porting
