"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CircleCiOidcRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const CircleCiOidcProvider_1 = require("./CircleCiOidcProvider");
/**
 * This construct creates a CircleCI ODIC provider to allow AWS access from CircleCI jobs. You'll need to instantiate
 * this construct once per AWS account you want to use CircleCI OIDC with.
 *
 * To create a role that can be assumed by CircleCI jobs, use the `CircleCiOidcRole` construct.
 */
class CircleCiOidcRole extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { circleCiProjectIds, circleCiOidcProvider, ...roleProps } = props;
        const { provider, organizationId } = this.extractOpenIdConnectProvider(circleCiOidcProvider);
        const oidcUrl = `oidc.circleci.com/org/${organizationId}`;
        this.role = new aws_iam_1.Role(this, 'CircleCiOidcRole', {
            assumedBy: new aws_iam_1.OpenIdConnectPrincipal(provider, {
                StringEquals: { [`${oidcUrl}:aud`]: organizationId },
                ...this.generateProjectCondition(oidcUrl, organizationId, circleCiProjectIds),
            }),
            ...roleProps,
        });
    }
    extractOpenIdConnectProvider(provider) {
        if (provider instanceof CircleCiOidcProvider_1.CircleCiOidcProvider) {
            return { provider: aws_iam_1.OpenIdConnectProvider.fromOpenIdConnectProviderArn(this, 'ImportOidcProvider', provider.provider.attrArn), organizationId: provider.organizationId };
        }
        else {
            return provider;
        }
    }
    generateProjectCondition(oidcUrl, organizationId, circleCiProjectIds) {
        if (!circleCiProjectIds || circleCiProjectIds.length === 0) {
            return {};
        }
        return {
            StringLike: { [`${oidcUrl}:sub`]: circleCiProjectIds.map((projectId) => `org/${organizationId}/project/${projectId}/*`) },
        };
    }
}
exports.CircleCiOidcRole = CircleCiOidcRole;
_a = JSII_RTTI_SYMBOL_1;
CircleCiOidcRole[_a] = { fqn: "@blimmer/cdk-circleci-oidc.CircleCiOidcRole", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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