"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CircleCiOidcProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
/**
 * This construct creates a CircleCI ODIC provider to allow AWS access from CircleCI jobs. You'll need to instantiate
 * this construct once per AWS account you want to use CircleCI OIDC with.
 *
 * To create a role that can be assumed by CircleCI jobs, use the `CircleCiOidcRole` construct.
 */
class CircleCiOidcProvider extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { organizationId, circleCiOidcThumbprints = ['9e99a48a9960b14926bb7f3b02e22da2b0ab7280'], } = props;
        // The L2 construct uses a Custom Resource, which is slow and has a few known issues
        // (see https://github.com/aws/aws-cdk/issues/21197#issuecomment-1312843734)
        // Therefore, we use the L1 OIDC provider construct directly instead.
        this.provider = new aws_iam_1.CfnOIDCProvider(this, 'CircleCiOidcProvider', {
            url: `https://oidc.circleci.com/org/${organizationId}`,
            clientIdList: [organizationId],
            thumbprintList: circleCiOidcThumbprints,
        });
        this.organizationId = organizationId;
    }
}
exports.CircleCiOidcProvider = CircleCiOidcProvider;
_a = JSII_RTTI_SYMBOL_1;
CircleCiOidcProvider[_a] = { fqn: "@blimmer/cdk-circleci-oidc.CircleCiOidcProvider", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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