'''
Created on 16 sep 2013

@author: Simon Tegelid

Python wrapper of the Vector API vxlapi.dll.
Enables the same API for Python as vxlapi provides for C.
'''
import inspect
import types
import sys
import ctypes
import os.path
import platform
import os

class XLstatus(ctypes.c_short):
    pass


XLportHandle = ctypes.c_long
pXLportHandle = ctypes.POINTER(XLportHandle)
XLaccess = ctypes.c_uint64
XLuserHandle = ctypes.c_ushort
XLmostEventTag = ctypes.c_ushort
XLeventTag = ctypes.c_ubyte
XLfrEventTag = ctypes.c_ushort
XLhandle = ctypes.c_void_p  # win32event HANDLE (winnt.h: typedef void *HANDLE)
XLremoteHandle = ctypes.c_uint
XLdeviceAccess = ctypes.c_uint
XLremoteStatus = ctypes.c_uint
XLethEventTag = ctypes.c_ushort
XLuint64 = ctypes.c_uint64
XLmostEventTag = ctypes.c_ushort

XL_TRANSCEIVER_TYPE_NONE = 0x0000
XL_TRANSCEIVER_TYPE_CAN_251 = 0x0001
XL_TRANSCEIVER_TYPE_CAN_252 = 0x0002
XL_TRANSCEIVER_TYPE_CAN_DNOPTO = 0x0003
XL_TRANSCEIVER_TYPE_CAN_SWC_PROTO = 0x0005
XL_TRANSCEIVER_TYPE_CAN_SWC = 0x0006
XL_TRANSCEIVER_TYPE_CAN_EVA = 0x0007
XL_TRANSCEIVER_TYPE_CAN_FIBER = 0x0008
XL_TRANSCEIVER_TYPE_CAN_1054_OPTO = 0x000B
XL_TRANSCEIVER_TYPE_CAN_SWC_OPTO = 0x000C
XL_TRANSCEIVER_TYPE_CAN_B10011S = 0x000D
XL_TRANSCEIVER_TYPE_CAN_1050 = 0x000E
XL_TRANSCEIVER_TYPE_CAN_1050_OPTO = 0x000F
XL_TRANSCEIVER_TYPE_CAN_1041 = 0x0010
XL_TRANSCEIVER_TYPE_CAN_1041_OPTO = 0x0011
XL_TRANSCEIVER_TYPE_CAN_VIRTUAL = 0x0016
XL_TRANSCEIVER_TYPE_LIN_6258_OPTO = 0x0017
XL_TRANSCEIVER_TYPE_LIN_6259_OPTO = 0x0019
XL_TRANSCEIVER_TYPE_DAIO_8444_OPTO = 0x001D
XL_TRANSCEIVER_TYPE_CAN_1041A_OPTO = 0x0021
XL_TRANSCEIVER_TYPE_LIN_6259_MAG = 0x0023
XL_TRANSCEIVER_TYPE_LIN_7259_MAG = 0x0025
XL_TRANSCEIVER_TYPE_LIN_7269_MAG = 0x0027
XL_TRANSCEIVER_TYPE_CAN_1054_MAG = 0x0033
XL_TRANSCEIVER_TYPE_CAN_251_MAG = 0x0035
XL_TRANSCEIVER_TYPE_CAN_1050_MAG = 0x0037
XL_TRANSCEIVER_TYPE_CAN_1040_MAG = 0x0039
XL_TRANSCEIVER_TYPE_CAN_1041A_MAG = 0x003B
XL_TRANSCEIVER_TYPE_TWIN_CAN_1041A_MAG = 0x0080
XL_TRANSCEIVER_TYPE_TWIN_LIN_7269_MAG = 0x0081
XL_TRANSCEIVER_TYPE_TWIN_CAN_1041AV2_MAG = 0x0082
XL_TRANSCEIVER_TYPE_TWIN_CAN_1054_1041A_MAG = 0x0083
XL_TRANSCEIVER_TYPE_PB_CAN_251 = 0x0101
XL_TRANSCEIVER_TYPE_PB_CAN_1054 = 0x0103
XL_TRANSCEIVER_TYPE_PB_CAN_251_OPTO = 0x0105
XL_TRANSCEIVER_TYPE_PB_CAN_SWC = 0x010B
XL_TRANSCEIVER_TYPE_PB_CAN_1054_OPTO = 0x0115
XL_TRANSCEIVER_TYPE_PB_CAN_SWC_OPTO = 0x0117
XL_TRANSCEIVER_TYPE_PB_CAN_TT_OPTO = 0x0119
XL_TRANSCEIVER_TYPE_PB_CAN_1050 = 0x011B
XL_TRANSCEIVER_TYPE_PB_CAN_1050_OPTO = 0x011D
XL_TRANSCEIVER_TYPE_PB_CAN_1041 = 0x011F
XL_TRANSCEIVER_TYPE_PB_CAN_1041_OPTO = 0x0121
XL_TRANSCEIVER_TYPE_PB_LIN_6258_OPTO = 0x0129
XL_TRANSCEIVER_TYPE_PB_LIN_6259_OPTO = 0x012B
XL_TRANSCEIVER_TYPE_PB_LIN_6259_MAG = 0x012D
XL_TRANSCEIVER_TYPE_PB_CAN_1041A_OPTO = 0x012F
XL_TRANSCEIVER_TYPE_PB_LIN_7259_MAG = 0x0131
XL_TRANSCEIVER_TYPE_PB_LIN_7269_MAG = 0x0133
XL_TRANSCEIVER_TYPE_PB_CAN_251_MAG = 0x0135
XL_TRANSCEIVER_TYPE_PB_CAN_1050_MAG = 0x0136
XL_TRANSCEIVER_TYPE_PB_CAN_1040_MAG = 0x0137
XL_TRANSCEIVER_TYPE_PB_CAN_1041A_MAG = 0x0138
XL_TRANSCEIVER_TYPE_PB_DAIO_8444_OPTO = 0x0139
XL_TRANSCEIVER_TYPE_PB_CAN_1054_MAG = 0x013B
XL_TRANSCEIVER_TYPE_CAN_1051_CAP_FIX = 0x013C
XL_TRANSCEIVER_TYPE_DAIO_1021_FIX = 0x013D
XL_TRANSCEIVER_TYPE_LIN_7269_CAP_FIX = 0x013E
XL_TRANSCEIVER_TYPE_PB_CAN_1051_CAP = 0x013F
XL_TRANSCEIVER_TYPE_PB_CAN_SWC_7356_CAP = 0x0140
XL_TRANSCEIVER_TYPE_PB_CAN_1055_CAP = 0x0141
XL_TRANSCEIVER_TYPE_PB_CAN_1057_CAP = 0x0142
XL_TRANSCEIVER_TYPE_A429_HOLT8596_FIX = 0x0143
XL_TRANSCEIVER_TYPE_A429_HOLT8455_FIX = 0x0144
XL_TRANSCEIVER_TYPE_PB_FR_1080 = 0x0201
XL_TRANSCEIVER_TYPE_PB_FR_1080_MAG = 0x0202
XL_TRANSCEIVER_TYPE_PB_FR_1080A_MAG = 0x0203
XL_TRANSCEIVER_TYPE_PB_FR_1082_CAP = 0x0204
XL_TRANSCEIVER_TYPE_PB_FRC_1082_CAP = 0x0205
XL_TRANSCEIVER_TYPE_FR_1082_CAP_FIX = 0x0206
XL_TRANSCEIVER_TYPE_MOST150_ONBOARD = 0x0220
XL_TRANSCEIVER_TYPE_ETH_BCM54810_FIX = 0x0230
XL_TRANSCEIVER_TYPE_ETH_AR8031_FIX = 0x0231
XL_TRANSCEIVER_TYPE_ETH_BCM89810_FIX = 0x0232
XL_TRANSCEIVER_TYPE_ETH_TJA1100_FIX = 0x0233
XL_TRANSCEIVER_TYPE_ETH_BCM54810_89811_FIX = 0x0234
XL_TRANSCEIVER_TYPE_PB_DAIO_8642 = 0x0280
TRANSCEIVER_TYPE_DAIO_AL_ONLY = 0x028f
TRANSCEIVER_TYPE_DAIO_1021_FIX_WITH_AL = 0x0290
TRANSCEIVER_TYPE_DAIO_AL_WU = 0x0291

XL_TRANSCEIVER_LINEMODE_NA = 0x0000
XL_TRANSCEIVER_LINEMODE_TWO_LINE = 0x0001
XL_TRANSCEIVER_LINEMODE_CAN_H = 0x0002
XL_TRANSCEIVER_LINEMODE_CAN_L = 0x0003
XL_TRANSCEIVER_LINEMODE_SWC_SLEEP = 0x0004
XL_TRANSCEIVER_LINEMODE_SWC_NORMAL = 0x0005
XL_TRANSCEIVER_LINEMODE_SWC_FAST = 0x0006
XL_TRANSCEIVER_LINEMODE_SWC_WAKEUP = 0x0007
XL_TRANSCEIVER_LINEMODE_SLEEP = 0x0008
XL_TRANSCEIVER_LINEMODE_NORMAL = 0x0009
XL_TRANSCEIVER_LINEMODE_STDBY = 0x000a
XL_TRANSCEIVER_LINEMODE_TT_CAN_H = 0x000b
XL_TRANSCEIVER_LINEMODE_TT_CAN_L = 0x000c
XL_TRANSCEIVER_LINEMODE_EVA_00 = 0x000d
XL_TRANSCEIVER_LINEMODE_EVA_01 = 0x000e
XL_TRANSCEIVER_LINEMODE_EVA_10 = 0x000f
XL_TRANSCEIVER_LINEMODE_EVA_11 = 0x0010
XL_TRANSCEIVER_STATUS_PRESENT = 0x0001
XL_TRANSCEIVER_STATUS_POWER_GOOD = 0x0010
XL_TRANSCEIVER_STATUS_EXT_POWER_GOOD = 0x0020
XL_TRANSCEIVER_STATUS_NOT_SUPPORTED = 0x0040

XL_SUCCESS = 0
XL_PENDING = 1

XL_ERR_QUEUE_IS_EMPTY = 10
XL_ERR_QUEUE_IS_FULL = 11
XL_ERR_TX_NOT_POSSIBLE = 12
XL_ERR_NO_LICENSE = 14
XL_ERR_WRONG_PARAMETER = 101
XL_ERR_TWICE_REGISTER = 110
XL_ERR_INVALID_CHAN_INDEX = 111
XL_ERR_INVALID_ACCESS = 112
XL_ERR_PORT_IS_OFFLINE = 113
XL_ERR_CHAN_IS_ONLINE = 116
XL_ERR_NOT_IMPLEMENTED = 117
XL_ERR_INVALID_PORT = 118
XL_ERR_HW_NOT_READY = 120
XL_ERR_CMD_TIMEOUT = 121
XL_ERR_CMD_HANDLING = 122
XL_ERR_HW_NOT_PRESENT = 129
XL_ERR_NOTIFY_ALREADY_ACTIVE = 131
XL_ERR_INVALID_TAG = 132
XL_ERR_INVALID_RESERVED_FLD = 133
XL_ERR_INVALID_SIZE = 134
XL_ERR_INSUFFICIENT_BUFFER = 135
XL_ERR_ERROR_CRC = 136
XL_ERR_BAD_EXE_FORMAT = 137
XL_ERR_NO_SYSTEM_RESOURCES = 138
XL_ERR_NOT_FOUND = 139
XL_ERR_INVALID_ADDRESS = 140
XL_ERR_REQ_NOT_ACCEP = 141
XL_ERR_INVALID_LEVEL = 142
XL_ERR_NO_DATA_DETECTED = 143
XL_ERR_INTERNAL_ERROR = 144
XL_ERR_UNEXP_NET_ERR = 145
XL_ERR_INVALID_USER_BUFFER = 146
XL_ERR_NO_RESOURCES = 152
XL_ERR_WRONG_CHIP_TYPE = 153
XL_ERR_WRONG_COMMAND = 154
XL_ERR_INVALID_HANDLE = 155
XL_ERR_RESERVED_NOT_ZERO = 157
XL_ERR_INIT_ACCESS_MISSING = 158
XL_ERR_CANNOT_OPEN_DRIVER = 201
XL_ERR_WRONG_BUS_TYPE = 202
XL_ERR_DLL_NOT_FOUND = 203
XL_ERR_INVALID_CHANNEL_MASK = 204
XL_ERR_NOT_SUPPORTED = 205
XL_ERR_CONNECTION_BROKEN = 210
XL_ERR_CONNECTION_CLOSED = 211
XL_ERR_INVALID_STREAM_NAME = 212
XL_ERR_CONNECTION_FAILED = 213
XL_ERR_STREAM_NOT_FOUND = 214
XL_ERR_STREAM_NOT_CONNECTED = 215
XL_ERR_QUEUE_OVERRUN = 216
XL_ERROR = 255

XL_ERR_INVALID_DLC = 0x0201
XL_ERR_INVALID_CANID = 0x0202
XL_ERR_INVALID_FDFLAG_MODE20 = 0x0203
XL_ERR_EDL_RTR = 0x0204
XL_ERR_EDL_NOT_SET = 0x0205
XL_ERR_UNKNOWN_FLAG = 0x0206
XL_ERR_ETH_PHY_ACTIVATION_FAILED = 0x1100
XL_ERR_ETH_MAC_RESET_FAILED = 0x1101
XL_ERR_ETH_MAC_NOT_READY = 0x1102

XL_ERR_ETH_PHY_CONFIG_ABORTED = 0x1103
XL_ERR_ETH_RESET_FAILED = 0x1104
XL_ERR_ETH_SET_CONFIG_DELAYED = 0x1105
XL_ERR_ETH_UNSUPPORTED_FEATURE = 0x1106
XL_ERR_ETH_MAC_ACTIVATION_FAILED = 0x1107
XL_ERR_ETH_FILTER_INVALID = 0x1108
XL_ERR_ETH_FILTER_UNAVAILABLE = 0x1109
XL_ERR_ETH_FILTER_NO_INIT_ACCESS = 0x110A
XL_ERR_ETH_FILTER_TOO_COMPLEX = 0x110B


XL_RECEIVE_MSG = 0x0001
XL_CHIP_STATE = 0x0004
XL_TRANSCEIVER_INFO = 0x0006
XL_TRANSCEIVER = XL_TRANSCEIVER_INFO
XL_TIMER_EVENT = 0x0008
XL_TIMER = XL_TIMER_EVENT
XL_TRANSMIT_MSG = 0x000A
XL_SYNC_PULSE = 0x000B
XL_APPLICATION_NOTIFICATION = 0x000F
LIN_MSG = 0x0014
LIN_ERRMSG = 0x0015
LIN_SYNCERR = 0x0016
LIN_NOANS = 0x0017
LIN_WAKEUP = 0x0018
LIN_SLEEP = 0x0019
LIN_CRCINFO = 0x001A
RECEIVE_DAIO_DATA = 0x0020
XL_FR_START_CYCLE = 0x0080
XL_FR_RX_FRAME = 0x0081
XL_FR_TX_FRAME = 0x0082
XL_FR_TXACK_FRAME = 0x0083
XL_FR_INVALID_FRAME = 0x0084
XL_FR_WAKEUP = 0x0085
XL_FR_SYMBOL_WINDOW = 0x0086
XL_FR_ERROR = 0x0087
XL_FR_ERROR_POC_MODE = 0x01
XL_FR_ERROR_SYNC_FRAMES_BELOWMIN = 0x02
XL_FR_ERROR_SYNC_FRAMES_OVERLOAD = 0x03
XL_FR_ERROR_CLOCK_CORR_FAILURE = 0x04
XL_FR_ERROR_NIT_FAILURE = 0x05
XL_FR_ERROR_CC_ERROR = 0x06
XL_FR_STATUS = 0x0088
XL_FR_NM_VECTOR = 0x008A
XL_FR_TRANCEIVER_STATUS = 0x008B
XL_FR_SPY_FRAME = 0x008E
XL_FR_SPY_SYMBOL = 0x008F
XL_MOST_START = 0x0101
XL_MOST_STOP = 0x0102
XL_MOST_EVENTSOURCES = 0x0103
XL_MOST_ALLBYPASS = 0x0107
XL_MOST_TIMINGMODE = 0x0108
XL_MOST_FREQUENCY = 0x0109
XL_MOST_REGISTER_BYTES = 0x010a
XL_MOST_REGISTER_BITS = 0x010b
XL_MOST_SPECIAL_REGISTER = 0x010c
XL_MOST_CTRL_RX_SPY = 0x010d
XL_MOST_CTRL_RX_OS8104 = 0x010e
XL_MOST_CTRL_TX = 0x010f
XL_MOST_ASYNC_MSG = 0x0110
XL_MOST_ASYNC_TX = 0x0111
XL_MOST_SYNC_ALLOCTABLE = 0x0112
XL_MOST_SYNC_VOLUME_STATUS = 0x0116
XL_MOST_RXLIGHT = 0x0117
XL_MOST_TXLIGHT = 0x0118
XL_MOST_LOCKSTATUS = 0x0119
XL_MOST_ERROR = 0x011a
XL_MOST_CTRL_RXBUFFER = 0x011c
XL_MOST_SYNC_TX_UNDERFLOW = 0x011d
XL_MOST_SYNC_RX_OVERFLOW = 0x011e
XL_MOST_CTRL_SYNC_AUDIO = 0x011f
XL_MOST_SYNC_MUTE_STATUS = 0x0120
XL_MOST_GENLIGHTERROR = 0x0121
XL_MOST_GENLOCKERROR = 0x0122
XL_MOST_TXLIGHT_POWER = 0x0123
XL_MOST_CTRL_BUSLOAD = 0x0126
XL_MOST_ASYNC_BUSLOAD = 0x0127
XL_MOST_CTRL_SYNC_AUDIO_EX = 0x012a
XL_MOST_TIMINGMODE_SPDIF = 0x012b
XL_MOST_STREAM_STATE = 0x012c
XL_MOST_STREAM_BUFFER = 0x012d
XL_START = 0x0200
XL_STOP = 0x0201
XL_MOST150_EVENT_SOURCE = 0x0203
XL_MOST150_DEVICE_MODE = 0x0204
XL_MOST150_SYNC_ALLOC_INFO = 0x0205
XL_MOST150_FREQUENCY = 0x0206
XL_MOST150_SPECIAL_NODE_INFO = 0x0207
XL_MOST150_CTRL_RX = 0x0208
XL_MOST150_CTRL_TX_ACK = 0x0209
XL_MOST150_ASYNC_SPY = 0x020A
XL_MOST150_ASYNC_RX = 0x020B
XL_MOST150_SYNC_VOLUME_STATUS = 0x020D
XL_MOST150_TX_LIGHT = 0x020E
XL_MOST150_RXLIGHT_LOCKSTATUS = 0x020F
XL_MOST150_ERROR = 0x0210
XL_MOST150_CONFIGURE_RX_BUFFER = 0x0211
XL_MOST150_CTRL_SYNC_AUDIO = 0x0212
XL_MOST150_SYNC_MUTE_STATUS = 0x0213
XL_MOST150_LIGHT_POWER = 0x0214
XL_MOST150_GEN_LIGHT_ERROR = 0x0215
XL_MOST150_GEN_LOCK_ERROR = 0x0216
XL_MOST150_CTRL_BUSLOAD = 0x0217
XL_MOST150_ASYNC_BUSLOAD = 0x0218
XL_MOST150_ETHERNET_RX = 0x0219
XL_MOST150_SYSTEMLOCK_FLAG = 0x021A
XL_MOST150_SHUTDOWN_FLAG = 0x021B
XL_MOST150_CTRL_SPY = 0x021C
XL_MOST150_ASYNC_TX_ACK = 0x021D
XL_MOST150_ETHERNET_SPY = 0x021E
XL_MOST150_ETHERNET_TX_ACK = 0x021F
XL_MOST150_SPDIFMODE = 0x0220
XL_MOST150_ECL_LINE_CHANGED = 0x0222
XL_MOST150_ECL_TERMINATION_CHANGED = 0x0223
XL_MOST150_NW_STARTUP = 0x0224
XL_MOST150_NW_SHUTDOWN = 0x0225
XL_MOST150_STREAM_STATE = 0x0226
XL_MOST150_STREAM_TX_BUFFER = 0x0227
XL_MOST150_STREAM_RX_BUFFER = 0x0228
XL_MOST150_STREAM_TX_LABEL = 0x0229
XL_MOST150_STREAM_TX_UNDERFLOW = 0x022B
XL_MOST150_GEN_BYPASS_STRESS = 0x022C
XL_MOST150_ECL_SEQUENCE = 0x022D
XL_MOST150_ECL_GLITCH_FILTER = 0x022E
XL_MOST150_SSO_RESULT = 0x022F
XL_CAN_EV_TAG_RX_OK = 0x0400
XL_CAN_EV_TAG_RX_ERROR = 0x0401
XL_CAN_EV_TAG_TX_ERROR = 0x0402
XL_CAN_EV_TAG_TX_REQUEST = 0x0403
XL_CAN_EV_TAG_TX_OK = 0x0404
XL_CAN_EV_TAG_CHIP_STATE = 0x0409
XL_CAN_EV_TAG_TX_MSG = 0x0440
XL_ETH_EVENT_TAG_FRAMERX = 0x0500
XL_ETH_EVENT_TAG_FRAMERX_ERROR = 0x0501
XL_ETH_EVENT_TAG_FRAMETX_ERROR = 0x0506
XL_ETH_EVENT_TAG_FRAMETX_ERROR_SWITCH = 0x0507
XL_ETH_EVENT_TAG_FRAMETX_ACK = 0x0510
XL_ETH_EVENT_TAG_FRAMETX_ACK_SWITCH = 0x0511
XL_ETH_EVENT_TAG_FRAMETX_ACK_OTHER_APP = 0x0513
XL_ETH_EVENT_TAG_FRAMETX_ERROR_OTHER_APP = 0x0514
XL_ETH_EVENT_TAG_CHANNEL_STATUS = 0x0520
XL_ETH_EVENT_TAG_CONFIGRESULT = 0x0530
XL_ETH_EVENT_TAG_LOSTEVENT = 0x05fe
XL_ETH_EVENT_TAG_ERROR = 0x05ff
XL_A429_EV_TAG_TX_OK = 0x0600
XL_A429_EV_TAG_TX_ERR = 0x0601
XL_A429_EV_TAG_RX_OK = 0x0608
XL_A429_EV_TAG_RX_ERR = 0x0609
XL_A429_EV_TAG_BUS_STATISTIC = 0x060F

XL_NOTIFY_REASON_CHANNEL_ACTIVATION = 1
XL_NOTIFY_REASON_CHANNEL_DEACTIVATION = 2
XL_NOTIFY_REASON_PORT_CLOSED = 3
XL_SYNC_PULSE_EXTERNAL = 0x00
XL_SYNC_PULSE_OUR = 0x01
XL_SYNC_PULSE_OUR_SHARED = 0x02

XL_BUS_TYPE_NONE = 0x00000000
XL_BUS_TYPE_CAN = 0x00000001
XL_BUS_TYPE_LIN = 0x00000002
XL_BUS_TYPE_FLEXRAY = 0x00000004
XL_BUS_TYPE_AFDX = 0x00000008
XL_BUS_TYPE_MOST = 0x00000010
XL_BUS_TYPE_DAIO = 0x00000040
XL_BUS_TYPE_J1708 = 0x00000100
XL_BUS_TYPE_ETHERNET = 0x00001000
XL_BUS_TYPE_A429 = 0x00002000

XL_HWTYPE_NONE = 0
XL_HWTYPE_VIRTUAL = 1
XL_HWTYPE_CANCARDX = 2
XL_HWTYPE_CANAC2PCI = 6
XL_HWTYPE_CANCARDY = 12
XL_HWTYPE_CANCARDXL = 15
XL_HWTYPE_CANCASEXL = 21
XL_HWTYPE_CANCASEXL_LOG_OBSOLETE = 23
XL_HWTYPE_CANBOARDXL = 25
XL_HWTYPE_CANBOARDXL_PXI = 27
XL_HWTYPE_VN2600 = 29
XL_HWTYPE_VN2610 = XL_HWTYPE_VN2600
XL_HWTYPE_VN3300 = 37
XL_HWTYPE_VN3600 = 39
XL_HWTYPE_VN7600 = 41
XL_HWTYPE_CANCARDXLE = 43
XL_HWTYPE_VN8900 = 45
XL_HWTYPE_VN8950 = 47
XL_HWTYPE_VN2640 = 53
XL_HWTYPE_VN1610 = 55
XL_HWTYPE_VN1630 = 57
XL_HWTYPE_VN1640 = 59
XL_HWTYPE_VN8970 = 61
XL_HWTYPE_VN1611 = 63
XL_HWTYPE_VN5610 = 65
XL_HWTYPE_VN7570 = 67
XL_HWTYPE_IPCLIENT = 69
XL_HWTYPE_IPSERVER = 71
XL_HWTYPE_VX1121 = 73
XL_HWTYPE_VX1131 = 75
XL_HWTYPE_VT6204 = 77
XL_HWTYPE_VN1630_LOG = 79
XL_HWTYPE_VN7610 = 81
XL_HWTYPE_VN7572 = 83
XL_HWTYPE_VN8972 = 85
XL_HWTYPE_VN0601 = 87
XL_HWTYPE_VX0312 = 91
XL_HWTYPE_VN8800 = 95
XL_HWTYPE_IPCL8800 = 96
XL_HWTYPE_IPSRV8800 = 97
XL_HWTYPE_CSMCAN = 98
XL_HWTYPE_VN5610A = 101
XL_HWTYPE_VN7640 = 102
XL_MAX_HWTYPE = 102

XL_LIN_MASTER = 1
XL_LIN_SLAVE = 2
XL_LIN_VERSION_1_3 = 0x01
XL_LIN_VERSION_2_0 = 0x02
XL_LIN_VERSION_2_1 = 0x03
XL_LIN_CALC_CHECKSUM = 0x100
XL_LIN_CALC_CHECKSUM_ENHANCED = 0x200
XL_LIN_SET_SILENT = 0x01
XL_LIN_SET_WAKEUPID = 0x03
XL_LIN_CHECKSUM_CLASSIC = 0x00
XL_LIN_CHECKSUM_ENHANCED = 0x01
XL_LIN_CHECKSUM_UNDEFINED = 0xff
XL_LIN_STAYALIVE = 0x00
XL_LIN_SET_SLEEPMODE = 0x01
XL_LIN_COMESFROM_SLEEPMODE = 0x02
XL_LIN_WAKUP_INTERNAL = 0x01
XL_LIN_UNDEFINED_DLC = 0xff
XL_LIN_SLAVE_ON = 0xff
XL_LIN_SLAVE_OFF = 0x00
MAX_MSG_LEN = 8
XL_INTERFACE_VERSION_V2 = 2
XL_INTERFACE_VERSION_V3 = 3
XL_INTERFACE_VERSION_V4 = 4
XL_INTERFACE_VERSION = XL_INTERFACE_VERSION_V3
XL_CAN_EXT_MSG_ID = 0x80000000
XL_CAN_MSG_FLAG_ERROR_FRAME = 0x01
XL_CAN_MSG_FLAG_OVERRUN = 0x02
XL_CAN_MSG_FLAG_NERR = 0x04
XL_CAN_MSG_FLAG_WAKEUP = 0x08
XL_CAN_MSG_FLAG_REMOTE_FRAME = 0x10
XL_CAN_MSG_FLAG_RESERVED_1 = 0x20
XL_CAN_MSG_FLAG_TX_COMPLETED = 0x40
XL_CAN_MSG_FLAG_TX_REQUEST = 0x80
XL_CAN_MSG_FLAG_SRR_BIT_DOM = 0x0200
XL_CAN_TXMSG_FLAG_EDL = 0x0001
XL_CAN_TXMSG_FLAG_BRS = 0x0002
XL_CAN_TXMSG_FLAG_RTR = 0x0010
XL_CAN_TXMSG_FLAG_HIGHPRIO = 0x0080
XL_CAN_TXMSG_FLAG_WAKEUP = 0x0200
XL_CAN_RXMSG_FLAG_EDL = 0x0001
XL_CAN_RXMSG_FLAG_BRS = 0x0002
XL_CAN_RXMSG_FLAG_ESI = 0x0004
XL_CAN_RXMSG_FLAG_RTR = 0x0010
XL_CAN_RXMSG_FLAG_EF = 0x0200
XL_CAN_RXMSG_FLAG_ARB_LOST = 0x0400
XL_CAN_RXMSG_FLAG_WAKEUP = 0x2000
XL_CAN_RXMSG_FLAG_TE = 0x4000
XL_EVENT_FLAG_OVERRUN = 0x01
XL_LIN_MSGFLAG_TX = XL_CAN_MSG_FLAG_TX_COMPLETED
XL_LIN_MSGFLAG_CRCERROR = 0x81
XL_DAIO_DATA_GET = 0x8000
XL_DAIO_DATA_VALUE_DIGITAL = 0x0001
XL_DAIO_DATA_VALUE_ANALOG = 0x0002
XL_DAIO_DATA_PWM = 0x0010
XL_DAIO_MODE_PULSE = 0x0020
XL_CHIPSTAT_BUSOFF = 0x01
XL_CHIPSTAT_ERROR_PASSIVE = 0x02
XL_CHIPSTAT_ERROR_WARNING = 0x04
XL_CHIPSTAT_ERROR_ACTIVE = 0x08
XL_TRANSCEIVER_EVENT_NONE = 0
XL_TRANSCEIVER_EVENT_INSERTED = 1
XL_TRANSCEIVER_EVENT_REMOVED = 2
XL_TRANSCEIVER_EVENT_STATE_CHANGE = 3
XL_OUTPUT_MODE_SILENT = 0
XL_OUTPUT_MODE_NORMAL = 1
XL_OUTPUT_MODE_TX_OFF = 2
XL_OUTPUT_MODE_SJA_1000_SILENT = 3
XL_TRANSCEIVER_EVENT_ERROR = 1
XL_TRANSCEIVER_EVENT_CHANGED = 2
DriverNotifyMessageName = "VectorCanDriverChangeNotifyMessage"
XL_MAX_APPNAME = 32

XL_MAX_LENGTH = 31
XL_CONFIG_MAX_CHANNELS = 64

XL_ACTIVATE_NONE = 0
XL_ACTIVATE_RESET_CLOCK = 8

XL_BUS_COMPATIBLE_CAN = XL_BUS_TYPE_CAN
XL_BUS_COMPATIBLE_LIN = XL_BUS_TYPE_LIN
XL_BUS_COMPATIBLE_FLEXRAY = XL_BUS_TYPE_FLEXRAY
XL_BUS_COMPATIBLE_MOST = XL_BUS_TYPE_MOST
XL_BUS_COMPATIBLE_DAIO = XL_BUS_TYPE_DAIO
XL_BUS_COMPATIBLE_J1708 = XL_BUS_TYPE_J1708
XL_BUS_COMPATIBLE_ETHERNET = XL_BUS_TYPE_ETHERNET
XL_BUS_COMPATIBLE_A429 = XL_BUS_TYPE_A429

XL_BUS_ACTIVE_CAP_CAN = (XL_BUS_COMPATIBLE_CAN << 16)
XL_BUS_ACTIVE_CAP_LIN = (XL_BUS_COMPATIBLE_LIN << 16)
XL_BUS_ACTIVE_CAP_FLEXRAY = (XL_BUS_COMPATIBLE_FLEXRAY << 16)
XL_BUS_ACTIVE_CAP_MOST = (XL_BUS_COMPATIBLE_MOST << 16)
XL_BUS_ACTIVE_CAP_DAIO = (XL_BUS_COMPATIBLE_DAIO << 16)
XL_BUS_ACTIVE_CAP_J1708 = (XL_BUS_COMPATIBLE_J1708 << 16)
XL_BUS_ACTIVE_CAP_ETHERNET = (XL_BUS_COMPATIBLE_ETHERNET << 16)
XL_BUS_ACTIVE_CAP_A429 = (XL_BUS_COMPATIBLE_A429 << 16)

XL_BUS_NAME_NONE = ""
XL_BUS_NAME_CAN = "CAN"
XL_BUS_NAME_LIN = "LIN"
XL_BUS_NAME_FLEXRAY = "FlexRay"
XL_BUS_NAME_STREAM = "Stream"
XL_BUS_NAME_MOST = "MOST"
XL_BUS_NAME_DAIO = "DAIO"
XL_BUS_NAME_HWSYNC_KEYPAD = "HWSYNC_KEYPAD"
XL_BUS_NAME_J1708 = "J1708"
XL_BUS_NAME_KLINE = "K-Line"
XL_BUS_NAME_ETHERNET = "Ethernet"
XL_BUS_NAME_AFDX = "AFDX"
XL_BUS_NAME_A429 = "ARINC429"

XL_CAN_STD = 1
XL_CAN_EXT = 2
XL_BUS_PARAMS_MOST_SPEED_GRADE_25 = 0x01
XL_BUS_PARAMS_MOST_SPEED_GRADE_150 = 0x02
XL_BUS_PARAMS_CANOPMODE_CAN20 = 0x01
XL_BUS_PARAMS_CANOPMODE_CANFD = 0x02
XL_INVALID_PORTHANDLE = -1
XL_CONNECTION_INFO_USB_FULLSPEED = 1
XL_CONNECTION_INFO_USB_UNKNOWN = 0
XL_CONNECTION_INFO_USB_HIGHSPEED = 2
XL_CONNECTION_INFO_USB_SUPERSPEED = 3
XL_FPGA_CORE_TYPE_NONE = 0
XL_FPGA_CORE_TYPE_CAN = 1
XL_FPGA_CORE_TYPE_LIN = 2
XL_FPGA_CORE_TYPE_LIN_RX = 3
XL_SPECIAL_DEVICE_STAT_FPGA_UPDATE_DONE = 0x01
XL_DAIO_DIGITAL_ENABLED = 0x00000001
XL_DAIO_DIGITAL_INPUT = 0x00000002
XL_DAIO_DIGITAL_TRIGGER = 0x00000004
XL_DAIO_ANALOG_ENABLED = 0x00000001
XL_DAIO_ANALOG_INPUT = 0x00000002
XL_DAIO_ANALOG_TRIGGER = 0x00000004
XL_DAIO_ANALOG_RANGE_32V = 0x00000008
XL_DAIO_TRIGGER_MODE_NONE = 0x00000000
XL_DAIO_TRIGGER_MODE_DIGITAL = 0x00000001
XL_DAIO_TRIGGER_MODE_ANALOG_ASCENDING = 0x00000002
XL_DAIO_TRIGGER_MODE_ANALOG_DESCENDING = 0x00000004
XL_DAIO_TRIGGER_MODE_ANALOG = XL_DAIO_TRIGGER_MODE_ANALOG_ASCENDING | XL_DAIO_TRIGGER_MODE_ANALOG_DESCENDING
XL_DAIO_TRIGGER_LEVEL_NONE = 0
XL_DAIO_POLLING_NONE = 0
XL_SET_TIMESYNC_NO_CHANGE = 0
XL_SET_TIMESYNC_ON = 1
XL_SET_TIMESYNC_OFF = 2
MOST_ALLOC_TABLE_SIZE = 64

XL_IPv4 = 4
XL_IPv6 = 6
XL_MAX_REMOTE_DEVICE_INFO = 16
XL_ALL_REMOTE_DEVICES = 0xFFFFFFFF
XL_MAX_REMOTE_ALIAS_SIZE = 64

XL_REMOTE_OFFLINE = 1
XL_REMOTE_ONLINE = 2
XL_REMOTE_BUSY = 3
XL_REMOTE_CONNECION_REFUSED = 4

XL_REMOTE_ADD_PERMANENT = 0x0
XL_REMOTE_ADD_TEMPORARY = 0x1

XL_REMOTE_REGISTER_NONE = 0x0
XL_REMOTE_REGISTER_CONNECT = 0x1
XL_REMOTE_REGISTER_TEMP_CONNECT = 0x2

XL_REMOTE_DISCONNECT_NONE = 0x0
XL_REMOTE_DISCONNECT_REMOVE_ENTRY = 0x1

XL_REMOTE_DEVICE_AVAILABLE = 0x00000001
XL_REMOTE_DEVICE_CONFIGURED = 0x00000002
XL_REMOTE_DEVICE_CONNECTED = 0x00000004
XL_REMOTE_DEVICE_ENABLED = 0x00000008
XL_REMOTE_DEVICE_BUSY = 0x00000010
XL_REMOTE_DEVICE_TEMP_CONFIGURED = 0x00000020

XL_REMOTE_NO_NET_SEARCH = 0
XL_REMOTE_NET_SEARCH = 1

XL_REMOTE_DEVICE_TYPE_UNKNOWN = 0
XL_REMOTE_DEVICE_TYPE_VN8900 = 1
XL_REMOTE_DEVICE_TYPE_STANDARD_PC = 2
XL_REMOTE_DEVICE_TYPE_VX = 3
XL_REMOTE_DEVICE_TYPE_VN8800 = 4

XL_CHANNEL_FLAG_TIME_SYNC_RUNNING = 0x00000001
XL_CHANNEL_FLAG_NO_HWSYNC_SUPPORT = 0x00000400
XL_CHANNEL_FLAG_SPDIF_CAPABLE = 0x00004000
XL_CHANNEL_FLAG_CANFD_BOSCH_SUPPORT = 0x20000000
XL_CHANNEL_FLAG_CANFD_ISO_SUPPORT = 0x80000000

RX_FIFO_MOST_QUEUE_SIZE_MAX = 1048576
RX_FIFO_MOST_QUEUE_SIZE_MIN = 8192

XL_MOST_SOURCE_ASYNC_SPY = 0x8000
XL_MOST_SOURCE_ASYNC_RX = 0x1000
XL_MOST_SOURCE_ASYNC_TX = 0x0800
XL_MOST_SOURCE_CTRL_OS8104A = 0x0400
XL_MOST_SOURCE_CTRL_SPY = 0x0100
XL_MOST_SOURCE_ALLOC_TABLE = 0x0080
XL_MOST_SOURCE_SYNC_RC_OVER = 0x0040
XL_MOST_SOURCE_SYNC_TX_UNDER = 0x0020
XL_MOST_SOURCE_SYNCLINE = 0x0010
XL_MOST_SOURCE_ASYNC_RX_FIFO_OVER = 0x0008
XL_MOST_OS8104_TX_LOCK_ERROR = 0x00000001
XL_MOST_OS8104_SPDIF_LOCK_ERROR = 0x00000002
XL_MOST_OS8104_ASYNC_BUFFER_FULL = 0x00000003
XL_MOST_OS8104_ASYNC_CRC_ERROR = 0x00000004
XL_MOST_ASYNC_TX_UNDERRUN = 0x00000005
XL_MOST_CTRL_TX_UNDERRUN = 0x00000006
XL_MOST_MCU_TS_CMD_QUEUE_UNDERRUN = 0x00000007
XL_MOST_MCU_TS_CMD_QUEUE_OVERRUN = 0x00000008
XL_MOST_CMD_TX_UNDERRUN = 0x00000009
XL_MOST_SYNCPULSE_ERROR = 0x0000000A
XL_MOST_OS8104_CODING_ERROR = 0x0000000B
XL_MOST_ERROR_UNKNOWN_COMMAND = 0x0000000C
XL_MOST_ASYNC_RX_OVERFLOW_ERROR = 0x0000000D
XL_MOST_FPGA_TS_FIFO_OVERFLOW = 0x0000000E
XL_MOST_SPY_OVERFLOW_ERROR = 0x0000000F
XL_MOST_CTRL_TYPE_QUEUE_OVERFLOW = 0x00000010
XL_MOST_ASYNC_TYPE_QUEUE_OVERFLOW = 0x00000011
XL_MOST_CTRL_UNKNOWN_TYPE = 0x00000012
XL_MOST_CTRL_QUEUE_UNDERRUN = 0x00000013
XL_MOST_ASYNC_UNKNOWN_TYPE = 0x00000014
XL_MOST_ASYNC_QUEUE_UNDERRUN = 0x00000015
XL_MOST_DEMANDED_START = 0x00000001
XL_MOST_RX_DATA_SIZE = 1028
XL_MOST_TS_DATA_SIZE = 12
XL_MOST_RX_ELEMENT_HEADER_SIZE = 32
XL_MOST_CTRL_RX_SPY_SIZE = 36
XL_MOST_CTRL_RX_OS8104_SIZE = 28
XL_MOST_SPECIAL_REGISTER_CHANGE_SIZE = 20
XL_MOST_ERROR_EV_SIZE_4 = 4
XL_MOST_ERROR_EV_SIZE = 16
XL_MOST_DEVICE_CASE_LINE_IN = 0
XL_MOST_DEVICE_CASE_LINE_OUT = 1
XL_MOST_DEVICE_SPDIF_IN = 7
XL_MOST_DEVICE_SPDIF_OUT = 8
XL_MOST_DEVICE_SPDIF_IN_OUT_SYNC = 11
XL_MOST_SPDIF_LOCK_OFF = 0
XL_MOST_SPDIF_LOCK_ON = 1
XL_MOST_NO_MUTE = 0
XL_MOST_MUTE = 1
XL_MOST_VN2600 = 0x01
XL_MOST_OS8104A = 0x02
XL_MOST_OS8104B = 0x04
XL_MOST_SPY = 0x08
XL_MOST_MODE_DEACTIVATE = 0
XL_MOST_MODE_ACTIVATE = 1
XL_MOST_MODE_FORCE_DEACTIVATE = 2
XL_MOST_RX_BUFFER_CLEAR_ONCE = 2
XL_MOST_TIMING_SLAVE = 0
XL_MOST_TIMING_MASTER = 1
XL_MOST_TIMING_SLAVE_SPDIF_MASTER = 2
XL_MOST_TIMING_SLAVE_SPDIF_SLAVE = 3
XL_MOST_TIMING_MASTER_SPDIF_MASTER = 4
XL_MOST_TIMING_MASTER_SPDIF_SLAVE = 5
XL_MOST_TIMING_MASTER_FROM_SPDIF_SLAVE = 6
XL_MOST_FREQUENCY_44100 = 0
XL_MOST_FREQUENCY_48000 = 1
XL_MOST_FREQUENCY_ERROR = 2
XL_MOST_LIGHT_OFF = 0
XL_MOST_LIGHT_FORCE_ON = 1
XL_MOST_LIGHT_MODULATED = 2
XL_MOST_LIGHT_FULL = 100
XL_MOST_LIGHT_3DB = 50
XL_MOST_UNLOCK = 5
XL_MOST_LOCK = 6
XL_MOST_STATE_UNKNOWN = 9
XL_MOST_TX_WHILE_UNLOCKED = 0x80000000
XL_MOST_TX_TIMEOUT = 0x40000000
XL_MOST_DIRECTION_RX = 0
XL_MOST_DIRECTION_TX = 1
XL_MOST_NO_QUEUE_OVERFLOW = 0x0000
XL_MOST_QUEUE_OVERFLOW = 0x8000
XL_MOST_COMMAND_FAILED = 0x4000
XL_MOST_INTERNAL_OVERFLOW = 0x2000
XL_MOST_MEASUREMENT_NOT_ACTIVE = 0x1000
XL_MOST_QUEUE_OVERFLOW_ASYNC = 0x0800
XL_MOST_QUEUE_OVERFLOW_CTRL = 0x0400
XL_MOST_NOT_SUPPORTED = 0x0200
XL_MOST_QUEUE_OVERFLOW_DRV = 0x0100
XL_MOST_NA_CHANGED = 0x0001
XL_MOST_GA_CHANGED = 0x0002
XL_MOST_APA_CHANGED = 0x0004
XL_MOST_NPR_CHANGED = 0x0008
XL_MOST_MPR_CHANGED = 0x0010
XL_MOST_NDR_CHANGED = 0x0020
XL_MOST_MDR_CHANGED = 0x0040
XL_MOST_SBC_CHANGED = 0x0080
XL_MOST_XTIM_CHANGED = 0x0100
XL_MOST_XRTY_CHANGED = 0x0200
XL_MOST_bGA = 0x89
XL_MOST_bNAH = 0x8A
XL_MOST_bNAL = 0x8B
XL_MOST_bSDC2 = 0x8C
XL_MOST_bSDC3 = 0x8D
XL_MOST_bCM2 = 0x8E
XL_MOST_bNDR = 0x8F
XL_MOST_bMPR = 0x90
XL_MOST_bMDR = 0x91
XL_MOST_bCM4 = 0x93
XL_MOST_bSBC = 0x96
XL_MOST_bXSR2 = 0x97
XL_MOST_bRTYP = 0xA0
XL_MOST_bRSAH = 0xA1
XL_MOST_bRSAL = 0xA2
XL_MOST_bRCD0 = 0xA3
XL_MOST_bXTIM = 0xBE
XL_MOST_bXRTY = 0xBF
XL_MOST_bXPRI = 0xC0
XL_MOST_bXTYP = 0xC1
XL_MOST_bXTAH = 0xC2
XL_MOST_bXTAL = 0xC3
XL_MOST_bXCD0 = 0xC4
XL_MOST_bXTS = 0xD5
XL_MOST_bPCTC = 0xE2
XL_MOST_bPCTS = 0xE3
XL_MOST_SPY_RX_STATUS_NO_LIGHT = 0x01
XL_MOST_SPY_RX_STATUS_NO_LOCK = 0x02
XL_MOST_SPY_RX_STATUS_BIPHASE_ERROR = 0x04
XL_MOST_SPY_RX_STATUS_MESSAGE_LENGTH_ERROR = 0x08
XL_MOST_SPY_RX_STATUS_PARITY_ERROR = 0x10
XL_MOST_SPY_RX_STATUS_FRAME_LENGTH_ERROR = 0x20
XL_MOST_SPY_RX_STATUS_PREAMBLE_TYPE_ERROR = 0x40
XL_MOST_SPY_RX_STATUS_CRC_ERROR = 0x80
XL_MOST_ASYNC_NO_ERROR = 0x00
XL_MOST_ASYNC_SBC_ERROR = 0x0C
XL_MOST_ASYNC_NEXT_STARTS_TO_EARLY = 0x0D
XL_MOST_ASYNC_TO_LONG = 0x0E
XL_MOST_ASYNC_UNLOCK = 0x0F
SYNC_PULSE_EXTERNAL = 0x00
SYNC_PULSE_OUR = 0x01
XL_MOST_CTRL_TYPE_NORMAL = 0x00
XL_MOST_CTRL_TYPE_REMOTE_READ = 0x01
XL_MOST_CTRL_TYPE_REMOTE_WRITE = 0x02
XL_MOST_CTRL_TYPE_RESOURCE_ALLOCATE = 0x03
XL_MOST_CTRL_TYPE_RESOURCE_DEALLOCATE = 0x04
XL_MOST_CTRL_TYPE_GET_SOURCE = 0x05
XL_MOST_BUSLOAD_COUNTER_TYPE_NONE = 0x00
XL_MOST_BUSLOAD_COUNTER_TYPE_1_BYTE = 0x01
XL_MOST_BUSLOAD_COUNTER_TYPE_2_BYTE = 0x02
XL_MOST_BUSLOAD_COUNTER_TYPE_3_BYTE = 0x03
XL_MOST_BUSLOAD_COUNTER_TYPE_4_BYTE = 0x04
XL_MOST_STATESEL_LIGHTLOCK = 0x0001
XL_MOST_STATESEL_REGISTERBUNCH1 = 0x0002
XL_MOST_STATESEL_BYPASSTIMING = 0x0004
XL_MOST_STATESEL_REGISTERBUNCH2 = 0x0008
XL_MOST_STATESEL_REGISTERBUNCH3 = 0x0010
XL_MOST_STATESEL_VOLUMEMUTE = 0x0020
XL_MOST_STATESEL_EVENTSOURCE = 0x0040
XL_MOST_STATESEL_RXBUFFERMODE = 0x0080
XL_MOST_STATESEL_ALLOCTABLE = 0x0100
XL_MOST_STATESEL_SUPERVISOR_LOCKSTATUS = 0x0200
XL_MOST_STATESEL_SUPERVISOR_MESSAGE = 0x0400
XL_MOST_STREAM_RX_DATA = 0
XL_MOST_STREAM_TX_DATA = 1
XL_MOST_STREAM_ADD_FRAME_HEADER = 1
XL_MOST_STREAM_STATE_CLOSED = 0x01
XL_MOST_STREAM_STATE_OPENED = 0x02
XL_MOST_STREAM_STATE_STARTED = 0x03
XL_MOST_STREAM_STATE_STOPPED = 0x04
XL_MOST_STREAM_STATE_START_PENDING = 0x05
XL_MOST_STREAM_STATE_STOP_PENDING = 0x06
XL_MOST_STREAM_STATE_UNKNOWN = 0xFF
XL_MOST_STREAM_ACTIVATE = 0
XL_MOST_STREAM_DEACTIVATE = 1
XL_MOST_STREAM_INVALID_HANDLE = 0
XL_MOST_STREAM_LATENCY_VERY_LOW = 0
XL_MOST_STREAM_LATENCY_LOW = 1
XL_MOST_STREAM_LATENCY_MEDIUM = 2
XL_MOST_STREAM_LATENCY_HIGH = 3
XL_MOST_STREAM_LATENCY_VERY_HIGH = 4
XL_MOST_STREAM_ERR_NO_ERROR = 0x00
XL_MOST_STREAM_ERR_INVALID_HANDLE = 0x01
XL_MOST_STREAM_ERR_NO_MORE_BUFFERS_AVAILABLE = 0x02
XL_MOST_STREAM_ERR_ANY_BUFFER_LOCKED = 0x03
XL_MOST_STREAM_ERR_WRITE_RE_FAILED = 0x04
XL_MOST_STREAM_ERR_STREAM_ALREADY_STARTED = 0x05
XL_MOST_STREAM_ERR_TX_BUFFER_UNDERRUN = 0x06
XL_MOST_STREAM_ERR_RX_BUFFER_OVERFLOW = 0x07
XL_MOST_STREAM_ERR_INSUFFICIENT_RESOURCES = 0x08
XL_MOST_EVENT_HEADER_SIZE = 32
XL_MOST_EVENT_MAX_DATA_SIZE = 1024
XL_MOST_EVENT_MAX_SIZE = (XL_MOST_EVENT_HEADER_SIZE + XL_MOST_EVENT_MAX_DATA_SIZE)
XL_FR_MAX_DATA_LENGTH = 254
XL_FR_CHANNEL_CFG_STATUS_INIT_APP_PRESENT = 0x01
XL_FR_CHANNEL_CFG_STATUS_CHANNEL_ACTIVATED = 0x02
XL_FR_CHANNEL_CFG_STATUS_VALID_CLUSTER_CFG = 0x04
XL_FR_CHANNEL_CFG_STATUS_VALID_CFG_MODE = 0x08
XL_FR_CHANNEL_CFG_MODE_SYNCHRONOUS = 1
XL_FR_CHANNEL_CFG_MODE_COMBINED = 2
XL_FR_CHANNEL_CFG_MODE_ASYNCHRONOUS = 3
XL_FR_MODE_NORMAL = 0x00
XL_FR_MODE_COLD_NORMAL = 0x04
XL_FR_MODE_NONE = 0x00
XL_FR_MODE_WAKEUP = 0x01
XL_FR_MODE_COLDSTART_LEADING = 0x02
XL_FR_MODE_COLDSTART_FOLLOWING = 0x03
XL_FR_MODE_WAKEUP_AND_COLDSTART_LEADING = 0x04
XL_FR_MODE_WAKEUP_AND_COLDSTART_FOLLOWING = 0x05
XL_FR_SYMBOL_MTS = 0x01
XL_FR_SYMBOL_CAS = 0x02
XL_FR_TRANSCEIVER_MODE_SLEEP = 0x01
XL_FR_TRANSCEIVER_MODE_NORMAL = 0x02
XL_FR_TRANSCEIVER_MODE_RECEIVE_ONLY = 0x03
XL_FR_TRANSCEIVER_MODE_STANDBY = 0x04
XL_FR_SYNC_PULSE_EXTERNAL = XL_SYNC_PULSE_EXTERNAL
XL_FR_SYNC_PULSE_OUR = XL_SYNC_PULSE_OUR
XL_FR_SYNC_PULSE_OUR_SHARED = XL_SYNC_PULSE_OUR_SHARED
XL_FR_SPY_MODE_ASYNCHRONOUS = 0x01
XL_FR_FILTER_PASS = 0x00000000
XL_FR_FILTER_BLOCK = 0x00000001
XL_FR_FILTER_TYPE_DATA = 0x00000001
XL_FR_FILTER_TYPE_NF = 0x00000002
XL_FR_FILTER_TYPE_FILLUP_NF = 0x00000004
XL_FR_FILTER_CHANNEL_A = 0x00000001
XL_FR_FILTER_CHANNEL_B = 0x00000002
XL_FR_CHANNEL_A = 0x01
XL_FR_CHANNEL_B = 0x02
XL_FR_CHANNEL_AB = XL_FR_CHANNEL_A | XL_FR_CHANNEL_B
XL_FR_CC_COLD_A = 0x04
XL_FR_CC_COLD_B = 0x08
XL_FR_CC_COLD_AB = XL_FR_CC_COLD_A | XL_FR_CC_COLD_B
XL_FR_SPY_CHANNEL_A = 0x10
XL_FR_SPY_CHANNEL_B = 0x20
XL_FR_QUEUE_OVERFLOW = 0x100
XL_FR_FRAMEFLAG_STARTUP = 0x0001
XL_FR_FRAMEFLAG_SYNC = 0x0002
XL_FR_FRAMEFLAG_NULLFRAME = 0x0004
XL_FR_FRAMEFLAG_PAYLOAD_PREAMBLE = 0x0008
XL_FR_FRAMEFLAG_FR_RESERVED = 0x0010
XL_FR_FRAMEFLAG_REQ_TXACK = 0x0020
XL_FR_FRAMEFLAG_TXACK_SS = XL_FR_FRAMEFLAG_REQ_TXACK
XL_FR_FRAMEFLAG_RX_UNEXPECTED = XL_FR_FRAMEFLAG_REQ_TXACK
XL_FR_FRAMEFLAG_NEW_DATA_TX = 0x0040
XL_FR_FRAMEFLAG_DATA_UPDATE_LOST = 0x0080
XL_FR_FRAMEFLAG_SYNTAX_ERROR = 0x0200
XL_FR_FRAMEFLAG_CONTENT_ERROR = 0x0400
XL_FR_FRAMEFLAG_SLOT_BOUNDARY_VIOLATION = 0x0800
XL_FR_FRAMEFLAG_TX_CONFLICT = 0x1000
XL_FR_FRAMEFLAG_EMPTY_SLOT = 0x2000
XL_FR_FRAMEFLAG_FRAME_TRANSMITTED = 0x8000
XL_FR_SPY_FRAMEFLAG_FRAMING_ERROR = 0x01
XL_FR_SPY_FRAMEFLAG_HEADER_CRC_ERROR = 0x02
XL_FR_SPY_FRAMEFLAG_FRAME_CRC_ERROR = 0x04
XL_FR_SPY_FRAMEFLAG_BUS_ERROR = 0x08
XL_FR_SPY_FRAMEFLAG_FRAME_CRC_NEW_LAYOUT = 0x80000000
XL_FR_TX_MODE_CYCLIC = 0x01
XL_FR_TX_MODE_SINGLE_SHOT = 0x02
XL_FR_TX_MODE_NONE = 0xff
XL_FR_PAYLOAD_INCREMENT_8BIT = 8
XL_FR_PAYLOAD_INCREMENT_16BIT = 16
XL_FR_PAYLOAD_INCREMENT_32BIT = 32
XL_FR_PAYLOAD_INCREMENT_NONE = 0
XL_FR_STATUS_DEFAULT_CONFIG = 0x00
XL_FR_STATUS_READY = 0x01
XL_FR_STATUS_NORMAL_ACTIVE = 0x02
XL_FR_STATUS_NORMAL_PASSIVE = 0x03
XL_FR_STATUS_HALT = 0x04
XL_FR_STATUS_MONITOR_MODE = 0x05
XL_FR_STATUS_CONFIG = 0x0f
XL_FR_STATUS_WAKEUP_STANDBY = 0x10
XL_FR_STATUS_WAKEUP_LISTEN = 0x11
XL_FR_STATUS_WAKEUP_SEND = 0x12
XL_FR_STATUS_WAKEUP_DETECT = 0x13
XL_FR_STATUS_STARTUP_PREPARE = 0x20
XL_FR_STATUS_COLDSTART_LISTEN = 0x21
XL_FR_STATUS_COLDSTART_COLLISION_RESOLUTION = 0x22
XL_FR_STATUS_COLDSTART_CONSISTENCY_CHECK = 0x23
XL_FR_STATUS_COLDSTART_GAP = 0x24
XL_FR_STATUS_COLDSTART_JOIN = 0x25
XL_FR_STATUS_INTEGRATION_COLDSTART_CHECK = 0x26
XL_FR_STATUS_INTEGRATION_LISTEN = 0x27
XL_FR_STATUS_INTEGRATION_CONSISTENCY_CHECK = 0x28
XL_FR_STATUS_INITIALIZE_SCHEDULE = 0x29
XL_FR_STATUS_ABORT_STARTUP = 0x2a
XL_FR_STATUS_STARTUP_SUCCESS = 0x2b
XL_FR_ERROR_POC_ACTIVE = 0x00
XL_FR_ERROR_POC_PASSIVE = 0x01
XL_FR_ERROR_POC_COMM_HALT = 0x02
XL_FR_ERROR_NIT_SENA = 0x100
XL_FR_ERROR_NIT_SBNA = 0x200
XL_FR_ERROR_NIT_SENB = 0x400
XL_FR_ERROR_NIT_SBNB = 0x800
XL_FR_ERROR_MISSING_OFFSET_CORRECTION = 0x00000001
XL_FR_ERROR_MAX_OFFSET_CORRECTION_REACHED = 0x00000002
XL_FR_ERROR_MISSING_RATE_CORRECTION = 0x00000004
XL_FR_ERROR_MAX_RATE_CORRECTION_REACHED = 0x00000008
XL_FR_ERROR_CC_PERR = 0x00000040
XL_FR_ERROR_CC_IIBA = 0x00000200
XL_FR_ERROR_CC_IOBA = 0x00000400
XL_FR_ERROR_CC_MHF = 0x00000800
XL_FR_ERROR_CC_EDA = 0x00010000
XL_FR_ERROR_CC_LTVA = 0x00020000
XL_FR_ERROR_CC_TABA = 0x00040000
XL_FR_ERROR_CC_EDB = 0x01000000
XL_FR_ERROR_CC_LTVB = 0x02000000
XL_FR_ERROR_CC_TABB = 0x04000000
XL_FR_WAKEUP_UNDEFINED = 0x00
XL_FR_WAKEUP_RECEIVED_HEADER = 0x01
XL_FR_WAKEUP_RECEIVED_WUP = 0x02
XL_FR_WAKEUP_COLLISION_HEADER = 0x03
XL_FR_WAKEUP_COLLISION_WUP = 0x04
XL_FR_WAKEUP_COLLISION_UNKNOWN = 0x05
XL_FR_WAKEUP_TRANSMITTED = 0x06
XL_FR_WAKEUP_EXTERNAL_WAKEUP = 0x07
XL_FR_WAKEUP_WUP_RECEIVED_WITHOUT_WUS_TX = 0x10
XL_FR_WAKEUP_RESERVED = 0xFF
XL_FR_SYMBOL_STATUS_SESA = 0x01
XL_FR_SYMBOL_STATUS_SBSA = 0x02
XL_FR_SYMBOL_STATUS_TCSA = 0x04
XL_FR_SYMBOL_STATUS_SESB = 0x08
XL_FR_SYMBOL_STATUS_SBSB = 0x10
XL_FR_SYMBOL_STATUS_TCSB = 0x20
XL_FR_SYMBOL_STATUS_MTSA = 0x40
XL_FR_SYMBOL_STATUS_MTSB = 0x80
XL_FR_RX_EVENT_HEADER_SIZE = 32
XL_FR_MAX_EVENT_SIZE = 512
XL_DAIO_PORT_TYPE_MASK_DIGITAL = 0x01
XL_DAIO_PORT_TYPE_MASK_ANALOG = 0x02
XL_DAIO_TRIGGER_TYPE_CYCLIC = 0x01
XL_DAIO_TRIGGER_TYPE_PORT = 0x02
XL_DAIO_TRIGGER_TYPE_RISING = 0x01
XL_DAIO_TRIGGER_TYPE_FALLING = 0x02
XL_DAIO_TRIGGER_TYPE_BOTH = 0x03
XL_DAIO_PORT_DIGITAL_IN = 0x00
XL_DAIO_PORT_DIGITAL_PUSHPULL = 0x01
XL_DAIO_PORT_DIGITAL_OPENDRAIN = 0x02
XL_DAIO_PORT_DIGITAL_IN_OUT = 0x06
XL_DAIO_PORT_ANALOG_IN = 0x00
XL_DAIO_PORT_ANALOG_OUT = 0x01
XL_DAIO_PORT_ANALOG_DIFF = 0x02
XL_DAIO_PORT_ANALOG_OFF = 0x03
XL_DAIO_DO_LEVEL_0V = 0
XL_DAIO_DO_LEVEL_5V = 5
XL_DAIO_DO_LEVEL_12V = 12
XL_DAIO_PORT_MASK_DIGITAL_D0 = 0x01
XL_DAIO_PORT_MASK_DIGITAL_D1 = 0x02
XL_DAIO_PORT_MASK_DIGITAL_D2 = 0x04
XL_DAIO_PORT_MASK_DIGITAL_D3 = 0x08
XL_DAIO_PORT_MASK_DIGITAL_D4 = 0x10
XL_DAIO_PORT_MASK_DIGITAL_D5 = 0x20
XL_DAIO_PORT_MASK_DIGITAL_D6 = 0x40
XL_DAIO_PORT_MASK_DIGITAL_D7 = 0x80
XL_DAIO_PORT_MASK_ANALOG_A0 = 0x01
XL_DAIO_PORT_MASK_ANALOG_A1 = 0x02
XL_DAIO_PORT_MASK_ANALOG_A2 = 0x04
XL_DAIO_PORT_MASK_ANALOG_A3 = 0x08
XL_DAIO_EVT_ID_DIGITAL = XL_DAIO_PORT_TYPE_MASK_DIGITAL
XL_DAIO_EVT_ID_ANALOG = XL_DAIO_PORT_TYPE_MASK_ANALOG

XL_ETH_EVENT_SIZE_HEADER = 32
XL_ETH_EVENT_SIZE_MAX = 2048
XL_ETH_RX_FIFO_QUEUE_SIZE_MAX = (8 * 1024 * 1024)
XL_ETH_RX_FIFO_QUEUE_SIZE_MIN = (64 * 1024)
XL_ETH_PAYLOAD_SIZE_MAX = 1500
XL_ETH_PAYLOAD_SIZE_MIN = 46
XL_ETH_RAW_FRAME_SIZE_MAX = 1600

XL_ETH_CONNECTOR_RJ45 = 0x0001
XL_ETH_CONNECTOR_DSUB = 0x0002
XL_ETH_PHY_IEEE = 0x0004
XL_ETH_PHY_BROADR = 0x0008
XL_ETH_FRAME_BYPASSED = 0x0010
XL_ETH_QUEUE_OVERFLOW = 0x0100
XL_ETH_BYPASS_QUEUE_OVERFLOW = 0x8000

XL_ETH_MACADDR_OCTETS = 6
XL_ETH_ETHERTYPE_OCTETS = 2
XL_ETH_VLANTAG_OCTETS = 4

XL_ETH_MODE_SPEED_AUTO_100 = 2
XL_ETH_MODE_SPEED_AUTO_1000 = 4
XL_ETH_MODE_SPEED_AUTO_100_1000 = 5
XL_ETH_MODE_SPEED_FIXED_100 = 8

XL_ETH_MODE_DUPLEX_DONT_CARE = 0
XL_ETH_MODE_DUPLEX_AUTO = 1
XL_ETH_MODE_DUPLEX_FULL = 3

XL_ETH_MODE_CONNECTOR_RJ45 = 1
XL_ETH_MODE_CONNECTOR_DSUB = 2

XL_ETH_MODE_PHY_IEEE_802_3 = 1
XL_ETH_MODE_PHY_BROADR_REACH = 2

XL_ETH_MODE_CLOCK_DONT_CARE = 0
XL_ETH_MODE_CLOCK_AUTO = 1
XL_ETH_MODE_CLOCK_MASTER = 2
XL_ETH_MODE_CLOCK_SLAVE = 3

XL_ETH_MODE_MDI_AUTO = 1
XL_ETH_MODE_MDI_STRAIGHT = 2
XL_ETH_MODE_MDI_CROSSOVER = 3

XL_ETH_MODE_BR_PAIR_DONT_CARE = 0
XL_ETH_MODE_BR_PAIR_1PAIR = 1

# T_XL_ETH_CHANNEL_STATUS.link
XL_ETH_STATUS_LINK_UNKNOWN = 0
XL_ETH_STATUS_LINK_DOWN = 1
XL_ETH_STATUS_LINK_UP = 2
XL_ETH_STATUS_LINK_ERROR = 4

# T_XL_ETH_CHANNEL_STATUS.speed
XL_ETH_STATUS_SPEED_UNKNOWN = 0
XL_ETH_STATUS_SPEED_100 = 2
XL_ETH_STATUS_SPEED_1000 = 3

# T_XL_ETH_CHANNEL_STATUS.duplex
XL_ETH_STATUS_DUPLEX_UNKNOWN = 0
XL_ETH_STATUS_DUPLEX_FULL = 2

# T_XL_ETH_CHANNEL_STATUS.mdiType
XL_ETH_STATUS_MDI_UNKNOWN = 0
XL_ETH_STATUS_MDI_STRAIGHT = 1
XL_ETH_STATUS_MDI_CROSSOVER = 2

# T_XL_ETH_CHANNEL_STATUS.activeConnector
XL_ETH_STATUS_CONNECTOR_RJ45 = 1
XL_ETH_STATUS_CONNECTOR_DSUB = 2

# T_XL_ETH_CHANNEL_STATUS.activePhy
XL_ETH_STATUS_PHY_UNKNOWN = 0
XL_ETH_STATUS_PHY_IEEE_802_3 = 1
XL_ETH_STATUS_PHY_BROADR_REACH = 2

# T_XL_ETH_CHANNEL_STATUS.clockMode
XL_ETH_STATUS_CLOCK_DONT_CARE = 0
XL_ETH_STATUS_CLOCK_MASTER = 1
XL_ETH_STATUS_CLOCK_SLAVE = 2

# T_XL_ETH_CHANNEL_STATUS.brPairs
XL_ETH_STATUS_BR_PAIR_DONT_CARE = 0
XL_ETH_STATUS_BR_PAIR_1PAIR = 1

# T_XL_ETH_DATAFRAME_RX_ERROR.errorFlags
XL_ETH_RX_ERROR_INVALID_LENGTH = 0x00000001
XL_ETH_RX_ERROR_INVALID_CRC = 0x00000002
XL_ETH_RX_ERROR_PHY_ERROR = 0x00000004

XL_ETH_DATAFRAME_FLAGS_USE_SOURCE_MAC = 0x00000001

XL_ETH_BYPASS_INACTIVE = 0
XL_ETH_BYPASS_PHY = 1
XL_ETH_BYPASS_MACCORE = 2

XL_ETH_TX_ERROR_BYPASS_ENABLED = 1
XL_ETH_TX_ERROR_NO_LINK = 2
XL_ETH_TX_ERROR_PHY_NOT_CONFIGURED = 3
XL_ETH_TX_ERROR_INVALID_LENGTH = 7


XL_MOST150_RX_EVENT_HEADER_SIZE = 32
XL_MOST150_MAX_EVENT_DATA_SIZE = 2048
MOST150_SYNC_ALLOC_INFO_SIZE = 372
XL_MOST150_CTRL_PAYLOAD_MAX_SIZE = 45
XL_MOST150_ASYNC_PAYLOAD_MAX_SIZE = 1524
XL_MOST150_ETHERNET_PAYLOAD_MAX_SIZE = 1506
XL_MOST150_ASYNC_SEND_PAYLOAD_MAX_SIZE = 1600
XL_MOST150_ETHERNET_SEND_PAYLOAD_MAX_SIZE = 1600
XL_MOST150_VN2640 = 0x0001
XL_MOST150_INIC = 0x0002
XL_MOST150_SPY = 0x0004
XL_MOST150_QUEUE_OVERFLOW = 0x0100
XL_MOST150_SOURCE_SPECIAL_NODE = 0x00000001
XL_MOST150_SOURCE_SYNC_ALLOC_INFO = 0x00000004
XL_MOST150_SOURCE_CTRL_SPY = 0x00000008
XL_MOST150_SOURCE_ASYNC_SPY = 0x00000010
XL_MOST150_SOURCE_ETH_SPY = 0x00000020
XL_MOST150_SOURCE_SHUTDOWN_FLAG = 0x00000040
XL_MOST150_SOURCE_SYSTEMLOCK_FLAG = 0x00000080
XL_MOST150_SOURCE_LIGHTLOCK_SPY = 0x00000200
XL_MOST150_SOURCE_LIGHTLOCK_INIC = 0x00000400
XL_MOST150_SOURCE_ECL_CHANGE = 0x00000800
XL_MOST150_SOURCE_LIGHT_STRESS = 0x00001000
XL_MOST150_SOURCE_LOCK_STRESS = 0x00002000
XL_MOST150_SOURCE_BUSLOAD_CTRL = 0x00004000
XL_MOST150_SOURCE_BUSLOAD_ASYNC = 0x00008000
XL_MOST150_SOURCE_CTRL_MLB = 0x00010000
XL_MOST150_SOURCE_ASYNC_MLB = 0x00020000
XL_MOST150_SOURCE_ETH_MLB = 0x00040000
XL_MOST150_SOURCE_TXACK_MLB = 0x00080000
XL_MOST150_SOURCE_STREAM_UNDERFLOW = 0x00100000
XL_MOST150_SOURCE_STREAM_OVERFLOW = 0x00200000
XL_MOST150_SOURCE_STREAM_RX_DATA = 0x00400000
XL_MOST150_SOURCE_ECL_SEQUENCE = 0x00800000
XL_MOST150_DEVICEMODE_SLAVE = 0x00
XL_MOST150_DEVICEMODE_MASTER = 0x01
XL_MOST150_DEVICEMODE_STATIC_MASTER = 0x03
XL_MOST150_DEVICEMODE_RETIMED_BYPASS_SLAVE = 0x04
XL_MOST150_DEVICEMODE_RETIMED_BYPASS_MASTER = 0x05
XL_MOST150_FREQUENCY_44100 = 0x00000000
XL_MOST150_FREQUENCY_48000 = 0x00000001
XL_MOST150_FREQUENCY_ERROR = 0x00000002
XL_MOST150_NA_CHANGED = 0x00000001
XL_MOST150_GA_CHANGED = 0x00000002
XL_MOST150_NPR_CHANGED = 0x00000004
XL_MOST150_MPR_CHANGED = 0x00000008
XL_MOST150_SBC_CHANGED = 0x00000010
XL_MOST150_CTRL_RETRY_PARAMS_CHANGED = 0x00000060
XL_MOST150_ASYNC_RETRY_PARAMS_CHANGED = 0x00000180
XL_MOST150_MAC_ADDR_CHANGED = 0x00000200
XL_MOST150_NPR_SPY_CHANGED = 0x00000400
XL_MOST150_MPR_SPY_CHANGED = 0x00000800
XL_MOST150_SBC_SPY_CHANGED = 0x00001000
XL_MOST150_INIC_NISTATE_CHANGED = 0x00002000
XL_MOST150_SPECIAL_NODE_MASK_CHANGED = 0x00003FFF
XL_MOST150_CTRL_RETRY_TIME_MIN = 3
XL_MOST150_CTRL_RETRY_TIME_MAX = 31
XL_MOST150_CTRL_SEND_ATTEMPT_MIN = 1
XL_MOST150_CTRL_SEND_ATTEMPT_MAX = 16
XL_MOST150_ASYNC_RETRY_TIME_MIN = 0
XL_MOST150_ASYNC_RETRY_TIME_MAX = 255
XL_MOST150_ASYNC_SEND_ATTEMPT_MIN = 1
XL_MOST150_ASYNC_SEND_ATTEMPT_MAX = 16
XL_MOST150_INIC_NISTATE_NET_OFF = 0x00000000
XL_MOST150_INIC_NISTATE_NET_INIT = 0x00000001
XL_MOST150_INIC_NISTATE_NET_RBD = 0x00000002
XL_MOST150_INIC_NISTATE_NET_ON = 0x00000003
XL_MOST150_INIC_NISTATE_NET_RBD_RESULT = 0x00000004
XL_MOST150_TX_OK = 0x00000001
XL_MOST150_TX_FAILED_FORMAT_ERROR = 0x00000002
XL_MOST150_TX_FAILED_NETWORK_OFF = 0x00000004
XL_MOST150_TX_FAILED_TIMEOUT = 0x00000005
XL_MOST150_TX_FAILED_WRONG_TARGET = 0x00000008
XL_MOST150_TX_OK_ONE_SUCCESS = 0x00000009
XL_MOST150_TX_FAILED_BAD_CRC = 0x0000000C
XL_MOST150_TX_FAILED_RECEIVER_BUFFER_FULL = 0x0000000E
XL_MOST150_VALID_DATALENANNOUNCED = 0x00000001
XL_MOST150_VALID_SOURCEADDRESS = 0x00000002
XL_MOST150_VALID_TARGETADDRESS = 0x00000004
XL_MOST150_VALID_PACK = 0x00000008
XL_MOST150_VALID_CACK = 0x00000010
XL_MOST150_VALID_PINDEX = 0x00000020
XL_MOST150_VALID_PRIORITY = 0x00000040
XL_MOST150_VALID_CRC = 0x00000080
XL_MOST150_VALID_CRCCALCULATED = 0x00000100
XL_MOST150_VALID_MESSAGE = 0x80000000
XL_MOST150_PACK_OK = 0x00000004
XL_MOST150_PACK_BUFFER_FULL = 0x00000001
XL_MOST150_PACK_NO_RESPONSE = 0x00000000
XL_MOST150_CACK_OK = 0x00000004
XL_MOST150_CACK_CRC_ERROR = 0x00000001
XL_MOST150_CACK_NO_RESPONSE = 0x00000000
XL_MOST150_ASYNC_INVALID_RX_LENGTH = 0x00008000
XL_MOST150_ETHERNET_INVALID_RX_LENGTH = 0x80000000
XL_MOST150_LIGHT_OFF = 0x00000000
XL_MOST150_LIGHT_FORCE_ON = 0x00000001
XL_MOST150_LIGHT_MODULATED = 0x00000002
XL_MOST150_LIGHT_OFF = 0x00000000
XL_MOST150_LIGHT_ON_UNLOCK = 0x00000003
XL_MOST150_LIGHT_ON_LOCK = 0x00000004
XL_MOST150_LIGHT_ON_STABLE_LOCK = 0x00000005
XL_MOST150_LIGHT_ON_CRITICAL_UNLOCK = 0x00000006
XL_MOST150_ERROR_ASYNC_TX_ACK_HANDLE = 0x00000001
XL_MOST150_ERROR_ETH_TX_ACK_HANDLE = 0x00000002
XL_MOST150_RX_BUFFER_TYPE_CTRL = 0x00000001
XL_MOST150_RX_BUFFER_TYPE_ASYNC = 0x00000002
XL_MOST150_RX_BUFFER_NORMAL_MODE = 0x00000000
XL_MOST150_RX_BUFFER_BLOCK_MODE = 0x00000001
XL_MOST150_DEVICE_LINE_IN = 0x00000000
XL_MOST150_DEVICE_LINE_OUT = 0x00000001
XL_MOST150_DEVICE_SPDIF_IN = 0x00000002
XL_MOST150_DEVICE_SPDIF_OUT = 0x00000003
XL_MOST150_DEVICE_ALLOC_BANDWIDTH = 0x00000004
XL_MOST150_DEVICE_MODE_OFF = 0x00000000
XL_MOST150_DEVICE_MODE_ON = 0x00000001
XL_MOST150_DEVICE_MODE_OFF_BYPASS_CLOSED = 0x00000002
XL_MOST150_DEVICE_MODE_OFF_NOT_IN_NETON = 0x00000003
XL_MOST150_DEVICE_MODE_OFF_NO_MORE_RESOURCES = 0x00000004
XL_MOST150_DEVICE_MODE_OFF_NOT_ENOUGH_FREE_BW = 0x00000005
XL_MOST150_DEVICE_MODE_OFF_DUE_TO_NET_OFF = 0x00000006
XL_MOST150_DEVICE_MODE_OFF_DUE_TO_CFG_NOT_OK = 0x00000007
XL_MOST150_DEVICE_MODE_OFF_COMMUNICATION_ERROR = 0x00000008
XL_MOST150_DEVICE_MODE_OFF_STREAM_CONN_ERROR = 0x00000009
XL_MOST150_DEVICE_MODE_OFF_CL_ALREADY_USED = 0x0000000A
XL_MOST150_DEVICE_MODE_CL_NOT_ALLOCATED = 0x000000FF
XL_MOST150_ALLOC_BANDWIDTH_NUM_CL_MAX = 10
XL_MOST150_CL_DEALLOC_ALL = 0x00000FFF
XL_MOST150_VOLUME_MIN = 0x00000000
XL_MOST150_VOLUME_MAX = 0x000000FF
XL_MOST150_NO_MUTE = 0x00000000
XL_MOST150_MUTE = 0x00000001
XL_MOST150_LIGHT_FULL = 0x00000064
XL_MOST150_LIGHT_3DB = 0x00000032
XL_MOST150_SYSTEMLOCK_FLAG_NOT_SET = 0x00000000
XL_MOST150_SYSTEMLOCK_FLAG_SET = 0x00000001
XL_MOST150_SHUTDOWN_FLAG_NOT_SET = 0x00000000
XL_MOST150_SHUTDOWN_FLAG_SET = 0x00000001
XL_MOST150_ECL_LINE_LOW = 0x00000000
XL_MOST150_ECL_LINE_HIGH = 0x00000001
XL_MOST150_ECL_LINE_PULL_UP_NOT_ACTIVE = 0x00000000
XL_MOST150_ECL_LINE_PULL_UP_ACTIVE = 0x00000001
XL_MOST150_ECL_SEQ_NUM_STATES_MAX = 200
XL_MOST150_ECL_SEQ_DURATION_MIN = 1
XL_MOST150_ECL_SEQ_DURATION_MAX = 655350
XL_MOST150_ECL_GLITCH_FILTER_MIN = 50
XL_MOST150_ECL_GLITCH_FILTER_MAX = 50000
XL_MOST150_MODE_DEACTIVATED = 0
XL_MOST150_MODE_ACTIVATED = 1
XL_MOST150_BUSLOAD_TYPE_DATA_PACKET = 0
XL_MOST150_BUSLOAD_TYPE_ETHERNET_PACKET = 1
XL_MOST150_BUSLOAD_COUNTER_TYPE_NONE = 0x00
XL_MOST150_BUSLOAD_COUNTER_TYPE_1_BYTE = 0x01
XL_MOST150_BUSLOAD_COUNTER_TYPE_2_BYTE = 0x02
XL_MOST150_BUSLOAD_COUNTER_TYPE_3_BYTE = 0x03
XL_MOST150_BUSLOAD_COUNTER_TYPE_4_BYTE = 0x04
XL_MOST150_SPDIF_MODE_SLAVE = 0x00000000
XL_MOST150_SPDIF_MODE_MASTER = 0x00000001
XL_MOST150_SPDIF_ERR_NO_ERROR = 0x00000000
XL_MOST150_SPDIF_ERR_HW_COMMUNICATION = 0x00000001
XL_MOST150_STARTUP_NO_ERROR = 0x00000000
XL_MOST150_STARTUP_NO_ERRORINFO = 0xFFFFFFFF
XL_MOST150_SHUTDOWN_NO_ERROR = 0x00000000
XL_MOST150_SHUTDOWN_NO_ERRORINFO = 0xFFFFFFFF
XL_MOST150_STREAM_RX_DATA = 0
XL_MOST150_STREAM_TX_DATA = 1
XL_MOST150_STREAM_INVALID_HANDLE = 0
XL_MOST150_STREAM_STATE_CLOSED = 0x01
XL_MOST150_STREAM_STATE_OPENED = 0x02
XL_MOST150_STREAM_STATE_STARTED = 0x03
XL_MOST150_STREAM_STATE_STOPPED = 0x04
XL_MOST150_STREAM_STATE_START_PENDING = 0x05
XL_MOST150_STREAM_STATE_STOP_PENDING = 0x06
XL_MOST150_STREAM_STATE_OPEN_PENDING = 0x07
XL_MOST150_STREAM_STATE_CLOSE_PENDING = 0x08
XL_MOST150_STREAM_TX_BYTES_PER_FRAME_MIN = 1
XL_MOST150_STREAM_TX_BYTES_PER_FRAME_MAX = 152
XL_MOST150_STREAM_RX_NUM_CL_MAX = 8
XL_MOST150_STREAM_CL_MIN = 0x000C
XL_MOST150_STREAM_CL_MAX = 0x017F
XL_MOST150_STREAM_STATE_ERROR_NO_ERROR = 0
XL_MOST150_STREAM_STATE_ERROR_NOT_ENOUGH_BW = 1
XL_MOST150_STREAM_STATE_ERROR_NET_OFF = 2
XL_MOST150_STREAM_STATE_ERROR_CONFIG_NOT_OK = 3
XL_MOST150_STREAM_STATE_ERROR_CL_DISAPPEARED = 4
XL_MOST150_STREAM_STATE_ERROR_INIC_SC_ERROR = 5
XL_MOST150_STREAM_STATE_ERROR_DEVICEMODE_BYPASS = 6
XL_MOST150_STREAM_STATE_ERROR_NISTATE_NOT_NETON = 7
XL_MOST150_STREAM_STATE_ERROR_INIC_BUSY = 8
XL_MOST150_STREAM_STATE_ERROR_CL_MISSING = 9
XL_MOST150_STREAM_STATE_ERROR_NUM_BYTES_MISMATCH = 10
XL_MOST150_STREAM_STATE_ERROR_INIC_COMMUNICATION = 11
XL_MOST150_STREAM_BUFFER_ERROR_NO_ERROR = 0
XL_MOST150_STREAM_BUFFER_ERROR_NOT_ENOUGH_DATA = 1
XL_MOST150_STREAM_BUFFER_TX_FIFO_CLEARED = 2
XL_MOST150_STREAM_BUFFER_ERROR_NO_ERROR = 0
XL_MOST150_STREAM_BUFFER_ERROR_STOP_BY_APP = 1
XL_MOST150_STREAM_BUFFER_ERROR_MOST_SIGNAL_OFF = 2
XL_MOST150_STREAM_BUFFER_ERROR_UNLOCK = 3
XL_MOST150_STREAM_BUFFER_ERROR_CL_MISSING = 4
XL_MOST150_STREAM_BUFFER_ERROR_ALL_CL_MISSING = 5
XL_MOST150_STREAM_BUFFER_ERROR_OVERFLOW = 128
XL_MOST150_STREAM_LATENCY_VERY_LOW = 0
XL_MOST150_STREAM_LATENCY_LOW = 1
XL_MOST150_STREAM_LATENCY_MEDIUM = 2
XL_MOST150_STREAM_LATENCY_HIGH = 3
XL_MOST150_STREAM_LATENCY_VERY_HIGH = 4
XL_MOST150_BYPASS_STRESS_TIME_MIN = 10
XL_MOST150_BYPASS_STRESS_TIME_MAX = 65535
XL_MOST150_BYPASS_STRESS_STOPPED = 0
XL_MOST150_BYPASS_STRESS_STARTED = 1
XL_MOST150_BYPASS_STRESS_STOPPED_LIGHT_OFF = 2
XL_MOST150_BYPASS_STRESS_STOPPED_DEVICE_MODE = 3
XL_MOST150_SSO_RESULT_NO_RESULT = 0x00000000
XL_MOST150_SSO_RESULT_NO_FAULT_SAVED = 0x00000001
XL_MOST150_SSO_RESULT_SUDDEN_SIGNAL_OFF = 0x00000002
XL_MOST150_SSO_RESULT_CRITICAL_UNLOCK = 0x00000003


class s_xl_application_notification(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("notifyReason", ctypes.c_uint),
                ("reserved", ctypes.c_uint * 7)]


XL_APPLICATION_NOTIFICATION_EV = s_xl_application_notification


class XLlinStatPar(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("LINMode", ctypes.c_uint),
                ("baudrate", ctypes.c_int),
                ("LINVersion", ctypes.c_uint),
                ("reserved", ctypes.c_uint)]


class s_xl_sync_pulse_ev(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("triggerSource", ctypes.c_uint),
                ("reserved", ctypes.c_uint),
                ("time", ctypes.c_uint64)]


XL_SYNC_PULSE_EV = s_xl_sync_pulse_ev


class s_xl_io_digital_data(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("digitalInputData", ctypes.c_uint)]


XL_IO_DIGITAL_DATA = s_xl_io_digital_data


class s_xl_io_analog_data(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("measuredAnalogData0", ctypes.c_uint),
                ("measuredAnalogData1", ctypes.c_uint),
                ("measuredAnalogData2", ctypes.c_uint),
                ("measuredAnalogData3", ctypes.c_uint)]


XL_IO_ANALOG_DATA = s_xl_io_analog_data


class s_xl_license_info(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("bAvailable", ctypes.c_ubyte),
                ("licName", ctypes.c_byte * 65)]


XL_LICENSE_INFO = s_xl_license_info
XLlicenseInfo = XL_LICENSE_INFO


class XLBusParamsDataCan(ctypes.Structure):
    _pack_ = 1
    _fields = [("bitRate", ctypes.c_uint),
               ("sjw", ctypes.c_ubyte),
               ("tseg1", ctypes.c_ubyte),
               ("tseg2", ctypes.c_ubyte),
               ("sam", ctypes.c_ubyte),
               ("outputMode", ctypes.c_ubyte),
               ("reserved", ctypes.c_ubyte * 7),
               ("canOpMode", ctypes.c_ubyte)]


class XLBusParamsDataCanFD(ctypes.Structure):
    _pack_ = 1
    _fields = [("arbitrationBitRate", ctypes.c_uint),
               ("sjwAbr", ctypes.c_ubyte),
               ("tseg1Abr", ctypes.c_ubyte),
               ("tseg2Abr", ctypes.c_ubyte),
               ("samAbr", ctypes.c_ubyte),
               ("outputMode", ctypes.c_ubyte),
               ("sjwDbr", ctypes.c_ubyte),
               ("tseg1Dbr", ctypes.c_ubyte),
               ("tseg2Dbr", ctypes.c_ubyte),
               ("dataBitRate", ctypes.c_uint),
               ("canOpMode", ctypes.c_ubyte)]


class XLBusParamsDataMost(ctypes.Structure):
    _pack_ = 1
    _fields = [("activeSpeedGrade", ctypes.c_uint),
               ("compatibleSpeedGrade", ctypes.c_uint),
               ("inicFwVersion", ctypes.c_uint)]


class XLBusParamsDataFlexray(ctypes.Structure):
    _pack_ = 1
    _fields = [("status", ctypes.c_uint),
               ("cfgMode", ctypes.c_uint),
               ("baudrate", ctypes.c_uint)]


class XLBusParamsDataEthernet(ctypes.Structure):
    _pack_ = 1
    _fields = [("macAddr", ctypes.c_ubyte * 6),
               ("connector", ctypes.c_ubyte),
               ("phy", ctypes.c_ubyte),
               ("link", ctypes.c_ubyte),
               ("speed", ctypes.c_ubyte),
               ("clockMode", ctypes.c_ubyte),
               ("bypass", ctypes.c_ubyte)]


class XLBusParamsDataA429TXStruct(ctypes.Structure):
    _pack_ = 1
    _fields = [("bitrate", ctypes.c_uint),
               ("parity", ctypes.c_uint),
               ("minGap", ctypes.c_uint)]


class XLBusParamsDataA429RXStruct(ctypes.Structure):
    _pack_ = 1
    _fields = [("bitrate", ctypes.c_uint),
               ("minBitrate", ctypes.c_uint),
               ("maxBitrate", ctypes.c_uint),
               ("parity", ctypes.c_uint),
               ("minGap", ctypes.c_uint),
               ("autoBaudrate", ctypes.c_uint)]


class XLBusParamsDataA429(ctypes.Structure):
    _pack_ = 1
    _fields = [("channelDirection", ctypes.c_ushort),
               ("resl", ctypes.c_ushort),
               ("tx", XLBusParamsDataA429TXStruct),
               ("rx", XLBusParamsDataA429RXStruct),
               ("raw", ctypes.c_ubyte * 24)]


class XLBusParamsData(ctypes.Union):
    _fields_ = [("can", XLBusParamsDataCan),
                ("canFD", XLBusParamsDataCanFD),
                ("most", XLBusParamsDataMost),
                ("flexray", XLBusParamsDataFlexray),
                ("ethernet", XLBusParamsDataEthernet),
                ("a429", XLBusParamsDataA429),
                ("raw", ctypes.c_ubyte * 28)]


class XLbusParams(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("busType", ctypes.c_uint),
                ("data", XLBusParamsData)]


class s_xl_channel_config(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("name", ctypes.c_byte * (XL_MAX_LENGTH + 1)),
                ("hwType", ctypes.c_ubyte),
                ("hwIndex", ctypes.c_ubyte),
                ("hwChannel", ctypes.c_ubyte),
                ("transceiverType", ctypes.c_ushort),
                ("transceiverState", ctypes.c_ushort),
                ("configError", ctypes.c_ushort),
                ("channelIndex", ctypes.c_ubyte),
                ("channelMask", ctypes.c_uint64),
                ("channelCapabilities", ctypes.c_uint),
                ("channelBusCapabilities", ctypes.c_uint),
                ("isOnBus", ctypes.c_ubyte),
                ("connectedBusType", ctypes.c_uint),
                ("busParams", XLbusParams),
                ("_doNotUse", ctypes.c_uint),
                ("driverVersion", ctypes.c_uint),
                ("interfaceVersion", ctypes.c_uint),
                ("raw_data", ctypes.c_uint * 10),
                ("serialNumber", ctypes.c_uint),
                ("articleNumber", ctypes.c_uint),
                ("transceiverName", ctypes.c_byte * (XL_MAX_LENGTH + 1)),
                ("specialCabFlags", ctypes.c_uint),
                ("dominantTimeout", ctypes.c_uint),
                ("dominantRecessiveDelay", ctypes.c_ubyte),
                ("recessiveDominantDelay", ctypes.c_ubyte),
                ("connectionInfo", ctypes.c_ubyte),
                ("currentlyAvailableTimestamps", ctypes.c_ubyte),
                ("minimalSupplyVoltage", ctypes.c_ushort),
                ("maximalSupplyVoltage", ctypes.c_ushort),
                ("maximalBaudrate", ctypes.c_uint),
                ("fpgaCoreCapabilities", ctypes.c_ubyte),
                ("specialDeviceStatus", ctypes.c_ubyte),
                ("channelBusActiveCapabilities", ctypes.c_ushort),
                ("breakOffset", ctypes.c_ushort),
                ("delimiterOffset", ctypes.c_ushort),
                ("reserved", ctypes.c_uint * 3)]


XL_CHANNEL_CONFIG = s_xl_channel_config
XLchannelConfig = XL_CHANNEL_CONFIG


class s_xl_driver_config(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("dllVersion", ctypes.c_uint),
                ("channelCount", ctypes.c_uint),
                ("reserved", ctypes.c_uint * 10),
                ("channel", XLchannelConfig * XL_CONFIG_MAX_CHANNELS)]


XL_DRIVER_CONFIG = s_xl_driver_config
XLdriverConfig = XL_DRIVER_CONFIG


class s_xl_most_ctrl_spy(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("arbitration", ctypes.c_uint),
                ("targetAddress", ctypes.c_ushort),
                ("sourceAddress", ctypes.c_ushort),
                ("ctrlType", ctypes.c_ubyte),
                ("ctrlData", ctypes.c_ubyte * 17),
                ("crc", ctypes.c_ushort),
                ("txStatus", ctypes.c_ushort),
                ("ctrlRes", ctypes.c_ushort),
                ("spyRxStatus", ctypes.c_uint)]


XL_MOST_CTRL_SPY_EV = s_xl_most_ctrl_spy


class s_xl_most_ctrl_msg(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("ctrlPrio", ctypes.c_ubyte),
                ("ctrlType", ctypes.c_ubyte),
                ("targetAddress", ctypes.c_ushort),
                ("sourceAddress", ctypes.c_ushort),
                ("ctrlData", ctypes.c_ubyte * 17),
                ("direction", ctypes.c_ubyte),
                ("status", ctypes.c_uint)]


XL_MOST_CTRL_MSG_EV = s_xl_most_ctrl_msg


class s_xl_most_async_msg(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("status", ctypes.c_uint),
                ("crc", ctypes.c_uint),
                ("arbitration", ctypes.c_ubyte),
                ("length", ctypes.c_ubyte),
                ("targetAddress", ctypes.c_ushort),
                ("sourceAddress", ctypes.c_ushort),
                ("asyncData", ctypes.c_ubyte * 1018)]


XL_MOST_ASYNC_MSG_EV = s_xl_most_async_msg


class s_xl_most_async_tx(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("arbitration", ctypes.c_ubyte),
                ("length", ctypes.c_ubyte),
                ("targetAddress", ctypes.c_ushort),
                ("sourceAddress", ctypes.c_ushort),
                ("asyncData", ctypes.c_ubyte * 1014)]


XL_MOST_ASYNC_TX_EV = s_xl_most_async_tx


class s_xl_most_special_register(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("changeMask", ctypes.c_uint),
                ("lockStatus", ctypes.c_uint),
                ("register_bNAH", ctypes.c_ubyte),
                ("register_bNAL", ctypes.c_ubyte),
                ("register_bGA", ctypes.c_ubyte),
                ("register_bAPAH", ctypes.c_ubyte),
                ("register_bAPAL", ctypes.c_ubyte),
                ("register_bNPR", ctypes.c_ubyte),
                ("register_bMPR", ctypes.c_ubyte),
                ("register_bNDR", ctypes.c_ubyte),
                ("register_bMDR", ctypes.c_ubyte),
                ("register_bSBC", ctypes.c_ubyte),
                ("register_bXTIM", ctypes.c_ubyte),
                ("register_bXRTY", ctypes.c_ubyte)]


XL_MOST_SPECIAL_REGISTER_EV = s_xl_most_special_register


class s_xl_most_event_source(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("mask", ctypes.c_uint),
                ("state", ctypes.c_uint)]


XL_MOST_EVENT_SOURCE_EV = s_xl_most_event_source


class s_xl_most_all_bypass(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("bypassState", ctypes.c_uint)]


XL_MOST_ALL_BYPASS_EV = s_xl_most_all_bypass


class s_xl_most_timing_mode(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("timingmode", ctypes.c_uint)]


XL_MOST_TIMING_MODE_EV = s_xl_most_timing_mode


class s_xl_most_timing_mode_spdif(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("timingmode", ctypes.c_uint)]


XL_MOST_TIMING_MODE_SPDIF_EV = s_xl_most_timing_mode_spdif


class s_xl_most_frequency(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frequency", ctypes.c_uint)]


XL_MOST_FREQUENCY_EV = s_xl_most_frequency


class s_xl_most_register_bytes(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("number", ctypes.c_uint),
                ("address", ctypes.c_uint),
                ("value", ctypes.c_ubyte * 16)]


XL_MOST_REGISTER_BYTES_EV = s_xl_most_register_bytes


class s_xl_most_register_bits(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("address", ctypes.c_uint),
                ("value", ctypes.c_uint),
                ("mask", ctypes.c_uint)]


XL_MOST_REGISTER_BITS_EV = s_xl_most_register_bits


class s_xl_most_sync_alloc(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("allocTable", ctypes.c_ubyte * MOST_ALLOC_TABLE_SIZE)]


XL_MOST_SYNC_ALLOC_EV = s_xl_most_sync_alloc


class s_xl_most_ctrl_sync_audio(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("channelMask", ctypes.c_uint * 4),
                ("device", ctypes.c_uint),
                ("mode", ctypes.c_uint)]


XL_MOST_CTRL_SYNC_AUDIO_EV = s_xl_most_ctrl_sync_audio


class s_xl_most_ctrl_sync_audio_ex(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("channelMask", ctypes.c_uint * 16),
                ("device", ctypes.c_uint),
                ("mode", ctypes.c_uint)]


XL_MOST_CTRL_SYNC_AUDIO_EX_EV = s_xl_most_ctrl_sync_audio_ex


class s_xl_most_sync_volume_status(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("device", ctypes.c_uint),
                ("volume", ctypes.c_uint)]


XL_MOST_SYNC_VOLUME_STATUS_EV = s_xl_most_sync_volume_status


class s_xl_most_sync_mutes_status(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("device", ctypes.c_uint),
                ("mute", ctypes.c_uint)]


XL_MOST_SYNC_MUTES_STATUS_EV = s_xl_most_sync_mutes_status


class s_xl_most_rx_light(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("light", ctypes.c_uint)]


XL_MOST_RX_LIGHT_EV = s_xl_most_rx_light


class s_xl_most_tx_light(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("light", ctypes.c_uint)]


XL_MOST_TX_LIGHT_EV = s_xl_most_tx_light


class s_xl_most_light_power(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("lightPower", ctypes.c_uint)]


XL_MOST_LIGHT_POWER_EV = s_xl_most_light_power


class s_xl_most_lock_status(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("lockStatus", ctypes.c_uint)]


XL_MOST_LOCK_STATUS_EV = s_xl_most_lock_status


class s_xl_most_supervisor_lock_status(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("supervisorLockStatus", ctypes.c_uint)]


XL_MOST_SUPERVISOR_LOCK_STATUS_EV = s_xl_most_supervisor_lock_status


class s_xl_most_gen_light_error(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("lightOnTime", ctypes.c_uint),
                ("lightOffTime", ctypes.c_uint),
                ("repeat", ctypes.c_uint)]


XL_MOST_GEN_LIGHT_ERROR_EV = s_xl_most_gen_light_error


class s_xl_most_gen_lock_error(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("lockOnTime", ctypes.c_uint),
                ("lockOffTime", ctypes.c_uint),
                ("repeat", ctypes.c_uint)]


XL_MOST_GEN_LOCK_ERROR_EV = s_xl_most_gen_lock_error


class s_xl_most_rx_buffer(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("mode", ctypes.c_uint)]


XL_MOST_RX_BUFFER_EV = s_xl_most_rx_buffer


class s_xl_most_error(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("errorCode", ctypes.c_uint),
                ("parameter", ctypes.c_uint * 3)]


XL_MOST_ERROR_EV = s_xl_most_error
XL_MOST_SYNC_PULSE_EV = XL_MOST_ERROR_EV


class s_xl_most_ctrl_busload(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("busloadCtrlStarted", ctypes.c_uint)]


XL_MOST_CTRL_BUSLOAD_EV = s_xl_most_ctrl_busload


class s_xl_most_async_busload(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("busloadAsyncStarted", ctypes.c_uint)]


XL_MOST_ASYNC_BUSLOAD_EV = s_xl_most_async_busload


class s_xl_most_stream_state(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("streamHandle", ctypes.c_uint),
                ("streamState", ctypes.c_uint),
                ("streamError", ctypes.c_uint),
                ("reserved", ctypes.c_uint)]


XL_MOST_STREAM_STATE_EV = s_xl_most_stream_state


class s_xl_most_stream_buffer(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("streamHandle", ctypes.c_uint),
                ("pBuffer", ctypes.POINTER(ctypes.c_ubyte)),
                ("validBytes", ctypes.c_uint),
                ("status", ctypes.c_uint),
                ("pBuffer_highpart", ctypes.c_uint)]


XL_MOST_STREAM_BUFFER_EV = s_xl_most_stream_buffer


class s_xl_most_sync_tx_underflow(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("streamHandle", ctypes.c_uint),
                ("reserved", ctypes.c_uint)]


XL_MOST_SYNC_TX_UNDERFLOW_EV = s_xl_most_sync_tx_underflow


class s_xl_most_sync_rx_overflow(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("streamHandle", ctypes.c_uint),
                ("reserved", ctypes.c_uint)]


XL_MOST_SYNC_RX_OVERFLOW_EV = s_xl_most_sync_rx_overflow


class s_xl_most_tag_data(ctypes.Union):
    _fields_ = [("mostCtrlSpy", XL_MOST_CTRL_SPY_EV),
                ("mostCtrlMsg", XL_MOST_CTRL_MSG_EV),
                ("mostAsyncMsg", XL_MOST_ASYNC_MSG_EV),
                ("mostAsyncTx", XL_MOST_ASYNC_TX_EV),
                ("mostSpecialRegister", XL_MOST_SPECIAL_REGISTER_EV),
                ("mostEventSource", XL_MOST_EVENT_SOURCE_EV),
                ("mostAllBypass", XL_MOST_ALL_BYPASS_EV),
                ("mostTimingMode", XL_MOST_TIMING_MODE_EV),
                ("mostTimingModeSpdif", XL_MOST_TIMING_MODE_SPDIF_EV),
                ("mostFrequency", XL_MOST_FREQUENCY_EV),
                ("mostRegisterBytes", XL_MOST_REGISTER_BYTES_EV),
                ("mostRegisterBits", XL_MOST_REGISTER_BITS_EV),
                ("mostSyncAlloc", XL_MOST_SYNC_ALLOC_EV),
                ("mostCtrlSyncAudio", XL_MOST_CTRL_SYNC_AUDIO_EV),
                ("mostCtrlSyncAudioEx", XL_MOST_CTRL_SYNC_AUDIO_EX_EV),
                ("mostSyncVolumeStatus", XL_MOST_SYNC_VOLUME_STATUS_EV),
                ("mostSyncMuteStatus", XL_MOST_SYNC_MUTES_STATUS_EV),
                ("mostRxLight", XL_MOST_RX_LIGHT_EV),
                ("mostTxLight", XL_MOST_TX_LIGHT_EV),
                ("mostLightPower", XL_MOST_LIGHT_POWER_EV),
                ("mostLockStatus", XL_MOST_LOCK_STATUS_EV),
                ("mostGenLightError", XL_MOST_GEN_LIGHT_ERROR_EV),
                ("mostGenLockError", XL_MOST_GEN_LOCK_ERROR_EV),
                ("mostRxBuffer", XL_MOST_RX_BUFFER_EV),
                ("mostError", XL_MOST_ERROR_EV),
                ("mostSyncPulse", XL_MOST_SYNC_PULSE_EV),
                ("mostCtrlBusload", XL_MOST_CTRL_BUSLOAD_EV),
                ("mostAsyncBusload", XL_MOST_ASYNC_BUSLOAD_EV),
                ("mostStreamState", XL_MOST_STREAM_STATE_EV),
                ("mostStreamBuffer", XL_MOST_STREAM_BUFFER_EV),
                ("mostSyncTxUnderflow", XL_MOST_SYNC_TX_UNDERFLOW_EV),
                ("mostSyncRxOverflow", XL_MOST_SYNC_RX_OVERFLOW_EV)]


class s_xl_most_event(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("size", ctypes.c_uint),
                ("tag", XLmostEventTag),
                ("channelIndex", ctypes.c_ushort),
                ("userHandle", ctypes.c_uint),
                ("flagsChip", ctypes.c_ushort),
                ("reserved", ctypes.c_ushort),
                ("timeStamp", ctypes.c_uint64),
                ("timeStampSync", ctypes.c_uint64),
                ("tagData", s_xl_most_tag_data)]


XLmostEvent = s_xl_most_event
XLmostCtrlMsg = XL_MOST_CTRL_MSG_EV
XLmostAsyncMsg = XL_MOST_ASYNC_TX_EV


class s_xl_most_ctrl_busload_configuration(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("transmissionRate", ctypes.c_uint),
                ("counterType", ctypes.c_uint),
                ("counterPosition", ctypes.c_uint),
                ("busloadCtrlMsg", XL_MOST_CTRL_MSG_EV)]


XL_MOST_CTRL_BUSLOAD_CONFIGURATION = s_xl_most_ctrl_busload_configuration


class s_xl_most_async_busload_configuration(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("transmissionRate", ctypes.c_uint),
                ("counterType", ctypes.c_uint),
                ("counterPosition", ctypes.c_uint),
                ("busloadAsyncMsg", XL_MOST_ASYNC_TX_EV)]


XL_MOST_ASYNC_BUSLOAD_CONFIGURATION = s_xl_most_async_busload_configuration
XLmostCtrlBusloadConfiguration = XL_MOST_CTRL_BUSLOAD_CONFIGURATION
XLmostAsyncBusloadConfiguration = XL_MOST_ASYNC_BUSLOAD_CONFIGURATION


class s_xl_most_device_state(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("selectionMask", ctypes.c_uint),
                ("lockState", ctypes.c_uint),
                ("rxLight", ctypes.c_uint),
                ("txLight", ctypes.c_uint),
                ("txLightPower", ctypes.c_uint),
                ("registerBunch1", ctypes.c_ubyte * 16),
                ("bypassState", ctypes.c_uint),
                ("timingMode", ctypes.c_uint),
                ("frequency", ctypes.c_uint),
                ("registerBunch2", ctypes.c_ubyte * 2),
                ("registerBunch3", ctypes.c_ubyte * 2),
                ("volume", ctypes.c_uint * 2),
                ("mute", ctypes.c_uint * 2),
                ("eventSource", ctypes.c_uint),
                ("rxBufferMode", ctypes.c_uint),
                ("allocTable", ctypes.c_ubyte * MOST_ALLOC_TABLE_SIZE),
                ("supervisorLockStatus", ctypes.c_uint),
                ("broadcastedConfigStatus", ctypes.c_uint),
                ("adrNetworkMaster", ctypes.c_uint),
                ("abilityToWake", ctypes.c_uint)]


XL_MOST_DEVICE_STATE = s_xl_most_device_state
XLmostDeviceState = XL_MOST_DEVICE_STATE


class s_xl_most_stream_open(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("pStreamHandle", ctypes.POINTER(ctypes.c_uint)),
                ("numSyncChannels", ctypes.c_uint),
                ("direction", ctypes.c_uint),
                ("options", ctypes.c_uint),
                ("latency", ctypes.c_uint)]


XL_MOST_STREAM_OPEN = s_xl_most_stream_open
XLmostStreamOpen = XL_MOST_STREAM_OPEN


class s_xl_most_stream_info(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("streamHandle", ctypes.c_uint),
                ("numSyncChannels", ctypes.c_uint),
                ("direction", ctypes.c_uint),
                ("options", ctypes.c_uint),
                ("latency", ctypes.c_uint),
                ("streamState", ctypes.c_uint),
                ("reserved", ctypes.c_uint),
                ("syncChannels", ctypes.c_ubyte * 60)]


XL_MOST_STREAM_INFO = s_xl_most_stream_info
XLmostStreamInfo = XL_MOST_STREAM_INFO


class s_xl_fr_cluster_configuration(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("busGuardianEnable", ctypes.c_uint),
                ("baudrate", ctypes.c_uint),
                ("busGuardianTick", ctypes.c_uint),
                ("externalClockCorrectionMode", ctypes.c_uint),
                ("gColdStartAttempts", ctypes.c_uint),
                ("gListenNoise", ctypes.c_uint),
                ("gMacroPerCycle", ctypes.c_uint),
                ("gMaxWithoutClockCorrectionFatal", ctypes.c_uint),
                ("gMaxWithoutClockCorrectionPassive", ctypes.c_uint),
                ("gNetworkManagementVectorLength", ctypes.c_uint),
                ("gNumberOfMinislots", ctypes.c_uint),
                ("gNumberOfStaticSlots", ctypes.c_uint),
                ("gOffsetCorrectionStart", ctypes.c_uint),
                ("gPayloadLengthStatic", ctypes.c_uint),
                ("gSyncNodeMax", ctypes.c_uint),
                ("gdActionPointOffset", ctypes.c_uint),
                ("gdDynamicSlotIdlePhase", ctypes.c_uint),
                ("gdMacrotick", ctypes.c_uint),
                ("gdMinislot", ctypes.c_uint),
                ("gdMiniSlotActionPointOffset", ctypes.c_uint),
                ("gdNIT", ctypes.c_uint),
                ("gdStaticSlot", ctypes.c_uint),
                ("gdSymbolWindow", ctypes.c_uint),
                ("gdTSSTransmitter", ctypes.c_uint),
                ("gdWakeupSymbolRxIdle", ctypes.c_uint),
                ("gdWakeupSymbolRxLow", ctypes.c_uint),
                ("gdWakeupSymbolRxWindow", ctypes.c_uint),
                ("gdWakeupSymbolTxIdle", ctypes.c_uint),
                ("gdWakeupSymbolTxLow", ctypes.c_uint),
                ("pAllowHaltDueToClock", ctypes.c_uint),
                ("pAllowPassiveToActive", ctypes.c_uint),
                ("pChannels", ctypes.c_uint),
                ("pClusterDriftDamping", ctypes.c_uint),
                ("pDecodingCorrection", ctypes.c_uint),
                ("pDelayCompensationA", ctypes.c_uint),
                ("pDelayCompensationB", ctypes.c_uint),
                ("pExternOffsetCorrection", ctypes.c_uint),
                ("pExternRateCorrection", ctypes.c_uint),
                ("pKeySlotUsedForStartup", ctypes.c_uint),
                ("pKeySlotUsedForSync", ctypes.c_uint),
                ("pLatestTx", ctypes.c_uint),
                ("pMacroInitialOffsetA", ctypes.c_uint),
                ("pMacroInitialOffsetB", ctypes.c_uint),
                ("pMaxPayloadLengthDynamic", ctypes.c_uint),
                ("pMicroInitialOffsetA", ctypes.c_uint),
                ("pMicroInitialOffsetB", ctypes.c_uint),
                ("pMicroPerCycle", ctypes.c_uint),
                ("pMicroPerMacroNom", ctypes.c_uint),
                ("pOffsetCorrectionOut", ctypes.c_uint),
                ("pRateCorrectionOut", ctypes.c_uint),
                ("pSamplesPerMicrotick", ctypes.c_uint),
                ("pSingleSlotEnabled", ctypes.c_uint),
                ("pWakeupChannel", ctypes.c_uint),
                ("pWakeupPattern", ctypes.c_uint),
                ("pdAcceptedStartupRange", ctypes.c_uint),
                ("pdListenTimeout", ctypes.c_uint),
                ("pdMaxDrift", ctypes.c_uint),
                ("pdMicrotick", ctypes.c_uint),
                ("gdCASRxLowMax", ctypes.c_uint),
                ("gChannels", ctypes.c_uint),
                ("vExternOffsetControl", ctypes.c_uint),
                ("vExternRateControl", ctypes.c_uint),
                ("pChannelsMTS", ctypes.c_uint),
                ("framePresetData", ctypes.c_uint),
                ("reserved", ctypes.c_uint * 15)]


XLfrClusterConfig = s_xl_fr_cluster_configuration


class s_xl_fr_channel_config(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("status", ctypes.c_uint),
                ("cfgMode", ctypes.c_uint),
                ("reserved", ctypes.c_uint * 6),
                ("xlFrClusterConfig", XLfrClusterConfig)]


XLfrChannelConfig = s_xl_fr_channel_config


class s_xl_fr_set_modes(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frMode", ctypes.c_uint),
                ("frStartupAttributes", ctypes.c_uint),
                ("reserved", ctypes.c_uint * 30)]


XLfrMode = s_xl_fr_set_modes


class s_xl_fr_acceptance_filter(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("filterStatus", ctypes.c_uint),
                ("filterTypeMask", ctypes.c_uint),
                ("filterFirstSlot", ctypes.c_uint),
                ("filterLastSlot", ctypes.c_uint),
                ("filterChannelMask", ctypes.c_uint)]


XLfrAcceptanceFilter = s_xl_fr_acceptance_filter


class s_xl_fr_start_cycle(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("cycleCount", ctypes.c_uint),
                ("vRateCorrection", ctypes.c_int),
                ("vOffsetCorrection", ctypes.c_int),
                ("vClockCorrectionFailed", ctypes.c_uint),
                ("vAllowPassivToActive", ctypes.c_uint),
                ("reserved", ctypes.c_uint * 3)]


XL_FR_START_CYCLE_EV = s_xl_fr_start_cycle


class s_xl_fr_rx_frame(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("flags", ctypes.c_ushort),
                ("headerCRC", ctypes.c_ushort),
                ("slotID", ctypes.c_ushort),
                ("cycleCount", ctypes.c_ubyte),
                ("payloadLength", ctypes.c_ubyte),
                ("data", ctypes.c_ubyte * XL_FR_MAX_DATA_LENGTH)]


XL_FR_RX_FRAME_EV = s_xl_fr_rx_frame


class s_xl_fr_tx_frame(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("flags", ctypes.c_ushort),
                ("slotID", ctypes.c_ushort),
                ("offset", ctypes.c_ubyte),
                ("repetition", ctypes.c_ubyte),
                ("payloadLength", ctypes.c_ubyte),
                ("txMode", ctypes.c_ubyte),
                ("incrementSize", ctypes.c_ubyte),
                ("incrementOffset", ctypes.c_ubyte),
                ("reserved0", ctypes.c_ubyte),
                ("reserved1", ctypes.c_ubyte),
                ("data", ctypes.c_ubyte * XL_FR_MAX_DATA_LENGTH)]


XL_FR_TX_FRAME_EV = s_xl_fr_tx_frame


class s_xl_fr_wakeup(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("cycleCount", ctypes.c_ubyte),
                ("wakeupStatus", ctypes.c_ubyte),
                ("reserved", ctypes.c_ubyte * 6)]


XL_FR_WAKEUP_EV = s_xl_fr_wakeup


class s_xl_fr_symbol_window(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("symbol", ctypes.c_uint),
                ("flags", ctypes.c_uint),
                ("cycleCount", ctypes.c_ubyte),
                ("reserved", ctypes.c_ubyte * 7)]


XL_FR_SYMBOL_WINDOW_EV = s_xl_fr_symbol_window


class s_xl_fr_status(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("statusType", ctypes.c_uint),
                ("reserved", ctypes.c_uint)]


XL_FR_STATUS_EV = s_xl_fr_status


class s_xl_fr_nm_vector(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("nmVector", ctypes.c_ubyte * 12),
                ("cycleCount", ctypes.c_ubyte),
                ("reserved", ctypes.c_ubyte * 3)]


XL_FR_NM_VECTOR_EV = s_xl_fr_nm_vector
XL_FR_SYNC_PULSE_EV = XL_SYNC_PULSE_EV


class s_xl_fr_error_poc_mode(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("errorMode", ctypes.c_ubyte),
                ("reserved", ctypes.c_ubyte * 3)]


XL_FR_ERROR_POC_MODE_EV = s_xl_fr_error_poc_mode


class s_xl_fr_error_sync_frames(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("evenSyncFramesA", ctypes.c_ushort),
                ("oddSyncFramesA", ctypes.c_ushort),
                ("evenSyncFramesB", ctypes.c_ushort),
                ("oddSyncFramesB", ctypes.c_ushort),
                ("reserved", ctypes.c_uint)]


XL_FR_ERROR_SYNC_FRAMES_EV = s_xl_fr_error_sync_frames


class s_xl_fr_error_clock_corr_failure(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("evenSyncFramesA", ctypes.c_ushort),
                ("oddSyncFramesA", ctypes.c_ushort),
                ("evenSyncFramesB", ctypes.c_ushort),
                ("oddSyncFramesB", ctypes.c_ushort),
                ("flags", ctypes.c_uint),
                ("clockCorrFailedCounter", ctypes.c_uint),
                ("reserved", ctypes.c_uint)]


XL_FR_ERROR_CLOCK_CORR_FAILURE_EV = s_xl_fr_error_clock_corr_failure


class s_xl_fr_error_nit_failure(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("flags", ctypes.c_uint),
                ("reserved", ctypes.c_uint)]


XL_FR_ERROR_NIT_FAILURE_EV = s_xl_fr_error_nit_failure


class s_xl_fr_error_cc_error(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("ccError", ctypes.c_uint),
                ("reserved", ctypes.c_uint)]


XL_FR_ERROR_CC_ERROR_EV = s_xl_fr_error_cc_error


class s_xl_fr_error_info(ctypes.Union):
    _fields_ = [("frPocMode", XL_FR_ERROR_POC_MODE_EV),
                ("frSyncFramesBelowMin", XL_FR_ERROR_SYNC_FRAMES_EV),
                ("frSyncFramesOverload", XL_FR_ERROR_SYNC_FRAMES_EV),
                ("frClockCorrectionFailure", XL_FR_ERROR_CLOCK_CORR_FAILURE_EV),
                ("frNitFailure", XL_FR_ERROR_NIT_FAILURE_EV),
                ("frCCError", XL_FR_ERROR_CC_ERROR_EV)]


class s_xl_fr_error(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("tag", ctypes.c_ubyte),
                ("cycleCount", ctypes.c_ubyte),
                ("reserved", ctypes.c_ubyte * 6),
                ("errorInfo", s_xl_fr_error_info)]


XL_FR_ERROR_EV = s_xl_fr_error


class s_xl_fr_spy_frame(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameLength", ctypes.c_uint),
                ("frameError", ctypes.c_ubyte),
                ("tssLength", ctypes.c_ubyte),
                ("headerFlags", ctypes.c_ushort),
                ("slotID", ctypes.c_ushort),
                ("headerCRC", ctypes.c_ushort),
                ("payloadLength", ctypes.c_ubyte),
                ("cycleCount", ctypes.c_ubyte),
                ("reserved", ctypes.c_ushort),
                ("frameCRC", ctypes.c_uint),
                ("data", ctypes.c_ubyte * XL_FR_MAX_DATA_LENGTH)]


XL_FR_SPY_FRAME_EV = s_xl_fr_spy_frame


class s_xl_fr_spy_symbol(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("lowLength", ctypes.c_ushort),
                ("reserved", ctypes.c_ushort)]


XL_FR_SPY_SYMBOL_EV = s_xl_fr_spy_symbol


class s_xl_fr_tag_data(ctypes.Union):
    _fields_ = [("frStartCycle", XL_FR_START_CYCLE_EV),
                ("frRxFrame", XL_FR_RX_FRAME_EV),
                ("frTxFrame", XL_FR_TX_FRAME_EV),
                ("frWakeup", XL_FR_WAKEUP_EV),
                ("frSymbolWindow", XL_FR_SYMBOL_WINDOW_EV),
                ("frError", XL_FR_ERROR_EV),
                ("frStatus", XL_FR_STATUS_EV),
                ("frNmVector", XL_FR_NM_VECTOR_EV),
                ("frSyncPulse", XL_FR_SYNC_PULSE_EV),
                ("frSpyFrame", XL_FR_SPY_FRAME_EV),
                ("frSpySymbol", XL_FR_SPY_SYMBOL_EV),
                ("applicationNotification", XL_APPLICATION_NOTIFICATION_EV),
                ("raw", ctypes.c_ubyte * (XL_FR_MAX_EVENT_SIZE - XL_FR_RX_EVENT_HEADER_SIZE))]


class s_xl_daio_trigger_mode_param_digital(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("portMask", ctypes.c_uint),
                ("type", ctypes.c_uint)]


class s_xl_daio_trigger_mode_param(ctypes.Union):
    _fields_ = [("cycleTime", ctypes.c_uint),
                ("digital", s_xl_daio_trigger_mode_param_digital)]


class s_xl_daio_trigger_mode(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("portTypeMask", ctypes.c_uint),
                ("triggerType", ctypes.c_uint),
                ("param", s_xl_daio_trigger_mode_param)]


XLdaioTriggerMode = s_xl_daio_trigger_mode


class xl_daio_set_port(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("portType", ctypes.c_uint),
                ("portMask", ctypes.c_uint),
                ("portFunction", ctypes.c_uint * 8),
                ("reserved", ctypes.c_uint * 8)]


XLdaioSetPort = xl_daio_set_port


class xl_daio_analog_params(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("portMask", ctypes.c_uint),
                ("value", ctypes.c_uint * 8)]


XLdaioAnalogParams = xl_daio_analog_params


class xl_daio_digital_params(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("portMask", ctypes.c_uint),
                ("valueMask", ctypes.c_uint)]


XLdaioDigitalParams = xl_daio_digital_params


class s_xl_most150_event_source(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("sourceMask", ctypes.c_uint)]


XL_MOST150_EVENT_SOURCE_EV = s_xl_most150_event_source


class s_xl_most150_device_mode(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("deviceMode", ctypes.c_uint)]


XL_MOST150_DEVICE_MODE_EV = s_xl_most150_device_mode


class s_xl_most150_frequency(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frequency", ctypes.c_uint)]


XL_MOST150_FREQUENCY_EV = s_xl_most150_frequency


class s_xl_most150_special_node_info(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("changeMask", ctypes.c_uint),
                ("nodeAddress", ctypes.c_ushort),
                ("groupAddress", ctypes.c_ushort),
                ("npr", ctypes.c_ubyte),
                ("mpr", ctypes.c_ubyte),
                ("sbc", ctypes.c_ubyte),
                ("ctrlRetryTime", ctypes.c_ubyte),
                ("ctrlSendAttempts", ctypes.c_ubyte),
                ("asyncRetryTime", ctypes.c_ubyte),
                ("asyncSendAttempts", ctypes.c_ubyte),
                ("macAddr", ctypes.c_ubyte * 6),
                ("nprSpy", ctypes.c_ubyte),
                ("mprSpy", ctypes.c_ubyte),
                ("sbcSpy", ctypes.c_ubyte),
                ("inicNIState", ctypes.c_ubyte),
                ("reserved1", ctypes.c_ubyte * 3),
                ("reserved2", ctypes.c_uint * 3)]


XL_MOST150_SPECIAL_NODE_INFO_EV = s_xl_most150_special_node_info


class s_xl_most150_ctrl_rx(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("targetAddress", ctypes.c_ushort),
                ("sourceAddress", ctypes.c_ushort),
                ("fblockId", ctypes.c_ubyte),
                ("instId", ctypes.c_ubyte),
                ("functionId", ctypes.c_ushort),
                ("opType", ctypes.c_ubyte),
                ("telId", ctypes.c_ubyte),
                ("telLen", ctypes.c_ushort),
                ("ctrlData", ctypes.c_ubyte * 45)]


XL_MOST150_CTRL_RX_EV = s_xl_most150_ctrl_rx


class s_xl_most150_ctrl_spy(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameCount", ctypes.c_uint),
                ("msgDuration", ctypes.c_uint),
                ("priority", ctypes.c_ubyte),
                ("targetAddress", ctypes.c_ushort),
                ("pAck", ctypes.c_ubyte),
                ("ctrlDataLenAnnounced", ctypes.c_ushort),
                ("reserved0", ctypes.c_ubyte),
                ("pIndex", ctypes.c_ubyte),
                ("sourceAddress", ctypes.c_ushort),
                ("reserved1", ctypes.c_ushort),
                ("crc", ctypes.c_ushort),
                ("crcCalculated", ctypes.c_ushort),
                ("cAck", ctypes.c_ubyte),
                ("ctrlDataLen", ctypes.c_ushort),
                ("reserved2", ctypes.c_ubyte),
                ("status", ctypes.c_uint),
                ("validMask", ctypes.c_uint),
                ("ctrlData", ctypes.c_ubyte * 51)]


XL_MOST150_CTRL_SPY_EV = s_xl_most150_ctrl_spy


class s_xl_most150_async_rx_msg(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("length", ctypes.c_ushort),
                ("targetAddress", ctypes.c_ushort),
                ("sourceAddress", ctypes.c_ushort),
                ("asyncData", ctypes.c_ubyte * 1524)]


XL_MOST150_ASYNC_RX_EV = s_xl_most150_async_rx_msg


class s_xl_most150_async_spy_msg(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameCount", ctypes.c_uint),
                ("pktDuration", ctypes.c_uint),
                ("asyncDataLenAnnounced", ctypes.c_ushort),
                ("targetAddress", ctypes.c_ushort),
                ("pAck", ctypes.c_ubyte),
                ("pIndex", ctypes.c_ubyte),
                ("sourceAddress", ctypes.c_ushort),
                ("crc", ctypes.c_uint),
                ("crcCalculated", ctypes.c_uint),
                ("cAck", ctypes.c_ubyte),
                ("asyncDataLen", ctypes.c_ushort),
                ("reserved", ctypes.c_ubyte),
                ("status", ctypes.c_uint),
                ("validMask", ctypes.c_uint),
                ("asyncData", ctypes.c_ubyte * 1524)]


XL_MOST150_ASYNC_SPY_EV = s_xl_most150_async_spy_msg


class s_xl_most150_ethernet_rx(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("sourceAddress", ctypes.c_ubyte * 6),
                ("targetAddress", ctypes.c_ubyte * 6),
                ("length", ctypes.c_uint),
                ("ethernetData", ctypes.c_ubyte * 1510)]


XL_MOST150_ETHERNET_RX_EV = s_xl_most150_ethernet_rx


class s_xl_most150_ethernet_spy(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameCount", ctypes.c_uint),
                ("pktDuration", ctypes.c_uint),
                ("ethernetDataLenAnnounced", ctypes.c_ushort),
                ("targetAddress", ctypes.c_ubyte * 6),
                ("pAck", ctypes.c_ubyte),
                ("sourceAddress", ctypes.c_ubyte * 6),
                ("reserved0", ctypes.c_ubyte),
                ("crc", ctypes.c_uint),
                ("crcCalculated", ctypes.c_uint),
                ("cAck", ctypes.c_ubyte),
                ("ethernetDataLen", ctypes.c_ushort),
                ("reserved1", ctypes.c_ubyte),
                ("status", ctypes.c_uint),
                ("validMask", ctypes.c_uint),
                ("ethernetData", ctypes.c_ubyte * 1506)]


XL_MOST150_ETHERNET_SPY_EV = s_xl_most150_ethernet_spy


class s_xl_most150_cl_info(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("label", ctypes.c_ushort),
                ("channelWidth", ctypes.c_ushort)]


XL_MOST150_CL_INFO = s_xl_most150_cl_info


class s_xl_most150_sync_alloc_info(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("allocTable", XL_MOST150_CL_INFO * MOST150_SYNC_ALLOC_INFO_SIZE)]


XL_MOST150_SYNC_ALLOC_INFO_EV = s_xl_most150_sync_alloc_info


class s_xl_most150_sync_volume_status(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("device", ctypes.c_uint),
                ("volume", ctypes.c_uint)]


XL_MOST150_SYNC_VOLUME_STATUS_EV = s_xl_most150_sync_volume_status


class s_xl_most150_tx_light(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("light", ctypes.c_uint)]


XL_MOST150_TX_LIGHT_EV = s_xl_most150_tx_light


class s_xl_most150_rx_light_lock_status(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("status", ctypes.c_uint)]


XL_MOST150_RXLIGHT_LOCKSTATUS_EV = s_xl_most150_rx_light_lock_status


class s_xl_most150_error(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("errorCode", ctypes.c_uint),
                ("parameter", ctypes.c_uint * 3)]


XL_MOST150_ERROR_EV = s_xl_most150_error


class s_xl_most150_configure_rx_buffer(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("bufferType", ctypes.c_uint),
                ("bufferMode", ctypes.c_uint)]


XL_MOST150_CONFIGURE_RX_BUFFER_EV = s_xl_most150_configure_rx_buffer


class s_xl_most150_ctrl_sync_audio(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("label", ctypes.c_uint),
                ("width", ctypes.c_uint),
                ("device", ctypes.c_uint),
                ("mode", ctypes.c_uint)]


XL_MOST150_CTRL_SYNC_AUDIO_EV = s_xl_most150_ctrl_sync_audio


class s_xl_most150_sync_mute_status(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("device", ctypes.c_uint),
                ("mute", ctypes.c_uint)]


XL_MOST150_SYNC_MUTE_STATUS_EV = s_xl_most150_sync_mute_status


class s_xl_most150_tx_light_power(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("lightPower", ctypes.c_uint)]


XL_MOST150_LIGHT_POWER_EV = s_xl_most150_tx_light_power


class s_xl_most150_gen_light_error(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("stressStarted", ctypes.c_uint)]


XL_MOST150_GEN_LIGHT_ERROR_EV = s_xl_most150_gen_light_error


class s_xl_most150_gen_lock_error(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("stressStarted", ctypes.c_uint)]


XL_MOST150_GEN_LOCK_ERROR_EV = s_xl_most150_gen_lock_error


class s_xl_most150_ctrl_busload(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("busloadStarted", ctypes.c_ulong)]


XL_MOST150_CTRL_BUSLOAD_EV = s_xl_most150_ctrl_busload


class s_xl_most150_async_busload(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("busloadStarted", ctypes.c_ulong)]


XL_MOST150_ASYNC_BUSLOAD_EV = s_xl_most150_async_busload


class s_xl_most150_systemlock_flag(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("state", ctypes.c_uint)]


XL_MOST150_SYSTEMLOCK_FLAG_EV = s_xl_most150_systemlock_flag


class s_xl_most150_shutdown_flag(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("state", ctypes.c_uint)]


XL_MOST150_SHUTDOWN_FLAG_EV = s_xl_most150_shutdown_flag


class s_xl_most150_spdif_mode(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("spdifMode", ctypes.c_uint),
                ("spdifError", ctypes.c_uint)]


XL_MOST150_SPDIF_MODE_EV = s_xl_most150_spdif_mode


class s_xl_most150_ecl(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("eclLineState", ctypes.c_uint)]


XL_MOST150_ECL_EV = s_xl_most150_ecl


class s_xl_most150_ecl_termination(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("resistorEnabled", ctypes.c_uint)]


XL_MOST150_ECL_TERMINATION_EV = s_xl_most150_ecl_termination


class s_xl_most150_nw_startup(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("error", ctypes.c_uint),
                ("errorInfo", ctypes.c_uint)]


XL_MOST150_NW_STARTUP_EV = s_xl_most150_nw_startup


class s_xl_most150_nw_shutdown(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("error", ctypes.c_uint),
                ("errorInfo", ctypes.c_uint)]


XL_MOST150_NW_SHUTDOWN_EV = s_xl_most150_nw_shutdown


class s_xl_most150_stream_state(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("streamHandle", ctypes.c_uint),
                ("streamState", ctypes.c_uint),
                ("streamError", ctypes.c_uint)]


XL_MOST150_STREAM_STATE_EV = s_xl_most150_stream_state


class s_xl_most150_stream_tx_buffer(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("streamHandle", ctypes.c_uint),
                ("numberOfBytes", ctypes.c_uint),
                ("status", ctypes.c_uint)]


XL_MOST150_STREAM_TX_BUFFER_EV = s_xl_most150_stream_tx_buffer


class s_xl_most150_stream_rx_buffer(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("streamHandle", ctypes.c_uint),
                ("numberOfBytes", ctypes.c_uint),
                ("status", ctypes.c_uint),
                ("labelInfo", ctypes.c_uint)]


XL_MOST150_STREAM_RX_BUFFER_EV = s_xl_most150_stream_rx_buffer


class s_xl_most150_stream_tx_underflow(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("streamHandle", ctypes.c_uint),
                ("reserved", ctypes.c_uint)]


XL_MOST150_STREAM_TX_UNDERFLOW_EV = s_xl_most150_stream_tx_underflow


class s_xl_most150_stream_tx_label(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("streamHandle", ctypes.c_uint),
                ("errorInfo", ctypes.c_uint),
                ("connLabel", ctypes.c_uint),
                ("width", ctypes.c_uint)]


XL_MOST150_STREAM_TX_LABEL_EV = s_xl_most150_stream_tx_label


class s_xl_most150_gen_bypass_stress(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("stressStarted", ctypes.c_uint)]


XL_MOST150_GEN_BYPASS_STRESS_EV = s_xl_most150_gen_bypass_stress


class s_xl_most150_ecl_sequence(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("sequenceStarted", ctypes.c_uint)]


XL_MOST150_ECL_SEQUENCE_EV = s_xl_most150_ecl_sequence


class s_xl_most150_ecl_glitch_filter(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("duration", ctypes.c_uint)]


XL_MOST150_ECL_GLITCH_FILTER_EV = s_xl_most150_ecl_glitch_filter


class s_xl_most150_sso_result(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("status", ctypes.c_uint)]


XL_MOST150_SSO_RESULT_EV = s_xl_most150_sso_result


class s_xl_most150_ctrl_tx_ack(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("targetAddress", ctypes.c_ushort),
                ("sourceAddress", ctypes.c_ushort),
                ("ctrlPrio", ctypes.c_ubyte),
                ("ctrlSendAttempts", ctypes.c_ubyte),
                ("reserved", ctypes.c_ubyte * 2),
                ("status", ctypes.c_uint),
                ("ctrlData", ctypes.c_ubyte * 51)]


XL_MOST150_CTRL_TX_ACK_EV = s_xl_most150_ctrl_tx_ack


class s_xl_most150_async_tx_ack(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("priority", ctypes.c_ubyte),
                ("asyncSendAttempts", ctypes.c_ubyte),
                ("length", ctypes.c_ushort),
                ("targetAddress", ctypes.c_ushort),
                ("sourceAddress", ctypes.c_ushort),
                ("status", ctypes.c_uint),
                ("asyncData", ctypes.c_ubyte * 1524)]


XL_MOST150_ASYNC_TX_ACK_EV = s_xl_most150_async_tx_ack


class s_xl_most150_ethernet_tx(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("priority", ctypes.c_ubyte),
                ("ethSendAttempts", ctypes.c_ubyte),
                ("sourceAddress", ctypes.c_ubyte * 6),
                ("targetAddress", ctypes.c_ubyte * 6),
                ("reserved", ctypes.c_ubyte * 2),
                ("length", ctypes.c_uint),
                ("ethernetData", ctypes.c_ubyte * 1510)]


XL_MOST150_ETHERNET_TX_ACK_EV = s_xl_most150_ethernet_tx


class s_xl_most150_hw_sync(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("pulseCode", ctypes.c_uint)]


XL_MOST150_HW_SYNC_EV = s_xl_most150_hw_sync


class s_xl_event_most150TagData(ctypes.Union):
    _fields_ = [("rawData", ctypes.c_ubyte * XL_MOST150_MAX_EVENT_DATA_SIZE),
                ("mostEventSource", XL_MOST150_EVENT_SOURCE_EV),
                ("mostDeviceMode", XL_MOST150_DEVICE_MODE_EV),
                ("mostFrequency", XL_MOST150_FREQUENCY_EV),
                ("mostSpecialNodeInfo", XL_MOST150_SPECIAL_NODE_INFO_EV),
                ("mostCtrlRx", XL_MOST150_CTRL_RX_EV),
                ("mostCtrlTxAck", XL_MOST150_CTRL_TX_ACK_EV),
                ("mostAsyncSpy", XL_MOST150_ASYNC_SPY_EV),
                ("mostAsyncRx", XL_MOST150_ASYNC_RX_EV),
                ("mostSyncAllocInfo", XL_MOST150_SYNC_ALLOC_INFO_EV),
                ("mostSyncVolumeStatus", XL_MOST150_SYNC_VOLUME_STATUS_EV),
                ("mostTxLight", XL_MOST150_TX_LIGHT_EV),
                ("mostRxLightLockStatus", XL_MOST150_RXLIGHT_LOCKSTATUS_EV),
                ("mostError", XL_MOST150_ERROR_EV),
                ("mostConfigureRxBuffer", XL_MOST150_CONFIGURE_RX_BUFFER_EV),
                ("mostCtrlSyncAudio", XL_MOST150_CTRL_SYNC_AUDIO_EV),
                ("mostSyncMuteStatus", XL_MOST150_SYNC_MUTE_STATUS_EV),
                ("mostLightPower", XL_MOST150_LIGHT_POWER_EV),
                ("mostGenLightError", XL_MOST150_GEN_LIGHT_ERROR_EV),
                ("mostGenLockError", XL_MOST150_GEN_LOCK_ERROR_EV),
                ("mostCtrlBusload", XL_MOST150_CTRL_BUSLOAD_EV),
                ("mostAsyncBusload", XL_MOST150_ASYNC_BUSLOAD_EV),
                ("mostEthernetRx", XL_MOST150_ETHERNET_RX_EV),
                ("mostSystemLockFlag", XL_MOST150_SYSTEMLOCK_FLAG_EV),
                ("mostShutdownFlag", XL_MOST150_SHUTDOWN_FLAG_EV),
                ("mostSpdifMode", XL_MOST150_SPDIF_MODE_EV),
                ("mostEclEvent", XL_MOST150_ECL_EV),
                ("mostEclTermination", XL_MOST150_ECL_TERMINATION_EV),
                ("mostCtrlSpy", XL_MOST150_CTRL_SPY_EV),
                ("mostAsyncTxAck", XL_MOST150_ASYNC_TX_ACK_EV),
                ("mostEthernetSpy", XL_MOST150_ETHERNET_SPY_EV),
                ("mostEthernetTxAck", XL_MOST150_ETHERNET_TX_ACK_EV),
                ("mostHWSync", XL_MOST150_HW_SYNC_EV),
                ("mostStartup", XL_MOST150_NW_STARTUP_EV),
                ("mostShutdown", XL_MOST150_NW_SHUTDOWN_EV),
                ("mostStreamState", XL_MOST150_STREAM_STATE_EV),
                ("mostStreamTxBuffer", XL_MOST150_STREAM_TX_BUFFER_EV),
                ("mostStreamRxBuffer", XL_MOST150_STREAM_RX_BUFFER_EV),
                ("mostStreamTxUnderflow", XL_MOST150_STREAM_TX_UNDERFLOW_EV),
                ("mostStreamTxLabel", XL_MOST150_STREAM_TX_LABEL_EV),
                ("mostGenBypassStress", XL_MOST150_GEN_BYPASS_STRESS_EV),
                ("mostEclSequence", XL_MOST150_ECL_SEQUENCE_EV),
                ("mostEclGlitchFilter", XL_MOST150_ECL_GLITCH_FILTER_EV),
                ("mostSsoResult", XL_MOST150_SSO_RESULT_EV)]


class s_xl_event_most150(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("size", ctypes.c_uint),
                ("tag", XLmostEventTag),
                ("channelIndex", ctypes.c_ushort),
                ("userHandle", ctypes.c_uint),
                ("flagsChip", ctypes.c_ushort),
                ("reserved", ctypes.c_ushort),
                ("timeStamp", ctypes.c_uint64),
                ("timeStampSync", ctypes.c_uint64),
                ("tagData", s_xl_event_most150TagData)]


XLmost150event = s_xl_event_most150


class s_xl_set_most150_special_node_info(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("changeMask", ctypes.c_uint),
                ("nodeAddress", ctypes.c_uint),
                ("groupAddress", ctypes.c_uint),
                ("sbc", ctypes.c_uint),
                ("ctrlRetryTime", ctypes.c_uint),
                ("ctrlSendAttempts", ctypes.c_uint),
                ("asyncRetryTime", ctypes.c_uint),
                ("asyncSendAttempts", ctypes.c_uint),
                ("macAddr", ctypes.c_ubyte * 6)]


XLmost150SetSpecialNodeInfo = s_xl_set_most150_special_node_info


class s_xl_most150_ctrl_tx_msg(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("ctrlPrio", ctypes.c_uint),
                ("ctrlSendAttempts", ctypes.c_uint),
                ("targetAddress", ctypes.c_uint),
                ("ctrlData", ctypes.c_ubyte * 51)]


XLmost150CtrlTxMsg = s_xl_most150_ctrl_tx_msg


class s_xl_most150_async_tx_msg(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("priority", ctypes.c_uint),
                ("asyncSendAttempts", ctypes.c_uint),
                ("length", ctypes.c_uint),
                ("targetAddress", ctypes.c_uint),
                ("asyncData", ctypes.c_ubyte * XL_MOST150_ASYNC_SEND_PAYLOAD_MAX_SIZE)]


XLmost150AsyncTxMsg = s_xl_most150_async_tx_msg


class s_xl_most150_ethernet_tx_msg(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("priority", ctypes.c_uint),
                ("ethSendAttempts", ctypes.c_uint),
                ("sourceAddress", ctypes.c_ubyte * 6),
                ("targetAddress", ctypes.c_ubyte * 6),
                ("length", ctypes.c_uint),
                ("ethernetData", ctypes.c_ubyte * XL_MOST150_ETHERNET_SEND_PAYLOAD_MAX_SIZE)]


XLmost150EthernetTxMsg = s_xl_most150_ethernet_tx_msg


class s_xl_most150_sync_audio_parameter(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("label", ctypes.c_uint),
                ("width", ctypes.c_uint),
                ("device", ctypes.c_uint),
                ("mode", ctypes.c_uint)]


XLmost150SyncAudioParameter = s_xl_most150_sync_audio_parameter


class s_xl_most150_ctrl_busload_config(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("transmissionRate", ctypes.c_uint),
                ("counterType", ctypes.c_uint),
                ("counterPosition", ctypes.c_uint),
                ("busloadCtrlMsg", XLmost150CtrlTxMsg)]


XLmost150CtrlBusloadConfig = s_xl_most150_ctrl_busload_config


class s_xl_most150_async_busload_configBusloadPkt(ctypes.Union):
    _fields_ = [("rawBusloadPkt", ctypes.c_ubyte * 1540),
                ("busloadAsyncPkt", XLmost150AsyncTxMsg),
                ("busloadEthernetPkt", XLmost150EthernetTxMsg)]


class s_xl_most150_async_busload_config(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("busloadType", ctypes.c_uint),
                ("transmissionRate", ctypes.c_uint),
                ("counterType", ctypes.c_uint),
                ("counterPosition", ctypes.c_uint),
                ("busloadPkt", s_xl_most150_async_busload_configBusloadPkt)]


XLmost150AsyncBusloadConfig = s_xl_most150_async_busload_config


class s_xl_most150_stream_open(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("pStreamHandle", ctypes.POINTER(ctypes.c_uint)),
                ("direction", ctypes.c_uint),
                ("numBytesPerFrame", ctypes.c_uint),
                ("reserved", ctypes.c_uint),
                ("latency", ctypes.c_uint)]


XLmost150StreamOpen = s_xl_most150_stream_open


class s_xl_most150_stream_get_info(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("streamHandle", ctypes.c_uint),
                ("numBytesPerFrame", ctypes.c_uint),
                ("direction", ctypes.c_uint),
                ("reserved", ctypes.c_uint),
                ("latency", ctypes.c_uint),
                ("streamState", ctypes.c_uint),
                ("connLabels", ctypes.c_uint * XL_MOST150_STREAM_RX_NUM_CL_MAX)]


XLmost150StreamInfo = s_xl_most150_stream_get_info

XL_CAN_MAX_DATA_LEN = 64
XL_CANFD_RX_EVENT_HEADER_SIZE = 32
XL_CANFD_MAX_EVENT_SIZE = 128


def CANFD_GET_NUM_DATABYTES(dlc, edl, rtr):
    dlc_lud = {9: 12,
               10: 16,
               11: 20,
               12: 24,
               13: 32,
               14: 48}
    if rtr:
        return 0
    elif dlc < 9:
        return dlc
    elif not edl:
        return 8
    elif dlc in dlc_lud:
        return dlc_lud[dlc]
    else:
        return 64


class XL_CAN_TX_MSG(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("canId", ctypes.c_uint),
                ("msgFlags", ctypes.c_uint),
                ("dlc", ctypes.c_ubyte),
                ("reserved", ctypes.c_ubyte * 7),
                ("data", ctypes.c_ubyte * XL_CAN_MAX_DATA_LEN)]


class XLcanTxEvent_tagData(ctypes.Union):
    _fields_ = [("canMsg", XL_CAN_TX_MSG)]


class XLcanTxEvent(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("tag", ctypes.c_ushort),
                ("transId", ctypes.c_ushort),
                ("channelIndex", ctypes.c_ubyte),
                ("reserved", ctypes.c_ubyte * 3),
                ("tagData", XLcanTxEvent_tagData)]


class XL_CAN_EV_RX_MSG(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("canId", ctypes.c_uint),
                ("msgFlags", ctypes.c_uint),
                ("crc", ctypes.c_uint),
                ("reserved1", ctypes.c_ubyte * 12),
                ("totalBitCnt", ctypes.c_ushort),
                ("dlc", ctypes.c_ubyte),
                ("reserved", ctypes.c_ubyte * 5),
                ("data", ctypes.c_ubyte * XL_CAN_MAX_DATA_LEN)]


class XL_CAN_EV_TX_REQUEST(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("canId", ctypes.c_uint),
                ("msgFlags", ctypes.c_uint),
                ("dlc", ctypes.c_ubyte),
                ("reserved1", ctypes.c_ubyte),
                ("reserved", ctypes.c_ushort),
                ("data", ctypes.c_ubyte * XL_CAN_MAX_DATA_LEN)]


class XL_CAN_EV_CHIP_STATE(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("busStatus", ctypes.c_ubyte),
                ("txErrorCounter", ctypes.c_ubyte),
                ("rxErrorCounter", ctypes.c_ubyte),
                ("reserved", ctypes.c_ubyte),
                ("reserved0", ctypes.c_uint)]


XL_CAN_EV_SYNC_PULSE = XL_SYNC_PULSE_EV


XL_CAN_ERRC_BIT_ERROR = 1
XL_CAN_ERRC_FORM_ERROR = 2
XL_CAN_ERRC_STUFF_ERROR = 3
XL_CAN_ERRC_OTHER_ERROR = 4
XL_CAN_ERRC_CRC_ERROR = 5
XL_CAN_ERRC_ACK_ERROR = 6
XL_CAN_ERRC_NACK_ERROR = 7
XL_CAN_ERRC_OVLD_ERROR = 8
XL_CAN_ERRC_EXCPT_ERROR = 9


class XL_CAN_EV_ERROR(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("errorCode", ctypes.c_ubyte),
                ("reserved", ctypes.c_ubyte * 95)]


XL_CAN_QUEUE_OVERFLOW = 0x100

RX_FIFO_CANFD_QUEUE_SIZE_MAX = 524288
RX_FIFO_CANFD_QUEUE_SIZE_MIN = 8192


class XLcanRxEvent_tagData(ctypes.Union):
    _fields_ = [("raw", ctypes.c_ubyte * (XL_CANFD_MAX_EVENT_SIZE - XL_CANFD_RX_EVENT_HEADER_SIZE)),
                ("canRxOkMsg", XL_CAN_EV_RX_MSG),
                ("canTxOkMsg", XL_CAN_EV_RX_MSG),  # XXX: Is this really the correct type?
                ("canTxRequest", XL_CAN_EV_TX_REQUEST),
                ("canError", XL_CAN_EV_ERROR),
                ("canChipState", XL_CAN_EV_CHIP_STATE),
                ("canSyncPulse", XL_CAN_EV_SYNC_PULSE)]


class XLcanRxEvent(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("size", ctypes.c_uint),
                ("tag", ctypes.c_ushort),
                ("channelIndex", ctypes.c_ushort),
                ("userHandle", ctypes.c_uint),
                ("flagsChip", ctypes.c_ushort),
                ("reserved0", ctypes.c_ushort),
                ("reserved1", XLuint64),
                ("timeStampSync", XLuint64),
                ("tagData", XLcanRxEvent_tagData)]


XL_A429_MSG_CHANNEL_DIR_TX = 0x01
XL_A429_MSG_CHANNEL_DIR_RX = 0x02
XL_A429_MSG_BITRATE_SLOW_MIN = 10500
XL_A429_MSG_BITRATE_SLOW_MAX = 16000
XL_A429_MSG_BITRATE_FAST_MIN = 90000
XL_A429_MSG_BITRATE_FAST_MAX = 110000
XL_A429_MSG_GAP_4BIT = 32
XL_A429_MSG_BITRATE_RX_MIN = 10000
XL_A429_MSG_BITRATE_RX_MAX = 120000
XL_A429_MSG_AUTO_BAUDRATE_DISABLED = 0
XL_A429_MSG_AUTO_BAUDRATE_ENABLED = 1
XL_A429_MSG_FLAG_ON_REQUEST = 0x00000001
XL_A429_MSG_FLAG_CYCLIC = 0x00000002
XL_A429_MSG_FLAG_DELETE_CYCLIC = 0x00000004
XL_A429_MSG_CYCLE_MAX = 0x3FFFFFFF
XL_A429_MSG_GAP_DEFAULT = 0
XL_A429_MSG_GAP_MAX = 0x000FFFFF
XL_A429_MSG_PARITY_DEFAULT = 0
XL_A429_MSG_PARITY_DISABLED = 1
XL_A429_MSG_PARITY_ODD = 2
XL_A429_MSG_PARITY_EVEN = 3
XL_A429_EV_TX_MSG_CTRL_ON_REQUEST = 0
XL_A429_EV_TX_MSG_CTRL_CYCLIC = 1
XL_A429_EV_TX_ERROR_ACCESS_DENIED = 0
XL_A429_EV_TX_ERROR_TRANSMISSION_ERROR = 1
XL_A429_EV_RX_ERROR_GAP_VIOLATION = 0
XL_A429_EV_RX_ERROR_PARITY = 1
XL_A429_EV_RX_ERROR_BITRATE_LOW = 2
XL_A429_EV_RX_ERROR_BITRATE_HIGH = 3
XL_A429_EV_RX_ERROR_FRAME_FORMAT = 4
XL_A429_EV_RX_ERROR_CODING_RZ = 5
XL_A429_EV_RX_ERROR_DUTY_FACTOR = 6
XL_A429_EV_RX_ERROR_AVG_BIT_LENGTH = 7
XL_A429_QUEUE_OVERFLOW = 0x100
XL_A429_RX_FIFO_QUEUE_SIZE_MAX = 524288
XL_A429_RX_FIFO_QUEUE_SIZE_MIN = 8192


class XL_A429_PARAMS_DATA_TX(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("bitRate", ctypes.c_uint),
                ("parity", ctypes.c_uint),
                ("minGap", ctypes.c_uint)]


class XL_A429_PARAMS_DATA_RX(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("bitRate", ctypes.c_uint),
                ("minBitrate", ctypes.c_uint),
                ("maxBitrate", ctypes.c_uint),
                ("parity", ctypes.c_uint),
                ("minGap", ctypes.c_uint),
                ("autoBaudrate", ctypes.c_uint)]


class XL_A429_PARAMS_DATA(ctypes.Union):
    _pack_ = 1
    _fields_ = [("tx", XL_A429_PARAMS_DATA_TX),
                ("rx", XL_A429_PARAMS_DATA_RX)]


class s_xl_a429_params(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("channelDirection", ctypes.c_ushort),
                ("res1", ctypes.c_ushort),
                ("data", XL_A429_PARAMS_DATA)]


XL_A429_PARAMS = s_xl_a429_params


class s_xl_a429_msg_tx(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("userHandle", ctypes.c_ushort),
                ("res1", ctypes.c_ushort),
                ("flags", ctypes.c_uint),
                ("cycleTime", ctypes.c_uint),
                ("gap", ctypes.c_uint),
                ("label", ctypes.c_byte),
                ("parity", ctypes.c_byte),
                ("res2", ctypes.c_ushort),
                ("data", ctypes.c_uint)]


XL_A429_MSG_TX = s_xl_a429_msg_tx


class s_xl_a429_ev_tx_ok(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameLength", ctypes.c_uint),
                ("bitrate", ctypes.c_uint),
                ("label", ctypes.c_byte),
                ("msgCtrl", ctypes.c_byte),
                ("res1", ctypes.c_ushort),
                ("data", ctypes.c_uint)]


XL_A429_EV_TX_OK = s_xl_a429_ev_tx_ok


class s_xl_a429_ev_tx_err(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameLength", ctypes.c_uint),
                ("bitrate", ctypes.c_uint),
                ("errorPosition", ctypes.c_byte),
                ("errorReason", ctypes.c_byte),
                ("label", ctypes.c_byte),
                ("res1", ctypes.c_byte),
                ("data", ctypes.c_uint)]


XL_A429_EV_TX_ERR = s_xl_a429_ev_tx_err


class s_xl_a429_ev_rx_ok(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameLength", ctypes.c_uint),
                ("bitrate", ctypes.c_uint),
                ("label", ctypes.c_byte),
                ("res1", ctypes.c_byte * 3),
                ("data", ctypes.c_uint)]


XL_A429_EV_RX_OK = s_xl_a429_ev_rx_ok


class s_xl_a429_ev_rx_err(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameLength", ctypes.c_uint),
                ("bitrate", ctypes.c_uint),
                ("bitLengthOfLastBit", ctypes.c_uint),
                ("errorPosition", ctypes.c_byte),
                ("errorReason", ctypes.c_byte),
                ("label", ctypes.c_byte),
                ("res1", ctypes.c_byte),
                ("data", ctypes.c_uint)]


XL_A429_EV_RX_ERR = s_xl_a429_ev_rx_err


class s_xl_a429_ev_bus_statistic(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("busLoad", ctypes.c_uint),
                ("res1", ctypes.c_uint * 3)]


XL_A429_EV_BUS_STATISTIC = s_xl_a429_ev_bus_statistic

XL_A429_EV_SYNC_PULSE = XL_SYNC_PULSE_EV


class XLa429RxEvent_tagData_data(ctypes.Union):
    _pack_ = 1
    _fields_ = [("a429TxOkMsg", XL_A429_EV_TX_OK),
                ("a429TxErrMsg", XL_A429_EV_TX_ERR),
                ("a429RxOkMsg", XL_A429_EV_RX_OK),
                ("a429RxErrMsg", XL_A429_EV_RX_ERR),
                ("a429BusStatistic", XL_A429_EV_BUS_STATISTIC),
                ("a429SyncPulse", XL_A429_EV_SYNC_PULSE)]


class XLa429RxEvent(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("size", ctypes.c_uint),
                ("tag", ctypes.c_ushort),
                ("channelIndex", ctypes.c_byte),
                ("reserved", ctypes.c_byte),
                ("userHandle", ctypes.c_uint),
                ("flagsChip", ctypes.c_ushort),
                ("reserved0", ctypes.c_ushort),
                ("timeStamp", XLuint64),
                ("timeStampSync", XLuint64),
                ("tagData", XLa429RxEvent_tagData_data)]


class s_xl_sync_pulse(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("pulseCode", ctypes.c_ubyte),
                ("time", ctypes.c_uint64)]


class s_xl_can_msg(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("id", ctypes.c_ulong),
                ("flags", ctypes.c_ushort),
                ("dlc", ctypes.c_ushort),
                ("res1", ctypes.c_uint64),
                ("data", ctypes.c_ubyte * MAX_MSG_LEN),
                ("res2", ctypes.c_uint64)]


class s_xl_daio_data(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("flags", ctypes.c_ushort),
                ("timestamp_correction", ctypes.c_uint),
                ("mask_digital", ctypes.c_ubyte),
                ("value_digital", ctypes.c_ubyte),
                ("mask_analog", ctypes.c_ubyte),
                ("reserved0", ctypes.c_ubyte),
                ("value_analog", ctypes.c_ushort * (4)),
                ("pwm_frequency", ctypes.c_uint),
                ("pwm_value", ctypes.c_ushort),
                ("reserved1", ctypes.c_uint),
                ("reserved2", ctypes.c_uint)]


class s_xl_daio_piggy_dataData(ctypes.Union):
    _fields_ = [("digital", ctypes.c_uint),
                ("analog", ctypes.c_uint)]


class s_xl_daio_piggy_data(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("daioEvtTag", ctypes.c_uint),
                ("triggerType", ctypes.c_uint),
                ("data", s_xl_daio_piggy_dataData)]


class s_xl_chip_state(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("busStatus", ctypes.c_ubyte),
                ("txErrorCounter", ctypes.c_ubyte),
                ("rxErrorCounter", ctypes.c_ubyte)]


class s_xl_transceiver(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("event_reason", ctypes.c_ubyte),
                ("is_present", ctypes.c_ubyte)]


class s_xl_lin_msg(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("id", ctypes.c_ubyte),
                ("dlc", ctypes.c_ubyte),
                ("flags", ctypes.c_ushort),
                ("data", ctypes.c_ubyte * (8)),
                ("crc", ctypes.c_ubyte)]


class s_xl_lin_sleep(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("flag", ctypes.c_ubyte)]


class s_xl_lin_no_ans(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("id", ctypes.c_ubyte)]


class s_xl_lin_wake_up(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("flag", ctypes.c_ubyte),
                ("unused", ctypes.c_ubyte * 3),
                ("startOffs", ctypes.c_int),
                ("width", ctypes.c_int)]


class s_xl_lin_crc_info(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("id", ctypes.c_ubyte),
                ("flags", ctypes.c_ubyte)]


class s_xl_lin_msg_api(ctypes.Union):
    _fields_ = [("linMsg", s_xl_lin_msg),
                ("linNoAns", s_xl_lin_no_ans),
                ("linWakeUp", s_xl_lin_wake_up),
                ("linSleep", s_xl_lin_sleep),
                ("linCRCinfo", s_xl_lin_crc_info)]


class s_xl_tag_data(ctypes.Union):
    _fields_ = [("msg", s_xl_can_msg),
                ("chipState", s_xl_chip_state),
                ("linMsgApi", s_xl_lin_msg_api),
                ("syncPulse", s_xl_sync_pulse),
                ("daioData", s_xl_daio_data),
                ("transceiver", s_xl_transceiver),
                ("daioPiggyData", s_xl_daio_piggy_data)]


class s_xl_eventTagData(ctypes.Union):
    _fields_ = [("msg", s_xl_can_msg),
                ("chipState", s_xl_chip_state),
                ("linMsgApi", s_xl_lin_msg_api),
                ("syncPulse", s_xl_sync_pulse),
                ("daioData", s_xl_daio_data),
                ("transceiver", s_xl_transceiver),
                ("daioPiggyData", s_xl_daio_piggy_data)
                ]


class s_xl_event(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("tag", XLeventTag),
                ("chanIndex", ctypes.c_ubyte),
                ("transId", ctypes.c_ushort),
                ("portHandle", ctypes.c_ushort),
                ("flags", ctypes.c_ubyte),
                ("reserved", ctypes.c_ubyte),
                ("timeStamp", ctypes.c_uint64),
                ("tagData", s_xl_eventTagData)]


XLevent = s_xl_event


class XLcanFdConf(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("arbitrationBitRate", ctypes.c_uint),
                ("sjwAbr", ctypes.c_uint),
                ("tseg1Abr", ctypes.c_uint),
                ("tseg2Abr", ctypes.c_uint),
                ("dataBitRate", ctypes.c_uint),
                ("sjwDbr", ctypes.c_uint),
                ("tseg1Dbr", ctypes.c_uint),
                ("tseg2Dbr", ctypes.c_uint),
                ("reserved", ctypes.c_uint * 2)]


class XLchipParams(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("bitRate", ctypes.c_ulong),
                ("sjw", ctypes.c_ubyte),
                ("tseg1", ctypes.c_ubyte),
                ("tseg2", ctypes.c_ubyte),
                ("sam", ctypes.c_ubyte)]


class _XLacc_filt(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("isSet", ctypes.c_ubyte),
                ("code", ctypes.c_ulong),
                ("mask", ctypes.c_ulong)]


XLaccFilt = _XLacc_filt


class _XLacceptance(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("std", XLaccFilt),
                ("xtd", XLaccFilt)]


XLacceptance = _XLacceptance


class s_xl_ip_address_ip(ctypes.Union):
    _fields_ = [("v4", ctypes.c_uint),
                ("v6", ctypes.c_uint * 4)]


class s_xl_ip_address(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("ip", s_xl_ip_address_ip),
                ("prefixLength", ctypes.c_uint),
                ("ipVersion", ctypes.c_uint),
                ("configPort", ctypes.c_uint),
                ("eventPort", ctypes.c_uint)]


XLipAddress = s_xl_ip_address


class s_xl_remote_location_config(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("hostName", ctypes.c_char * 64),
                ("alias", ctypes.c_char * 64),
                ("ipAddress", XLipAddress),
                ("userIpAddress", XLipAddress),
                ("deviceType", ctypes.c_uint),
                ("serialNumber", ctypes.c_uint),
                ("articleNumber", ctypes.c_uint),
                ("remoteHandle", XLremoteHandle)]


XLremoteLocationConfig = s_xl_remote_location_config


class s_xl_remote_device(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("deviceName", ctypes.c_char * 32),
                ("hwType", ctypes.c_uint),
                ("articleNumber", ctypes.c_uint),
                ("serialNumber", ctypes.c_uint),
                ("reserved", ctypes.c_uint)]


XLremoteDevice = s_xl_remote_device


class s_xl_remote_device_info(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("locationConfig", XLremoteLocationConfig),
                ("flags", ctypes.c_uint),
                ("reserved", ctypes.c_uint),
                ("nbrOfDevices", ctypes.c_uint),
                ("deviceInfo", XLremoteDevice * XL_MAX_REMOTE_DEVICE_INFO)]


XLremoteDeviceInfo = s_xl_remote_device_info


class s_xl_eth_frame(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("etherType", ctypes.c_ushort),
                ("payload", ctypes.c_ubyte * XL_ETH_PAYLOAD_SIZE_MAX)]


T_XL_ETH_FRAME = s_xl_eth_frame


class s_xl_eth_framedata(ctypes.Union):
    _fields_ = [("rawData", ctypes.c_ubyte * XL_ETH_RAW_FRAME_SIZE_MAX),
                ("ethFrame", T_XL_ETH_FRAME)]


T_XL_ETH_FRAMEDATA = s_xl_eth_framedata


class s_xl_eth_dataframe_rx(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameIdentifier", ctypes.c_uint),
                ("frameDuration", ctypes.c_uint),
                ("dataLen", ctypes.c_ushort),
                ("reserved", ctypes.c_ushort),
                ("reserved2", ctypes.c_uint * 3),
                ("fcs", ctypes.c_uint),
                ("destMAC", ctypes.c_ubyte * XL_ETH_MACADDR_OCTETS),
                ("sourceMAC", ctypes.c_ubyte * XL_ETH_MACADDR_OCTETS),
                ("frameData", T_XL_ETH_FRAMEDATA)]


T_XL_ETH_DATAFRAME_RX = s_xl_eth_dataframe_rx


class s_xl_eth_dataframe_rxerror(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameIdentifier", ctypes.c_uint),
                ("frameDuration", ctypes.c_uint),
                ("errorFlags", ctypes.c_uint),
                ("dataLen", ctypes.c_ushort),
                ("reserved", ctypes.c_ushort),
                ("reserved2", ctypes.c_uint * 3),
                ("fcs", ctypes.c_uint),
                ("destMAC", ctypes.c_ubyte * XL_ETH_MACADDR_OCTETS),
                ("sourceMAC", ctypes.c_ubyte * XL_ETH_MACADDR_OCTETS),
                ("frameData", T_XL_ETH_FRAMEDATA)]


T_XL_ETH_DATAFRAME_RX_ERROR = s_xl_eth_dataframe_rxerror


class s_xl_eth_dataframe_tx(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameIdentifier", ctypes.c_uint),
                ("flags", ctypes.c_uint),
                ("dataLen", ctypes.c_ushort),
                ("reserved", ctypes.c_ushort),
                ("reserved2", ctypes.c_uint * 4),
                ("destMAC", ctypes.c_ubyte * XL_ETH_MACADDR_OCTETS),
                ("sourceMAC", ctypes.c_ubyte * XL_ETH_MACADDR_OCTETS),
                ("frameData", T_XL_ETH_FRAMEDATA)]


T_XL_ETH_DATAFRAME_TX = s_xl_eth_dataframe_tx


class s_xl_eth_dataframe_tx_event(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameIdentifier", ctypes.c_uint),
                ("flags", ctypes.c_uint),
                ("dataLen", ctypes.c_ushort),
                ("reserved", ctypes.c_ushort),
                ("frameDuration", ctypes.c_uint),
                ("reserved2", ctypes.c_uint * 2),
                ("fcs", ctypes.c_uint),
                ("destMAC", ctypes.c_ubyte * XL_ETH_MACADDR_OCTETS),
                ("sourceMAC", ctypes.c_ubyte * XL_ETH_MACADDR_OCTETS),
                ("frameData", T_XL_ETH_FRAMEDATA)]


T_XL_ETH_DATAFRAME_TX_EVENT = s_xl_eth_dataframe_tx_event

T_XL_ETH_DATAFRAME_TXACK = T_XL_ETH_DATAFRAME_TX_EVENT
T_XL_ETH_DATAFRAME_TXACK_SW = T_XL_ETH_DATAFRAME_TX_EVENT
T_XL_ETH_DATAFRAME_TXACK_OTHERAPP = T_XL_ETH_DATAFRAME_TX_EVENT


class s_xl_eth_dataframe_txerror(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("errorType", ctypes.c_uint),
                ("txFrame", T_XL_ETH_DATAFRAME_TX_EVENT)]


T_XL_ETH_DATAFRAME_TX_ERROR = s_xl_eth_dataframe_txerror

T_XL_ETH_DATAFRAME_TX_ERR_SW = T_XL_ETH_DATAFRAME_TX_ERROR
T_XL_ETH_DATAFRAME_TX_ERR_OTHERAPP = T_XL_ETH_DATAFRAME_TX_ERROR


class s_xl_eth_config_result(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("result", ctypes.c_uint)]


T_XL_ETH_CONFIG_RESULT = s_xl_eth_config_result


class s_xl_eth_channel_status(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("link", ctypes.c_uint),
                ("speed", ctypes.c_uint),
                ("duplex", ctypes.c_uint),
                ("mdiType", ctypes.c_uint),
                ("activeConnector", ctypes.c_uint),
                ("activePhy", ctypes.c_uint),
                ("clockMode", ctypes.c_uint),
                ("brPairs", ctypes.c_uint)]


T_XL_ETH_CHANNEL_STATUS = s_xl_eth_channel_status


class s_xl_eth_lostevent_eventInfo_txAck(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("frameIdentifier", ctypes.c_uint),
                ("fcs", ctypes.c_uint),
                ("sourceMAC", ctypes.c_ubyte * XL_ETH_MACADDR_OCTETS),
                ("reserved", ctypes.c_ubyte * 2)]


class s_xl_eth_lostevent_eventInfo_txError(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("errorType", ctypes.c_uint),
                ("frameIdentifier", ctypes.c_uint),
                ("fcs", ctypes.c_uint),
                ("sourceMAC", ctypes.c_ubyte * XL_ETH_MACADDR_OCTETS),
                ("reserved", ctypes.c_ubyte * 2)]


class s_xl_eth_lostevent_eventInfo(ctypes.Union):
    _fields_ = [("txAck", s_xl_eth_lostevent_eventInfo_txAck),
                ("txAckSw", s_xl_eth_lostevent_eventInfo_txAck),
                ("txError", s_xl_eth_lostevent_eventInfo_txError),
                ("txErrorSw", s_xl_eth_lostevent_eventInfo_txError),
                ("reserved", ctypes.c_uint * 20)]


class s_xl_eth_lostevent(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("eventTypeLost", XLethEventTag),
                ("reserved", ctypes.c_ushort),
                ("reason", ctypes.c_uint),
                ("eventInfo", s_xl_eth_lostevent_eventInfo)]


T_XL_ETH_LOSTEVENT = s_xl_eth_lostevent


class s_xl_eth_event_tagData(ctypes.Union):
    _fields_ = [("rawData", ctypes.c_ubyte * XL_ETH_EVENT_SIZE_MAX),
                ("frameRxOk", T_XL_ETH_DATAFRAME_RX),
                ("frameRxError", T_XL_ETH_DATAFRAME_RX_ERROR),
                ("frameTxAck", T_XL_ETH_DATAFRAME_TXACK),
                ("frameTxAckSw", T_XL_ETH_DATAFRAME_TXACK_SW),
                ("frameTxAckOtherApp", T_XL_ETH_DATAFRAME_TXACK_OTHERAPP),
                ("frameTxError", T_XL_ETH_DATAFRAME_TX_ERROR),
                ("frameTxErrorSw", T_XL_ETH_DATAFRAME_TX_ERR_SW),
                ("frameTxErrorOtherApp", T_XL_ETH_DATAFRAME_TX_ERR_OTHERAPP),
                ("configResult", T_XL_ETH_CONFIG_RESULT),
                ("channelStatus", T_XL_ETH_CHANNEL_STATUS),
                ("syncPulse", XL_SYNC_PULSE_EV),
                ("lostEvent", T_XL_ETH_LOSTEVENT)]


class s_xl_eth_event(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("size", ctypes.c_uint),
                ("tag", XLethEventTag),
                ("channelIndex", ctypes.c_ushort),
                ("userHandle", ctypes.c_uint),
                ("flagsChip", ctypes.c_ushort),
                ("reserved", ctypes.c_ushort),
                ("reserved1", XLuint64),
                ("timeStampSync", XLuint64),
                ("tagData", s_xl_eth_event_tagData)]


T_XL_ETH_EVENT = s_xl_eth_event


class T_XL_ETH_CONFIG(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("speed", ctypes.c_uint),
                ("duplex", ctypes.c_uint),
                ("connector", ctypes.c_uint),
                ("phy", ctypes.c_uint),
                ("clockMode", ctypes.c_uint),
                ("mdiMode", ctypes.c_uint),
                ("brPairs", ctypes.c_uint)]


class s_xl_fr_event(ctypes.Structure):
    _pack_ = 1
    _fields_ = [("size", ctypes.c_uint),
                ("tag", XLfrEventTag),
                ("channelIndex", ctypes.c_ushort),
                ("userHandle", ctypes.c_uint),
                ("flagsChip", ctypes.c_ushort),
                ("reserved", ctypes.c_ushort),
                ("timeStamp", ctypes.c_uint64),
                ("timeStampSync", ctypes.c_uint64),
                ("tagData", s_xl_fr_tag_data)]


XLfrEvent = s_xl_fr_event


class XLstatusError(Exception):
    str_lud = {XL_ERR_QUEUE_IS_EMPTY: "XL_ERR_QUEUE_IS_EMPTY",
               XL_ERR_QUEUE_IS_FULL: "XL_ERR_QUEUE_IS_FULL",
               XL_ERR_TX_NOT_POSSIBLE: "XL_ERR_TX_NOT_POSSIBLE",
               XL_ERR_NO_LICENSE: "XL_ERR_NO_LICENSE",
               XL_ERR_WRONG_PARAMETER: "XL_ERR_WRONG_PARAMETER",
               XL_ERR_TWICE_REGISTER: "XL_ERR_TWICE_REGISTER",
               XL_ERR_INVALID_CHAN_INDEX: "XL_ERR_INVALID_CHAN_INDEX",
               XL_ERR_INVALID_ACCESS: "XL_ERR_INVALID_ACCESS",
               XL_ERR_PORT_IS_OFFLINE: "XL_ERR_PORT_IS_OFFLINE",
               XL_ERR_CHAN_IS_ONLINE: "XL_ERR_CHAN_IS_ONLINE",
               XL_ERR_NOT_IMPLEMENTED: "XL_ERR_NOT_IMPLEMENTED",
               XL_ERR_INVALID_PORT: "XL_ERR_INVALID_PORT",
               XL_ERR_HW_NOT_READY: "XL_ERR_HW_NOT_READY",
               XL_ERR_CMD_TIMEOUT: "XL_ERR_CMD_TIMEOUT",
               XL_ERR_CMD_HANDLING: "XL_ERR_CMD_HANDLING",
               XL_ERR_HW_NOT_PRESENT: "XL_ERR_HW_NOT_PRESENT",
               XL_ERR_NOTIFY_ALREADY_ACTIVE: "XL_ERR_NOTIFY_ALREADY_ACTIVE",
               XL_ERR_INVALID_TAG: "XL_ERR_INVALID_TAG",
               XL_ERR_INVALID_RESERVED_FLD: "XL_ERR_INVALID_RESERVED_FLD",
               XL_ERR_INVALID_SIZE: "XL_ERR_INVALID_SIZE",
               XL_ERR_INSUFFICIENT_BUFFER: "XL_ERR_INSUFFICIENT_BUFFER",
               XL_ERR_ERROR_CRC: "XL_ERR_ERROR_CRC",
               XL_ERR_BAD_EXE_FORMAT: "XL_ERR_BAD_EXE_FORMAT",
               XL_ERR_NO_SYSTEM_RESOURCES: "XL_ERR_NO_SYSTEM_RESOURCES",
               XL_ERR_NOT_FOUND: "XL_ERR_NOT_FOUND",
               XL_ERR_INVALID_ADDRESS: "XL_ERR_INVALID_ADDRESS",
               XL_ERR_REQ_NOT_ACCEP: "XL_ERR_REQ_NOT_ACCEP",
               XL_ERR_INVALID_LEVEL: "XL_ERR_INVALID_LEVEL",
               XL_ERR_NO_DATA_DETECTED: "XL_ERR_NO_DATA_DETECTED",
               XL_ERR_INTERNAL_ERROR: "XL_ERR_INTERNAL_ERROR",
               XL_ERR_UNEXP_NET_ERR: "XL_ERR_UNEXP_NET_ERR",
               XL_ERR_INVALID_USER_BUFFER: "XL_ERR_INVALID_USER_BUFFER",
               XL_ERR_NO_RESOURCES: "XL_ERR_NO_RESOURCES",
               XL_ERR_WRONG_CHIP_TYPE: "XL_ERR_WRONG_CHIP_TYPE",
               XL_ERR_WRONG_COMMAND: "XL_ERR_WRONG_COMMAND",
               XL_ERR_INVALID_HANDLE: "XL_ERR_INVALID_HANDLE",
               XL_ERR_RESERVED_NOT_ZERO: "XL_ERR_RESERVED_NOT_ZERO",
               XL_ERR_INIT_ACCESS_MISSING: "XL_ERR_INIT_ACCESS_MISSING",
               XL_ERR_CANNOT_OPEN_DRIVER: "XL_ERR_CANNOT_OPEN_DRIVER",
               XL_ERR_WRONG_BUS_TYPE: "XL_ERR_WRONG_BUS_TYPE",
               XL_ERR_DLL_NOT_FOUND: "XL_ERR_DLL_NOT_FOUND",
               XL_ERR_INVALID_CHANNEL_MASK: "XL_ERR_INVALID_CHANNEL_MASK",
               XL_ERR_NOT_SUPPORTED: "XL_ERR_NOT_SUPPORTED",
               XL_ERR_CONNECTION_BROKEN: "XL_ERR_CONNECTION_BROKEN",
               XL_ERR_CONNECTION_CLOSED: "XL_ERR_CONNECTION_CLOSED",
               XL_ERR_INVALID_STREAM_NAME: "XL_ERR_INVALID_STREAM_NAME",
               XL_ERR_CONNECTION_FAILED: "XL_ERR_CONNECTION_FAILED",
               XL_ERR_STREAM_NOT_FOUND: "XL_ERR_STREAM_NOT_FOUND",
               XL_ERR_STREAM_NOT_CONNECTED: "XL_ERR_STREAM_NOT_CONNECTED",
               XL_ERR_QUEUE_OVERRUN: "XL_ERR_QUEUE_OVERRUN",
               XL_ERR_INVALID_DLC: "XL_ERR_INVALID_DLC",
               XL_ERR_INVALID_CANID: "XL_ERR_INVALID_CANID",
               XL_ERR_INVALID_FDFLAG_MODE20: "XL_ERR_INVALID_FDFLAG_MODE20",
               XL_ERR_EDL_RTR: "XL_ERR_EDL_RTR",
               XL_ERR_EDL_NOT_SET: "XL_ERR_EDL_NOT_SET",
               XL_ERR_UNKNOWN_FLAG: "XL_ERR_UNKNOWN_FLAG",
               XL_ERR_ETH_PHY_ACTIVATION_FAILED: "XL_ERR_ETH_PHY_ACTIVATION_FAILED",
               XL_ERR_ETH_MAC_RESET_FAILED: "XL_ERR_ETH_MAC_RESET_FAILED",
               XL_ERR_ETH_MAC_NOT_READY: "XL_ERR_ETH_MAC_NOT_READY",
               XL_ERR_ETH_PHY_CONFIG_ABORTED: "XL_ERR_ETH_PHY_CONFIG_ABORTED",
               XL_ERR_ETH_RESET_FAILED: "XL_ERR_ETH_RESET_FAILED",
               XL_ERR_ETH_SET_CONFIG_DELAYED: "XL_ERR_ETH_SET_CONFIG_DELAYED",
               XL_ERR_ETH_UNSUPPORTED_FEATURE: "XL_ERR_ETH_UNSUPPORTED_FEATURE",
               XL_ERR_ETH_MAC_ACTIVATION_FAILED: "XL_ERR_ETH_MAC_ACTIVATION_FAILED",
               XL_ERR_ETH_FILTER_INVALID: "XL_ERR_ETH_FILTER_INVALID",
               XL_ERR_ETH_FILTER_UNAVAILABLE: "XL_ERR_ETH_FILTER_UNAVAILABLE",
               XL_ERR_ETH_FILTER_NO_INIT_ACCESS: "XL_ERR_ETH_FILTER_NO_INIT_ACCESS",
               XL_ERR_ETH_FILTER_TOO_COMPLEX: "XL_ERR_ETH_FILTER_TOO_COMPLEX"}

    def __init__(self, funcrepr, status):
        self.funcrepr = funcrepr
        self.status = status

    def __str__(self):
        if self.status in XLstatusError.str_lud:
            errstr = XLstatusError.str_lud[self.status]
        else:
            errstr = "No translation available"
        return "%s failed with status %d (%s)" % (self.funcrepr, self.status, errstr)


def STDXL_FUNC(api):
    def caller(*args, **kwargs):
        if hasattr(args[0], 'trace') and args[0].trace:
            print(repr(api), repr(args), repr(kwargs))
        status = api(*args, **kwargs)
        if type(status) == XLstatus and status.value != XL_SUCCESS:
            raise XLstatusError(repr(api), status.value)
        try:
            return status.value
        except AttributeError:
            return status
    return caller


def dec_setter(decorator):
    #  TODO: Decorate functions explicitly instead of this hack
    def decorate(cls):
        for name, fn in inspect.getmembers(cls):
            if isinstance(fn, types.UnboundMethodType if sys.version < '3' else types.FunctionType):
                setattr(cls, name, decorator(fn))
        return cls
    return decorate


@dec_setter(STDXL_FUNC)
class vxlapy(object):

    """
    Python style vxlapi.
    Refer to the Vector API documentation for reference.
    """

    def __init__(self, trace=False):
        import win32event
        self.waitForSingleObject = win32event.WaitForSingleObject
        self.trace = trace
        try:
            DLL_NAME = 'vxlapi64.dll' if platform.architecture()[0] == '64bit' else 'vxlapi32.dll'
            dll_path = os.path.join(os.path.dirname(__file__), DLL_NAME)
            self.vxlapi = ctypes.windll.LoadLibrary(dll_path)
        except:
            try:
                DLL_NAME = 'vxlapi64' if platform.architecture()[0] == '64bit' else 'vxlapi'
                self.vxlapi = ctypes.windll.LoadLibrary(DLL_NAME)
            except:
                try:
                    DLL_NAME = 'vxlapi_64bit.dll' if platform.architecture()[0] == '64bit' else 'vxlapi_32bit.dll'
                    dll_path = os.path.join(os.path.dirname(__file__), DLL_NAME)
                    self.vxlapi = ctypes.windll.LoadLibrary(dll_path)
                except:
                    raise Exception('Could not load vxlapi dll file')
    def xlOpenDriver(self):
        """void"""
        return XLstatus(self.vxlapi.xlOpenDriver())

    def xlCloseDriver(self):
        """void"""
        return XLstatus(self.vxlapi.xlCloseDriver())

    def xlGetApplConfig(self, appName, appChannel, pHwType, pHwIndex, pHwChannel, busType):
        """char *appName, unsigned int appChannel, unsigned int *pHwType, unsigned int *pHwIndex, unsigned int *pHwChannel, unsigned int busType """
        self.vxlapi.xlGetApplConfig.argtypes = [ctypes.c_char_p, ctypes.c_uint, ctypes.POINTER(ctypes.c_uint), ctypes.POINTER(ctypes.c_uint), ctypes.POINTER(ctypes.c_uint), ctypes.c_uint]
        return XLstatus(self.vxlapi.xlGetApplConfig(appName.encode('ascii'), appChannel, pHwType, pHwIndex, pHwChannel, busType))

    def xlSetApplConfig(self, appName, appChannel, hwType, hwIndex, hwChannel, busType):
        """char *appName, unsigned int appChannel, unsigned int hwType, unsigned int hwIndex, unsigned int hwChannel, unsigned int busType """
        self.vxlapi.xlSetApplConfig.argtypes = [ctypes.c_char_p, ctypes.c_uint, ctypes.c_uint, ctypes.c_uint, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlSetApplConfig(appName.encode('ascii'), appChannel, hwType, hwIndex, hwChannel, busType))

    def xlGetDriverConfig(self, pDriverConfig):
        """XLdriverConfig *pDriverConfig"""
        self.vxlapi.xlGetDriverConfig.argtypes = [ctypes.POINTER(XLdriverConfig)]
        return XLstatus(self.vxlapi.xlGetDriverConfig(pDriverConfig))

    def xlOpenPort(self, pPortHandle, userName, accessMask, pPermissionMask, rxQueueSize, xlInterfaceVersion, busType):
        """XLportHandle *pPortHandle, char *userName, XLaccess accessMask, XLaccess *pPermissionMask, unsigned int rxQueueSize, unsigned int xlInterfaceVersion, unsigned int busType"""
        self.vxlapi.xlOpenPort.argtypes = [ctypes.POINTER(XLportHandle), ctypes.c_char_p, XLaccess, ctypes.POINTER(XLaccess), ctypes.c_uint, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlOpenPort(pPortHandle, userName.encode('ascii'), accessMask, pPermissionMask, rxQueueSize, xlInterfaceVersion, busType))

    def xlGetChannelIndex(self, hwType, hwIndex, hwChannel):
        """int hwType, int hwIndex, int hwChannel"""
        self.vxlapi.xlGetChannelIndex.argtypes = [ctypes.c_int, ctypes.c_int, ctypes.c_int]
        return self.vxlapi.xlGetChannelIndex(hwType, hwIndex, hwChannel)

    def xlSetTimerRate(self, portHandle, timerRate):
        """XLportHandle portHandle, unsigned long timerRate"""
        self.vxlapi.xlSetTimerRate.argtypes = [XLportHandle, ctypes.c_ulong]
        return XLstatus(self.vxlapi.xlSetTimerRate(portHandle, timerRate))

    def xlSetTimerRateAndChannel(self, portHandle, timerChannelMask, timerRate):
        """XLportHandle portHandle, XLaccess *timerChannelMask, unsigned long *timerRate"""
        self.vxlapi.xlSetTimerRateAndChannel.argtypes = [XLportHandle, ctypes.POINTER(XLaccess), ctypes.POINTER(ctypes.c_ulong)]
        return XLstatus(self.vxlapi.xlSetTimerRateAndChannel(portHandle, timerChannelMask, timerRate))

    def xlResetClock(self, portHandle):
        """XLportHandle portHandle"""
        self.vxlapi.xlResetClock.argtypes = [XLportHandle]
        return XLstatus(self.vxlapi.xlResetClock(portHandle))

    def xlSetNotification(self, portHandle, pHandle, queueLevel):
        """XLportHandle portHandle, XLhandle *pHandle, int queueLevel"""
        self.vxlapi.xlSetNotification.argtypes = [XLportHandle, ctypes.POINTER(XLhandle), ctypes.c_int]
        return XLstatus(self.vxlapi.xlSetNotification(portHandle, pHandle, queueLevel))

    def xlSetTimerBasedNotify(self, portHandle, pHandle):
        """XLportHandle portHandle, XLhandle *pHandle"""
        self.vxlapi.xlSetTimerBasedNotify.argtypes = [XLportHandle, ctypes.POINTER(XLhandle)]
        return XLstatus(self.vxlapi.xlSetTimerBasedNotify(portHandle, pHandle))

    def xlFlushReceiveQueue(self, portHandle):
        """XLportHandle portHandle"""
        self.vxlapi.xlFlushReceiveQueue.argtypes = [XLportHandle]
        return XLstatus(self.vxlapi.xlFlushReceiveQueue(portHandle))

    def xlGetReceiveQueueLevel(self, portHandle, level):
        """XLportHandle portHandle, int *level"""
        self.vxlapi.xlGetReceiveQueueLevel.argtypes = [XLportHandle, ctypes.POINTER(ctypes.c_int)]
        return XLstatus(self.vxlapi.xlGetReceiveQueueLevel(portHandle, level))

    def xlActivateChannel(self, portHandle, accessMask, busType, flags):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int busType, unsigned int flags"""
        self.vxlapi.xlActivateChannel.argtypes = [XLportHandle, XLaccess, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlActivateChannel(portHandle, accessMask, busType, flags))

    def xlReceive(self, portHandle, pEventCount, pEvents):
        """XLportHandle portHandle, unsigned int *pEventCount, XLevent *pEvents"""
        self.vxlapi.xlReceive.argtypes = [XLportHandle, ctypes.POINTER(ctypes.c_uint), ctypes.POINTER(XLevent)]
        return XLstatus(self.vxlapi.xlReceive(portHandle, pEventCount, pEvents))

    def xlOemContact(self, portHandle, Channel, context1, context2):
        """XLportHandle portHandle, unsigned long Channel, XLuint64 context1, XLuint64 *context2"""
        self.vxlapi.xlOemContact.argtypes = [XLportHandle, ctypes.c_ulong, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64)]
        return XLstatus(self.vxlapi.xlOemContact(portHandle, Channel, context1, context2))

    def xlGetSyncTime(self, portHandle, pTime):
        """XLportHandle portHandle, XLuint64 *pTime"""
        self.vxlapi.xlGetSyncTime.argtypes = [XLportHandle, ctypes.POINTER(ctypes.c_uint64)]
        return XLstatus(self.vxlapi.xlGetSyncTime(portHandle, pTime))

    def xlGetChannelTime(self, portHandle, accessMask, pChannelTime):
        """XLportHandle portHandle, XLaccess accessMask, XLuint64 *pChannelTime"""
        self.vxlapi.xlGetChannelTime.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(ctypes.c_uint64)]
        return XLstatus(self.vxlapi.xlGetChannelTime(portHandle, accessMask, pChannelTime))

    def xlGenerateSyncPulse(self, portHandle, accessMask):
        """XLportHandle portHandle, XLaccess accessMask"""
        self.vxlapi.xlGenerateSyncPulse.argtypes = [XLportHandle, XLaccess]
        return XLstatus(self.vxlapi.xlGenerateSyncPulse(portHandle, accessMask))

    def xlPopupHwConfig(self, callSign, waitForFinish):
        """char *callSign, unsigned int waitForFinish"""
        self.vxlapi.xlPopupHwConfig.argtypes = [ctypes.c_char_p, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlPopupHwConfig(callSign, waitForFinish))

    def xlDeactivateChannel(self, portHandle, accessMask):
        """XLportHandle portHandle, XLaccess accessMask"""
        self.vxlapi.xlDeactivateChannel.argtypes = [XLportHandle, XLaccess]
        return XLstatus(self.vxlapi.xlDeactivateChannel(portHandle, accessMask))

    def xlClosePort(self, portHandle):
        """XLportHandle portHandle"""
        self.vxlapi.xlClosePort.argtypes = [XLportHandle]
        return XLstatus(self.vxlapi.xlClosePort(portHandle))

    def xlCanFlushTransmitQueue(self, portHandle, accessMask):
        """XLportHandle portHandle, XLaccess accessMask"""
        self.vxlapi.xlCanFlushTransmitQueue.argtypes = [XLportHandle, XLaccess]
        return XLstatus(self.vxlapi.xlCanFlushTransmitQueue(portHandle, accessMask))

    def xlCanSetChannelOutput(self, portHandle, accessMask, mode):
        """XLportHandle portHandle, XLaccess accessMask, int mode"""
        self.vxlapi.xlCanSetChannelOutput.argtypes = [XLportHandle, XLaccess, ctypes.c_int]
        return XLstatus(self.vxlapi.xlCanSetChannelOutput(portHandle, accessMask, mode))

    def xlCanSetChannelMode(self, portHandle, accessMask, tx, txrq):
        """XLportHandle portHandle, XLaccess accessMask, int tx, int txrq"""
        self.vxlapi.xlCanSetChannelMode.argtypes = [XLportHandle, XLaccess, ctypes.c_int, ctypes.c_int]
        return XLstatus(self.vxlapi.xlCanSetChannelMode(portHandle, accessMask, tx, txrq))

    def xlCanSetReceiveMode(self, Port, ErrorFrame, ChipState):
        """XLportHandle Port, unsigned char ErrorFrame, unsigned char ChipState """
        self.vxlapi.xlCanSetReceiveMode.argtypes = [XLportHandle, ctypes.c_ubyte, ctypes.c_ubyte]
        return XLstatus(self.vxlapi.xlCanSetReceiveMode(Port, ErrorFrame, ChipState))

    def xlCanSetChannelTransceiver(self, portHandle, accessMask, type, lineMode, resNet):
        """XLportHandle portHandle, XLaccess accessMask, int type, int lineMode, int resNet"""
        self.vxlapi.xlCanSetChannelTransceiver.argtypes = [XLportHandle, XLaccess, ctypes.c_int, ctypes.c_int, ctypes.c_int]
        return XLstatus(self.vxlapi.xlCanSetChannelTransceiver(portHandle, accessMask, type, lineMode, resNet))

    def xlCanSetChannelParams(self, portHandle, accessMask, pChipParams):
        """XLportHandle portHandle, XLaccess accessMask, XLchipParams* pChipParams"""
        self.vxlapi.xlCanSetChannelParams.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XLchipParams)]
        return XLstatus(self.vxlapi.xlCanSetChannelParams(portHandle, accessMask, pChipParams))

    def xlCanSetChannelParamsC200(self, portHandle, accessMask, btr0, btr1):
        """XLportHandle portHandle, XLaccess accessMask, unsigned char btr0, unsigned char btr1"""
        self.vxlapi.xlCanSetChannelParamsC200.argtypes = [XLportHandle, XLaccess, ctypes.c_ubyte, ctypes.c_ubyte]
        return XLstatus(self.vxlapi.xlCanSetChannelParamsC200(portHandle, accessMask, btr0, btr1))

    def xlCanSetChannelBitrate(self, portHandle, accessMask, bitrate):
        """XLportHandle portHandle, XLaccess accessMask, unsigned long bitrate"""
        self.vxlapi.xlCanSetChannelBitrate.argtypes = [XLportHandle, XLaccess, ctypes.c_ulong]
        return XLstatus(self.vxlapi.xlCanSetChannelBitrate(portHandle, accessMask, bitrate))

    def xlCanFdSetConfiguration(self, portHandle, accessMask, pCanFdConf):
        """XLportHandle portHandle, XLaccess accessMask, XLcanFdConf* pCanFdConf"""
        self.vxlapi.xlCanFdSetConfiguration.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XLcanFdConf)]
        return XLstatus(self.vxlapi.xlCanFdSetConfiguration(portHandle, accessMask, pCanFdConf))

    def xlCanReceive(self, portHandle, pXlCanRxEvt):
        """XLportHandle portHandle, XLcanRxEvent* pXlCanRxEvt"""
        self.vxlapi.xlCanReceive.argtypes = [XLportHandle, ctypes.POINTER(XLcanRxEvent)]
        return XLstatus(self.vxlapi.xlCanReceive(portHandle, pXlCanRxEvt))

    def xlCanTransmitEx(self, portHandle, accessMask, msgCnt, pMsgCntSent, pXlCanTxEvt):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int msgCnt, unsigned int* pMsgCntSent, XLcanTxEvent* pXlCanTxEvt"""
        self.vxlapi.xlCanTransmitEx.argtypes = [XLportHandle, XLaccess, ctypes.c_uint, ctypes.POINTER(ctypes.c_uint), ctypes.POINTER(XLcanTxEvent)]
        return XLstatus(self.vxlapi.xlCanTransmitEx(portHandle, accessMask, msgCnt, pMsgCntSent, pXlCanTxEvt))

    def xlCanSetChannelAcceptance(self, portHandle, accessMask, code, mask, idRange):
        """XLportHandle portHandle, XLaccess accessMask, unsigned long code, unsigned long mask, unsigned int idRange"""
        self.vxlapi.xlCanSetChannelAcceptance.argtypes = [XLportHandle, XLaccess, ctypes.c_ulong, ctypes.c_ulong, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlCanSetChannelAcceptance(portHandle, accessMask, code, mask, idRange))

    def xlCanAddAcceptanceRange(self, portHandle, accessMask, first_id, last_id):
        """XLportHandle portHandle, XLaccess accessMask, unsigned long first_id, unsigned long last_id"""
        self.vxlapi.xlCanAddAcceptanceRange.argtypes = [XLportHandle, XLaccess, ctypes.c_ulong, ctypes.c_ulong]
        return XLstatus(self.vxlapi.xlCanAddAcceptanceRange(portHandle, accessMask, first_id, last_id))

    def xlCanRemoveAcceptanceRange(self, portHandle, accessMask, first_id, last_id):
        """XLportHandle portHandle, XLaccess accessMask, unsigned long first_id, unsigned long last_id"""
        self.vxlapi.xlCanRemoveAcceptanceRange.argtypes = [XLportHandle, XLaccess, ctypes.c_ulong, ctypes.c_ulong]
        return XLstatus(self.vxlapi.xlCanRemoveAcceptanceRange(portHandle, accessMask, first_id, last_id))

    def xlCanResetAcceptance(self, portHandle, accessMask, idRange):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int idRange"""
        self.vxlapi.xlCanResetAcceptance.argtypes = [XLportHandle, XLaccess, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlCanResetAcceptance(portHandle, accessMask, idRange))

    def xlCanRequestChipState(self, portHandle, accessMask):
        """XLportHandle portHandle, XLaccess accessMask"""
        self.vxlapi.xlCanRequestChipState.argtypes = [XLportHandle, XLaccess]
        return XLstatus(self.vxlapi.xlCanRequestChipState(portHandle, accessMask))

    def xlCanTransmit(self, portHandle, accessMask, pEventCount, pEvents):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int *pEventCount, void *pEvents"""
        self.vxlapi.xlCanTransmit.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(ctypes.c_uint), ctypes.c_void_p]
        return XLstatus(self.vxlapi.xlCanTransmit(portHandle, accessMask, pEventCount, pEvents))

    def xlSetGlobalTimeSync(self, newValue, previousValue):
        """unsigned long newValue, unsigned long *previousValue"""
        self.vxlapi.xlSetGlobalTimeSync.argtypes = [ctypes.c_ulong, ctypes.POINTER(ctypes.c_ulong)]
        return XLstatus(self.vxlapi.xlSetGlobalTimeSync(newValue, previousValue))

    def xlCheckLicense(self, portHandle, accessMask, protectionCode):
        """XLportHandle portHandle, XLaccess accessMask, unsigned long protectionCode"""
        self.vxlapi.xlCheckLicense.argtypes = [XLportHandle, XLaccess, ctypes.c_ulong]
        return XLstatus(self.vxlapi.xlCheckLicense(portHandle, accessMask, protectionCode))

    def xlGetLicenseInfo(self, channelMask, pLicInfoArray, licInfoArraySize):
        """XLaccess channelMask, XLlicenseInfo *pLicInfoArray, unsigned int licInfoArraySize"""
        self.vxlapi.xlGetLicenseInfo.argtypes = [XLaccess, ctypes.POINTER(XLlicenseInfo), ctypes.c_uint]
        return XLstatus(self.vxlapi.xlGetLicenseInfo(channelMask, pLicInfoArray, licInfoArraySize))

    def xlLinSetChannelParams(self, portHandle, accessMask, vStatPar):
        """XLportHandle portHandle, XLaccess accessMask, XLlinStatPar vStatPar"""
        self.vxlapi.xlLinSetChannelParams.argtypes = [XLportHandle, XLaccess, XLlinStatPar]
        return XLstatus(self.vxlapi.xlLinSetChannelParams(portHandle, accessMask, vStatPar))

    def xlLinSetDLC(self, portHandle, accessMask, dlc):
        """XLportHandle portHandle, XLaccess accessMask, unsigned char dlc[64]"""
        self.vxlapi.xlLinSetDLC.argtypes = [XLportHandle, XLaccess, ctypes.c_ubyte * 64]
        return XLstatus(self.vxlapi.xlLinSetDLC(portHandle, accessMask, dlc))

    def xlLinSetSlave(self, portHandle, accessMask, linId, data, dlc, checksum):
        """XLportHandle portHandle, XLaccess accessMask, unsigned char linId, unsigned char data[8], unsigned char dlc, unsigned short checksum"""
        self.vxlapi.xlLinSetSlave.argtypes = [XLportHandle, XLaccess, ctypes.c_ubyte, ctypes.c_ubyte * 8, ctypes.c_ubyte, ctypes.c_ushort]
        return XLstatus(self.vxlapi.xlLinSetSlave(portHandle, accessMask, linId, data, dlc, checksum))

    def xlLinSendRequest(self, portHandle, accessMask, linId, flags):
        """XLportHandle portHandle, XLaccess accessMask, unsigned char linId, unsigned int flags"""
        self.vxlapi.xlLinSendRequest.argtypes = [XLportHandle, XLaccess, ctypes.c_ubyte, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlLinSendRequest(portHandle, accessMask, linId, flags))

    def xlLinSetSleepMode(self, portHandle, accessMask, flags, linId):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int flags, unsigned char linId"""
        self.vxlapi.xlLinSetSleepMode.argtypes = [XLportHandle, XLaccess, ctypes.c_uint, ctypes.c_ubyte]
        return XLstatus(self.vxlapi.xlLinSetSleepMode(portHandle, accessMask, flags, linId))

    def xlLinWakeUp(self, portHandle, accessMask):
        """XLportHandle portHandle, XLaccess accessMask"""
        self.vxlapi.xlLinWakeUp.argtypes = [XLportHandle, XLaccess]
        return XLstatus(self.vxlapi.xlLinWakeUp(portHandle, accessMask))

    def xlLinSetChecksum(self, portHandle, accessMask, checksum):
        """XLportHandle portHandle, XLaccess accessMask, unsigned char checksum[60]"""
        self.vxlapi.xlLinSetChecksum.argtypes = [XLportHandle, XLaccess, ctypes.c_ubyte * 60]
        return XLstatus(self.vxlapi.xlLinSetChecksum(portHandle, accessMask, checksum))

    def xlLinSwitchSlave(self, portHandle, accessMask, linID, mode):
        """XLportHandle portHandle, XLaccess accessMask, unsigned char linID, unsigned char mode"""
        self.vxlapi.xlLinSwitchSlave.argtypes = [XLportHandle, XLaccess, ctypes.c_ubyte, ctypes.c_ubyte]
        return XLstatus(self.vxlapi.xlLinSwitchSlave(portHandle, accessMask, linID, mode))

    def xlDAIOSetPWMOutput(self, portHandle, accessMask, frequency, value):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int frequency, unsigned int value"""
        self.vxlapi.xlLinSwitchSlave.argtypes = [XLportHandle, XLaccess, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlDAIOSetPWMOutput(portHandle, accessMask, frequency, value))

    def xlDAIOSetDigitalOutput(self, portHandle, accessMask, outputMask, valuePattern):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int outputMask, unsigned int valuePattern"""
        self.vxlapi.xlLinSwitchSlave.argtypes = [XLportHandle, XLaccess, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlDAIOSetDigitalOutput(portHandle, accessMask, outputMask, valuePattern))

    def xlDAIOSetAnalogOutput(self, portHandle, accessMask, analogLine1, analogLine2, analogLine3, analogLine4):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int analogLine1, unsigned int analogLine2, unsigned int analogLine3, unsigned int analogLine4"""
        self.vxlapi.xlLinSwitchSlave.argtypes = [XLportHandle, XLaccess, ctypes.c_uint, ctypes.c_uint, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlDAIOSetAnalogOutput(portHandle, accessMask, analogLine1, analogLine2, analogLine3, analogLine4))

    def xlDAIORequestMeasurement(self, portHandle, accessMask):
        """XLportHandle portHandle, XLaccess accessMask"""
        self.vxlapi.xlLinSwitchSlave.argtypes = [XLportHandle, XLaccess]
        return XLstatus(self.vxlapi.xlDAIORequestMeasurement(portHandle, accessMask))

    def xlDAIOSetDigitalParameters(self, portHandle, accessMask, inputMask, outputMask):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int inputMask, unsigned int outputMask"""
        self.vxlapi.xlLinSwitchSlave.argtypes = [XLportHandle, XLaccess, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlDAIOSetDigitalParameters(portHandle, accessMask, inputMask, outputMask))

    def xlDAIOSetAnalogParameters(self, portHandle, accessMask, inputMask, outputMask, highRangeMask):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int inputMask, unsigned int outputMask, unsigned int highRangeMask"""
        self.vxlapi.xlLinSwitchSlave.argtypes = [XLportHandle, XLaccess, ctypes.c_uint, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlDAIOSetAnalogParameters(portHandle, accessMask, inputMask, outputMask, highRangeMask))

    def xlDAIOSetAnalogTrigger(self, portHandle, accessMask, triggerMask, triggerLevel, triggerEventMode):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int triggerMask, unsigned int triggerLevel, unsigned int triggerEventMode"""
        self.vxlapi.xlLinSwitchSlave.argtypes = [XLportHandle, XLaccess, ctypes.c_uint, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlDAIOSetAnalogTrigger(portHandle, accessMask, triggerMask, triggerLevel, triggerEventMode))

    def xlDAIOSetMeasurementFrequency(self, portHandle, accessMask, measurementInterval):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int measurementInterval"""
        self.vxlapi.xlLinSwitchSlave.argtypes = [XLportHandle, XLaccess, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlDAIOSetMeasurementFrequency(portHandle, accessMask, measurementInterval))

    def xlDAIOSetDigitalTrigger(self, portHandle, accessMask, triggerMask):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int triggerMask"""
        self.vxlapi.xlLinSwitchSlave.argtypes = [XLportHandle, XLaccess, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlDAIOSetDigitalTrigger(portHandle, accessMask, triggerMask))

    def xlMostReceive(self, portHandle, pEventBuffer):
        """XLportHandle portHandle, XLmostEvent* pEventBuffer"""
        self.vxlapi.xlMostReceive.argtypes = [XLportHandle, ctypes.POINTER(XLmostEvent)]
        return XLstatus(self.vxlapi.xlMostReceive(portHandle, pEventBuffer))

    def xlMostSwitchEventSources(self, portHandle, accessMask, userHandle, sourceMask):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned short sourceMask"""
        self.vxlapi.xlMostSwitchEventSources.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ushort]
        return XLstatus(self.vxlapi.xlMostSwitchEventSources(portHandle, accessMask, userHandle, sourceMask))

    def xlMostSetAllBypass(self, portHandle, accessMask, userHandle, bypassMode):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned char bypassMode"""
        self.vxlapi.xlMostSetAllBypass.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ubyte]
        return XLstatus(self.vxlapi.xlMostSetAllBypass(portHandle, accessMask, userHandle, bypassMode))

    def xlMostGetAllBypass(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMostGetAllBypass.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMostGetAllBypass(portHandle, accessMask, userHandle))

    def xlMostSetTimingMode(self, portHandle, accessMask, userHandle, timingMode):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned char timingMode"""
        self.vxlapi.xlMostSetTimingMode.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ubyte]
        return XLstatus(self.vxlapi.xlMostSetTimingMode(portHandle, accessMask, userHandle, timingMode))

    def xlMostGetTimingMode(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMostGetTimingMode.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMostGetTimingMode(portHandle, accessMask, userHandle))

    def xlMostSetFrequency(self, portHandle, accessMask, userHandle, frequency):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned short frequency"""
        self.vxlapi.xlMostSetFrequency.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ushort]
        return XLstatus(self.vxlapi.xlMostSetFrequency(portHandle, accessMask, userHandle, frequency))

    def xlMostGetFrequency(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMostGetFrequency.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMostGetFrequency(portHandle, accessMask, userHandle))

    def xlMostWriteRegister(self, portHandle, accessMask, userHandle, adr, numBytes, data):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned short adr, unsigned char numBytes, unsigned char data[16]"""
        self.vxlapi.xlMostWriteRegister.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ushort, ctypes.c_ubyte, ctypes.c_ubyte * 16]
        return XLstatus(self.vxlapi.xlMostWriteRegister(portHandle, accessMask, userHandle, adr, numBytes, data))

    def xlMostReadRegister(self, portHandle, accessMask, userHandle, adr, numBytes):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned short adr, unsigned char numBytes"""
        self.vxlapi.xlMostReadRegister.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ushort, ctypes.c_ubyte]
        return XLstatus(self.vxlapi.xlMostReadRegister(portHandle, accessMask, userHandle, adr, numBytes))

    def xlMostWriteRegisterBit(self, portHandle, accessMask, userHandle, adr, mask, value):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned short adr, unsigned char mask, unsigned char value"""
        self.vxlapi.xlMostWriteRegisterBit.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ushort, ctypes.c_ubyte, ctypes.c_ubyte]
        return XLstatus(self.vxlapi.xlMostWriteRegisterBit(portHandle, accessMask, userHandle, adr, mask, value))

    def xlMostCtrlTransmit(self, portHandle, accessMask, userHandle, pCtrlMsg):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmostCtrlMsg* pCtrlMsg"""
        self.vxlapi.xlMostCtrlTransmit.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmostCtrlMsg)]
        return XLstatus(self.vxlapi.xlMostCtrlTransmit(portHandle, accessMask, userHandle, pCtrlMsg))

    def xlMostAsyncTransmit(self, portHandle, accessMask, userHandle, pAsyncMsg):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmostAsyncMsg* pAsyncMsg"""
        self.vxlapi.xlMostAsyncTransmit.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmostAsyncMsg)]
        return XLstatus(self.vxlapi.xlMostAsyncTransmit(portHandle, accessMask, userHandle, pAsyncMsg))

    def xlMostSyncGetAllocTable(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMostSyncGetAllocTable.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMostSyncGetAllocTable(portHandle, accessMask, userHandle))

    def xlMostCtrlSyncAudio(self, portHandle, accessMask, userHandle, channel, device, mode):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int channel[4], unsigned int device, unsigned int mode"""
        self.vxlapi.xlMostCtrlSyncAudio.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint * 4, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMostCtrlSyncAudio(portHandle, accessMask, userHandle, channel, device, mode))

    def xlMostCtrlSyncAudioEx(self, portHandle, accessMask, userHandle, channel, device, mode):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int channel[16], unsigned int device, unsigned int mode"""
        self.vxlapi.xlMostCtrlSyncAudioEx.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint * 16, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMostCtrlSyncAudioEx(portHandle, accessMask, userHandle, channel, device, mode))

    def xlMostSyncVolume(self, portHandle, accessMask, userHandle, device, volume):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int device, unsigned char volume"""
        self.vxlapi.xlMostSyncVolume.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.c_ubyte]
        return XLstatus(self.vxlapi.xlMostSyncVolume(portHandle, accessMask, userHandle, device, volume))

    def xlMostSyncMute(self, portHandle, accessMask, userHandle, device, mute):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int device, unsigned char mute"""
        self.vxlapi.xlMostSyncMute.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.c_ubyte]
        return XLstatus(self.vxlapi.xlMostSyncMute(portHandle, accessMask, userHandle, device, mute))

    def xlMostSyncGetVolumeStatus(self, portHandle, accessMask, userHandle, device):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int device"""
        self.vxlapi.xlMostSyncGetVolumeStatus.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMostSyncGetVolumeStatus(portHandle, accessMask, userHandle, device))

    def xlMostSyncGetMuteStatus(self, portHandle, accessMask, userHandle, device):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int device"""
        self.vxlapi.xlMostSyncGetMuteStatus.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMostSyncGetMuteStatus(portHandle, accessMask, userHandle, device))

    def xlMostGetRxLight(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMostGetRxLight.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMostGetRxLight(portHandle, accessMask, userHandle))

    def xlMostSetTxLight(self, portHandle, accessMask, userHandle, txLight):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned char txLight"""
        self.vxlapi.xlMostSetTxLight.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ubyte]
        return XLstatus(self.vxlapi.xlMostSetTxLight(portHandle, accessMask, userHandle, txLight))

    def xlMostGetTxLight(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMostGetTxLight.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMostGetTxLight(portHandle, accessMask, userHandle))

    def xlMostSetLightPower(self, portHandle, accessMask, userHandle, attenuation):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned char attenuation"""
        self.vxlapi.xlMostSetLightPower.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ubyte]
        return XLstatus(self.vxlapi.xlMostSetLightPower(portHandle, accessMask, userHandle, attenuation))

    def xlMostGetLockStatus(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMostGetLockStatus.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMostGetLockStatus(portHandle, accessMask, userHandle))

    def xlMostGenerateLightError(self, portHandle, accessMask, userHandle, lightOffTime, lightOnTime, repeat):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned long lightOffTime, unsigned long lightOnTime, unsigned short repeat"""
        self.vxlapi.xlMostGenerateLightError.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ulong, ctypes.c_ulong, ctypes.c_ushort]
        return XLstatus(self.vxlapi.xlMostGenerateLightError(portHandle, accessMask, userHandle, lightOffTime, lightOnTime, repeat))

    def xlMostGenerateLockError(self, portHandle, accessMask, userHandle, unmodTime, modTime, repeat):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned long unmodTime, unsigned long modTime, unsigned short repeat"""
        self.vxlapi.xlMostGenerateLockError.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ulong, ctypes.c_ulong, ctypes.c_ushort]
        return XLstatus(self.vxlapi.xlMostGenerateLockError(portHandle, accessMask, userHandle, unmodTime, modTime, repeat))

    def xlMostCtrlRxBuffer(self, portHandle, accessMask, userHandle, bufferMode):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned short bufferMode"""
        self.vxlapi.xlMostCtrlRxBuffer.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ushort]
        return XLstatus(self.vxlapi.xlMostCtrlRxBuffer(portHandle, accessMask, userHandle, bufferMode))

    def xlMostTwinklePowerLed(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMostTwinklePowerLed.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMostTwinklePowerLed(portHandle, accessMask, userHandle))

    def xlMostCtrlConfigureBusload(self, portHandle, accessMask, userHandle, pCtrlBusloadConfiguration):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmostCtrlBusloadConfiguration* pCtrlBusloadConfiguration"""
        self.vxlapi.xlMostCtrlConfigureBusload.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmostCtrlBusloadConfiguration)]
        return XLstatus(self.vxlapi.xlMostCtrlConfigureBusload(portHandle, accessMask, userHandle, pCtrlBusloadConfiguration))

    def xlMostCtrlGenerateBusload(self, portHandle, accessMask, userHandle, numberCtrlFrames):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned long numberCtrlFrames"""
        self.vxlapi.xlMostCtrlGenerateBusload.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ulong]
        return XLstatus(self.vxlapi.xlMostCtrlGenerateBusload(portHandle, accessMask, userHandle, numberCtrlFrames))

    def xlMostAsyncConfigureBusload(self, portHandle, accessMask, userHandle, pAsyncBusloadConfiguration):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmostAsyncBusloadConfiguration* pAsyncBusloadConfiguration"""
        self.vxlapi.xlMostAsyncConfigureBusload.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmostAsyncBusloadConfiguration)]
        return XLstatus(self.vxlapi.xlMostAsyncConfigureBusload(portHandle, accessMask, userHandle, pAsyncBusloadConfiguration))

    def xlMostAsyncGenerateBusload(self, portHandle, accessMask, userHandle, numberAsyncFrames):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned long numberAsyncFrames"""
        self.vxlapi.xlMostAsyncGenerateBusload.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ulong]
        return XLstatus(self.vxlapi.xlMostAsyncGenerateBusload(portHandle, accessMask, userHandle, numberAsyncFrames))

    def xlMostStreamOpen(self, portHandle, accessMask, userHandle, pStreamOpen):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmostStreamOpen* pStreamOpen"""
        self.vxlapi.xlMostStreamOpen.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmostStreamOpen)]
        return XLstatus(self.vxlapi.xlMostStreamOpen(portHandle, accessMask, userHandle, pStreamOpen))

    def xlMostStreamClose(self, portHandle, accessMask, userHandle, streamHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int streamHandle"""
        self.vxlapi.xlMostStreamClose.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMostStreamClose(portHandle, accessMask, userHandle, streamHandle))

    def xlMostStreamStart(self, portHandle, accessMask, userHandle, streamHandle, syncChannels):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int streamHandle, unsigned char syncChannels[60]"""
        self.vxlapi.xlMostStreamStart.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.c_ubyte * 60]
        return XLstatus(self.vxlapi.xlMostStreamStart(portHandle, accessMask, userHandle, streamHandle, syncChannels))

    def xlMostStreamStop(self, portHandle, accessMask, userHandle, streamHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int streamHandle"""
        self.vxlapi.xlMostStreamStop.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMostStreamStop(portHandle, accessMask, userHandle, streamHandle))

    def xlMostStreamBufferAllocate(self, portHandle, accessMask, userHandle, streamHandle, ppBuffer, pBufferSize):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int streamHandle, unsigned char** ppBuffer, unsigned int* pBufferSize"""
        self.vxlapi.xlMostStreamBufferAllocate.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.POINTER(ctypes.c_char_p), ctypes.POINTER(ctypes.c_uint)]
        return XLstatus(self.vxlapi.xlMostStreamBufferAllocate(portHandle, accessMask, userHandle, streamHandle, ppBuffer.encode('ascii'), pBufferSize))

    def xlMostStreamBufferDeallocateAll(self, portHandle, accessMask, userHandle, streamHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int streamHandle"""
        self.vxlapi.xlMostStreamBufferDeallocateAll.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMostStreamBufferDeallocateAll(portHandle, accessMask, userHandle, streamHandle))

    def xlMostStreamBufferSetNext(self, portHandle, accessMask, userHandle, streamHandle, pBuffer, filledBytes):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int streamHandle, unsigned char* pBuffer, unsigned int filledBytes"""
        self.vxlapi.xlMostStreamBufferSetNext.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.POINTER(ctypes.c_ubyte), ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMostStreamBufferSetNext(portHandle, accessMask, userHandle, streamHandle, pBuffer, filledBytes))

    def xlMostStreamGetInfo(self, portHandle, accessMask, userHandle, pStreamInfo):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmostStreamInfo* pStreamInfo"""
        self.vxlapi.xlMostStreamGetInfo.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmostStreamInfo)]
        return XLstatus(self.vxlapi.xlMostStreamGetInfo(portHandle, accessMask, userHandle, pStreamInfo))

    def xlMostStreamBufferClearAll(self, portHandle, accessMask, userHandle, streamHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int streamHandle"""
        self.vxlapi.xlMostStreamBufferClearAll.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMostStreamBufferClearAll(portHandle, accessMask, userHandle, streamHandle))

    def xlFrSetConfiguration(self, portHandle, accessMask, pxlClusterConfig):
        """XLportHandle portHandle, XLaccess accessMask, XLfrClusterConfig    *pxlClusterConfig"""
        self.vxlapi.xlFrSetConfiguration.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XLfrClusterConfig)]
        return XLstatus(self.vxlapi.xlFrSetConfiguration(portHandle, accessMask, pxlClusterConfig))

    def xlFrGetChannelConfiguration(self, portHandle, accessMask, pxlFrChannelConfig):
        """XLportHandle portHandle, XLaccess accessMask, XLfrChannelConfig* pxlFrChannelConfig"""
        self.vxlapi.xlFrGetChannelConfiguration.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XLfrChannelConfig)]
        return XLstatus(self.vxlapi.xlFrGetChannelConfiguration(portHandle, accessMask, pxlFrChannelConfig))

    def xlFrSetMode(self, portHandle, accessMask, pxlFrMode):
        """XLportHandle portHandle, XLaccess accessMask, XLfrMode    *pxlFrMode"""
        self.vxlapi.xlFrSetMode.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XLfrMode)]
        return XLstatus(self.vxlapi.xlFrSetMode(portHandle, accessMask, pxlFrMode))

    def xlFrInitStartupAndSync(self, portHandle, accessMask, pEventBuffer):
        """XLportHandle portHandle, XLaccess accessMask, XLfrEvent *pEventBuffer"""
        self.vxlapi.xlFrInitStartupAndSync.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XLfrEvent)]
        return XLstatus(self.vxlapi.xlFrInitStartupAndSync(portHandle, accessMask, pEventBuffer))

    def xlFrSetupSymbolWindow(self, portHandle, accessMask, frChannel, symbolWindowMask):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int frChannel, unsigned int symbolWindowMask"""
        self.vxlapi.xlFrSetupSymbolWindow.argtypes = [XLportHandle, XLaccess, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlFrSetupSymbolWindow(portHandle, accessMask, frChannel, symbolWindowMask))

    def xlFrReceive(self, portHandle, pEventBuffer):
        """XLportHandle portHandle, XLfrEvent *pEventBuffer"""
        self.vxlapi.xlFrReceive.argtypes = [XLportHandle, ctypes.POINTER(XLfrEvent)]
        return XLstatus(self.vxlapi.xlFrReceive(portHandle, pEventBuffer))

    def xlFrTransmit(self, portHandle, accessMask, pEventBuffer):
        """XLportHandle portHandle, XLaccess accessMask, XLfrEvent *pEventBuffer"""
        self.vxlapi.xlFrTransmit.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XLfrEvent)]
        return XLstatus(self.vxlapi.xlFrTransmit(portHandle, accessMask, pEventBuffer))

    def xlFrSetTransceiverMode(self, portHandle, accessMask, frChannel, mode):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int frChannel, unsigned int mode"""
        self.vxlapi.xlFrSetTransceiverMode.argtypes = [XLportHandle, XLaccess, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlFrSetTransceiverMode(portHandle, accessMask, frChannel, mode))

    def xlFrSendSymbolWindow(self, portHandle, accessMask, symbolWindow):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int symbolWindow"""
        self.vxlapi.xlFrSendSymbolWindow.argtypes = [XLportHandle, XLaccess, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlFrSendSymbolWindow(portHandle, accessMask, symbolWindow))

    def xlFrActivateSpy(self, portHandle, accessMask, mode):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int mode"""
        self.vxlapi.xlFrActivateSpy.argtypes = [XLportHandle, XLaccess, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlFrActivateSpy(portHandle, accessMask, mode))

    def xlFrSetAcceptanceFilter(self, portHandle, accessMask, pAcceptanceFilter):
        """XLportHandle portHandle, XLaccess accessMask, XLfrAcceptanceFilter *pAcceptanceFilter"""
        self.vxlapi.xlFrSetAcceptanceFilter.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XLfrAcceptanceFilter)]
        return XLstatus(self.vxlapi.xlFrSetAcceptanceFilter(portHandle, accessMask, pAcceptanceFilter))

    def xlGetRemoteDriverConfig(self, pDriverConfig):
        """XLdriverConfig *pDriverConfig"""
        self.vxlapi.xlGetRemoteDriverConfig.argtypes = [ctypes.POINTER(XLdriverConfig)]
        return XLstatus(self.vxlapi.xlGetRemoteDriverConfig(pDriverConfig))

    def xlGetRemoteDeviceInfo(self, deviceList, nbrOfRemoteDevices, netSearch):
        """XLremoteDeviceInfo  **deviceList, unsigned int *nbrOfRemoteDevices, unsigned int netSearch"""
        self.vxlapi.xlGetRemoteDeviceInfo.argtypes = [ctypes.POINTER(ctypes.POINTER(XLremoteDeviceInfo)), ctypes.POINTER(ctypes.c_uint), ctypes.c_uint]
        return XLstatus(self.vxlapi.xlGetRemoteDeviceInfo(deviceList, nbrOfRemoteDevices, netSearch))

    def xlReleaseRemoteDeviceInfo(self, deviceList):
        """XLremoteDeviceInfo  **deviceList"""
        self.vxlapi.xlReleaseRemoteDeviceInfo.argtypes = [ctypes.POINTER(ctypes.POINTER(XLremoteDeviceInfo))]
        return XLstatus(self.vxlapi.xlReleaseRemoteDeviceInfo(deviceList))

    def xlAddRemoteDevice(self, remoteHandle, deviceMask, flags):
        """XLremoteHandle remoteHandle, XLdeviceAccess deviceMask, unsigned int flags"""
        self.vxlapi.xlAddRemoteDevice.argtypes = [XLremoteHandle, XLdeviceAccess, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlAddRemoteDevice(remoteHandle, deviceMask, flags))

    def xlRemoveRemoteDevice(self, remoteHandle, deviceMask, flags):
        """XLremoteHandle remoteHandle, XLdeviceAccess deviceMask, unsigned int flags"""
        self.vxlapi.xlRemoveRemoteDevice.argtypes = [XLremoteHandle, XLdeviceAccess, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlRemoveRemoteDevice(remoteHandle, deviceMask, flags))

    def xlUpdateRemoteDeviceInfo(self, deviceList, nbrOfRemoteDevices):
        """XLremoteDeviceInfo *deviceList, unsigned int nbrOfRemoteDevices"""
        self.vxlapi.xlUpdateRemoteDeviceInfo.argtypes = [ctypes.POINTER(XLremoteDeviceInfo), ctypes.c_uint]
        return XLstatus(self.vxlapi.xlUpdateRemoteDeviceInfo(deviceList, nbrOfRemoteDevices))

    def xlGetRemoteHwInfo(self, remoteHandle, hwType, hwIndex, isPresent):
        """XLremoteHandle remoteHandle, int *hwType, int *hwIndex, int *isPresent"""
        self.vxlapi.xlGetRemoteHwInfo.argtypes = [XLremoteHandle, ctypes.POINTER(ctypes.c_int), ctypes.POINTER(ctypes.c_int), ctypes.POINTER(ctypes.c_int)]
        return XLstatus(self.vxlapi.xlGetRemoteHwInfo(remoteHandle, hwType, hwIndex, isPresent))

    def xlRegisterRemoteDevice(self, hwType, ipAddress, flags):
        """int hwType, XLipAddress *ipAddress, unsigned int flags"""
        self.vxlapi.xlRegisterRemoteDevice.argtypes = [ctypes.c_int, ctypes.POINTER(XLipAddress), ctypes.c_uint]
        return XLstatus(self.vxlapi.xlRegisterRemoteDevice(hwType, ipAddress, flags))

    def xlIoSetTriggerMode(self, portHandle, accessMask, pxlDaioTriggerMode):
        """XLportHandle portHandle, XLaccess accessMask, XLdaioTriggerMode* pxlDaioTriggerMode"""
        self.vxlapi.xlIoSetTriggerMode.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XLdaioTriggerMode)]
        return XLstatus(self.vxlapi.xlIoSetTriggerMode(portHandle, accessMask, pxlDaioTriggerMode))

    def xlIoSetDigitalOutput(self, portHandle, accessMask, pxlDaioDigitalParams):
        """XLportHandle portHandle, XLaccess accessMask, XLdaioDigitalParams *pxlDaioDigitalParams"""
        self.vxlapi.xlIoSetDigitalOutput.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XLdaioDigitalParams)]
        return XLstatus(self.vxlapi.xlIoSetDigitalOutput(portHandle, accessMask, pxlDaioDigitalParams))

    def xlIoConfigurePorts(self, portHandle, accessMask, pxlDaioSetPort):
        """XLportHandle portHandle, XLaccess accessMask, XLdaioSetPort *pxlDaioSetPort"""
        self.vxlapi.xlIoConfigurePorts.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XLdaioSetPort)]
        return XLstatus(self.vxlapi.xlIoConfigurePorts(portHandle, accessMask, pxlDaioSetPort))

    def xlIoSetDigInThreshold(self, portHandle, accessMask, level):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int level"""
        self.vxlapi.xlIoSetDigInThreshold.argtypes = [XLportHandle, XLaccess, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlIoSetDigInThreshold(portHandle, accessMask, level))

    def xlIoSetDigOutLevel(self, portHandle, accessMask, level):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int level"""
        self.vxlapi.xlIoSetDigOutLevel.argtypes = [XLportHandle, XLaccess, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlIoSetDigOutLevel(portHandle, accessMask, level))

    def xlIoSetAnalogOutput(self, portHandle, accessMask, pxlDaioAnalogParams):
        """XLportHandle portHandle, XLaccess accessMask, XLdaioAnalogParams *pxlDaioAnalogParams"""
        self.vxlapi.xlIoSetAnalogOutput.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XLdaioAnalogParams)]
        return XLstatus(self.vxlapi.xlIoSetAnalogOutput(portHandle, accessMask, pxlDaioAnalogParams))

    def xlIoStartSampling(self, portHandle, accessMask, portTypeMask):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int portTypeMask"""
        self.vxlapi.xlIoStartSampling.argtypes = [XLportHandle, XLaccess, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlIoStartSampling(portHandle, accessMask, portTypeMask))

    def xlMost150Receive(self, portHandle, pEventBuffer):
        """XLportHandle portHandle, XLmost150event* pEventBuffer"""
        self.vxlapi.xlMost150Receive.argtypes = [XLportHandle, ctypes.POINTER(XLmost150event)]
        return XLstatus(self.vxlapi.xlMost150Receive(portHandle, pEventBuffer))

    def xlMost150TwinklePowerLed(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMost150TwinklePowerLed.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMost150TwinklePowerLed(portHandle, accessMask, userHandle))

    def xlMost150SwitchEventSources(self, portHandle, accessMask, userHandle, sourceMask):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int sourceMask"""
        self.vxlapi.xlMost150SwitchEventSources.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SwitchEventSources(portHandle, accessMask, userHandle, sourceMask))

    def xlMost150SetDeviceMode(self, portHandle, accessMask, userHandle, deviceMode):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int deviceMode"""
        self.vxlapi.xlMost150SetDeviceMode.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SetDeviceMode(portHandle, accessMask, userHandle, deviceMode))

    def xlMost150GetDeviceMode(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMost150GetDeviceMode.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMost150GetDeviceMode(portHandle, accessMask, userHandle))

    def xlMost150SetSPDIFMode(self, portHandle, accessMask, userHandle, spdifMode):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int spdifMode"""
        self.vxlapi.xlMost150SetSPDIFMode.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SetSPDIFMode(portHandle, accessMask, userHandle, spdifMode))

    def xlMost150GetSPDIFMode(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMost150GetSPDIFMode.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMost150GetSPDIFMode(portHandle, accessMask, userHandle))

    def xlMost150SetSpecialNodeInfo(self, portHandle, accessMask, userHandle, pSpecialNodeInfo):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmost150SetSpecialNodeInfo *pSpecialNodeInfo"""
        self.vxlapi.xlMost150SetSpecialNodeInfo.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmost150SetSpecialNodeInfo)]
        return XLstatus(self.vxlapi.xlMost150SetSpecialNodeInfo(portHandle, accessMask, userHandle, pSpecialNodeInfo))

    def xlMost150GetSpecialNodeInfo(self, portHandle, accessMask, userHandle, requestMask):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int requestMask"""
        self.vxlapi.xlMost150GetSpecialNodeInfo.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150GetSpecialNodeInfo(portHandle, accessMask, userHandle, requestMask))

    def xlMost150SetFrequency(self, portHandle, accessMask, userHandle, frequency):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int frequency"""
        self.vxlapi.xlMost150SetFrequency.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SetFrequency(portHandle, accessMask, userHandle, frequency))

    def xlMost150GetFrequency(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMost150GetFrequency.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMost150GetFrequency(portHandle, accessMask, userHandle))

    def xlMost150CtrlTransmit(self, portHandle, accessMask, userHandle, pCtrlTxMsg):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmost150CtrlTxMsg *pCtrlTxMsg"""
        self.vxlapi.xlMost150CtrlTransmit.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmost150CtrlTxMsg)]
        return XLstatus(self.vxlapi.xlMost150CtrlTransmit(portHandle, accessMask, userHandle, pCtrlTxMsg))

    def xlMost150AsyncTransmit(self, portHandle, accessMask, userHandle, pAsyncTxMsg):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmost150AsyncTxMsg *pAsyncTxMsg"""
        self.vxlapi.xlMost150AsyncTransmit.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmost150AsyncTxMsg)]
        return XLstatus(self.vxlapi.xlMost150AsyncTransmit(portHandle, accessMask, userHandle, pAsyncTxMsg))

    def xlMost150EthernetTransmit(self, portHandle, accessMask, userHandle, pEthernetTxMsg):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmost150EthernetTxMsg *pEthernetTxMsg"""
        self.vxlapi.xlMost150EthernetTransmit.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmost150EthernetTxMsg)]
        return XLstatus(self.vxlapi.xlMost150EthernetTransmit(portHandle, accessMask, userHandle, pEthernetTxMsg))

    def xlMost150GetSystemLockFlag(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMost150GetSystemLockFlag.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMost150GetSystemLockFlag(portHandle, accessMask, userHandle))

    def xlMost150GetShutdownFlag(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMost150GetShutdownFlag.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMost150GetShutdownFlag(portHandle, accessMask, userHandle))

    def xlMost150Shutdown(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMost150Shutdown.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMost150Shutdown(portHandle, accessMask, userHandle))

    def xlMost150Startup(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMost150Startup.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMost150Startup(portHandle, accessMask, userHandle))

    def xlMost150SyncGetAllocTable(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMost150SyncGetAllocTable.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMost150SyncGetAllocTable(portHandle, accessMask, userHandle))

    def xlMost150CtrlSyncAudio(self, portHandle, accessMask, userHandle, pSyncAudioParameter):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmost150SyncAudioParameter *pSyncAudioParameter"""
        self.vxlapi.xlMost150CtrlSyncAudio.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmost150SyncAudioParameter)]
        return XLstatus(self.vxlapi.xlMost150CtrlSyncAudio(portHandle, accessMask, userHandle, pSyncAudioParameter))

    def xlMost150SyncSetVolume(self, portHandle, accessMask, userHandle, device, volume):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int device, unsigned int volume"""
        self.vxlapi.xlMost150SyncSetVolume.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SyncSetVolume(portHandle, accessMask, userHandle, device, volume))

    def xlMost150SyncGetVolume(self, portHandle, accessMask, userHandle, device):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int device"""
        self.vxlapi.xlMost150SyncGetVolume.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SyncGetVolume(portHandle, accessMask, userHandle, device))

    def xlMost150SyncSetMute(self, portHandle, accessMask, userHandle, device, mute):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int device, unsigned int mute"""
        self.vxlapi.xlMost150SyncSetMute.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SyncSetMute(portHandle, accessMask, userHandle, device, mute))

    def xlMost150SyncGetMute(self, portHandle, accessMask, userHandle, device):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int device"""
        self.vxlapi.xlMost150SyncGetMute.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SyncGetMute(portHandle, accessMask, userHandle, device))

    def xlMost150GetRxLightLockStatus(self, portHandle, accessMask, userHandle, fromSpy):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int fromSpy"""
        self.vxlapi.xlMost150GetRxLightLockStatus.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150GetRxLightLockStatus(portHandle, accessMask, userHandle, fromSpy))

    def xlMost150SetTxLight(self, portHandle, accessMask, userHandle, txLight):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int txLight"""
        self.vxlapi.xlMost150SetTxLight.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SetTxLight(portHandle, accessMask, userHandle, txLight))

    def xlMost150GetTxLight(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMost150GetTxLight.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMost150GetTxLight(portHandle, accessMask, userHandle))

    def xlMost150SetTxLightPower(self, portHandle, accessMask, userHandle, attenuation):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int attenuation"""
        self.vxlapi.xlMost150SetTxLightPower.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SetTxLightPower(portHandle, accessMask, userHandle, attenuation))

    def xlMost150GenerateLightError(self, portHandle, accessMask, userHandle, lightOffTime, lightOnTime, repeat):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int lightOffTime, unsigned int lightOnTime, unsigned int repeat"""
        self.vxlapi.xlMost150GenerateLightError.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150GenerateLightError(portHandle, accessMask, userHandle, lightOffTime, lightOnTime, repeat))

    def xlMost150GenerateLockError(self, portHandle, accessMask, userHandle, unlockTime, lockTime, repeat):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int unlockTime, unsigned int lockTime, unsigned int repeat"""
        self.vxlapi.xlMost150GenerateLockError.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150GenerateLockError(portHandle, accessMask, userHandle, unlockTime, lockTime, repeat))

    def xlMost150ConfigureRxBuffer(self, portHandle, accessMask, userHandle, bufferType, bufferMode):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int bufferType, unsigned int bufferMode"""
        self.vxlapi.xlMost150ConfigureRxBuffer.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150ConfigureRxBuffer(portHandle, accessMask, userHandle, bufferType, bufferMode))

    def xlMost150CtrlConfigureBusload(self, portHandle, accessMask, userHandle, pCtrlBusLoad):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmost150CtrlBusloadConfig *pCtrlBusLoad"""
        self.vxlapi.xlMost150CtrlConfigureBusload.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmost150CtrlBusloadConfig)]
        return XLstatus(self.vxlapi.xlMost150CtrlConfigureBusload(portHandle, accessMask, userHandle, pCtrlBusLoad))

    def xlMost150CtrlGenerateBusload(self, portHandle, accessMask, userHandle, numberCtrlFrames):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned long numberCtrlFrames"""
        self.vxlapi.xlMost150CtrlGenerateBusload.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ulong]
        return XLstatus(self.vxlapi.xlMost150CtrlGenerateBusload(portHandle, accessMask, userHandle, numberCtrlFrames))

    def xlMost150AsyncConfigureBusload(self, portHandle, accessMask, userHandle, pAsyncBusLoad):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmost150AsyncBusloadConfig *pAsyncBusLoad"""
        self.vxlapi.xlMost150AsyncConfigureBusload.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmost150AsyncBusloadConfig)]
        return XLstatus(self.vxlapi.xlMost150AsyncConfigureBusload(portHandle, accessMask, userHandle, pAsyncBusLoad))

    def xlMost150AsyncGenerateBusload(self, portHandle, accessMask, userHandle, numberAsyncPackets):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned long numberAsyncPackets"""
        self.vxlapi.xlMost150AsyncGenerateBusload.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_ulong]
        return XLstatus(self.vxlapi.xlMost150AsyncGenerateBusload(portHandle, accessMask, userHandle, numberAsyncPackets))

    def xlMost150SetECLLine(self, portHandle, accessMask, userHandle, eclLineState):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int eclLineState"""
        self.vxlapi.xlMost150SetECLLine.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SetECLLine(portHandle, accessMask, userHandle, eclLineState))

    def xlMost150SetECLTermination(self, portHandle, accessMask, userHandle, eclLineTermination):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int eclLineTermination"""
        self.vxlapi.xlMost150SetECLTermination.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SetECLTermination(portHandle, accessMask, userHandle, eclLineTermination))

    def xlMost150GetECLInfo(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMost150GetECLInfo.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMost150GetECLInfo(portHandle, accessMask, userHandle))

    def xlMost150StreamOpen(self, portHandle, accessMask, userHandle, pStreamOpen):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmost150StreamOpen* pStreamOpen"""
        self.vxlapi.xlMost150StreamOpen.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmost150StreamOpen)]
        return XLstatus(self.vxlapi.xlMost150StreamOpen(portHandle, accessMask, userHandle, pStreamOpen))

    def xlMost150StreamClose(self, portHandle, accessMask, userHandle, streamHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int streamHandle"""
        self.vxlapi.xlMost150StreamClose.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150StreamClose(portHandle, accessMask, userHandle, streamHandle))

    def xlMost150StreamStart(self, portHandle, accessMask, userHandle, streamHandle, numConnLabels, pConnLabels):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int streamHandle, unsigned int numConnLabels, unsigned int* pConnLabels"""
        self.vxlapi.xlMost150StreamStart.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.c_uint, ctypes.POINTER(ctypes.c_uint)]
        return XLstatus(self.vxlapi.xlMost150StreamStart(portHandle, accessMask, userHandle, streamHandle, numConnLabels, pConnLabels))

    def xlMost150StreamStop(self, portHandle, accessMask, userHandle, streamHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int streamHandle"""
        self.vxlapi.xlMost150StreamStop.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150StreamStop(portHandle, accessMask, userHandle, streamHandle))

    def xlMost150StreamTransmitData(self, portHandle, accessMask, userHandle, streamHandle, pBuffer, pNumberOfBytes):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int streamHandle, unsigned char* pBuffer, unsigned int* pNumberOfBytes"""
        self.vxlapi.xlMost150StreamTransmitData.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.POINTER(ctypes.c_ubyte), ctypes.POINTER(ctypes.c_uint)]
        return XLstatus(self.vxlapi.xlMost150StreamTransmitData(portHandle, accessMask, userHandle, streamHandle, pBuffer, pNumberOfBytes))

    def xlMost150StreamClearTxFifo(self, portHandle, accessMask, userHandle, streamHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int streamHandle"""
        self.vxlapi.xlMost150StreamClearTxFifo.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150StreamClearTxFifo(portHandle, accessMask, userHandle, streamHandle))

    def xlMost150StreamGetInfo(self, portHandle, accessMask, userHandle, pStreamInfo):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, XLmost150StreamInfo* pStreamInfo"""
        self.vxlapi.xlMost150StreamGetInfo.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(XLmost150StreamInfo)]
        return XLstatus(self.vxlapi.xlMost150StreamGetInfo(portHandle, accessMask, userHandle, pStreamInfo))

    def xlMost150StreamInitRxFifo(self, portHandle, accessMask):
        """XLportHandle portHandle, XLaccess accessMask"""
        self.vxlapi.xlMost150StreamInitRxFifo.argtypes = [XLportHandle, XLaccess]
        return XLstatus(self.vxlapi.xlMost150StreamInitRxFifo(portHandle, accessMask))

    def xlMost150StreamReceiveData(self, portHandle, accessMask, pBuffer, pBufferSize):
        """XLportHandle portHandle, XLaccess accessMask, unsigned char* pBuffer, unsigned int* pBufferSize"""
        self.vxlapi.xlMost150StreamReceiveData.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(ctypes.c_ubyte), ctypes.POINTER(ctypes.c_uint)]
        return XLstatus(self.vxlapi.xlMost150StreamReceiveData(portHandle, accessMask, pBuffer, pBufferSize))

    def xlMost150GenerateBypassStress(self, portHandle, accessMask, userHandle, bypassCloseTime, bypassOpenTime, repeat):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int bypassCloseTime, unsigned int bypassOpenTime, unsigned int repeat"""
        self.vxlapi.xlMost150GenerateBypassStress.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.c_uint, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150GenerateBypassStress(portHandle, accessMask, userHandle, bypassCloseTime, bypassOpenTime, repeat))

    def xlMost150EclConfigureSeq(self, portHandle, accessMask, userHandle, numStates, pEclStates, pEclStatesDuration):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int numStates, unsigned int* pEclStates, unsigned int* pEclStatesDuration"""
        self.vxlapi.xlMost150EclConfigureSeq.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint, ctypes.POINTER(ctypes.c_uint), ctypes.POINTER(ctypes.c_uint)]
        return XLstatus(self.vxlapi.xlMost150EclConfigureSeq(portHandle, accessMask, userHandle, numStates, pEclStates, pEclStatesDuration))

    def xlMost150EclGenerateSeq(self, portHandle, accessMask, userHandle, start):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int start"""
        self.vxlapi.xlMost150EclGenerateSeq.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150EclGenerateSeq(portHandle, accessMask, userHandle, start))

    def xlMost150SetECLGlitchFilter(self, portHandle, accessMask, userHandle, duration):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int duration"""
        self.vxlapi.xlMost150SetECLGlitchFilter.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SetECLGlitchFilter(portHandle, accessMask, userHandle, duration))

    def xlMost150SetSSOResult(self, portHandle, accessMask, userHandle, ssoCUStatus):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int ssoCUStatus"""
        self.vxlapi.xlMost150SetSSOResult.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlMost150SetSSOResult(portHandle, accessMask, userHandle, ssoCUStatus))

    def xlMost150GetSSOResult(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlMost150GetSSOResult.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlMost150GetSSOResult(portHandle, accessMask, userHandle))

    def xlEthSetConfig(self, portHandle, accessMask, userHandle, config):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, const T_XL_ETH_CONFIG *config"""
        self.vxlapi.xlEthSetConfig.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(T_XL_ETH_CONFIG)]
        return XLstatus(self.vxlapi.xlEthSetConfig(portHandle, accessMask, userHandle, config))

    def xlEthGetConfig(self, portHandle, accessMask, userHandle, config):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, T_XL_ETH_CONFIG *config"""
        self.vxlapi.xlEthGetConfig.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(T_XL_ETH_CONFIG)]
        return XLstatus(self.vxlapi.xlEthGetConfig(portHandle, accessMask, userHandle, config))

    def xlEthReceive(self, portHandle, ethEventBuffer):
        """XLportHandle portHandle, T_XL_ETH_EVENT *ethEventBuffer"""
        self.vxlapi.xlEthReceive.argtypes = [XLportHandle, ctypes.POINTER(T_XL_ETH_EVENT)]
        return XLstatus(self.vxlapi.xlEthReceive(portHandle, ethEventBuffer))

    def xlEthSetBypass(self, portHandle, accessMask, userHandle, mode):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, unsigned int mode"""
        self.vxlapi.xlEthSetBypass.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.c_uint]
        return XLstatus(self.vxlapi.xlEthSetBypass(portHandle, accessMask, userHandle, mode))

    def xlEthTwinkleStatusLed(self, portHandle, accessMask, userHandle):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle"""
        self.vxlapi.xlEthTwinkleStatusLed.argtypes = [XLportHandle, XLaccess, XLuserHandle]
        return XLstatus(self.vxlapi.xlEthTwinkleStatusLed(portHandle, accessMask, userHandle))

    def xlEthTransmit(self, portHandle, accessMask, userHandle, data):
        """XLportHandle portHandle, XLaccess accessMask, XLuserHandle userHandle, const T_XL_ETH_DATAFRAME_TX *data"""
        self.vxlapi.xlEthTransmit.argtypes = [XLportHandle, XLaccess, XLuserHandle, ctypes.POINTER(T_XL_ETH_DATAFRAME_TX)]
        return XLstatus(self.vxlapi.xlEthTransmit(portHandle, accessMask, userHandle, data))

    def xlA429Receive(self, portHandle, pXlA429RxEvt):
        """XLportHandle portHandle, XLa429RxEvent* pXlA429RxEvt"""
        self.vxlapi.xlA429Receive.argtypes = [XLportHandle, ctypes.POINTER(XLa429RxEvent)]
        return XLstatus(self.vxlapi.xlA429Receive(portHandle, pXlA429RxEvt))

    def xlA429SetChannelParams(self, portHandle, accessMask, pXlA429Params):
        """XLportHandle portHandle, XLaccess accessMask, XL_A429_PARAMS* pXlA429Params"""
        self.vxlapi.xlA429SetChannelParams.argtypes = [XLportHandle, XLaccess, ctypes.POINTER(XL_A429_PARAMS)]
        return XLstatus(self.vxlapi.xlA429SetChannelParams(portHandle, accessMask, pXlA429Params))

    def xlA429Transmit(self, portHandle, accessMask, msgCnt, pMsgCntSent, pXlA429MsgTx):
        """XLportHandle portHandle, XLaccess accessMask, unsigned int msgCnt, unsigned int* pMsgCntSent, XL_A429_MSG_TX* pXlA429MsgTx"""
        self.vxlapi.xlA429Transmit.argtypes = [XLportHandle, XLaccess, ctypes.c_uint, ctypes.POINTER(ctypes.c_uint), ctypes.POINTER(XL_A429_MSG_TX)]
        return XLstatus(self.vxlapi.xlA429Transmit(portHandle, accessMask, msgCnt, pMsgCntSent, pXlA429MsgTx))

    def xlGetKeymanBoxes(self, boxCount):
        """unsigned int* boxCount"""
        self.vxlapi.xlGetKeymanBoxes.argtypes = [ctypes.POINTER(ctypes.c_uint)]
        return XLstatus(self.vxlapi.xlGetKeymanBoxes(boxCount))

    def xlGetKeymanInfo(self, boxIndex, boxMask, boxSerial, licInfo):
        """unsigned int boxIndex, unsigned int* boxMask, unsigned int* boxSerial, XLuint64* licInfo"""
        self.vxlapi.xlGetKeymanInfo.argtypes = [ctypes.c_uint, ctypes.POINTER(ctypes.c_uint), ctypes.POINTER(ctypes.c_uint), ctypes.POINTER(XLuint64)]
        return XLstatus(self.vxlapi.xlGetKeymanInfo(boxIndex, boxMask, boxSerial, licInfo))
