# coding: utf-8

"""
    OpenBoxes API specification

    [OpenBoxes](https://openboxes.org) is an open-source LMIS application that increases stock visibility, reduces the risk of stock-outs and stock wastage, and offers tools to improve forecasting and traceability.  **Notice** The following API documentation is a work in progress.  ---   # noqa: E501

    OpenAPI spec version: 0.8.17
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Product(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'product_code': 'str',
        'tags': 'list[Tag]',
        'documents': 'list[Document]',
        'product_groups': 'list[ProductGroup]',
        'packages': 'list[ProductPackage]',
        'synonyms': 'list[Synonym]',
        'inventory_levels': 'list[InventoryLevel]',
        'inventory_items': 'list[InventoryItem]',
        'product_suppliers': 'list[ProductSupplier]',
        'product_catalog_items': 'list[ProductCatalogItem]',
        'color': 'object'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'product_code': 'productCode',
        'tags': 'tags',
        'documents': 'documents',
        'product_groups': 'productGroups',
        'packages': 'packages',
        'synonyms': 'synonyms',
        'inventory_levels': 'inventoryLevels',
        'inventory_items': 'inventoryItems',
        'product_suppliers': 'productSuppliers',
        'product_catalog_items': 'productCatalogItems',
        'color': 'color'
    }

    def __init__(self, id=None, name=None, description=None, product_code=None, tags=None, documents=None, product_groups=None, packages=None, synonyms=None, inventory_levels=None, inventory_items=None, product_suppliers=None, product_catalog_items=None, color=None):  # noqa: E501
        """Product - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._name = None
        self._description = None
        self._product_code = None
        self._tags = None
        self._documents = None
        self._product_groups = None
        self._packages = None
        self._synonyms = None
        self._inventory_levels = None
        self._inventory_items = None
        self._product_suppliers = None
        self._product_catalog_items = None
        self._color = None
        self.discriminator = None
        self.id = id
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if product_code is not None:
            self.product_code = product_code
        if tags is not None:
            self.tags = tags
        if documents is not None:
            self.documents = documents
        if product_groups is not None:
            self.product_groups = product_groups
        if packages is not None:
            self.packages = packages
        if synonyms is not None:
            self.synonyms = synonyms
        if inventory_levels is not None:
            self.inventory_levels = inventory_levels
        if inventory_items is not None:
            self.inventory_items = inventory_items
        if product_suppliers is not None:
            self.product_suppliers = product_suppliers
        if product_catalog_items is not None:
            self.product_catalog_items = product_catalog_items
        if color is not None:
            self.color = color

    @property
    def id(self):
        """Gets the id of this Product.  # noqa: E501

        database identifier, may be uuid or numeric string  # noqa: E501

        :return: The id of this Product.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Product.

        database identifier, may be uuid or numeric string  # noqa: E501

        :param id: The id of this Product.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this Product.  # noqa: E501

        name of the product  # noqa: E501

        :return: The name of this Product.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Product.

        name of the product  # noqa: E501

        :param name: The name of this Product.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this Product.  # noqa: E501

        a more detailed description of the product  # noqa: E501

        :return: The description of this Product.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Product.

        a more detailed description of the product  # noqa: E501

        :param description: The description of this Product.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def product_code(self):
        """Gets the product_code of this Product.  # noqa: E501

        internal product code identifier (or SKU)  # noqa: E501

        :return: The product_code of this Product.  # noqa: E501
        :rtype: str
        """
        return self._product_code

    @product_code.setter
    def product_code(self, product_code):
        """Sets the product_code of this Product.

        internal product code identifier (or SKU)  # noqa: E501

        :param product_code: The product_code of this Product.  # noqa: E501
        :type: str
        """

        self._product_code = product_code

    @property
    def tags(self):
        """Gets the tags of this Product.  # noqa: E501


        :return: The tags of this Product.  # noqa: E501
        :rtype: list[Tag]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this Product.


        :param tags: The tags of this Product.  # noqa: E501
        :type: list[Tag]
        """

        self._tags = tags

    @property
    def documents(self):
        """Gets the documents of this Product.  # noqa: E501


        :return: The documents of this Product.  # noqa: E501
        :rtype: list[Document]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """Sets the documents of this Product.


        :param documents: The documents of this Product.  # noqa: E501
        :type: list[Document]
        """

        self._documents = documents

    @property
    def product_groups(self):
        """Gets the product_groups of this Product.  # noqa: E501


        :return: The product_groups of this Product.  # noqa: E501
        :rtype: list[ProductGroup]
        """
        return self._product_groups

    @product_groups.setter
    def product_groups(self, product_groups):
        """Sets the product_groups of this Product.


        :param product_groups: The product_groups of this Product.  # noqa: E501
        :type: list[ProductGroup]
        """

        self._product_groups = product_groups

    @property
    def packages(self):
        """Gets the packages of this Product.  # noqa: E501


        :return: The packages of this Product.  # noqa: E501
        :rtype: list[ProductPackage]
        """
        return self._packages

    @packages.setter
    def packages(self, packages):
        """Sets the packages of this Product.


        :param packages: The packages of this Product.  # noqa: E501
        :type: list[ProductPackage]
        """

        self._packages = packages

    @property
    def synonyms(self):
        """Gets the synonyms of this Product.  # noqa: E501


        :return: The synonyms of this Product.  # noqa: E501
        :rtype: list[Synonym]
        """
        return self._synonyms

    @synonyms.setter
    def synonyms(self, synonyms):
        """Sets the synonyms of this Product.


        :param synonyms: The synonyms of this Product.  # noqa: E501
        :type: list[Synonym]
        """

        self._synonyms = synonyms

    @property
    def inventory_levels(self):
        """Gets the inventory_levels of this Product.  # noqa: E501


        :return: The inventory_levels of this Product.  # noqa: E501
        :rtype: list[InventoryLevel]
        """
        return self._inventory_levels

    @inventory_levels.setter
    def inventory_levels(self, inventory_levels):
        """Sets the inventory_levels of this Product.


        :param inventory_levels: The inventory_levels of this Product.  # noqa: E501
        :type: list[InventoryLevel]
        """

        self._inventory_levels = inventory_levels

    @property
    def inventory_items(self):
        """Gets the inventory_items of this Product.  # noqa: E501


        :return: The inventory_items of this Product.  # noqa: E501
        :rtype: list[InventoryItem]
        """
        return self._inventory_items

    @inventory_items.setter
    def inventory_items(self, inventory_items):
        """Sets the inventory_items of this Product.


        :param inventory_items: The inventory_items of this Product.  # noqa: E501
        :type: list[InventoryItem]
        """

        self._inventory_items = inventory_items

    @property
    def product_suppliers(self):
        """Gets the product_suppliers of this Product.  # noqa: E501


        :return: The product_suppliers of this Product.  # noqa: E501
        :rtype: list[ProductSupplier]
        """
        return self._product_suppliers

    @product_suppliers.setter
    def product_suppliers(self, product_suppliers):
        """Sets the product_suppliers of this Product.


        :param product_suppliers: The product_suppliers of this Product.  # noqa: E501
        :type: list[ProductSupplier]
        """

        self._product_suppliers = product_suppliers

    @property
    def product_catalog_items(self):
        """Gets the product_catalog_items of this Product.  # noqa: E501


        :return: The product_catalog_items of this Product.  # noqa: E501
        :rtype: list[ProductCatalogItem]
        """
        return self._product_catalog_items

    @product_catalog_items.setter
    def product_catalog_items(self, product_catalog_items):
        """Sets the product_catalog_items of this Product.


        :param product_catalog_items: The product_catalog_items of this Product.  # noqa: E501
        :type: list[ProductCatalogItem]
        """

        self._product_catalog_items = product_catalog_items

    @property
    def color(self):
        """Gets the color of this Product.  # noqa: E501


        :return: The color of this Product.  # noqa: E501
        :rtype: object
        """
        return self._color

    @color.setter
    def color(self, color):
        """Sets the color of this Product.


        :param color: The color of this Product.  # noqa: E501
        :type: object
        """

        self._color = color

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Product, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Product):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
