# Generated by Django 2.0.8 on 2018-08-27 09:48

from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [("hordak", "0026_auto_20190723_0929")]

    operations = [
        migrations.RunSQL(
            """
            CREATE OR REPLACE FUNCTION update_full_account_codes()
                RETURNS TRIGGER AS
            $$
            BEGIN
                -- Set empty string codes to be NULL
                UPDATE hordak_account SET code = NULL where code = '';

                -- Set full code to the combination of the parent account's codes
                UPDATE
                    hordak_account AS a
                SET
                    full_code = (
                        SELECT string_agg(code, '' order by lft)
                        FROM hordak_account AS a2
                        WHERE a2.lft <= a.lft AND a2.rght >= a.rght AND a.tree_id = a2.tree_id AND code IS NOT NULL
                    )
                    WHERE tree_id IN (SELECT DISTINCT tree_id FROM hordak_account WHERE code IS NOT NULL);  -- search only account trees without null codes


                -- Set full codes to NULL where a parent account includes a NULL code
                UPDATE
                    hordak_account AS a
                SET
                    full_code = NULL
                WHERE
                    (
                        SELECT COUNT(*)
                        FROM hordak_account AS a2
                        WHERE a2.lft <= a.lft AND a2.rght >= a.rght AND a.tree_id = a2.tree_id AND a2.code IS NULL
                    ) > 0
                    AND full_code IS NOT NULL;  -- search only account trees without null codes
                RETURN NULL;
            END;
            $$
            LANGUAGE plpgsql;
            """,
            "DROP FUNCTION update_full_account_codes()",
        ),
    ]
