/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateTimeUtil {
    private static final FastDateFormat ourHumanDateFormat = FastDateFormat.getDateInstance(2);
    private static final FastDateFormat ourHumanDateTimeFormat = FastDateFormat.getDateTimeInstance(2, 2);

    public static String toHumanDisplay(TimeZone theTimeZone, TemporalPrecisionEnum thePrecision, Date theValue, String theValueAsString) {
        Calendar value = theTimeZone != null ? Calendar.getInstance(theTimeZone) : Calendar.getInstance();
        value.setTime(theValue);
        switch (thePrecision) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                return theValueAsString;
            }
        }
        return ourHumanDateTimeFormat.format(value);
    }

    public static String toHumanDisplayLocalTimezone(TemporalPrecisionEnum thePrecision, Date theValue, String theValueAsString) {
        switch (thePrecision) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                return theValueAsString;
            }
        }
        return ourHumanDateTimeFormat.format(theValue);
    }
}

